import { useEffect, useState } from 'react';
import {
  reactExtension,
  useApi,
  AdminAction,
  BlockStack,
  Button,
  Text,
} from '@shopify/ui-extensions-react/admin';

const TARGET = 'admin.order-details.action.render';

export default reactExtension(TARGET, () => <App />);

function App() {
  const { i18n, close, data } = useApi(TARGET);
  const [orderId, setOrderId] = useState('');


  useEffect(() => {
    const fetchOrderInfo = async () => {
      const getOrderQuery = {
        query: `
          query Order($id: ID!) {
            order(id: $id) {
              id
            }
          }
        `,
        variables: { id: data.selected[0].id },
      };



      try {
        const res = await fetch('shopify:admin/api/graphql.json', {
          method: 'POST',
          body: JSON.stringify(getOrderQuery),
        });

        if (!res.ok) {
          throw new Error('Network error');
        }

        const orderData = await res.json();
        const fullOrderId = orderData.data.order.id;
        const numericId = extractNumericId(fullOrderId);
        setOrderId(numericId);
      } catch (error) {
        console.error('Error fetching order:', error);
      }
    };

    if (data.selected && data.selected.length > 0) {
      fetchOrderInfo();
    }
  }, [data.selected]);

  const sendOrderID = (orderId) => {
    const url = `https://stockapp.confettibee.co.uk/api/getOrderId?orderId=${orderId.orderId}`;

    fetch(url, {
      method: 'GET',
      headers: {
        'Content-Type': 'application/json'
      }
    })
    .then(response => {
      if (!response.ok) {
        throw new Error('Failed to fetch');
      }
      return response.json();
    })
    .then(data => {
      console.log('Successfully passed orderId:', data);
    })
    .catch(error => {
      console.error('Error:', error);
    });
  }

  const extractNumericId = (fullOrderId) => {
    const parts = fullOrderId.split('/');
    return parts[parts.length - 1];
  };

  return (
    <AdminAction
      primaryAction={
        <Button
          onPress={() => {
            sendOrderID({orderId})
            close();
          }}
        >
          Confirm Stock Deduction
        </Button>
      }
      secondaryAction={
        <Button
          onPress={() => {
            console.log('closing');
            close();
          }}
        >
          Close
        </Button>
      }
    >
      <BlockStack>
        <Text>Order ID: {orderId}</Text>
      </BlockStack>
    </AdminAction>
  );
}
