"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.write = exports.colorize = exports.Table = exports.ExitError = exports.config = exports.Config = exports.ActionBase = exports.warn = exports.wait = exports.url = exports.tree = exports.trace = exports.table = exports.styledObject = exports.styledJSON = exports.styledHeader = exports.prompt = exports.progress = exports.logToStderr = exports.log = exports.info = exports.flush = exports.exit = exports.error = exports.done = exports.debug = exports.confirm = exports.anykey = exports.annotation = exports.action = exports.ux = void 0;
const chalk_1 = __importDefault(require("chalk"));
const node_util_1 = require("node:util");
const Errors = __importStar(require("../errors"));
const config_1 = require("./config");
const flush_1 = require("./flush");
const uxPrompt = __importStar(require("./prompt"));
const styled = __importStar(require("./styled"));
const wait_1 = __importDefault(require("./wait"));
const write_1 = __importDefault(require("./write"));
const hyperlinker = require('hyperlinker');
class ux {
    static config = config_1.config;
    static get action() {
        return config_1.config.action;
    }
    static annotation(text, annotation) {
        const supports = require('supports-hyperlinks');
        if (supports.stdout) {
            // \u001b]8;;https://google.com\u0007sometext\u001b]8;;\u0007
            this.log(`\u001B]1337;AddAnnotation=${text.length}|${annotation}\u0007${text}`);
        }
        else {
            this.log(text);
        }
    }
    /**
     * "press anykey to continue"
     */
    static get anykey() {
        return uxPrompt.anykey;
    }
    static get confirm() {
        return uxPrompt.confirm;
    }
    static debug(format, ...args) {
        if (['debug', 'trace'].includes(this.config.outputLevel)) {
            this.info((0, node_util_1.format)(format, ...args) + '\n');
        }
    }
    static async done() {
        config_1.config.action.stop();
    }
    static async flush(ms = 10000) {
        await (0, flush_1.flush)(ms);
    }
    static info(format, ...args) {
        write_1.default.stdout((0, node_util_1.format)(format, ...args) + '\n');
    }
    static log(format, ...args) {
        this.info(format || '', ...args);
    }
    static logToStderr(format, ...args) {
        write_1.default.stderr((0, node_util_1.format)(format, ...args) + '\n');
    }
    static get progress() {
        return styled.progress;
    }
    static get prompt() {
        return uxPrompt.prompt;
    }
    static styledHeader(header) {
        this.info(chalk_1.default.dim('=== ') + chalk_1.default.bold(header) + '\n');
    }
    static styledJSON(obj) {
        const json = JSON.stringify(obj, null, 2);
        if (!chalk_1.default.level) {
            this.info(json);
            return;
        }
        const cardinal = require('cardinal');
        const theme = require('cardinal/themes/jq');
        this.info(cardinal.highlight(json, { json: true, theme }));
    }
    static styledObject(obj, keys) {
        this.info(styled.styledObject(obj, keys));
    }
    static get table() {
        return styled.Table.table;
    }
    static trace(format, ...args) {
        if (this.config.outputLevel === 'trace') {
            this.info((0, node_util_1.format)(format, ...args) + '\n');
        }
    }
    static get tree() {
        return styled.tree;
    }
    static url(text, uri, params = {}) {
        const supports = require('supports-hyperlinks');
        if (supports.stdout) {
            this.log(hyperlinker(text, uri, params));
        }
        else {
            this.log(uri);
        }
    }
    static get wait() {
        return wait_1.default;
    }
}
exports.ux = ux;
const { action, annotation, anykey, confirm, debug, done, flush, info, log, logToStderr, progress, prompt, styledHeader, styledJSON, styledObject, table, trace, tree, url, wait, } = ux;
exports.action = action;
exports.annotation = annotation;
exports.anykey = anykey;
exports.confirm = confirm;
exports.debug = debug;
exports.done = done;
exports.flush = flush;
exports.info = info;
exports.log = log;
exports.logToStderr = logToStderr;
exports.progress = progress;
exports.prompt = prompt;
exports.styledHeader = styledHeader;
exports.styledJSON = styledJSON;
exports.styledObject = styledObject;
exports.table = table;
exports.trace = trace;
exports.tree = tree;
exports.url = url;
exports.wait = wait;
const { error, exit, warn } = Errors;
exports.error = error;
exports.exit = exit;
exports.warn = warn;
const uxProcessExitHandler = async () => {
    try {
        await ux.done();
    }
    catch (error) {
        console.error(error);
        process.exitCode = 1;
    }
};
// to avoid MaxListenersExceededWarning
// only attach named listener once
const uxListener = process.listeners('exit').find((fn) => fn.name === uxProcessExitHandler.name);
if (!uxListener) {
    process.once('exit', uxProcessExitHandler);
}
var base_1 = require("./action/base");
Object.defineProperty(exports, "ActionBase", { enumerable: true, get: function () { return base_1.ActionBase; } });
var config_2 = require("./config");
Object.defineProperty(exports, "Config", { enumerable: true, get: function () { return config_2.Config; } });
Object.defineProperty(exports, "config", { enumerable: true, get: function () { return config_2.config; } });
var exit_1 = require("./exit");
Object.defineProperty(exports, "ExitError", { enumerable: true, get: function () { return exit_1.ExitError; } });
var styled_1 = require("./styled");
Object.defineProperty(exports, "Table", { enumerable: true, get: function () { return styled_1.Table; } });
var theme_1 = require("./theme");
Object.defineProperty(exports, "colorize", { enumerable: true, get: function () { return theme_1.colorize; } });
var write_2 = require("./write");
Object.defineProperty(exports, "write", { enumerable: true, get: function () { return __importDefault(write_2).default; } });
