import { MetaAction, AnyAction } from '../types';
export declare enum Action {
    INVALID_ACTION = "APP::ERROR::INVALID_ACTION",
    INVALID_ACTION_TYPE = "APP::ERROR::INVALID_ACTION_TYPE",
    INVALID_PAYLOAD = "APP::ERROR::INVALID_PAYLOAD",
    INVALID_OPTIONS = "APP::ERROR::INVALID_OPTIONS",
    UNEXPECTED_ACTION = "APP::ERROR::UNEXPECTED_ACTION",
    PERSISTENCE = "APP::ERROR::PERSISTENCE",
    UNSUPPORTED_OPERATION = "APP::ERROR::UNSUPPORTED_OPERATION",
    NETWORK = "APP::ERROR::NETWORK",
    PERMISSION = "APP::ERROR::PERMISSION",
    FAILED_AUTHENTICATION = "APP::ERROR::FAILED_AUTHENTICATION",
    INVALID_ORIGIN = "APP::ERROR::INVALID_ORIGIN"
}
export declare enum AppActionType {
    INVALID_CONFIG = "APP::ERROR::INVALID_CONFIG",
    MISSING_CONFIG = "APP::APP_ERROR::MISSING_CONFIG",
    MISSING_APP_BRIDGE_MIDDLEWARE = "APP::APP_ERROR::MISSING_APP_BRIDGE_MIDDLEWARE",
    WINDOW_UNDEFINED = "APP::APP_ERROR::WINDOW_UNDEFINED",
    REDUX_REINSTANTIATED = "APP::APP_ERROR::REDUX_REINSTANTIATED",
    MISSING_LOCAL_ORIGIN = "APP::APP_ERROR::MISSING_LOCAL_ORIGIN",
    MISSING_HOST_PROVIDER = "APP::APP_ERROR::MISSING_HOST_PROVIDER",
    MISSING_ROUTER_CONTEXT = "APP::APP_ERROR::MISSING_ROUTER_CONTEXT",
    MISSING_HISTORY_BLOCK = "APP::APP_ERROR::MISSING_HISTORY_BLOCK"
}
export declare type Payload = MetaAction | AnyAction;
export declare class AppBridgeError {
    message: string;
    name: string;
    stack: any;
    action?: Payload;
    type?: string;
    constructor(message: string);
}
export interface ErrorAction extends MetaAction {
    payload: {
        type: typeof Action;
        action: Payload;
    };
}
export declare function fromAction(message: string, type: string, action?: Payload): AppBridgeError;
export declare function invalidOriginAction(message: string): ErrorAction;
export declare function throwError(type: Action | string, action: Payload, message?: string): void;
export declare function throwError(type: Action | string, message: string): void;
export declare function isErrorEventName(eventName: string): boolean;
export declare function permissionAction<A extends MetaAction>(action: A, message?: string): ErrorAction;
