"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var react_1 = __importDefault(require("react"));
var actions_1 = require("@shopify/app-bridge/actions");
var context_1 = require("../../../context");
/**
 * Modal Content component
 *
 * @remarks
 * React component which wraps the Shopify App Bridge Modal Content action.
 *
 * @public
 */
var ModalContent = /** @class */ (function (_super) {
    __extends(ModalContent, _super);
    function ModalContent() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ModalContent.prototype.componentDidMount = function () {
        var app = this.context;
        this.modalContent = actions_1.ModalContent.create(app);
        this.syncLoadingStatus();
    };
    ModalContent.prototype.componentDidUpdate = function () {
        this.syncLoadingStatus();
    };
    ModalContent.prototype.syncLoadingStatus = function () {
        if (!this.modalContent)
            return;
        if (this.props.loading) {
            this.modalContent.loading();
        }
        else {
            this.modalContent.loaded();
        }
    };
    ModalContent.prototype.render = function () {
        return null;
    };
    ModalContent.contextType = context_1.AppBridgeContext;
    return ModalContent;
}(react_1.default.Component));
exports.default = ModalContent;
