import React from 'react';
import { AppBridgeContext } from '../../context';
export interface Props {
    /** The content that should appear in the toast message */
    content: string;
    /**
     * The length of time in milliseconds the toast message should persist
     * @default 5000
     */
    duration?: number;
    /** Display an error toast. */
    error?: boolean;
    /** Callback when the dismiss icon is clicked */
    onDismiss(): void;
    /** An object to include an optional action in the toast */
    action?: {
        content: string;
        onAction: () => void;
    };
}
export declare const DEFAULT_TOAST_DURATION = 5000;
/**
 * Toast component
 *
 * @remarks
 * React component which wraps the Shopify App Bridge Toast action.
 *
 * @public
 */
declare class Toast extends React.PureComponent<Props, never> {
    static contextType: React.Context<import("../../context").IAppBridgeContext>;
    context: React.ContextType<typeof AppBridgeContext>;
    private toast;
    componentDidMount(): void;
    componentWillUnmount(): void;
    render(): null;
}
export default Toast;
