import { AppConfigV2, MessageType, ClientApplication, HooksInterface, LifecycleHandler } from '@shopify/app-bridge-core/client/types';
import type { Dispatch, Unsubscribe } from '../actions/types';
import type { Handler, MessageTransport } from '../MessageTransport';
export { Dispatcher, TransportDispatch, AppBridgeState, StaffMemberDetails, FeaturesAction, FeaturePermission, PermissionType, StateWithoutFeatures, HooksInterface, LifecycleHook, UpdateActionHook, UpdateActionHandler, DispatchActionHook, DispatchActionHandler, LifecycleHandler, Path, PathValue, TransportSubscription, FeaturesAvailable, FeaturesState, } from '@shopify/app-bridge-core/client/types';
export { AppConfigV2, MessageType, ClientApplication };
/**
 * @public
 */
export interface AppConfigV1 {
    apiKey: string;
    shopOrigin: string;
    forceRedirect?: boolean;
}
/**
 * @public
 */
export declare type AppConfig = AppConfigV2 | AppConfigV1;
/**
 * @internal
 * @param config
 */
export declare function isV1Config(config: AppConfig): config is AppConfigV1;
/**
 * @public
 */
export interface ClientApplicationCreator {
    (config: AppConfigV2): ClientApplication;
}
/**
 * @internalremarks
 * TODO: Generalize—pramaterize return type
 * @internal
 */
export interface ClientApplicationTransportInjector {
    (transport: MessageTransport, middleware?: AppMiddleware[]): ClientApplicationCreator;
}
/**
 * @deprecated Not to be used, there is no replacement.
 * @internal
 */
export interface Params {
    [key: string]: string;
}
/**
 * @internal
 */
export interface Hook {
    handler: LifecycleHandler;
    remove: Unsubscribe;
}
/**
 * @internal
 */
export interface HookMap {
    [key: string]: Hook[];
}
/**
 * @internal
 */
export interface AppMiddleware {
    (hooks: HooksInterface, app: ClientApplication): void;
}
export { Dispatch, Handler, Unsubscribe };
