import type { AppConfigV2, ClientApplication } from './client/types';
/**
 * Creates your application instance with validator middleware.
 * @param config - `apiKey` and `host` are both required.
 * @remarks
 * Please note that `forceRedirect` only works in production environment (`shopname.myshopify.com/admin`).
 * You will need to store `host` during the authentication process and then retrieve it for the code to
 * work properly. To learn more about this process, see
 * {@link https://help.shopify.com/api/embedded-apps/shop-origin | Getting and storing the shop origin}.
 * @public
 */
export declare function createApp(config: AppConfigV2): ClientApplication;
export default createApp;
export * from './MessageTransport';
export * from './client';
