(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory();
	else if(typeof define === 'function' && define.amd)
		define("app-bridge", [], factory);
	else if(typeof exports === 'object')
		exports["app-bridge"] = factory();
	else
		root["app-bridge"] = factory();
})(window, function() {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 68);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateActionFromPayload = exports.isValidOptionalString = exports.isValidOptionalNumber = exports.forEachInEnum = exports.getMergedProps = exports.findMatchInEnum = exports.getEventNameSpace = exports.NonSnakeCaseGroup = exports.actionWrapper = void 0;
var merge_1 = __importDefault(__webpack_require__(71));
var constants_1 = __webpack_require__(38);
var types_1 = __webpack_require__(1);
function actionWrapper(action) {
    return action;
}
exports.actionWrapper = actionWrapper;
exports.NonSnakeCaseGroup = [
    types_1.Group.AuthCode,
    types_1.Group.Button,
    types_1.Group.ButtonGroup,
    types_1.Group.Cart,
    types_1.Group.Error,
    types_1.Group.Features,
    types_1.Group.Fullscreen,
    types_1.Group.Link,
    types_1.Group.Loading,
    types_1.Group.Menu,
    types_1.Group.Modal,
    types_1.Group.Navigation,
    types_1.Group.Pos,
    types_1.Group.Print,
    types_1.Group.ResourcePicker,
    types_1.Group.Scanner,
    types_1.Group.SessionToken,
    types_1.Group.Share,
    types_1.Group.TitleBar,
    types_1.Group.Toast,
    types_1.Group.unstable_Picker,
];
function camelCaseToSnakeCase(value) {
    return value.replace(/([A-Z])/g, function (matcher, _val, index) {
        return "" + (index === 0 ? '' : '_') + matcher[0].toLowerCase();
    });
}
/**
 * Maps the group name to its event name
 * @internal
 * @remarks - This method is necessary for the new pattern of using snake case
 * which makes it more readable and easier to reconstruct the group from an event name.
 * Example: `ContextualSaveBar` becomes `CONTEXTUAL_SAVE_BAR`
 * */
function groupToEventNameSpace(group) {
    if (exports.NonSnakeCaseGroup.includes(group)) {
        return group.toUpperCase();
    }
    return camelCaseToSnakeCase(group).toUpperCase();
}
/**
 * Returns full event name with prefix, group, subgroups and type formatted with separators
 * @internal
 * */
function getEventNameSpace(group, eventName, component) {
    if (eventName.startsWith("" + constants_1.PREFIX + constants_1.SEPARATOR)) {
        return eventName;
    }
    var eventNameSpace = groupToEventNameSpace(group);
    if (component) {
        var subgroups_1 = component.subgroups, type = component.type;
        if (subgroups_1 && subgroups_1.length > 0) {
            eventNameSpace += eventNameSpace.length > 0 ? constants_1.SEPARATOR : '';
            subgroups_1.forEach(function (subgroup, index) {
                eventNameSpace += "" + subgroup.toUpperCase() + (index < subgroups_1.length - 1 ? constants_1.SEPARATOR : '');
            });
        }
        if (type !== group && type) {
            eventNameSpace += "" + (eventNameSpace.length > 0 ? constants_1.SEPARATOR : '') + type.toUpperCase();
        }
    }
    if (eventNameSpace) {
        eventNameSpace += "" + (eventNameSpace.length > 0 ? constants_1.SEPARATOR : '') + eventName.toUpperCase();
    }
    return "" + constants_1.PREFIX + constants_1.SEPARATOR + eventNameSpace;
}
exports.getEventNameSpace = getEventNameSpace;
function findMatchInEnum(types, lookup) {
    var match = Object.keys(types).find(function (key) {
        return lookup === types[key];
    });
    return match ? types[match] : undefined;
}
exports.findMatchInEnum = findMatchInEnum;
function getMergedProps(props, newProps) {
    var merged = merge_1.default(props, newProps);
    if (!merged) {
        // tslint:disable-next-line:prefer-object-spread
        var cloned = Object.assign(props, newProps);
        return cloned;
    }
    return merged;
}
exports.getMergedProps = getMergedProps;
function forEachInEnum(types, callback) {
    Object.keys(types).forEach(function (key) {
        callback(types[key]);
    });
}
exports.forEachInEnum = forEachInEnum;
function isValidOptionalNumber(value) {
    return value === null || value === undefined || typeof value === 'number';
}
exports.isValidOptionalNumber = isValidOptionalNumber;
function isValidOptionalString(value) {
    return value === null || value === undefined || typeof value === 'string';
}
exports.isValidOptionalString = isValidOptionalString;
function updateActionFromPayload(action, newProps) {
    var id = action.id;
    if (id === newProps.id) {
        // Merge new properties
        Object.assign(action, getMergedProps(action, newProps));
        return true;
    }
    return false;
}
exports.updateActionFromPayload = updateActionFromPayload;


/***/ }),
/* 1 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ComponentType = exports.Group = void 0;
/**
 * Various action groups.
 * @public
 */
var Group;
(function (Group) {
    Group["AuthCode"] = "AuthCode";
    Group["Button"] = "Button";
    Group["ButtonGroup"] = "ButtonGroup";
    Group["Cart"] = "Cart";
    Group["Client"] = "Client";
    Group["ContextualSaveBar"] = "ContextualSaveBar";
    Group["Error"] = "Error";
    Group["Features"] = "Features";
    Group["FeedbackModal"] = "FeedbackModal";
    Group["Fullscreen"] = "Fullscreen";
    Group["LeaveConfirmation"] = "LeaveConfirmation";
    Group["Link"] = "Link";
    Group["Loading"] = "Loading";
    Group["Menu"] = "Menu";
    Group["Modal"] = "Modal";
    Group["Navigation"] = "Navigation";
    Group["Performance"] = "Performance";
    Group["Pos"] = "Pos";
    Group["Print"] = "Print";
    Group["ResourcePicker"] = "Resource_Picker";
    /**
     * @unstable This API may be updated without warning in the future
     */
    Group["unstable_Picker"] = "unstable_Picker";
    Group["Scanner"] = "Scanner";
    Group["SessionToken"] = "SessionToken";
    Group["Share"] = "Share";
    Group["TitleBar"] = "TitleBar";
    Group["Toast"] = "Toast";
    Group["MarketingExternalActivityTopBar"] = "MarketingExternalActivityTopBar";
    Group["WebVitals"] = "WebVitals";
})(Group = exports.Group || (exports.Group = {}));
/**
 * @internal
 */
var ComponentType;
(function (ComponentType) {
    ComponentType["Button"] = "Button";
    ComponentType["ButtonGroup"] = "ButtonGroup";
})(ComponentType = exports.ComponentType || (exports.ComponentType = {}));


/***/ }),
/* 2 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.unsubscribeActions = exports.ActionSetWithChildren = exports.ActionSet = void 0;
var types_1 = __webpack_require__(13);
var collection_1 = __webpack_require__(23);
var Error_1 = __webpack_require__(12);
var types_2 = __webpack_require__(1);
var uuid_1 = __importDefault(__webpack_require__(44));
var helper_1 = __webpack_require__(0);
var ActionSet = /** @class */ (function () {
    function ActionSet(app, type, group, id) {
        var _this = this;
        this.app = app;
        this.type = type;
        this.group = group;
        this.subgroups = [];
        this.subscriptions = [];
        if (!app) {
            Error_1.throwError(Error_1.Action.INVALID_ACTION, 'Missing required `app`');
        }
        this.id = id || uuid_1.default();
        this.defaultGroup = group;
        var defaultSet = this.set;
        this.set = function () {
            var _a;
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            if (!_this.app.hooks) {
                return defaultSet.apply(_this, args);
            }
            return (_a = _this.app.hooks).run.apply(_a, __spreadArray([types_1.LifecycleHook.UpdateAction, defaultSet, _this], args));
        };
    }
    ActionSet.prototype.set = function () {
        var _ = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            _[_i] = arguments[_i];
        }
    };
    Object.defineProperty(ActionSet.prototype, "component", {
        get: function () {
            return {
                id: this.id,
                subgroups: this.subgroups,
                type: this.type,
            };
        },
        enumerable: false,
        configurable: true
    });
    ActionSet.prototype.updateSubscription = function (subscriptionToRemove, group, subgroups) {
        var eventType = subscriptionToRemove.eventType, callback = subscriptionToRemove.callback, component = subscriptionToRemove.component;
        var currentIndex;
        currentIndex = this.subscriptions.findIndex(function (subscription) { return subscription === subscriptionToRemove; });
        if (currentIndex >= 0) {
            this.subscriptions[currentIndex].unsubscribe();
        }
        else {
            currentIndex = undefined;
        }
        this.group = group;
        this.subgroups = subgroups;
        Object.assign(component, { subgroups: this.subgroups });
        return this.subscribe(eventType, callback, component, currentIndex);
    };
    ActionSet.prototype.error = function (callback) {
        var _this = this;
        var subscriptionIndices = [];
        helper_1.forEachInEnum(Error_1.Action, function (eventNameSpace) {
            // Keep track of subscription index so we can call unsubscribe later
            // This ensure it will continue to work even when the subscription has been updated
            subscriptionIndices.push(_this.subscriptions.length);
            _this.subscribe(eventNameSpace, callback);
        });
        return function () {
            var subscriptionsToRemove = subscriptionIndices.map(function (index) { return _this.subscriptions[index]; });
            subscriptionsToRemove.forEach(function (toRemove) {
                collection_1.removeFromCollection(_this.subscriptions, toRemove, function (removed) {
                    removed.unsubscribe();
                });
            });
        };
    };
    ActionSet.prototype.subscribe = function (eventName, callback, component, currentIndex) {
        var _this = this;
        var eventComponent = component || this.component;
        var eventType = eventName.toUpperCase();
        var boundedCallback = typeof currentIndex === 'number' ? callback : callback.bind(this);
        var eventNameSpace;
        if (Error_1.isErrorEventName(eventName)) {
            eventNameSpace = helper_1.getEventNameSpace(types_2.Group.Error, eventName, __assign(__assign({}, eventComponent), { type: '' }));
        }
        else {
            eventNameSpace = helper_1.getEventNameSpace(this.group, eventName, eventComponent);
        }
        var unsubscribe = this.app.subscribe(eventNameSpace, boundedCallback, component ? component.id : this.id);
        var subscription = {
            eventType: eventType,
            unsubscribe: unsubscribe,
            callback: boundedCallback,
            component: eventComponent,
            updateSubscribe: function (group, subgroups) {
                return _this.updateSubscription(subscription, group, subgroups);
            },
        };
        if (typeof currentIndex === 'number' &&
            currentIndex >= 0 &&
            currentIndex < this.subscriptions.length) {
            this.subscriptions[currentIndex] = subscription;
        }
        else {
            this.subscriptions.push(subscription);
        }
        return unsubscribe;
    };
    ActionSet.prototype.unsubscribe = function (resetOnly) {
        if (resetOnly === void 0) { resetOnly = false; }
        unsubscribeActions(this.subscriptions, this.defaultGroup, resetOnly);
        return this;
    };
    return ActionSet;
}());
exports.ActionSet = ActionSet;
var ActionSetWithChildren = /** @class */ (function (_super) {
    __extends(ActionSetWithChildren, _super);
    function ActionSetWithChildren() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.children = [];
        return _this;
    }
    ActionSetWithChildren.prototype.unsubscribe = function (unsubscribeChildren, resetParentOnly) {
        if (unsubscribeChildren === void 0) { unsubscribeChildren = true; }
        if (resetParentOnly === void 0) { resetParentOnly = false; }
        unsubscribeActions(this.subscriptions, this.defaultGroup, resetParentOnly);
        this.children.forEach(function (child) {
            if (child instanceof ActionSetWithChildren) {
                child.unsubscribe(unsubscribeChildren, !unsubscribeChildren);
            }
            else {
                child.unsubscribe(!unsubscribeChildren);
            }
        });
        return this;
    };
    ActionSetWithChildren.prototype.getChild = function (id) {
        var childIndex = this.children.findIndex(function (child) { return child.id === id; });
        return childIndex >= 0 ? this.children[childIndex] : undefined;
    };
    ActionSetWithChildren.prototype.getChildIndex = function (id) {
        return this.children.findIndex(function (child) { return child.id === id; });
    };
    ActionSetWithChildren.prototype.getChildSubscriptions = function (id, eventType) {
        return this.subscriptions.filter(function (sub) { return sub.component.id === id && (!eventType || eventType === sub.eventType); });
    };
    ActionSetWithChildren.prototype.addChild = function (child, group, subgroups) {
        var _this = this;
        var subscriptions = child.subscriptions;
        var existingChild = this.getChild(child.id);
        // Add child if it doesn't already exist
        if (!existingChild) {
            this.children.push(child);
        }
        if (!subscriptions || (group === child.group && subgroups === child.subgroups)) {
            return this;
        }
        subscriptions.forEach(function (subscription) {
            var updateSubscribe = subscription.updateSubscribe;
            updateSubscribe(group, subgroups);
        });
        // Update child's group and subgroups
        Object.assign(child, { group: group, subgroups: subgroups });
        // Update child's children subscriptions
        if (child instanceof ActionSetWithChildren) {
            child.children.forEach(function (childIter) {
                return _this.addChild(childIter, group, subgroups);
            });
        }
        return this;
    };
    ActionSetWithChildren.prototype.removeChild = function (id) {
        var _this = this;
        collection_1.removeFromCollection(this.children, this.getChild(id), function () {
            var toBeRemoved = _this.subscriptions.filter(function (subs) { return subs.component.id === id; });
            toBeRemoved.forEach(function (toRemove) {
                collection_1.removeFromCollection(_this.subscriptions, toRemove, function (removed) {
                    removed.unsubscribe();
                });
            });
        });
        return this;
    };
    ActionSetWithChildren.prototype.subscribeToChild = function (child, eventName, callback) {
        var _this = this;
        var boundedCallback = callback.bind(this);
        if (eventName instanceof Array) {
            eventName.forEach(function (eventNameIter) { return _this.subscribeToChild(child, eventNameIter, callback); });
            return this;
        }
        if (typeof eventName !== 'string') {
            return this;
        }
        var eventType = eventName.toUpperCase();
        var currentSubscriptions = this.getChildSubscriptions(child.id, eventType);
        if (currentSubscriptions.length > 0) {
            // Subscription is already there, simply update it
            currentSubscriptions.forEach(function (subs) { return subs.updateSubscribe(_this.group, child.subgroups); });
        }
        else {
            var childComponent = {
                id: child.id,
                subgroups: child.subgroups,
                type: child.type,
            };
            this.subscribe(eventType, boundedCallback, childComponent);
        }
        return this;
    };
    ActionSetWithChildren.prototype.getUpdatedChildActions = function (newActions, currentActions) {
        if (newActions.length === 0) {
            while (currentActions.length > 0) {
                var action = currentActions.pop();
                if (!action) {
                    break;
                }
                this.removeChild(action.id);
            }
            return undefined;
        }
        // Only allow unique actions
        var uniqueActions = newActions.filter(function (action, index, actionsArr) { return index === actionsArr.indexOf(action); });
        var newActionIds = uniqueActions.map(function (action) { return action.id; });
        // Remove unused actions
        var unusedActions = currentActions.filter(function (action) {
            return newActionIds.indexOf(action.id) < 0;
        });
        while (unusedActions.length > 0) {
            var action = unusedActions.pop();
            if (!action) {
                break;
            }
            this.removeChild(action.id);
        }
        return uniqueActions;
    };
    return ActionSetWithChildren;
}(ActionSet));
exports.ActionSetWithChildren = ActionSetWithChildren;
function unsubscribeActions(subscriptions, defaultGroup, reassign) {
    if (reassign === void 0) { reassign = false; }
    subscriptions.forEach(function (subscription) {
        if (reassign) {
            var updateSubscribe = subscription.updateSubscribe;
            // eslint-disable-next-line no-warning-comments
            // TODO: Support cases where we don't wipe out group and subgroups to defaults
            updateSubscribe(defaultGroup, []);
        }
        else {
            var unsubscribe = subscription.unsubscribe;
            unsubscribe();
        }
    });
    if (!reassign) {
        subscriptions.length = 0;
    }
}
exports.unsubscribeActions = unsubscribeActions;


/***/ }),
/* 3 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.validate = exports.matchesPositiveInteger = exports.matchesBoolean = exports.makeOptional = exports.matchesString = exports.matchesObject = exports.getErrors = exports.oneOf = exports.matchesArray = exports.matchesEnum = exports.composeSchemas = exports.TYPE_ERROR = void 0;
exports.TYPE_ERROR = 'type_error_expected';
function composeSchemas() {
    var validators = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        validators[_i] = arguments[_i];
    }
    return function (val) {
        var error;
        var i = 0;
        var len = validators.length;
        while (!error && i < len) {
            error = validators[i](val);
            if (error) {
                return error;
            }
            i++;
        }
    };
}
exports.composeSchemas = composeSchemas;
/**
 * Returns a validator that matches values in the given enum
 * @param type - enum to use for match values
 * @public
 */
function matchesEnum(types, options) {
    return function (value) {
        var values = Object.keys(types).map(function (key) { return types[key]; });
        var message = (options && options.message) || "expected:" + values.map(function (val) { return "`" + val + "`"; }).join(' or ');
        return values.includes(value)
            ? undefined
            : constructErrors(value, 'invalid_enum_value', __assign(__assign({}, options), { message: message }));
    };
}
exports.matchesEnum = matchesEnum;
function matchesArray(validator, options) {
    return function (value) {
        if (!Array.isArray(value)) {
            return constructErrors(value, exports.TYPE_ERROR + "_array", options);
        }
        if (!validator) {
            return;
        }
        var errors = [];
        value.forEach(function (val, key) {
            var objectError = validator(val);
            if (objectError) {
                errors = errors.concat(objectError.map(function (error) { return (__assign(__assign({}, error), { path: "['" + key + "']" + (error.path || '') })); }));
            }
        });
        return errors.length ? errors : undefined;
    };
}
exports.matchesArray = matchesArray;
function oneOf() {
    var validators = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        validators[_i] = arguments[_i];
    }
    return function (val) {
        var errors = [];
        for (var _i = 0, validators_1 = validators; _i < validators_1.length; _i++) {
            var validator = validators_1[_i];
            var result = validator(val);
            if (result == null)
                return result;
            errors.push.apply(errors, result);
        }
        return errors;
    };
}
exports.oneOf = oneOf;
function constructErrors(value, error, options) {
    if (options === void 0) { options = { message: undefined }; }
    return [
        {
            value: value,
            error: error,
            message: typeof options.message === 'function' ? options.message(error, value) : options.message,
        },
    ];
}
function getErrors(obj, validator, key) {
    var value = key ? obj[key] : obj;
    var path = key ? "['" + key + "']" : undefined;
    var error = validator(value);
    if (!error) {
        return;
    }
    return error.map(function (errorObj) { return (__assign(__assign({}, errorObj), { path: "" + (path || '') + (errorObj.path || '') || undefined })); });
}
exports.getErrors = getErrors;
function matchesObject(schema, options) {
    return function (val) {
        if (typeof val !== 'object' || !val || Array.isArray(val)) {
            return constructErrors(val, exports.TYPE_ERROR + "_object", options);
        }
        var flattened = Object.keys(schema).reduce(function (acc, key) {
            return __spreadArray(__spreadArray([], acc), (getErrors(val, schema[key], key) || []));
        }, []);
        return flattened.length ? flattened : undefined;
    };
}
exports.matchesObject = matchesObject;
function matchesString(options) {
    return function (value) {
        return typeof value === 'string' ? undefined : constructErrors(value, exports.TYPE_ERROR + "_string", options);
    };
}
exports.matchesString = matchesString;
function makeOptional(validator) {
    return function (value) {
        if (value === undefined || value === null) {
            return undefined;
        }
        return validator(value);
    };
}
exports.makeOptional = makeOptional;
function matchesBoolean(options) {
    return function (value) {
        return typeof value === 'boolean'
            ? undefined
            : constructErrors(value, exports.TYPE_ERROR + "_boolean", options);
    };
}
exports.matchesBoolean = matchesBoolean;
function matchesPositiveInteger(options) {
    return function (value) {
        return !Number.isInteger(value) || value < 0
            ? constructErrors(value, exports.TYPE_ERROR + "_integer", options)
            : undefined;
    };
}
exports.matchesPositiveInteger = matchesPositiveInteger;
function validate(obj, validator) {
    return getErrors(obj, validator);
}
exports.validate = validate;


/***/ }),
/* 4 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.relativePathSchema = exports.relativeUrlSchema = exports.isValidRelativePath = exports.createActionValidator = void 0;
var type_validate_1 = __webpack_require__(3);
function createActionValidator(type, payloadSchema, payloadRequired, idRequired) {
    if (payloadSchema === void 0) { payloadSchema = undefined; }
    if (payloadRequired === void 0) { payloadRequired = false; }
    if (idRequired === void 0) { idRequired = false; }
    var idSchema = type_validate_1.matchesObject({
        id: idRequired ? type_validate_1.matchesString() : type_validate_1.makeOptional(type_validate_1.matchesString()),
    });
    var schema = payloadSchema ? type_validate_1.composeSchemas(idSchema, payloadSchema) : idSchema;
    return type_validate_1.matchesObject({
        type: type_validate_1.matchesEnum(type, {
            message: function (_, val) { return "The action type `" + val + "` is invalid or unsupported"; },
        }),
        payload: payloadRequired ? schema : type_validate_1.makeOptional(schema),
    });
}
exports.createActionValidator = createActionValidator;
function isValidRelativePath(path) {
    return typeof path === 'string' && (path === '' || path.startsWith('/'));
}
exports.isValidRelativePath = isValidRelativePath;
exports.relativeUrlSchema = type_validate_1.composeSchemas(type_validate_1.matchesString(), function (value) {
    return isValidRelativePath(value)
        ? undefined
        : [{ error: 'invalid_relative_path', value: value, message: 'expected string to start with `/`' }];
});
exports.relativePathSchema = type_validate_1.matchesObject({
    path: exports.relativeUrlSchema,
});


/***/ }),
/* 5 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Button = exports.update = exports.clickButton = exports.Style = exports.Icon = exports.Action = void 0;
var helper_1 = __webpack_require__(0);
var ActionSet_1 = __webpack_require__(2);
var types_1 = __webpack_require__(1);
var Action;
(function (Action) {
    Action["CLICK"] = "CLICK";
    Action["UPDATE"] = "UPDATE";
})(Action = exports.Action || (exports.Action = {}));
var Icon;
(function (Icon) {
    Icon["Print"] = "print";
})(Icon = exports.Icon || (exports.Icon = {}));
var Style;
(function (Style) {
    Style["Danger"] = "danger";
})(Style = exports.Style || (exports.Style = {}));
function clickButton(group, component, payload) {
    var id = component.id;
    var action = helper_1.getEventNameSpace(group, Action.CLICK, component);
    var buttonPayload = {
        id: id,
        payload: payload,
    };
    return helper_1.actionWrapper({ type: action, group: group, payload: buttonPayload });
}
exports.clickButton = clickButton;
function update(group, component, props) {
    var id = component.id;
    var label = props.label;
    var action = helper_1.getEventNameSpace(group, Action.UPDATE, component);
    var buttonPayload = __assign(__assign({}, props), { id: id, label: label });
    return helper_1.actionWrapper({ type: action, group: group, payload: buttonPayload });
}
exports.update = update;
var Button = /** @class */ (function (_super) {
    __extends(Button, _super);
    function Button(app, options) {
        var _this = _super.call(this, app, types_1.ComponentType.Button, types_1.Group.Button) || this;
        _this.disabled = false;
        _this.loading = false;
        _this.plain = false;
        _this.set(options, false);
        return _this;
    }
    Object.defineProperty(Button.prototype, "options", {
        get: function () {
            return {
                disabled: this.disabled,
                icon: this.icon,
                label: this.label,
                style: this.style,
                loading: this.loading,
                plain: this.plain,
            };
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Button.prototype, "payload", {
        get: function () {
            return __assign(__assign({}, this.options), { id: this.id });
        },
        enumerable: false,
        configurable: true
    });
    Button.prototype.set = function (options, shouldUpdate) {
        if (shouldUpdate === void 0) { shouldUpdate = true; }
        var mergedOptions = helper_1.getMergedProps(this.options, options);
        var label = mergedOptions.label, disabled = mergedOptions.disabled, icon = mergedOptions.icon, style = mergedOptions.style, loading = mergedOptions.loading, plain = mergedOptions.plain;
        this.label = label;
        this.disabled = Boolean(disabled);
        this.icon = icon;
        this.style = style;
        this.loading = Boolean(loading);
        this.plain = Boolean(plain);
        if (shouldUpdate) {
            this.dispatch(Action.UPDATE);
        }
        return this;
    };
    Button.prototype.dispatch = function (action, payload) {
        switch (action) {
            case Action.CLICK:
                this.app.dispatch(clickButton(this.group, this.component, payload));
                break;
            case Action.UPDATE: {
                var updateAction = update(this.group, this.component, this.payload);
                this.app.dispatch(updateAction);
                break;
            }
        }
        return this;
    };
    return Button;
}(ActionSet_1.ActionSet));
exports.Button = Button;


/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getPackageName = exports.getVersion = exports.getMergedProps = exports.updateActionFromPayload = exports.isValidOptionalString = exports.isValidOptionalNumber = exports.NonSnakeCaseGroup = exports.getEventNameSpace = exports.forEachInEnum = exports.findMatchInEnum = exports.actionWrapper = void 0;
var helper_1 = __webpack_require__(0);
Object.defineProperty(exports, "actionWrapper", { enumerable: true, get: function () { return helper_1.actionWrapper; } });
Object.defineProperty(exports, "findMatchInEnum", { enumerable: true, get: function () { return helper_1.findMatchInEnum; } });
Object.defineProperty(exports, "forEachInEnum", { enumerable: true, get: function () { return helper_1.forEachInEnum; } });
Object.defineProperty(exports, "getEventNameSpace", { enumerable: true, get: function () { return helper_1.getEventNameSpace; } });
Object.defineProperty(exports, "NonSnakeCaseGroup", { enumerable: true, get: function () { return helper_1.NonSnakeCaseGroup; } });
Object.defineProperty(exports, "isValidOptionalNumber", { enumerable: true, get: function () { return helper_1.isValidOptionalNumber; } });
Object.defineProperty(exports, "isValidOptionalString", { enumerable: true, get: function () { return helper_1.isValidOptionalString; } });
Object.defineProperty(exports, "updateActionFromPayload", { enumerable: true, get: function () { return helper_1.updateActionFromPayload; } });
Object.defineProperty(exports, "getMergedProps", { enumerable: true, get: function () { return helper_1.getMergedProps; } });
// eslint-disable-next-line @typescript-eslint/no-var-requires
var packageJson = __webpack_require__(72);
function getVersion() {
    return packageJson.version;
}
exports.getVersion = getVersion;
function getPackageName() {
    return packageJson.name;
}
exports.getPackageName = getPackageName;


/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionSetPayload = exports.ComplexDispatch = exports.DispatchAction = exports.ClickAction = exports.ComponentType = exports.ActionSetProps = exports.ActionSetOptions = exports.Dispatch = exports.ErrorCallback = exports.UpdateSubscribe = exports.ActionSubscription = exports.ErrorSubscriber = exports.UpdateSubscription = exports.ActionSetInterface = exports.Component = exports.Group = exports.ClientInterface = exports.SimpleDispatch = exports.Unsubscribe = exports.MetaAction = exports.AnyAction = exports.ActionCallback = void 0;
var types_1 = __webpack_require__(1);
Object.defineProperty(exports, "ActionCallback", { enumerable: true, get: function () { return types_1.ActionCallback; } });
Object.defineProperty(exports, "AnyAction", { enumerable: true, get: function () { return types_1.AnyAction; } });
Object.defineProperty(exports, "MetaAction", { enumerable: true, get: function () { return types_1.MetaAction; } });
Object.defineProperty(exports, "Unsubscribe", { enumerable: true, get: function () { return types_1.Unsubscribe; } });
Object.defineProperty(exports, "SimpleDispatch", { enumerable: true, get: function () { return types_1.SimpleDispatch; } });
Object.defineProperty(exports, "ClientInterface", { enumerable: true, get: function () { return types_1.ClientInterface; } });
Object.defineProperty(exports, "Group", { enumerable: true, get: function () { return types_1.Group; } });
Object.defineProperty(exports, "Component", { enumerable: true, get: function () { return types_1.Component; } });
Object.defineProperty(exports, "ActionSetInterface", { enumerable: true, get: function () { return types_1.ActionSetInterface; } });
Object.defineProperty(exports, "UpdateSubscription", { enumerable: true, get: function () { return types_1.UpdateSubscription; } });
Object.defineProperty(exports, "ErrorSubscriber", { enumerable: true, get: function () { return types_1.ErrorSubscriber; } });
Object.defineProperty(exports, "ActionSubscription", { enumerable: true, get: function () { return types_1.ActionSubscription; } });
Object.defineProperty(exports, "UpdateSubscribe", { enumerable: true, get: function () { return types_1.UpdateSubscribe; } });
Object.defineProperty(exports, "ErrorCallback", { enumerable: true, get: function () { return types_1.ErrorCallback; } });
Object.defineProperty(exports, "Dispatch", { enumerable: true, get: function () { return types_1.Dispatch; } });
Object.defineProperty(exports, "ActionSetOptions", { enumerable: true, get: function () { return types_1.ActionSetOptions; } });
Object.defineProperty(exports, "ActionSetProps", { enumerable: true, get: function () { return types_1.ActionSetProps; } });
Object.defineProperty(exports, "ComponentType", { enumerable: true, get: function () { return types_1.ComponentType; } });
Object.defineProperty(exports, "ClickAction", { enumerable: true, get: function () { return types_1.ClickAction; } });
Object.defineProperty(exports, "DispatchAction", { enumerable: true, get: function () { return types_1.DispatchAction; } });
Object.defineProperty(exports, "ComplexDispatch", { enumerable: true, get: function () { return types_1.ComplexDispatch; } });
Object.defineProperty(exports, "ActionSetPayload", { enumerable: true, get: function () { return types_1.ActionSetPayload; } });


/***/ }),
/* 8 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.mixedAppClientCheck = exports.actionMessage = exports.relativePathSchema = exports.relativeUrlSchema = exports.isValidRelativePath = exports.createActionValidator = void 0;
var utils_1 = __webpack_require__(4);
Object.defineProperty(exports, "createActionValidator", { enumerable: true, get: function () { return utils_1.createActionValidator; } });
Object.defineProperty(exports, "isValidRelativePath", { enumerable: true, get: function () { return utils_1.isValidRelativePath; } });
Object.defineProperty(exports, "relativeUrlSchema", { enumerable: true, get: function () { return utils_1.relativeUrlSchema; } });
Object.defineProperty(exports, "relativePathSchema", { enumerable: true, get: function () { return utils_1.relativePathSchema; } });
function actionMessage(errors) {
    return errors
        .map(function (err) {
        var path = err.path, error = err.error, message = err.message, value = err.value;
        var valueStr = typeof value === 'object' ? JSON.stringify(value) : value;
        return "`" + error + "` thrown for" + (path ? " path: " + path + " and" : '') + " value: `" + valueStr + "`" + (message ? " with message: " + message : '');
    })
        .join(' | ');
}
exports.actionMessage = actionMessage;
function mixedAppClientCheck(window) {
    window.addEventListener('DOMContentLoaded', function () {
        if (!Object.prototype.hasOwnProperty.call(window, 'ShopifyApp')) {
            return;
        }
        // eslint-disable-next-line no-console
        console.error("%cException Detected \uD83D\uDEAB\n\n%cAn instance of the EASDK client was detected while initializing Shopify App Bridge. Using Shopify App Bridge and the EASDK simultaneously is not supported.\n\nIf you're migrating an existing app that was built with the shopify_app gem, then the EASDK client might have been included in the home page view template. In this case, remove it from your app before initializing Shopify App Bridge again.", 'font-size: large;', 'font-size: normal;');
    }, { once: true });
}
exports.mixedAppClientCheck = mixedAppClientCheck;


/***/ }),
/* 9 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.ButtonGroup = exports.isGroupedButtonPayload = exports.isGroupedButton = exports.update = exports.Action = void 0;
var buttonHelper_1 = __webpack_require__(17);
var helper_1 = __webpack_require__(0);
var ActionSet_1 = __webpack_require__(2);
var types_1 = __webpack_require__(1);
var Action;
(function (Action) {
    Action["UPDATE"] = "UPDATE";
})(Action = exports.Action || (exports.Action = {}));
function update(group, component, props) {
    return buttonActionWrapper(group, component, Action.UPDATE, props);
}
exports.update = update;
function isGroupedButton(options) {
    var castOptions = options;
    return castOptions.buttons && castOptions.buttons.length > 0 && castOptions.label !== undefined;
}
exports.isGroupedButton = isGroupedButton;
function isGroupedButtonPayload(payload) {
    var castOptions = payload;
    return (Array.isArray(castOptions.buttons) &&
        typeof castOptions.id === 'string' &&
        typeof castOptions.label === 'string');
}
exports.isGroupedButtonPayload = isGroupedButtonPayload;
var ButtonGroup = /** @class */ (function (_super) {
    __extends(ButtonGroup, _super);
    function ButtonGroup(app, options) {
        var _this = _super.call(this, app, types_1.ComponentType.ButtonGroup, types_1.Group.ButtonGroup) || this;
        _this.disabled = false;
        _this.plain = false;
        _this.buttonsOptions = [];
        _this.buttons = [];
        _this.set(options, false);
        return _this;
    }
    Object.defineProperty(ButtonGroup.prototype, "options", {
        get: function () {
            return {
                buttons: this.buttonsOptions,
                disabled: this.disabled,
                label: this.label,
                plain: this.plain,
            };
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ButtonGroup.prototype, "payload", {
        get: function () {
            return __assign(__assign({}, this.options), { buttons: this.buttons, id: this.id });
        },
        enumerable: false,
        configurable: true
    });
    ButtonGroup.prototype.set = function (options, shouldUpdate) {
        if (shouldUpdate === void 0) { shouldUpdate = true; }
        var mergedOptions = helper_1.getMergedProps(this.options, options);
        var label = mergedOptions.label, disabled = mergedOptions.disabled, buttons = mergedOptions.buttons, plain = mergedOptions.plain;
        this.label = label;
        this.disabled = Boolean(disabled);
        this.buttons = this.getButtons(buttons);
        this.plain = Boolean(plain);
        if (shouldUpdate) {
            this.dispatch(Action.UPDATE);
        }
        return this;
    };
    ButtonGroup.prototype.dispatch = function (action) {
        switch (action) {
            case Action.UPDATE: {
                var updateAction = update(this.group, this.component, this.payload);
                this.app.dispatch(updateAction);
                break;
            }
        }
        return this;
    };
    ButtonGroup.prototype.updateButtons = function (newPayload) {
        if (!this.buttons || this.buttons.length === 0) {
            return;
        }
        var updated;
        for (var _i = 0, _a = this.buttons; _i < _a.length; _i++) {
            var action = _a[_i];
            updated = helper_1.updateActionFromPayload(action, newPayload);
            if (updated) {
                break;
            }
        }
        if (updated) {
            this.dispatch(Action.UPDATE);
        }
    };
    ButtonGroup.prototype.getSingleButton = function (button) {
        return buttonHelper_1.getSingleButton(this, button, this.subgroups, this.updateButtons);
    };
    ButtonGroup.prototype.getButtons = function (buttonOptions) {
        var _this = this;
        var buttons = [];
        if (!buttonOptions) {
            return [];
        }
        buttonOptions.forEach(function (button) {
            var singleButton = buttonHelper_1.getSingleButton(_this, button, _this.subgroups, _this.updateButtons);
            buttons.push(singleButton);
        });
        this.buttonsOptions = buttonOptions;
        return buttons;
    };
    return ButtonGroup;
}(ActionSet_1.ActionSetWithChildren));
exports.ButtonGroup = ButtonGroup;
function create(app, options) {
    return new ButtonGroup(app, options);
}
exports.create = create;
function buttonActionWrapper(group, component, eventName, props, payload) {
    var id = component.id;
    var label = props.label;
    var action = helper_1.getEventNameSpace(group, eventName, component);
    var buttonPayload = __assign(__assign({}, props), { id: id, label: label, payload: payload });
    return helper_1.actionWrapper({ type: action, group: group, payload: buttonPayload });
}


/***/ }),
/* 10 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.matchesPositiveNumber = exports.TYPE_ERROR = exports.Options = exports.ValidationError = exports.Validator = exports.oneOf = exports.matchesArray = exports.validate = exports.matchesPositiveInteger = exports.matchesBoolean = exports.makeOptional = exports.matchesString = exports.Schema = exports.matchesObject = exports.ErrorMessageCallback = exports.Indexable = exports.matchesEnum = exports.composeSchemas = void 0;
var type_validate_1 = __webpack_require__(3);
Object.defineProperty(exports, "Validator", { enumerable: true, get: function () { return type_validate_1.Validator; } });
Object.defineProperty(exports, "ValidationError", { enumerable: true, get: function () { return type_validate_1.ValidationError; } });
Object.defineProperty(exports, "Options", { enumerable: true, get: function () { return type_validate_1.Options; } });
Object.defineProperty(exports, "TYPE_ERROR", { enumerable: true, get: function () { return type_validate_1.TYPE_ERROR; } });
var type_validate_2 = __webpack_require__(3);
Object.defineProperty(exports, "composeSchemas", { enumerable: true, get: function () { return type_validate_2.composeSchemas; } });
Object.defineProperty(exports, "matchesEnum", { enumerable: true, get: function () { return type_validate_2.matchesEnum; } });
Object.defineProperty(exports, "Indexable", { enumerable: true, get: function () { return type_validate_2.Indexable; } });
Object.defineProperty(exports, "ErrorMessageCallback", { enumerable: true, get: function () { return type_validate_2.ErrorMessageCallback; } });
Object.defineProperty(exports, "matchesObject", { enumerable: true, get: function () { return type_validate_2.matchesObject; } });
Object.defineProperty(exports, "Schema", { enumerable: true, get: function () { return type_validate_2.Schema; } });
Object.defineProperty(exports, "matchesString", { enumerable: true, get: function () { return type_validate_2.matchesString; } });
Object.defineProperty(exports, "makeOptional", { enumerable: true, get: function () { return type_validate_2.makeOptional; } });
Object.defineProperty(exports, "matchesBoolean", { enumerable: true, get: function () { return type_validate_2.matchesBoolean; } });
Object.defineProperty(exports, "matchesPositiveInteger", { enumerable: true, get: function () { return type_validate_2.matchesPositiveInteger; } });
Object.defineProperty(exports, "validate", { enumerable: true, get: function () { return type_validate_2.validate; } });
Object.defineProperty(exports, "matchesArray", { enumerable: true, get: function () { return type_validate_2.matchesArray; } });
Object.defineProperty(exports, "oneOf", { enumerable: true, get: function () { return type_validate_2.oneOf; } });
function constructErrors(value, error, options) {
    if (options === void 0) { options = { message: undefined }; }
    return [
        {
            value: value,
            error: error,
            message: typeof options.message === 'function' ? options.message(error, value) : options.message,
        },
    ];
}
function matchesPositiveNumber(options) {
    return function (value) {
        return Number.isNaN(value) || !Number.isFinite(value) || value < 0
            ? constructErrors(value, type_validate_1.TYPE_ERROR + "_number", options)
            : undefined;
    };
}
exports.matchesPositiveNumber = matchesPositiveNumber;


/***/ }),
/* 11 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.networkAction = exports.persistenceAction = exports.unsupportedOperationAction = exports.unexpectedAction = exports.invalidAction = exports.invalidActionType = exports.invalidPayload = exports.Message = exports.ErrorAction = exports.fromAction = exports.Action = exports.permissionAction = exports.isErrorEventName = exports.throwError = exports.invalidOriginAction = exports.AppBridgeError = exports.AppActionType = void 0;
var Error_1 = __webpack_require__(12);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Error_1.Action; } });
Object.defineProperty(exports, "fromAction", { enumerable: true, get: function () { return Error_1.fromAction; } });
Object.defineProperty(exports, "ErrorAction", { enumerable: true, get: function () { return Error_1.ErrorAction; } });
var helper_1 = __webpack_require__(6);
var types_1 = __webpack_require__(7);
var Error_2 = __webpack_require__(12);
Object.defineProperty(exports, "AppActionType", { enumerable: true, get: function () { return Error_2.AppActionType; } });
Object.defineProperty(exports, "AppBridgeError", { enumerable: true, get: function () { return Error_2.AppBridgeError; } });
Object.defineProperty(exports, "invalidOriginAction", { enumerable: true, get: function () { return Error_2.invalidOriginAction; } });
Object.defineProperty(exports, "throwError", { enumerable: true, get: function () { return Error_2.throwError; } });
Object.defineProperty(exports, "isErrorEventName", { enumerable: true, get: function () { return Error_2.isErrorEventName; } });
Object.defineProperty(exports, "permissionAction", { enumerable: true, get: function () { return Error_2.permissionAction; } });
function errorActionWrapperWithId(type, action, message) {
    var castPayload = action.payload;
    return helper_1.actionWrapper({
        type: type,
        group: types_1.Group.Error,
        payload: {
            action: action,
            message: message,
            type: type,
            id: castPayload && castPayload.id ? castPayload.id : undefined,
        },
    });
}
var Message;
(function (Message) {
    Message["MISSING_PAYLOAD"] = "Missing payload";
    Message["INVALID_PAYLOAD_ID"] = "Id in payload is missing or invalid";
})(Message = exports.Message || (exports.Message = {}));
function invalidPayload(action, message) {
    return errorActionWrapperWithId(Error_1.Action.INVALID_PAYLOAD, action, message || "The action's payload is missing required properties or has invalid properties");
}
exports.invalidPayload = invalidPayload;
function invalidActionType(action, message) {
    return helper_1.actionWrapper({
        group: types_1.Group.Error,
        payload: {
            action: action,
            message: message || 'The action type is invalid or unsupported',
            type: Error_1.Action.INVALID_ACTION_TYPE,
        },
        type: Error_1.Action.INVALID_ACTION_TYPE,
    });
}
exports.invalidActionType = invalidActionType;
function invalidAction(action, message) {
    return helper_1.actionWrapper({
        group: types_1.Group.Error,
        payload: {
            action: action,
            message: message || "The action's has missing/invalid values for `group`, `type` or `version`",
            type: Error_1.Action.INVALID_ACTION,
        },
        type: Error_1.Action.INVALID_ACTION,
    });
}
exports.invalidAction = invalidAction;
function unexpectedAction(action, message) {
    return helper_1.actionWrapper({
        group: types_1.Group.Error,
        payload: {
            action: action,
            message: message || 'Action cannot be called at this time',
            type: Error_1.Action.UNEXPECTED_ACTION,
        },
        type: Error_1.Action.UNEXPECTED_ACTION,
    });
}
exports.unexpectedAction = unexpectedAction;
function unsupportedOperationAction(action, message) {
    return errorActionWrapperWithId(Error_1.Action.UNSUPPORTED_OPERATION, action, message || 'The action type is unsupported');
}
exports.unsupportedOperationAction = unsupportedOperationAction;
function persistenceAction(action, message) {
    return errorActionWrapperWithId(Error_1.Action.PERSISTENCE, action, message || 'Action cannot be persisted on server');
}
exports.persistenceAction = persistenceAction;
function networkAction(action, message) {
    return errorActionWrapperWithId(Error_1.Action.NETWORK, action, message || 'Network error');
}
exports.networkAction = networkAction;


/***/ }),
/* 12 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.permissionAction = exports.isErrorEventName = exports.throwError = exports.invalidOriginAction = exports.fromAction = exports.AppBridgeError = exports.AppActionType = exports.Action = void 0;
var types_1 = __webpack_require__(1);
var helper_1 = __webpack_require__(0);
// Errors triggered in response to an action
var Action;
(function (Action) {
    Action["INVALID_ACTION"] = "APP::ERROR::INVALID_ACTION";
    Action["INVALID_ACTION_TYPE"] = "APP::ERROR::INVALID_ACTION_TYPE";
    Action["INVALID_PAYLOAD"] = "APP::ERROR::INVALID_PAYLOAD";
    Action["INVALID_OPTIONS"] = "APP::ERROR::INVALID_OPTIONS";
    Action["UNEXPECTED_ACTION"] = "APP::ERROR::UNEXPECTED_ACTION";
    Action["PERSISTENCE"] = "APP::ERROR::PERSISTENCE";
    Action["UNSUPPORTED_OPERATION"] = "APP::ERROR::UNSUPPORTED_OPERATION";
    Action["NETWORK"] = "APP::ERROR::NETWORK";
    Action["PERMISSION"] = "APP::ERROR::PERMISSION";
    Action["FAILED_AUTHENTICATION"] = "APP::ERROR::FAILED_AUTHENTICATION";
    Action["INVALID_ORIGIN"] = "APP::ERROR::INVALID_ORIGIN";
})(Action = exports.Action || (exports.Action = {}));
// Errors thrown in response to app setup
var AppActionType;
(function (AppActionType) {
    AppActionType["INVALID_CONFIG"] = "APP::ERROR::INVALID_CONFIG";
    AppActionType["MISSING_CONFIG"] = "APP::APP_ERROR::MISSING_CONFIG";
    AppActionType["MISSING_APP_BRIDGE_MIDDLEWARE"] = "APP::APP_ERROR::MISSING_APP_BRIDGE_MIDDLEWARE";
    AppActionType["WINDOW_UNDEFINED"] = "APP::APP_ERROR::WINDOW_UNDEFINED";
    AppActionType["REDUX_REINSTANTIATED"] = "APP::APP_ERROR::REDUX_REINSTANTIATED";
    AppActionType["MISSING_LOCAL_ORIGIN"] = "APP::APP_ERROR::MISSING_LOCAL_ORIGIN";
    AppActionType["MISSING_HOST_PROVIDER"] = "APP::APP_ERROR::MISSING_HOST_PROVIDER";
    AppActionType["MISSING_ROUTER_CONTEXT"] = "APP::APP_ERROR::MISSING_ROUTER_CONTEXT";
    AppActionType["MISSING_HISTORY_BLOCK"] = "APP::APP_ERROR::MISSING_HISTORY_BLOCK";
})(AppActionType = exports.AppActionType || (exports.AppActionType = {}));
var AppBridgeError = /** @class */ (function () {
    function AppBridgeError(message) {
        this.name = 'AppBridgeError';
        this.message = message;
        if (typeof Error.captureStackTrace === 'function') {
            Error.captureStackTrace(this, this.constructor);
        }
        else {
            this.stack = new Error(this.message).stack;
        }
    }
    return AppBridgeError;
}());
exports.AppBridgeError = AppBridgeError;
AppBridgeError.prototype = Object.create(Error.prototype);
function fromAction(message, type, action) {
    var errorMessage = message ? type + ": " + message : type;
    var error = new AppBridgeError(errorMessage);
    error.action = action;
    error.type = type;
    return error;
}
exports.fromAction = fromAction;
function invalidOriginAction(message) {
    return helper_1.actionWrapper({
        group: types_1.Group.Error,
        payload: {
            message: message,
            type: Action.INVALID_ORIGIN,
        },
        type: Action.INVALID_ORIGIN,
    });
}
exports.invalidOriginAction = invalidOriginAction;
function throwError() {
    var args = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        args[_i] = arguments[_i];
    }
    var type = args[0];
    var message;
    var action;
    if (typeof args[1] === 'string') {
        message = args[1];
    }
    else {
        action = args[1];
        message = args[2] || '';
    }
    throw fromAction(message, type, action);
}
exports.throwError = throwError;
function isErrorEventName(eventName) {
    var match = helper_1.findMatchInEnum(Action, eventName);
    return typeof match === 'string';
}
exports.isErrorEventName = isErrorEventName;
function errorActionWrapperWithId(type, action, message) {
    var castPayload = action.payload;
    return helper_1.actionWrapper({
        type: type,
        group: types_1.Group.Error,
        payload: {
            action: action,
            message: message,
            type: type,
            id: castPayload && castPayload.id ? castPayload.id : undefined,
        },
    });
}
function permissionAction(action, message) {
    return errorActionWrapperWithId(Action.PERMISSION, action, message || 'Action is not permitted');
}
exports.permissionAction = permissionAction;


/***/ }),
/* 13 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.LifecycleHook = exports.PermissionType = exports.MessageType = void 0;
/**
 * @internal
 */
var MessageType;
(function (MessageType) {
    MessageType["GetState"] = "getState";
    MessageType["Dispatch"] = "dispatch";
    MessageType["Subscribe"] = "subscribe";
    MessageType["Unsubscribe"] = "unsubscribe";
})(MessageType = exports.MessageType || (exports.MessageType = {}));
/**
 * @internal
 */
var PermissionType;
(function (PermissionType) {
    PermissionType["Dispatch"] = "Dispatch";
    PermissionType["Subscribe"] = "Subscribe";
})(PermissionType = exports.PermissionType || (exports.PermissionType = {}));
/**
 *
 * There are two types of hooks: `LifecycleHook.DispatchAction` and `LifecycleHook.UpdateAction`.
 *
 * @remarks
 * `DispatchAction` hooks are run when an action is dispatched with the `.dispatch()` function:
 *
 * ```js
 * const toastNotice = Toast.create(app, {message: 'Product saved'});
 * toastNotice.dispatch(Toast.Action.SHOW);
 * ```
 *
 * `UpdateAction` hooks are run when an action is updated, using the `.set()` function:
 *
 * ```js
 * toastNotice.set({message: 'Product could not be saved', isError: true});
 * ```
 *
 * @public
 */
var LifecycleHook;
(function (LifecycleHook) {
    LifecycleHook["UpdateAction"] = "UpdateAction";
    LifecycleHook["DispatchAction"] = "DispatchAction";
})(LifecycleHook = exports.LifecycleHook || (exports.LifecycleHook = {}));


/***/ }),
/* 14 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppLink = exports.update = exports.Action = void 0;
var helper_1 = __webpack_require__(0);
var ActionSet_1 = __webpack_require__(2);
var types_1 = __webpack_require__(1);
var Redirect_1 = __webpack_require__(18);
var Action;
(function (Action) {
    Action["UPDATE"] = "UPDATE";
})(Action = exports.Action || (exports.Action = {}));
function update(group, component, updatePayload) {
    var id = component.id;
    var label = updatePayload.label, destination = updatePayload.destination;
    var linkPayload = __assign(__assign({}, updatePayload), { id: id, label: label, destination: destination });
    return helper_1.actionWrapper({
        group: group,
        type: helper_1.getEventNameSpace(group, Action.UPDATE, component),
        payload: linkPayload,
    });
}
exports.update = update;
var AppLink = /** @class */ (function (_super) {
    __extends(AppLink, _super);
    function AppLink(app, options) {
        var _this = _super.call(this, app, types_1.Group.Link, types_1.Group.Link) || this;
        _this.label = '';
        _this.destination = '';
        _this.set(options, false);
        return _this;
    }
    Object.defineProperty(AppLink.prototype, "options", {
        get: function () {
            var _a = this, label = _a.label, destination = _a.destination;
            return {
                label: label,
                destination: destination,
                redirectType: Redirect_1.Action.APP,
            };
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AppLink.prototype, "payload", {
        get: function () {
            var _a = this.options, label = _a.label, destination = _a.destination, redirectType = _a.redirectType;
            var path = destination;
            return {
                id: this.id,
                label: label,
                destination: { path: path },
                redirectType: redirectType,
            };
        },
        enumerable: false,
        configurable: true
    });
    AppLink.prototype.set = function (options, shouldUpdate) {
        if (shouldUpdate === void 0) { shouldUpdate = true; }
        var _a = helper_1.getMergedProps(this.options, options), label = _a.label, destination = _a.destination;
        this.label = label;
        this.destination = destination;
        if (shouldUpdate) {
            this.dispatch(Action.UPDATE);
        }
        return this;
    };
    AppLink.prototype.dispatch = function (action) {
        switch (action) {
            case Action.UPDATE: {
                var updateAction = update(this.group, this.component, this.payload);
                this.app.dispatch(updateAction);
                break;
            }
        }
        return this;
    };
    return AppLink;
}(ActionSet_1.ActionSet));
exports.AppLink = AppLink;


/***/ }),
/* 15 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
var Client_1 = __webpack_require__(37);
__exportStar(__webpack_require__(43), exports);
__exportStar(__webpack_require__(37), exports);
exports.default = Client_1.createClientApp;


/***/ }),
/* 16 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = exports.validateAction = exports.validateProps = exports.buttonSchemaWithId = exports.buttonSchema = void 0;
var Button_1 = __webpack_require__(5);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Button_1.Action; } });
var type_validate_1 = __webpack_require__(3);
var utils_1 = __webpack_require__(4);
exports.buttonSchema = type_validate_1.matchesObject({
    disabled: type_validate_1.makeOptional(type_validate_1.matchesBoolean()),
    label: type_validate_1.matchesString(),
    style: type_validate_1.makeOptional(type_validate_1.matchesEnum(Button_1.Style)),
    icon: type_validate_1.makeOptional(type_validate_1.matchesEnum(Button_1.Icon)),
    loading: type_validate_1.makeOptional(type_validate_1.matchesBoolean()),
    plain: type_validate_1.makeOptional(type_validate_1.matchesBoolean()),
});
exports.buttonSchemaWithId = type_validate_1.composeSchemas(type_validate_1.matchesObject({
    id: type_validate_1.matchesString(),
}), exports.buttonSchema);
function validateProps(props) {
    return type_validate_1.validate(props, exports.buttonSchema);
}
exports.validateProps = validateProps;
function validateAction(action) {
    var validator = utils_1.createActionValidator(Button_1.Action, action.type === Button_1.Action.UPDATE ? exports.buttonSchema : undefined, true, true);
    return type_validate_1.validate(action, validator);
}
exports.validateAction = validateAction;


/***/ }),
/* 17 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getSingleButton = void 0;
var Button_1 = __webpack_require__(5);
function getSingleButton(action, button, subgroups, updateCb) {
    action.addChild(button, action.group, subgroups);
    action.subscribeToChild(button, Button_1.Action.UPDATE, updateCb);
    return button.payload;
}
exports.getSingleButton = getSingleButton;


/***/ }),
/* 18 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Redirect = exports.isProductVariantResourcePayload = exports.isCreateResourcePayload = exports.isAdminSection = exports.isRemotePayload = exports.isAdminSectionPayload = exports.isAdminPathPayload = exports.isAppPayload = exports.getRelativePath = exports.normalizeUrl = exports.getPathWithSearchAndHash = exports.toDestination = exports.toApp = exports.toRemote = exports.toAdminSection = exports.toAdminPath = exports.isResourcePayload = exports.ResourceType = exports.Action = void 0;
var helper_1 = __webpack_require__(0);
var ActionSet_1 = __webpack_require__(2);
var types_1 = __webpack_require__(1);
var Action;
(function (Action) {
    Action["ADMIN_SECTION"] = "APP::NAVIGATION::REDIRECT::ADMIN::SECTION";
    Action["ADMIN_PATH"] = "APP::NAVIGATION::REDIRECT::ADMIN::PATH";
    Action["REMOTE"] = "APP::NAVIGATION::REDIRECT::REMOTE";
    Action["APP"] = "APP::NAVIGATION::REDIRECT::APP";
})(Action = exports.Action || (exports.Action = {}));
var ResourceType;
(function (ResourceType) {
    ResourceType["Product"] = "products";
    ResourceType["Collection"] = "collections";
    ResourceType["Order"] = "orders";
    ResourceType["Customer"] = "customers";
    ResourceType["Discount"] = "discounts";
})(ResourceType = exports.ResourceType || (exports.ResourceType = {}));
function isResourcePayload(resource) {
    // tslint:disable-next-line:no-boolean-literal-compare
    return typeof resource.id === 'string';
}
exports.isResourcePayload = isResourcePayload;
function toAdminPath(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.Navigation,
        type: Action.ADMIN_PATH,
    });
}
exports.toAdminPath = toAdminPath;
function toAdminSection(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.Navigation,
        type: Action.ADMIN_SECTION,
    });
}
exports.toAdminSection = toAdminSection;
function toRemote(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.Navigation,
        type: Action.REMOTE,
    });
}
exports.toRemote = toRemote;
function toApp(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.Navigation,
        type: Action.APP,
    });
}
exports.toApp = toApp;
function toDestination(action, payload, id) {
    switch (action) {
        case Action.APP: {
            var appPayload = isAppPayload(payload) ? payload : { path: payload };
            return toApp(__assign({ id: id }, appPayload));
        }
        case Action.ADMIN_PATH: {
            var adminPathPayload = isAdminPathPayload(payload) ? payload : { path: payload };
            return toAdminPath(__assign({ id: id }, adminPathPayload));
        }
        case Action.ADMIN_SECTION: {
            var adminSectionPayload = isAdminSectionPayload(payload)
                ? payload
                : { section: payload };
            return toAdminSection(__assign({ id: id }, adminSectionPayload));
        }
        case Action.REMOTE: {
            var remotePayload = isRemotePayload(payload) ? payload : { url: payload };
            return toRemote(__assign({ id: id }, remotePayload));
        }
    }
}
exports.toDestination = toDestination;
function getPathWithSearchAndHash(_a) {
    var pathname = _a.pathname, search = _a.search, hash = _a.hash;
    return "" + pathname + (search || '') + (hash || '');
}
exports.getPathWithSearchAndHash = getPathWithSearchAndHash;
function normalizeUrl(to) {
    if (to instanceof URL) {
        return to.toString();
    }
    if (typeof to === 'string') {
        return to;
    }
    return getRelativePath(to);
}
exports.normalizeUrl = normalizeUrl;
function getRelativePath(to) {
    if (typeof to === 'string') {
        if (to.startsWith('/')) {
            return to;
        }
        return getPathWithSearchAndHash(new URL(to));
    }
    var search = to.search instanceof URLSearchParams ? to.search.toString() : to.search;
    return getPathWithSearchAndHash(__assign(__assign({}, to), { search: search }));
}
exports.getRelativePath = getRelativePath;
function isAppPayload(payload) {
    return typeof payload === 'object' && Object.prototype.hasOwnProperty.call(payload, 'path');
}
exports.isAppPayload = isAppPayload;
function isAdminPathPayload(payload) {
    return typeof payload === 'object' && Object.prototype.hasOwnProperty.call(payload, 'path');
}
exports.isAdminPathPayload = isAdminPathPayload;
function isAdminSectionPayload(payload) {
    return (typeof payload === 'object' &&
        typeof payload.section === 'object' &&
        Object.prototype.hasOwnProperty.call(payload.section, 'name'));
}
exports.isAdminSectionPayload = isAdminSectionPayload;
function isRemotePayload(payload) {
    return typeof payload === 'object' && Object.prototype.hasOwnProperty.call(payload, 'url');
}
exports.isRemotePayload = isRemotePayload;
function isAdminSection(to) {
    return typeof to === 'object' && typeof (to === null || to === void 0 ? void 0 : to.name) === 'string';
}
exports.isAdminSection = isAdminSection;
function isCreateResourcePayload(resource) {
    // tslint:disable-next-line:no-boolean-literal-compare
    return resource.create === true;
}
exports.isCreateResourcePayload = isCreateResourcePayload;
function isProductVariantResourcePayload(resource) {
    var castResource = resource;
    // tslint:disable-next-line:no-boolean-literal-compare
    return castResource.id !== undefined && castResource.variant !== undefined;
}
exports.isProductVariantResourcePayload = isProductVariantResourcePayload;
var Redirect = /** @class */ (function (_super) {
    __extends(Redirect, _super);
    function Redirect(app) {
        return _super.call(this, app, 'Redirect', types_1.Group.Navigation) || this;
    }
    Object.defineProperty(Redirect.prototype, "payload", {
        get: function () {
            return { id: this.id };
        },
        enumerable: false,
        configurable: true
    });
    Redirect.prototype.dispatch = function (action, payload) {
        var redirectAction = toDestination(action, payload, this.payload.id);
        this.app.dispatch(redirectAction);
        return this;
    };
    return Redirect;
}(ActionSet_1.ActionSet));
exports.Redirect = Redirect;


/***/ }),
/* 19 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModalIframe = exports.ModalMessage = exports.Modal = exports.isMessageModal = exports.isIframeModal = exports.data = exports.update = exports.clickFooterButton = exports.updateModalSize = exports.closeModal = exports.openModal = exports.Size = exports.Action = void 0;
var buttonHelper_1 = __webpack_require__(17);
var helper_1 = __webpack_require__(0);
var ActionSet_1 = __webpack_require__(2);
var types_1 = __webpack_require__(1);
var Button_1 = __webpack_require__(5);
var Action;
(function (Action) {
    Action["OPEN"] = "APP::MODAL::OPEN";
    Action["CLOSE"] = "APP::MODAL::CLOSE";
    Action["UPDATE"] = "APP::MODAL::UPDATE";
    Action["UPDATE_CONTENT"] = "APP::MODAL::CONTENT::UPDATE";
    Action["FOOTER_BUTTON_CLICK"] = "APP::MODAL::FOOTER::BUTTON::CLICK";
    Action["FOOTER_BUTTON_UPDATE"] = "APP::MODAL::FOOTER::BUTTON::UPDATE";
    Action["UPDATE_SIZE"] = "APP::MODAL::UPDATE_SIZE";
    Action["DATA"] = "APP::MODAL::DATA";
})(Action = exports.Action || (exports.Action = {}));
/**
 * Options available to the Modal `size` param
 * @public
 */
var Size;
(function (Size) {
    /** Small modal size */
    Size["Small"] = "small";
    /** Medium modal size */
    Size["Medium"] = "medium";
    /** Large modal size (wider than medium) */
    Size["Large"] = "large";
    /** @deprecated as of 1.6.5 */
    Size["Full"] = "full";
    /**
     * @deprecated as of 1.12.x
     * @remarks
     * This option has been removed in favour of the `setUpModalAutoSizing` utility.
     */
    Size["Auto"] = "auto";
})(Size = exports.Size || (exports.Size = {}));
var FOOTER_BUTTON_PROPS = {
    group: types_1.Group.Modal,
    subgroups: ['Footer'],
    type: types_1.ComponentType.Button,
};
function openModal(modalPayload) {
    return helper_1.actionWrapper({
        group: types_1.Group.Modal,
        payload: modalPayload,
        type: Action.OPEN,
    });
}
exports.openModal = openModal;
function closeModal(modalClosePayload) {
    return helper_1.actionWrapper({
        group: types_1.Group.Modal,
        payload: modalClosePayload,
        type: Action.CLOSE,
    });
}
exports.closeModal = closeModal;
/**
 * Action creator for modal update size action
 * @internal
 */
function updateModalSize(updateSizePayload) {
    return helper_1.actionWrapper({
        group: types_1.Group.Modal,
        payload: updateSizePayload,
        type: Action.UPDATE_SIZE,
    });
}
exports.updateModalSize = updateModalSize;
function clickFooterButton(id, payload) {
    var component = __assign({ id: id }, FOOTER_BUTTON_PROPS);
    return Button_1.clickButton(types_1.Group.Modal, component, payload);
}
exports.clickFooterButton = clickFooterButton;
function update(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.Modal,
        type: Action.UPDATE,
    });
}
exports.update = update;
function data(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.Modal,
        type: Action.DATA,
    });
}
exports.data = data;
function isIframeModal(options) {
    return (typeof options.url === 'string' ||
        typeof options.path === 'string');
}
exports.isIframeModal = isIframeModal;
function isMessageModal(options) {
    return typeof options.message === 'string';
}
exports.isMessageModal = isMessageModal;
var Modal = /** @class */ (function (_super) {
    __extends(Modal, _super);
    function Modal() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.size = Size.Small;
        return _this;
    }
    Object.defineProperty(Modal.prototype, "footer", {
        get: function () {
            if (!this.footerPrimary && !this.footerSecondary) {
                return undefined;
            }
            return {
                buttons: {
                    primary: this.footerPrimary,
                    secondary: this.footerSecondary,
                },
            };
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Modal.prototype, "footerOptions", {
        get: function () {
            if (!this.footerPrimaryOptions && !this.footerSecondaryOptions) {
                return undefined;
            }
            return {
                buttons: {
                    primary: this.footerPrimaryOptions,
                    secondary: this.footerSecondaryOptions,
                },
            };
        },
        enumerable: false,
        configurable: true
    });
    Modal.prototype.close = function () {
        this.app.dispatch(closeModal({ id: this.id }));
    };
    Modal.prototype.setFooterPrimaryButton = function (newOptions, updateCb) {
        var _this = this;
        var subgroups = FOOTER_BUTTON_PROPS.subgroups;
        this.footerPrimaryOptions = this.getChildButton(newOptions, this.footerPrimaryOptions);
        this.footerPrimary = this.footerPrimaryOptions
            ? buttonHelper_1.getSingleButton(this, this.footerPrimaryOptions, subgroups, function (newPayload) {
                _this.updatePrimaryFooterButton(newPayload, updateCb);
            })
            : undefined;
    };
    Modal.prototype.setFooterSecondaryButtons = function (newOptions, updateCb) {
        var _this = this;
        var subgroups = FOOTER_BUTTON_PROPS.subgroups;
        var newButtons = newOptions || [];
        var currentOptions = (this.footerOptions && this.footerOptions.buttons.secondary) || [];
        this.footerSecondaryOptions = this.getUpdatedChildActions(newButtons, currentOptions);
        this.footerSecondary = this.footerSecondaryOptions
            ? this.footerSecondaryOptions.map(function (action) {
                return buttonHelper_1.getSingleButton(_this, action, subgroups, function (newPayload) {
                    _this.updateSecondaryFooterButton(newPayload, updateCb);
                });
            })
            : undefined;
    };
    Modal.prototype.getChildButton = function (newAction, currentAction) {
        var newButtons = newAction ? [newAction] : [];
        var currentButtons = currentAction ? [currentAction] : [];
        var updatedButton = this.getUpdatedChildActions(newButtons, currentButtons);
        return updatedButton ? updatedButton[0] : undefined;
    };
    Modal.prototype.updatePrimaryFooterButton = function (newPayload, updateCb) {
        if (!this.footer || !this.footer.buttons.primary) {
            return;
        }
        if (helper_1.updateActionFromPayload(this.footer.buttons.primary, newPayload)) {
            updateCb();
        }
    };
    Modal.prototype.updateSecondaryFooterButton = function (newPayload, updateCb) {
        if (!this.footer || !this.footer.buttons || !this.footer.buttons.secondary) {
            return;
        }
        var updated;
        for (var _i = 0, _a = this.footer.buttons.secondary; _i < _a.length; _i++) {
            var action = _a[_i];
            updated = helper_1.updateActionFromPayload(action, newPayload);
            if (updated) {
                break;
            }
        }
        if (updated) {
            updateCb();
        }
    };
    return Modal;
}(ActionSet_1.ActionSetWithChildren));
exports.Modal = Modal;
var ModalMessage = /** @class */ (function (_super) {
    __extends(ModalMessage, _super);
    function ModalMessage(app, options) {
        var _this = _super.call(this, app, types_1.Group.Modal, types_1.Group.Modal) || this;
        _this.set(options, false);
        return _this;
    }
    Object.defineProperty(ModalMessage.prototype, "payload", {
        get: function () {
            return __assign(__assign({}, this.options), { footer: this.footer, id: this.id });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ModalMessage.prototype, "options", {
        get: function () {
            return {
                footer: this.footerOptions,
                message: this.message,
                size: this.size,
                title: this.title,
            };
        },
        enumerable: false,
        configurable: true
    });
    ModalMessage.prototype.set = function (options, shouldUpdate) {
        var _this = this;
        if (shouldUpdate === void 0) { shouldUpdate = true; }
        var mergedOptions = helper_1.getMergedProps(this.options, options);
        var title = mergedOptions.title, footer = mergedOptions.footer, message = mergedOptions.message, size = mergedOptions.size;
        this.title = title;
        this.message = message;
        this.size = size;
        this.setFooterPrimaryButton(footer ? footer.buttons.primary : undefined, function () {
            _this.dispatch(Action.UPDATE);
        });
        this.setFooterSecondaryButtons(footer ? footer.buttons.secondary : undefined, function () {
            _this.dispatch(Action.UPDATE);
        });
        if (shouldUpdate) {
            this.dispatch(Action.UPDATE);
        }
        return this;
    };
    ModalMessage.prototype.dispatch = function (action) {
        switch (action) {
            case Action.OPEN:
                this.app.dispatch(openModal(this.payload));
                break;
            case Action.CLOSE:
                this.close();
                break;
            case Action.UPDATE:
                this.app.dispatch(update(this.payload));
                break;
        }
        return this;
    };
    return ModalMessage;
}(Modal));
exports.ModalMessage = ModalMessage;
var ModalIframe = /** @class */ (function (_super) {
    __extends(ModalIframe, _super);
    function ModalIframe(app, options) {
        var _this = _super.call(this, app, types_1.Group.Modal, types_1.Group.Modal) || this;
        _this.set(options, false);
        return _this;
    }
    Object.defineProperty(ModalIframe.prototype, "payload", {
        get: function () {
            return __assign(__assign({}, this.options), { footer: this.footer, id: this.id });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ModalIframe.prototype, "options", {
        get: function () {
            return {
                footer: this.footerOptions,
                path: this.path,
                size: this.size,
                title: this.title,
                url: this.url,
                loading: this.loading,
            };
        },
        enumerable: false,
        configurable: true
    });
    ModalIframe.prototype.set = function (options, shouldUpdate) {
        var _this = this;
        if (shouldUpdate === void 0) { shouldUpdate = true; }
        var mergedOptions = helper_1.getMergedProps(this.options, options);
        var title = mergedOptions.title, footer = mergedOptions.footer, path = mergedOptions.path, url = mergedOptions.url, size = mergedOptions.size, loading = mergedOptions.loading;
        this.title = title;
        this.url = url;
        this.path = path;
        this.size = size;
        this.loading = loading;
        this.setFooterPrimaryButton(footer ? footer.buttons.primary : undefined, function () {
            _this.dispatch(Action.UPDATE);
        });
        this.setFooterSecondaryButtons(footer ? footer.buttons.secondary : undefined, function () {
            _this.dispatch(Action.UPDATE);
        });
        if (shouldUpdate) {
            this.dispatch(Action.UPDATE);
        }
        return this;
    };
    ModalIframe.prototype.dispatch = function (action, payload) {
        switch (action) {
            case Action.OPEN:
                this.app.dispatch(openModal(this.payload));
                break;
            case Action.CLOSE:
                this.close();
                break;
            case Action.UPDATE:
                this.app.dispatch(update(this.payload));
                break;
            case Action.DATA:
                this.app.dispatch(data(payload || {}));
                break;
        }
        return this;
    };
    return ModalIframe;
}(Modal));
exports.ModalIframe = ModalIframe;


/***/ }),
/* 20 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Toast = exports.primaryAction = exports.clear = exports.show = exports.Action = void 0;
var helper_1 = __webpack_require__(0);
var ActionSet_1 = __webpack_require__(2);
var types_1 = __webpack_require__(1);
var Action;
(function (Action) {
    Action["SHOW"] = "APP::TOAST::SHOW";
    Action["CLEAR"] = "APP::TOAST::CLEAR";
    Action["ACTION"] = "APP::TOAST::ACTION";
})(Action = exports.Action || (exports.Action = {}));
function show(toastMessage) {
    return helper_1.actionWrapper({
        group: types_1.Group.Toast,
        payload: toastMessage,
        type: Action.SHOW,
    });
}
exports.show = show;
function clear(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.Toast,
        type: Action.CLEAR,
    });
}
exports.clear = clear;
function primaryAction(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.Toast,
        type: Action.ACTION,
    });
}
exports.primaryAction = primaryAction;
var Toast = /** @class */ (function (_super) {
    __extends(Toast, _super);
    function Toast(app, options) {
        var _this = _super.call(this, app, types_1.Group.Toast, types_1.Group.Toast) || this;
        _this.message = '';
        _this.duration = 5000;
        _this.set(options);
        return _this;
    }
    Object.defineProperty(Toast.prototype, "options", {
        get: function () {
            var _a;
            return {
                duration: this.duration,
                isError: this.isError,
                message: this.message,
                action: ((_a = this.action) === null || _a === void 0 ? void 0 : _a.content)
                    ? {
                        content: this.action.content,
                    }
                    : undefined,
            };
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Toast.prototype, "payload", {
        get: function () {
            return __assign({ id: this.id }, this.options);
        },
        enumerable: false,
        configurable: true
    });
    Toast.prototype.set = function (options) {
        var mergedOptions = helper_1.getMergedProps(this.options, options);
        var message = mergedOptions.message, duration = mergedOptions.duration, isError = mergedOptions.isError, action = mergedOptions.action;
        this.message = message;
        this.duration = duration;
        this.isError = isError;
        this.action = (action === null || action === void 0 ? void 0 : action.content)
            ? {
                content: action.content || '',
            }
            : undefined;
        return this;
    };
    Toast.prototype.dispatch = function (action) {
        switch (action) {
            case Action.SHOW: {
                var openAction = show(this.payload);
                this.app.dispatch(openAction);
                break;
            }
            case Action.CLEAR:
                this.app.dispatch(clear({ id: this.id }));
                break;
            case Action.ACTION:
                this.app.dispatch(primaryAction({ id: this.id }));
                break;
        }
        return this;
    };
    return Toast;
}(ActionSet_1.ActionSet));
exports.Toast = Toast;


/***/ }),
/* 21 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.app = exports.PrintAction = exports.Action = void 0;
var Print_1 = __webpack_require__(73);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Print_1.Action; } });
Object.defineProperty(exports, "PrintAction", { enumerable: true, get: function () { return Print_1.PrintAction; } });
Object.defineProperty(exports, "app", { enumerable: true, get: function () { return Print_1.app; } });


/***/ }),
/* 22 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(74), exports);


/***/ }),
/* 23 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.removeFromCollection = exports.addAndRemoveFromCollection = void 0;
/**
 * Add an item to a collection, return a function that can then be used to
 * remove the item from the collection. Optionally accepting a callback that is
 * invoked when the item is removed from the collection.
 *
 * @internal
 */
function addAndRemoveFromCollection(collection, item, then) {
    collection.push(item);
    return function () {
        return removeFromCollection(collection, item, then);
    };
}
exports.addAndRemoveFromCollection = addAndRemoveFromCollection;
/**
 * Remove the item from the collection. Optionally accepting a callback that is
 * invoked when the item is removed from the collection.
 *
 * @internal
 */
function removeFromCollection(collection, item, then) {
    var idx = collection.findIndex(function (i) { return i === item; });
    if (idx >= 0) {
        collection.splice(idx, 1);
        if (then) {
            then(item);
        }
        return true;
    }
    return false;
}
exports.removeFromCollection = removeFromCollection;


/***/ }),
/* 24 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.isUnframed = exports.isClient = exports.isServer = void 0;
exports.isServer = typeof window === 'undefined';
exports.isClient = !exports.isServer;
// eslint-disable-next-line ssr-friendly/no-dom-globals-in-module-scope
exports.isUnframed = exports.isClient && ((_b = (_a = window.navigator) === null || _a === void 0 ? void 0 : _a.userAgent) === null || _b === void 0 ? void 0 : _b.indexOf('Unframed')) > 0;


/***/ }),
/* 25 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process) {
Object.defineProperty(exports, "__esModule", { value: true });
exports.isDevelopmentClient = exports.isProduction = exports.isDevelopment = exports.isUnframed = exports.isServer = exports.isClient = void 0;
var env_1 = __webpack_require__(24);
var env_2 = __webpack_require__(24);
Object.defineProperty(exports, "isClient", { enumerable: true, get: function () { return env_2.isClient; } });
Object.defineProperty(exports, "isServer", { enumerable: true, get: function () { return env_2.isServer; } });
Object.defineProperty(exports, "isUnframed", { enumerable: true, get: function () { return env_2.isUnframed; } });
exports.isDevelopment = typeof process !== 'undefined' && process.env && "production" === 'development';
exports.isProduction = !exports.isDevelopment;
exports.isDevelopmentClient = exports.isDevelopment && env_1.isClient;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(75)))

/***/ }),
/* 26 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.isShopifyPing = exports.isShopifyPOS = exports.isShopifyMobile = exports.isShopifyEmbedded = exports.isMobile = void 0;
var env_1 = __webpack_require__(25);
function isMobile() {
    return isShopifyMobile() || isShopifyPOS() || isShopifyPing();
}
exports.isMobile = isMobile;
function isShopifyEmbedded() {
    return (env_1.isClient && window.top !== window.self) || env_1.isUnframed;
}
exports.isShopifyEmbedded = isShopifyEmbedded;
function isShopifyMobile() {
    return typeof navigator !== 'undefined' && navigator.userAgent.indexOf('Shopify Mobile') >= 0;
}
exports.isShopifyMobile = isShopifyMobile;
function isShopifyPOS() {
    return typeof navigator !== 'undefined' && navigator.userAgent.indexOf('Shopify POS') >= 0;
}
exports.isShopifyPOS = isShopifyPOS;
function isShopifyPing() {
    return typeof navigator !== 'undefined' && navigator.userAgent.indexOf('Shopify Ping') >= 0;
}
exports.isShopifyPing = isShopifyPing;


/***/ }),
/* 27 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getWindow = exports.getLocation = exports.redirect = exports.shouldRedirect = void 0;
function shouldRedirect(frame) {
    return frame === window;
}
exports.shouldRedirect = shouldRedirect;
function redirect(url) {
    var location = getLocation();
    if (!location) {
        return;
    }
    location.assign(url);
}
exports.redirect = redirect;
function getLocation() {
    return hasWindow() ? window.location : undefined;
}
exports.getLocation = getLocation;
function getWindow() {
    return hasWindow() ? window : undefined;
}
exports.getWindow = getWindow;
function hasWindow() {
    return typeof window !== 'undefined';
}


/***/ }),
/* 28 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LeaveConfirmation = exports.confirm = exports.disable = exports.enable = exports.Action = void 0;
var helper_1 = __webpack_require__(0);
var ActionSet_1 = __webpack_require__(2);
var types_1 = __webpack_require__(1);
/**
 * Action for the Leave Confirmation group
 * @public
 */
var Action;
(function (Action) {
    Action["ENABLE"] = "APP::LEAVE_CONFIRMATION::ENABLE";
    Action["DISABLE"] = "APP::LEAVE_CONFIRMATION::DISABLE";
    Action["CONFIRM"] = "APP::LEAVE_CONFIRMATION::CONFIRM";
})(Action = exports.Action || (exports.Action = {}));
function enable(payload) {
    if (payload === void 0) { payload = {}; }
    return helper_1.actionWrapper({
        group: types_1.Group.LeaveConfirmation,
        payload: payload,
        type: Action.ENABLE,
    });
}
exports.enable = enable;
function disable(payload) {
    if (payload === void 0) { payload = {}; }
    return helper_1.actionWrapper({
        group: types_1.Group.LeaveConfirmation,
        payload: payload,
        type: Action.DISABLE,
    });
}
exports.disable = disable;
function confirm(payload) {
    if (payload === void 0) { payload = {}; }
    return helper_1.actionWrapper({
        group: types_1.Group.LeaveConfirmation,
        payload: payload,
        type: Action.CONFIRM,
    });
}
exports.confirm = confirm;
/**
 * Leave Confirmation action set
 */
var LeaveConfirmation = /** @class */ (function (_super) {
    __extends(LeaveConfirmation, _super);
    /**
     * Returns a new instance of a Leave Confirmation action set
     * @param app the client application
     */
    function LeaveConfirmation(app, options) {
        if (options === void 0) { options = {}; }
        var _this = _super.call(this, app, types_1.Group.LeaveConfirmation, types_1.Group.LeaveConfirmation) || this;
        _this.options = options;
        _this.set(options);
        return _this;
    }
    Object.defineProperty(LeaveConfirmation.prototype, "payload", {
        /**
         * Returns the action set payload
         */
        get: function () {
            return __assign({ id: this.id }, this.options);
        },
        enumerable: false,
        configurable: true
    });
    LeaveConfirmation.prototype.set = function (options) {
        this.options = helper_1.getMergedProps(this.options, options);
        return this;
    };
    /**
     * Dispatches a given action with the action set payload
     * @param action the action enum
     * @returns the action set instance
     */
    LeaveConfirmation.prototype.dispatch = function (action) {
        switch (action) {
            case Action.ENABLE: {
                var enableAction = enable(this.payload);
                this.app.dispatch(enableAction);
                break;
            }
            case Action.DISABLE: {
                var disableAction = disable(this.payload);
                this.app.dispatch(disableAction);
                break;
            }
            case Action.CONFIRM: {
                var confirmAction = confirm(this.payload);
                this.app.dispatch(confirmAction);
                break;
            }
        }
        return this;
    };
    return LeaveConfirmation;
}(ActionSet_1.ActionSet));
exports.LeaveConfirmation = LeaveConfirmation;


/***/ }),
/* 29 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.NavigationMenu = exports.update = exports.Action = void 0;
var AppLink_1 = __webpack_require__(14);
var helper_1 = __webpack_require__(0);
var ActionSet_1 = __webpack_require__(2);
var types_1 = __webpack_require__(1);
var SUBGROUPS = ['Navigation_Menu'];
var Action;
(function (Action) {
    Action["UPDATE"] = "APP::MENU::NAVIGATION_MENU::UPDATE";
    Action["LINK_UPDATE"] = "APP::MENU::NAVIGATION_MENU::LINK::UPDATE";
})(Action = exports.Action || (exports.Action = {}));
function update(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.Menu,
        type: Action.UPDATE,
    });
}
exports.update = update;
var NavigationMenu = /** @class */ (function (_super) {
    __extends(NavigationMenu, _super);
    function NavigationMenu(app, options) {
        var _this = _super.call(this, app, 'Navigation_Menu', types_1.Group.Menu) || this;
        _this.items = [];
        // Trigger 'update' on creation
        _this.set(options);
        return _this;
    }
    Object.defineProperty(NavigationMenu.prototype, "options", {
        get: function () {
            return {
                items: this.itemsOptions,
                active: this.activeOptions,
            };
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(NavigationMenu.prototype, "payload", {
        get: function () {
            return __assign(__assign({}, this.options), { active: this.active, items: this.items, id: this.id });
        },
        enumerable: false,
        configurable: true
    });
    NavigationMenu.prototype.set = function (options, shouldUpdate) {
        if (shouldUpdate === void 0) { shouldUpdate = true; }
        var mergedOptions = helper_1.getMergedProps(this.options, options);
        var items = mergedOptions.items, active = mergedOptions.active;
        this.setItems(items);
        this.activeOptions = active;
        this.active = active && active.id;
        if (shouldUpdate) {
            this.dispatch(Action.UPDATE);
        }
        return this;
    };
    NavigationMenu.prototype.dispatch = function (action) {
        switch (action) {
            case Action.UPDATE:
                this.app.dispatch(update(this.payload));
                break;
        }
        return this;
    };
    NavigationMenu.prototype.updateItem = function (newPayload) {
        if (!this.items) {
            return;
        }
        var itemToUpdate = this.items.find(function (action) { return action.id === newPayload.id; });
        if (!itemToUpdate) {
            return;
        }
        if (helper_1.updateActionFromPayload(itemToUpdate, newPayload)) {
            this.dispatch(Action.UPDATE);
        }
    };
    NavigationMenu.prototype.setItems = function (newOptions) {
        var _this = this;
        var newItems = newOptions || [];
        var currentItems = this.itemsOptions || [];
        this.itemsOptions = this.getUpdatedChildActions(newItems, currentItems);
        this.items = this.itemsOptions
            ? this.itemsOptions.map(function (action) {
                _this.addChild(action, _this.group, SUBGROUPS);
                _this.subscribeToChild(action, AppLink_1.Action.UPDATE, _this.updateItem);
                return action.payload;
            })
            : [];
    };
    return NavigationMenu;
}(ActionSet_1.ActionSetWithChildren));
exports.NavigationMenu = NavigationMenu;


/***/ }),
/* 30 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChannelMenu = exports.update = exports.Action = void 0;
var AppLink_1 = __webpack_require__(14);
var helper_1 = __webpack_require__(0);
var ActionSet_1 = __webpack_require__(2);
var types_1 = __webpack_require__(1);
var SUBGROUPS = ['Channel_Menu'];
var Action;
(function (Action) {
    Action["UPDATE"] = "APP::MENU::CHANNEL_MENU::UPDATE";
    Action["LINK_UPDATE"] = "APP::MENU::CHANNEL_MENU::LINK::UPDATE";
})(Action = exports.Action || (exports.Action = {}));
function update(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.Menu,
        type: Action.UPDATE,
    });
}
exports.update = update;
var ChannelMenu = /** @class */ (function (_super) {
    __extends(ChannelMenu, _super);
    function ChannelMenu(app, options) {
        var _this = _super.call(this, app, 'Channel_Menu', types_1.Group.Menu) || this;
        _this.items = [];
        // Trigger 'update' on creation
        _this.set(options);
        return _this;
    }
    Object.defineProperty(ChannelMenu.prototype, "options", {
        get: function () {
            return {
                items: this.itemsOptions,
                active: this.activeOptions,
            };
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChannelMenu.prototype, "payload", {
        get: function () {
            return __assign(__assign({}, this.options), { active: this.active, items: this.items, id: this.id });
        },
        enumerable: false,
        configurable: true
    });
    ChannelMenu.prototype.set = function (options, shouldUpdate) {
        if (shouldUpdate === void 0) { shouldUpdate = true; }
        var mergedOptions = helper_1.getMergedProps(this.options, options);
        var items = mergedOptions.items, active = mergedOptions.active;
        this.setItems(items);
        this.activeOptions = active;
        this.active = active && active.id;
        if (shouldUpdate) {
            this.dispatch(Action.UPDATE);
        }
        return this;
    };
    ChannelMenu.prototype.dispatch = function (action) {
        switch (action) {
            case Action.UPDATE:
                this.app.dispatch(update(this.payload));
                break;
        }
        return this;
    };
    ChannelMenu.prototype.updateItem = function (newPayload) {
        if (!this.items) {
            return;
        }
        var itemToUpdate = this.items.find(function (action) { return action.id === newPayload.id; });
        if (!itemToUpdate) {
            return;
        }
        if (helper_1.updateActionFromPayload(itemToUpdate, newPayload)) {
            this.dispatch(Action.UPDATE);
        }
    };
    ChannelMenu.prototype.setItems = function (newOptions) {
        var _this = this;
        var newItems = newOptions || [];
        var currentItems = this.itemsOptions || [];
        this.itemsOptions = this.getUpdatedChildActions(newItems, currentItems);
        this.items = this.itemsOptions
            ? this.itemsOptions.map(function (action) {
                _this.addChild(action, _this.group, SUBGROUPS);
                _this.subscribeToChild(action, AppLink_1.Action.UPDATE, _this.updateItem);
                return action.payload;
            })
            : [];
    };
    return ChannelMenu;
}(ActionSet_1.ActionSetWithChildren));
exports.ChannelMenu = ChannelMenu;


/***/ }),
/* 31 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.History = exports.replace = exports.push = exports.Action = void 0;
var helper_1 = __webpack_require__(0);
var ActionSet_1 = __webpack_require__(2);
var types_1 = __webpack_require__(1);
var Action;
(function (Action) {
    Action["PUSH"] = "APP::NAVIGATION::HISTORY::PUSH";
    Action["REPLACE"] = "APP::NAVIGATION::HISTORY::REPLACE";
})(Action = exports.Action || (exports.Action = {}));
function push(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.Navigation,
        type: Action.PUSH,
    });
}
exports.push = push;
function replace(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.Navigation,
        type: Action.REPLACE,
    });
}
exports.replace = replace;
var History = /** @class */ (function (_super) {
    __extends(History, _super);
    function History(app) {
        return _super.call(this, app, 'History', types_1.Group.Navigation) || this;
    }
    Object.defineProperty(History.prototype, "payload", {
        get: function () {
            return { id: this.id };
        },
        enumerable: false,
        configurable: true
    });
    History.prototype.dispatch = function (type, path) {
        var payload = __assign(__assign({}, this.payload), { path: path });
        switch (type) {
            case Action.PUSH:
                this.app.dispatch(push(payload));
                break;
            case Action.REPLACE:
                this.app.dispatch(replace(payload));
                break;
        }
        return this;
    };
    return History;
}(ActionSet_1.ActionSet));
exports.History = History;


/***/ }),
/* 32 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResourcePicker = exports.update = exports.close = exports.cancel = exports.open = exports.select = exports.ActionVerb = exports.ResourceType = exports.ProductStatus = exports.ProductVariantInventoryManagement = exports.ProductVariantInventoryPolicy = exports.WeightUnit = exports.FulfillmentServiceType = exports.CollectionSortOrder = exports.Action = void 0;
var helper_1 = __webpack_require__(0);
var ActionSet_1 = __webpack_require__(2);
var types_1 = __webpack_require__(1);
var Action;
(function (Action) {
    Action["OPEN"] = "APP::RESOURCE_PICKER::OPEN";
    Action["SELECT"] = "APP::RESOURCE_PICKER::SELECT";
    // Deprecated in 0.5.0 use 'APP::RESOURCE_PICKER::CANCEL' instead
    Action["CLOSE"] = "APP::RESOURCE_PICKER::CLOSE";
    Action["UPDATE"] = "APP::RESOURCE_PICKER::UPDATE";
    Action["CANCEL"] = "APP::RESOURCE_PICKER::CANCEL";
})(Action = exports.Action || (exports.Action = {}));
var CollectionSortOrder;
(function (CollectionSortOrder) {
    CollectionSortOrder["Manual"] = "MANUAL";
    CollectionSortOrder["BestSelling"] = "BEST_SELLING";
    CollectionSortOrder["AlphaAsc"] = "ALPHA_ASC";
    CollectionSortOrder["AlphaDesc"] = "ALPHA_DESC";
    CollectionSortOrder["PriceDesc"] = "PRICE_DESC";
    CollectionSortOrder["PriceAsc"] = "PRICE_ASC";
    CollectionSortOrder["CreatedDesc"] = "CREATED_DESC";
    CollectionSortOrder["Created"] = "CREATED";
    CollectionSortOrder["MostRelevant"] = "MOST_RELEVANT";
})(CollectionSortOrder = exports.CollectionSortOrder || (exports.CollectionSortOrder = {}));
var FulfillmentServiceType;
(function (FulfillmentServiceType) {
    FulfillmentServiceType["GiftCard"] = "GIFT_CARD";
    FulfillmentServiceType["Manual"] = "MANUAL";
    FulfillmentServiceType["ThirdParty"] = "THIRD_PARTY";
})(FulfillmentServiceType = exports.FulfillmentServiceType || (exports.FulfillmentServiceType = {}));
var WeightUnit;
(function (WeightUnit) {
    WeightUnit["Kilograms"] = "KILOGRAMS";
    WeightUnit["Grams"] = "GRAMS";
    WeightUnit["Pounds"] = "POUNDS";
    WeightUnit["Ounces"] = "OUNCES";
})(WeightUnit = exports.WeightUnit || (exports.WeightUnit = {}));
var ProductVariantInventoryPolicy;
(function (ProductVariantInventoryPolicy) {
    ProductVariantInventoryPolicy["Deny"] = "DENY";
    ProductVariantInventoryPolicy["Continue"] = "CONTINUE";
})(ProductVariantInventoryPolicy = exports.ProductVariantInventoryPolicy || (exports.ProductVariantInventoryPolicy = {}));
var ProductVariantInventoryManagement;
(function (ProductVariantInventoryManagement) {
    ProductVariantInventoryManagement["Shopify"] = "SHOPIFY";
    ProductVariantInventoryManagement["NotManaged"] = "NOT_MANAGED";
    ProductVariantInventoryManagement["FulfillmentService"] = "FULFILLMENT_SERVICE";
})(ProductVariantInventoryManagement = exports.ProductVariantInventoryManagement || (exports.ProductVariantInventoryManagement = {}));
var ProductStatus;
(function (ProductStatus) {
    ProductStatus["Active"] = "ACTIVE";
    ProductStatus["Archived"] = "ARCHIVED";
    ProductStatus["Draft"] = "DRAFT";
})(ProductStatus = exports.ProductStatus || (exports.ProductStatus = {}));
var ResourceType;
(function (ResourceType) {
    ResourceType["Product"] = "product";
    ResourceType["ProductVariant"] = "variant";
    ResourceType["Collection"] = "collection";
})(ResourceType = exports.ResourceType || (exports.ResourceType = {}));
var ActionVerb;
(function (ActionVerb) {
    ActionVerb["Add"] = "add";
    ActionVerb["Select"] = "select";
})(ActionVerb = exports.ActionVerb || (exports.ActionVerb = {}));
function select(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.ResourcePicker,
        type: Action.SELECT,
    });
}
exports.select = select;
function open(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.ResourcePicker,
        type: Action.OPEN,
    });
}
exports.open = open;
function cancel(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.ResourcePicker,
        type: Action.CANCEL,
    });
}
exports.cancel = cancel;
function close(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.ResourcePicker,
        type: Action.CANCEL,
    });
}
exports.close = close;
function update(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.ResourcePicker,
        type: Action.UPDATE,
    });
}
exports.update = update;
var ResourcePicker = /** @class */ (function (_super) {
    __extends(ResourcePicker, _super);
    function ResourcePicker(app, options, resourceType) {
        var _this = _super.call(this, app, types_1.Group.ResourcePicker, types_1.Group.ResourcePicker) || this;
        _this.initialSelectionIds = [];
        _this.selection = [];
        _this.resourceType = resourceType;
        _this.set(options, false);
        return _this;
    }
    Object.defineProperty(ResourcePicker.prototype, "payload", {
        get: function () {
            return __assign(__assign({}, this.options), { id: this.id, resourceType: this.resourceType });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ResourcePicker.prototype, "options", {
        get: function () {
            var options = {
                initialQuery: this.initialQuery,
                filterQuery: this.filterQuery,
                selectMultiple: this.selectMultiple,
                initialSelectionIds: this.initialSelectionIds,
                showHidden: this.showHidden,
                actionVerb: this.actionVerb,
            };
            if (this.resourceType === ResourceType.Product) {
                var productOptions = __assign(__assign({}, options), { showVariants: this.showVariants, showDraft: this.showDraft, showArchived: this.showArchived, showDraftBadge: this.showDraftBadge, showArchivedBadge: this.showArchivedBadge });
                return productOptions;
            }
            return options;
        },
        enumerable: false,
        configurable: true
    });
    ResourcePicker.prototype.set = function (options, shouldUpdate) {
        if (shouldUpdate === void 0) { shouldUpdate = true; }
        var mergedOptions = helper_1.getMergedProps(this.options, options);
        var initialQuery = mergedOptions.initialQuery, filterQuery = mergedOptions.filterQuery, _a = mergedOptions.initialSelectionIds, initialSelectionIds = _a === void 0 ? [] : _a, _b = mergedOptions.showHidden, showHidden = _b === void 0 ? true : _b, _c = mergedOptions.showVariants, showVariants = _c === void 0 ? true : _c, _d = mergedOptions.showDraft, showDraft = _d === void 0 ? true : _d, _e = mergedOptions.showArchived, showArchived = _e === void 0 ? true : _e, _f = mergedOptions.showDraftBadge, showDraftBadge = _f === void 0 ? false : _f, _g = mergedOptions.showArchivedBadge, showArchivedBadge = _g === void 0 ? false : _g, _h = mergedOptions.selectMultiple, selectMultiple = _h === void 0 ? true : _h, _j = mergedOptions.actionVerb, actionVerb = _j === void 0 ? ActionVerb.Add : _j;
        this.initialQuery = initialQuery;
        this.filterQuery = filterQuery;
        this.initialSelectionIds = initialSelectionIds;
        this.showHidden = showHidden;
        this.showVariants = showVariants;
        this.showDraft = showDraft;
        this.showArchived = showArchived;
        this.showDraftBadge = showDraftBadge;
        this.showArchivedBadge = showArchivedBadge;
        this.selectMultiple = selectMultiple;
        this.actionVerb = actionVerb;
        if (shouldUpdate) {
            this.update();
        }
        return this;
    };
    ResourcePicker.prototype.dispatch = function (action, selection) {
        if (action === Action.OPEN) {
            this.open();
        }
        else if (action === Action.UPDATE) {
            this.update();
        }
        else if (action === Action.CLOSE || action === Action.CANCEL) {
            this.cancel();
        }
        else if (action === Action.SELECT) {
            this.selection = selection;
            this.app.dispatch(select({ id: this.id, selection: this.selection }));
        }
        return this;
    };
    ResourcePicker.prototype.update = function () {
        this.app.dispatch(update(this.payload));
    };
    ResourcePicker.prototype.open = function () {
        this.app.dispatch(open(this.payload));
    };
    ResourcePicker.prototype.cancel = function () {
        this.app.dispatch(cancel({ id: this.id }));
    };
    ResourcePicker.prototype.close = function () {
        this.cancel();
    };
    return ResourcePicker;
}(ActionSet_1.ActionSet));
exports.ResourcePicker = ResourcePicker;


/***/ }),
/* 33 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.TitleBar = exports.update = exports.clickBreadcrumb = exports.clickActionButton = exports.Action = void 0;
var ActionSet_1 = __webpack_require__(2);
var Button_1 = __webpack_require__(5);
var ButtonGroup_1 = __webpack_require__(9);
var buttonGroupHelper_1 = __webpack_require__(95);
var buttonHelper_1 = __webpack_require__(17);
var helper_1 = __webpack_require__(0);
var types_1 = __webpack_require__(1);
var Action;
(function (Action) {
    Action["UPDATE"] = "APP::TITLEBAR::UPDATE";
    Action["BUTTON_CLICK"] = "APP::TITLEBAR::BUTTONS::BUTTON::CLICK";
    Action["BUTTON_UPDATE"] = "APP::TITLEBAR::BUTTONS::BUTTON::UPDATE";
    Action["BUTTON_GROUP_UPDATE"] = "APP::TITLEBAR::BUTTONS::BUTTONGROUP::UPDATE";
    Action["BREADCRUMBS_CLICK"] = "APP::TITLEBAR::BREADCRUMBS::BUTTON::CLICK";
    Action["BREADCRUMBS_UPDATE"] = "APP::TITLEBAR::BREADCRUMBS::BUTTON::UPDATE";
})(Action = exports.Action || (exports.Action = {}));
var TITLEBAR_BUTTON_PROPS = {
    group: types_1.Group.TitleBar,
    subgroups: ['Buttons'],
};
var BREADCRUMB_BUTTON_PROPS = {
    group: types_1.Group.TitleBar,
    subgroups: ['Breadcrumbs'],
    type: types_1.ComponentType.Button,
};
function clickActionButton(id, payload) {
    var type = types_1.ComponentType.Button;
    var component = __assign({ id: id, type: type }, TITLEBAR_BUTTON_PROPS);
    return Button_1.clickButton(types_1.Group.TitleBar, component, payload);
}
exports.clickActionButton = clickActionButton;
function clickBreadcrumb(id, payload) {
    var component = __assign({ id: id }, BREADCRUMB_BUTTON_PROPS);
    return Button_1.clickButton(types_1.Group.TitleBar, component, payload);
}
exports.clickBreadcrumb = clickBreadcrumb;
function update(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.TitleBar,
        type: Action.UPDATE,
    });
}
exports.update = update;
var TitleBar = /** @class */ (function (_super) {
    __extends(TitleBar, _super);
    function TitleBar(app, options) {
        var _this = _super.call(this, app, types_1.Group.TitleBar, types_1.Group.TitleBar) || this;
        if (!options.title && !options.breadcrumbs && !options.buttons) {
            return _this;
        }
        // Trigger 'update' on creation
        _this.set(options);
        return _this;
    }
    Object.defineProperty(TitleBar.prototype, "buttons", {
        get: function () {
            if (!this.primary && !this.secondary) {
                return undefined;
            }
            return {
                primary: this.primary,
                secondary: this.secondary,
            };
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TitleBar.prototype, "buttonsOptions", {
        get: function () {
            if (!this.primaryOptions && !this.secondaryOptions) {
                return undefined;
            }
            return {
                primary: this.primaryOptions,
                secondary: this.secondaryOptions,
            };
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TitleBar.prototype, "options", {
        get: function () {
            return {
                breadcrumbs: this.breadcrumbsOption,
                buttons: this.buttonsOptions,
                title: this.title,
            };
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TitleBar.prototype, "payload", {
        get: function () {
            return __assign(__assign({}, this.options), { breadcrumbs: this.breadcrumb, buttons: this.buttons, id: this.id });
        },
        enumerable: false,
        configurable: true
    });
    TitleBar.prototype.set = function (options, shouldUpdate) {
        if (shouldUpdate === void 0) { shouldUpdate = true; }
        var mergedOptions = helper_1.getMergedProps(this.options, options);
        var title = mergedOptions.title, buttons = mergedOptions.buttons, breadcrumbs = mergedOptions.breadcrumbs;
        this.title = title;
        this.setBreadcrumbs(breadcrumbs);
        this.setPrimaryButton(buttons ? buttons.primary : undefined);
        this.setSecondaryButton(buttons ? buttons.secondary : undefined);
        if (shouldUpdate) {
            this.dispatch(Action.UPDATE);
        }
        return this;
    };
    TitleBar.prototype.dispatch = function (action) {
        switch (action) {
            case Action.UPDATE:
                this.app.dispatch(update(this.payload));
                break;
        }
        return this;
    };
    TitleBar.prototype.getButton = function (button, subgroups, updateCb) {
        if (button instanceof ButtonGroup_1.ButtonGroup) {
            return buttonGroupHelper_1.getGroupedButton(this, button, subgroups, updateCb);
        }
        return buttonHelper_1.getSingleButton(this, button, subgroups, updateCb);
    };
    TitleBar.prototype.updatePrimaryButton = function (newPayload) {
        if (!this.primary) {
            return;
        }
        if (helper_1.updateActionFromPayload(this.primary, newPayload)) {
            this.dispatch(Action.UPDATE);
        }
    };
    TitleBar.prototype.updateSecondaryButtons = function (newPayload) {
        if (!this.secondary) {
            return;
        }
        var buttonToUpdate = this.secondary.find(function (action) { return action.id === newPayload.id; });
        if (!buttonToUpdate) {
            return;
        }
        var updated = false;
        if (ButtonGroup_1.isGroupedButtonPayload(newPayload)) {
            updated = helper_1.updateActionFromPayload(buttonToUpdate, newPayload);
        }
        else {
            updated = helper_1.updateActionFromPayload(buttonToUpdate, newPayload);
        }
        if (updated) {
            this.dispatch(Action.UPDATE);
        }
    };
    TitleBar.prototype.updateBreadcrumbButton = function (newPayload) {
        if (!this.breadcrumb) {
            return;
        }
        if (helper_1.updateActionFromPayload(this.breadcrumb, newPayload)) {
            this.dispatch(Action.UPDATE);
        }
    };
    TitleBar.prototype.setPrimaryButton = function (newOptions) {
        this.primaryOptions = this.getChildButton(newOptions, this.primaryOptions);
        this.primary = this.primaryOptions
            ? this.getButton(this.primaryOptions, TITLEBAR_BUTTON_PROPS.subgroups, this.updatePrimaryButton)
            : undefined;
    };
    TitleBar.prototype.setSecondaryButton = function (newOptions) {
        var _this = this;
        var newButtons = newOptions || [];
        var currentButtons = this.secondaryOptions || [];
        this.secondaryOptions = this.getUpdatedChildActions(newButtons, currentButtons);
        this.secondary = this.secondaryOptions
            ? this.secondaryOptions.map(function (action) {
                return _this.getButton(action, TITLEBAR_BUTTON_PROPS.subgroups, _this.updateSecondaryButtons);
            })
            : undefined;
    };
    TitleBar.prototype.setBreadcrumbs = function (breadcrumb) {
        this.breadcrumbsOption = this.getChildButton(breadcrumb, this.breadcrumbsOption);
        this.breadcrumb = this.breadcrumbsOption
            ? this.getButton(this.breadcrumbsOption, BREADCRUMB_BUTTON_PROPS.subgroups, this.updateBreadcrumbButton)
            : undefined;
    };
    TitleBar.prototype.getChildButton = function (newAction, currentAction) {
        var newButtons = newAction ? [newAction] : [];
        var currentButtons = currentAction ? [currentAction] : [];
        var updatedButton = this.getUpdatedChildActions(newButtons, currentButtons);
        return updatedButton ? updatedButton[0] : undefined;
    };
    return TitleBar;
}(ActionSet_1.ActionSetWithChildren));
exports.TitleBar = TitleBar;


/***/ }),
/* 34 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.unstable_Picker = exports.loadMore = exports.search = exports.update = exports.cancel = exports.open = exports.select = exports.ALL_RESOURCE_VERTICAL_ALIGNMENT = exports.ALL_MEDIA_KINDS = exports.ALL_BADGE_STATUSES = exports.ALL_BADGE_PROGRESSES = exports.Action = void 0;
var helper_1 = __webpack_require__(0);
var ActionSet_1 = __webpack_require__(2);
var types_1 = __webpack_require__(1);
var Action;
(function (Action) {
    Action["OPEN"] = "APP::PICKER::OPEN";
    Action["SELECT"] = "APP::PICKER::SELECT";
    Action["UPDATE"] = "APP::PICKER::UPDATE";
    Action["CANCEL"] = "APP::PICKER::CANCEL";
    Action["SEARCH"] = "APP::PICKER::SEARCH";
    Action["LOAD_MORE"] = "APP::PICKER::LOAD_MORE";
})(Action = exports.Action || (exports.Action = {}));
/**
 * To be used on validator as matchEnum(...). Make sure as new values are added to update
 * the items below
 *
 * Note: Intentionally not using an `enum type` directly as this would cause a dependency
 * of the same enum on the consumer API rather than just the string values.
 */
exports.ALL_BADGE_PROGRESSES = [
    'incomplete',
    'partiallyComplete',
    'complete',
];
exports.ALL_BADGE_STATUSES = [
    'success',
    'info',
    'attention',
    'critical',
    'warning',
    'new',
];
exports.ALL_MEDIA_KINDS = ['Avatar', 'Thumbnail'];
exports.ALL_RESOURCE_VERTICAL_ALIGNMENT = [
    'leading',
    'trailing',
    'center',
];
function select(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.unstable_Picker,
        type: Action.SELECT,
    });
}
exports.select = select;
function open(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.unstable_Picker,
        type: Action.OPEN,
    });
}
exports.open = open;
function cancel(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.unstable_Picker,
        type: Action.CANCEL,
    });
}
exports.cancel = cancel;
function update(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.unstable_Picker,
        type: Action.UPDATE,
    });
}
exports.update = update;
function search(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.unstable_Picker,
        type: Action.SEARCH,
    });
}
exports.search = search;
function loadMore(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.unstable_Picker,
        type: Action.LOAD_MORE,
    });
}
exports.loadMore = loadMore;
/**
 * @unstable This API may be updated without warning in the future
 */
var unstable_Picker = /** @class */ (function (_super) {
    __extends(unstable_Picker, _super);
    function unstable_Picker(app, options) {
        var _this = _super.call(this, app, types_1.Group.unstable_Picker, types_1.Group.unstable_Picker) || this;
        _this.items = [];
        _this.selectedItems = [];
        _this.set(options, false);
        return _this;
    }
    Object.defineProperty(unstable_Picker.prototype, "payload", {
        get: function () {
            return __assign(__assign({}, this.options), { id: this.id });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(unstable_Picker.prototype, "options", {
        get: function () {
            return {
                items: this.items,
                maxSelectable: this.maxSelectable,
                selectedItems: this.selectedItems,
                title: this.title,
                loading: this.loading,
                searchQuery: this.searchQuery,
                searchQueryPlaceholder: this.searchQueryPlaceholder,
                primaryActionLabel: this.primaryActionLabel,
                secondaryActionLabel: this.secondaryActionLabel,
                emptySearchLabel: this.emptySearchLabel,
                canLoadMore: this.canLoadMore,
                loadingMore: this.loadingMore,
                verticalAlignment: this.verticalAlignment,
                allowEmptySelection: this.allowEmptySelection,
                resourceName: this.resourceName,
            };
        },
        enumerable: false,
        configurable: true
    });
    unstable_Picker.prototype.set = function (options, shouldUpdate) {
        if (shouldUpdate === void 0) { shouldUpdate = true; }
        var mergedOptions = helper_1.getMergedProps(this.options, options);
        var _a = mergedOptions.selectedItems, selectedItems = _a === void 0 ? [] : _a, _b = mergedOptions.maxSelectable, maxSelectable = _b === void 0 ? 0 : _b, _c = mergedOptions.items, items = _c === void 0 ? [] : _c, _d = mergedOptions.loading, loading = _d === void 0 ? false : _d, title = mergedOptions.title, searchQuery = mergedOptions.searchQuery, searchQueryPlaceholder = mergedOptions.searchQueryPlaceholder, primaryActionLabel = mergedOptions.primaryActionLabel, secondaryActionLabel = mergedOptions.secondaryActionLabel, emptySearchLabel = mergedOptions.emptySearchLabel, _e = mergedOptions.canLoadMore, canLoadMore = _e === void 0 ? false : _e, _f = mergedOptions.loadingMore, loadingMore = _f === void 0 ? false : _f, verticalAlignment = mergedOptions.verticalAlignment, allowEmptySelection = mergedOptions.allowEmptySelection, resourceName = mergedOptions.resourceName;
        this.title = title;
        this.items = items;
        this.selectedItems = selectedItems;
        this.maxSelectable = maxSelectable;
        this.loading = loading;
        this.searchQuery = searchQuery;
        this.searchQueryPlaceholder = searchQueryPlaceholder;
        this.primaryActionLabel = primaryActionLabel;
        this.secondaryActionLabel = secondaryActionLabel;
        this.emptySearchLabel = emptySearchLabel;
        this.canLoadMore = canLoadMore;
        this.loadingMore = loadingMore;
        this.verticalAlignment = verticalAlignment;
        this.allowEmptySelection = allowEmptySelection;
        this.resourceName = resourceName;
        if (shouldUpdate) {
            this.update();
        }
        return this;
    };
    unstable_Picker.prototype.dispatch = function (action, payload) {
        if (action === Action.OPEN) {
            this.open();
        }
        else if (action === Action.UPDATE) {
            this.update();
        }
        else if (action === Action.CANCEL) {
            this.cancel();
        }
        else if (action === Action.SELECT) {
            this.selectedItems = (payload === null || payload === void 0 ? void 0 : payload.selectedItems) || [];
            this.app.dispatch(select({ id: this.id, selectedItems: this.selectedItems }));
        }
        else if (action === Action.SEARCH) {
            this.searchQuery = (payload === null || payload === void 0 ? void 0 : payload.searchQuery) || '';
            this.app.dispatch(search({ id: this.id, searchQuery: this.searchQuery }));
        }
        else if (action === Action.LOAD_MORE) {
            this.loadMore();
        }
        return this;
    };
    unstable_Picker.prototype.update = function () {
        this.app.dispatch(update(this.payload));
    };
    unstable_Picker.prototype.open = function () {
        this.app.dispatch(open(this.payload));
    };
    unstable_Picker.prototype.cancel = function () {
        this.app.dispatch(cancel({ id: this.id }));
    };
    unstable_Picker.prototype.loadMore = function () {
        this.app.dispatch(loadMore(this.payload));
    };
    return unstable_Picker;
}(ActionSet_1.ActionSet));
exports.unstable_Picker = unstable_Picker;


/***/ }),
/* 35 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(111), exports);
__exportStar(__webpack_require__(59), exports);


/***/ }),
/* 36 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createApp = void 0;
var validate_1 = __importDefault(__webpack_require__(69));
var utils_1 = __webpack_require__(8);
var redirect_1 = __webpack_require__(27);
var client_1 = __webpack_require__(15);
var shared_1 = __webpack_require__(40);
/**
 * Creates your application instance with validator middleware.
 * @param config - `apiKey` and `host` are both required.
 * @remarks
 * Please note that `forceRedirect` only works in production environment (`shopname.myshopify.com/admin`).
 * You will need to store `host` during the authentication process and then retrieve it for the code to
 * work properly. To learn more about this process, see
 * {@link https://help.shopify.com/api/embedded-apps/shop-origin | Getting and storing the shop origin}.
 * @public
 */
function createApp(config) {
    var currentWindow = redirect_1.getWindow();
    if (!currentWindow || !currentWindow.top) {
        return shared_1.serverAppBridge;
    }
    utils_1.mixedAppClientCheck(currentWindow);
    return client_1.createAppWrapper(currentWindow.top, currentWindow.location.origin, [validate_1.default])(config);
}
exports.createApp = createApp;
exports.default = createApp;
__exportStar(__webpack_require__(22), exports);
__exportStar(__webpack_require__(15), exports);


/***/ }),
/* 37 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createApp = exports.createAppWrapper = exports.createClientApp = exports.WINDOW_UNDEFINED_MESSAGE = void 0;
var helper_1 = __webpack_require__(6);
var Print_1 = __webpack_require__(21);
var Error_1 = __webpack_require__(11);
var MessageTransport_1 = __webpack_require__(22);
var shared_1 = __webpack_require__(40);
var env_1 = __webpack_require__(25);
var Client_1 = __webpack_require__(41);
var WebVitals_1 = __webpack_require__(42);
var print_1 = __webpack_require__(80);
var redirect_1 = __webpack_require__(27);
var types_1 = __webpack_require__(43);
var Hooks_1 = __importDefault(__webpack_require__(81));
exports.WINDOW_UNDEFINED_MESSAGE = 'window is not defined. Running an app outside a browser is not supported';
function redirectHandler(hostFrame, config) {
    var apiKey = config.apiKey, host = config.host, _a = config.forceRedirect, forceRedirect = _a === void 0 ? !env_1.isDevelopmentClient : _a;
    var location = redirect_1.getLocation();
    if (env_1.isUnframed || !location || !apiKey || !host || !forceRedirect || !redirect_1.shouldRedirect(hostFrame)) {
        return false;
    }
    var url = "https://" + host + "/apps/" + apiKey + location.pathname + (location.search || '');
    redirect_1.redirect(url);
    return true;
}
var actionWrapper = function (next) {
    return function (action) {
        return next(__assign(__assign({}, action), { version: helper_1.getVersion(), clientInterface: {
                name: helper_1.getPackageName(),
                version: helper_1.getVersion(),
            } }));
    };
};
var actionWrappingMiddleware = function (hooks) {
    hooks.set(types_1.LifecycleHook.DispatchAction, actionWrapper);
};
function appSetUp(app) {
    app.subscribe(Print_1.Action.APP, print_1.handleAppPrint);
    app.dispatch(Client_1.initialize());
    try {
        WebVitals_1.initializeWebVitals(app);
    }
    catch (err) {
        // eslint-disable-next-line no-console
        console.error('App-Bridge failed to initialize web-vitals', err);
    }
}
/**
 * @internal
 */
var createClientApp = function (transport, middlewares) {
    if (middlewares === void 0) { middlewares = []; }
    var getStateListeners = [];
    var transportListener = MessageTransport_1.createTransportListener();
    var handler = function (event) {
        var message = event.data;
        var type = message.type, payload = message.payload;
        switch (type) {
            case 'getState': {
                var resolvers = getStateListeners.splice(0);
                resolvers.forEach(function (resolver) { return resolver(payload); });
                break;
            }
            case 'dispatch': {
                transportListener.handleMessage(payload);
                var hasCallback = transportListener.handleActionDispatch(payload);
                if (hasCallback) {
                    return;
                }
                // Throw an error if there are no subscriptions to this error
                var errorType = helper_1.findMatchInEnum(Error_1.Action, payload.type);
                if (errorType) {
                    Error_1.throwError(errorType, payload);
                }
                break;
            }
            default:
            // Silently swallow unknown actions
        }
    };
    transport.subscribe(handler);
    return function (config) {
        var decodedConfig = validateAndDecodeConfig(config);
        var isRedirecting = redirectHandler(transport.hostFrame, decodedConfig);
        if (isRedirecting) {
            return shared_1.mockAppBridge;
        }
        var dispatcher = createDispatcher(transport, decodedConfig);
        var subscribe = transportListener.createSubscribeHandler(dispatcher);
        // It is possible to initialize an app multiple times
        // Therefore we need to clear subscriptions to be safe
        dispatcher(types_1.MessageType.Unsubscribe);
        function dispatch(action) {
            dispatcher(types_1.MessageType.Dispatch, action);
            return action;
        }
        var hostOrigin = new URL("https://" + decodedConfig.host).origin;
        var hooks = new Hooks_1.default();
        var app = {
            hostOrigin: hostOrigin,
            localOrigin: transport.localOrigin,
            hooks: hooks,
            dispatch: function (action) {
                if (!app.hooks) {
                    return dispatch(action);
                }
                return app.hooks.run(types_1.LifecycleHook.DispatchAction, dispatch, app, action);
            },
            featuresAvailable: function () {
                var features = [];
                for (var _i = 0; _i < arguments.length; _i++) {
                    features[_i] = arguments[_i];
                }
                var firstItem = features[0];
                var parsedFeatures = Array.isArray(firstItem) ? __spreadArray([], firstItem) : features;
                return app.getState('features').then(function (state) {
                    if (parsedFeatures.length) {
                        return parsedFeatures.reduce(function (acc, feature) {
                            if (Object.keys(state).includes(feature)) {
                                acc[feature] = state[feature];
                            }
                            return acc;
                        }, {});
                    }
                    return state;
                });
            },
            getState: function (query) {
                if (query && typeof query !== 'string') {
                    return Promise.resolve(undefined);
                }
                return new Promise(function (resolve) {
                    getStateListeners.push(resolve);
                    dispatcher(types_1.MessageType.GetState);
                }).then(function (state) {
                    var newState = state;
                    if (query) {
                        for (var _i = 0, _a = query.split('.'); _i < _a.length; _i++) {
                            var key = _a[_i];
                            if (newState == null ||
                                typeof newState !== 'object' ||
                                Array.isArray(newState) ||
                                !Object.keys(newState).includes(key)) {
                                return undefined;
                            }
                            newState = newState[key];
                        }
                    }
                    return newState;
                });
            },
            subscribe: subscribe,
            error: function (listener, id) {
                var unsubscribeCb = [];
                helper_1.forEachInEnum(Error_1.Action, function (eventNameSpace) {
                    unsubscribeCb.push(subscribe(eventNameSpace, listener, id));
                });
                return function () {
                    unsubscribeCb.forEach(function (unsubscribe) { return unsubscribe(); });
                };
            },
        };
        for (var _i = 0, middlewares_1 = middlewares; _i < middlewares_1.length; _i++) {
            var middleware = middlewares_1[_i];
            middleware(hooks, app);
        }
        appSetUp(app);
        return app;
    };
};
exports.createClientApp = createClientApp;
/**
 * @internal
 */
function validateAndDecodeConfig(config) {
    var _a;
    if (!config.host) {
        throw Error_1.fromAction('host must be provided', Error_1.AppActionType.INVALID_CONFIG);
    }
    if (!config.apiKey) {
        throw Error_1.fromAction('apiKey must be provided', Error_1.AppActionType.INVALID_CONFIG);
    }
    try {
        var host = atob((_a = config.host) === null || _a === void 0 ? void 0 : _a.replace(/_/g, '/').replace(/-/g, '+'));
        return __assign(__assign({}, config), { host: host });
    }
    catch (_b) {
        var message = "not a valid host, please use the value provided by Shopify";
        throw Error_1.fromAction(message, Error_1.AppActionType.INVALID_CONFIG);
    }
}
/**
 * @public
 */
function createAppWrapper(frame, localOrigin, middleware) {
    if (middleware === void 0) { middleware = []; }
    if (!frame) {
        throw Error_1.fromAction(exports.WINDOW_UNDEFINED_MESSAGE, Error_1.AppActionType.WINDOW_UNDEFINED);
    }
    var location = redirect_1.getLocation();
    var origin = localOrigin || (location && location.origin);
    if (!origin) {
        throw Error_1.fromAction('local origin cannot be blank', Error_1.AppActionType.MISSING_LOCAL_ORIGIN);
    }
    var transport = MessageTransport_1.fromWindow(frame, origin);
    var appCreator = exports.createClientApp(transport, __spreadArray([actionWrappingMiddleware], middleware));
    return appCreator;
}
exports.createAppWrapper = createAppWrapper;
/**
 * Creates your application instance.
 * @param config - `apiKey` and `host` are both required.
 * @remarks
 * You will need to store `host` during the authentication process and then retrieve it for the code to work properly. To learn more about this process, see {@link https://help.shopify.com/api/embedded-apps/shop-origin | Getting and storing the shop origin}.
 * @public
 */
function createApp(config) {
    var currentWindow = redirect_1.getWindow();
    if (!currentWindow || !currentWindow.top) {
        return shared_1.serverAppBridge;
    }
    return createAppWrapper(currentWindow.top)(config);
}
exports.createApp = createApp;
function createDispatcher(transport, config) {
    return function (type, payload) {
        transport.dispatch({
            payload: payload,
            source: config,
            type: type,
        });
    };
}
/**
 * {@inheritdocs createApp}
 * @public
 */
exports.default = createApp;


/***/ }),
/* 38 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.SEPARATOR = exports.PREFIX = void 0;
exports.PREFIX = 'APP';
exports.SEPARATOR = '::';


/***/ }),
/* 39 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.isPermitted = exports.getPermissionKey = exports.isPerformanceOrWebVitalsAction = exports.isAppMessage = exports.isAppBridgeAction = void 0;
var types_1 = __webpack_require__(13);
var constants_1 = __webpack_require__(38);
var helper_1 = __webpack_require__(0);
/**
 * Predicate to determine if an action is an App Bridge action.
 * @public
 */
function isAppBridgeAction(action) {
    return (action instanceof Object &&
        Object.prototype.hasOwnProperty.call(action, 'type') &&
        action.type.toString().startsWith(constants_1.PREFIX));
}
exports.isAppBridgeAction = isAppBridgeAction;
/**
 * Predicate to determine if an event originated from an application.
 * @internal
 */
function isAppMessage(event) {
    if (typeof event !== 'object' || !event.data || typeof event.data !== 'object') {
        return false;
    }
    var data = event.data;
    return (Object.prototype.hasOwnProperty.call(data, 'type') &&
        helper_1.findMatchInEnum(types_1.MessageType, data.type) !== undefined);
}
exports.isAppMessage = isAppMessage;
/**
 * Function used to determine if an action is in the Performance or WebVitals groups
 * @public
 */
function isPerformanceOrWebVitalsAction(_a) {
    var type = _a.type;
    return type.match(/^APP::(PERFORMANCE|WEB_VITALS)::/);
}
exports.isPerformanceOrWebVitalsAction = isPerformanceOrWebVitalsAction;
/**
 * Returns the action type without the prefix and group
 * @internal
 */
function getPermissionKey(type) {
    return type.replace(new RegExp("^" + constants_1.PREFIX + constants_1.SEPARATOR + "\\w+" + constants_1.SEPARATOR), '');
}
exports.getPermissionKey = getPermissionKey;
/**
 * Predicate to determine if an action is permitted
 * @internal
 */
function isPermitted(features, _a, permissionType) {
    var group = _a.group, type = _a.type;
    if (!group || !Object.prototype.hasOwnProperty.call(features, group)) {
        return false;
    }
    var feature = features[group];
    if (!feature) {
        return false;
    }
    var actionType = getPermissionKey(type);
    return feature[actionType] ? feature[actionType][permissionType] === true : false;
}
exports.isPermitted = isPermitted;


/***/ }),
/* 40 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.mockAppBridge = exports.serverAppBridge = void 0;
var Error_1 = __webpack_require__(11);
var noop = function () { };
var noopPromise = new Promise(function () {
    // Noop
});
/**
 * @internal
 */
exports.serverAppBridge = {
    dispatch: function () {
        return {};
    },
    error: function () {
        return noop;
    },
    featuresAvailable: function () {
        return Promise.reject(Error_1.fromAction('Feature detection is only available on the client side.', Error_1.AppActionType.WINDOW_UNDEFINED));
    },
    getState: function () {
        return Promise.reject(Error_1.fromAction('State is only available on the client side.', Error_1.AppActionType.WINDOW_UNDEFINED));
    },
    localOrigin: '',
    hostOrigin: '',
    subscribe: function () {
        return noop;
    },
};
/**
 * @internal
 */
exports.mockAppBridge = {
    dispatch: function () {
        return {};
    },
    error: function () {
        return noop;
    },
    featuresAvailable: function () {
        return noopPromise;
    },
    getState: function () {
        return noopPromise;
    },
    localOrigin: '',
    hostOrigin: '',
    subscribe: function () {
        return noop;
    },
};


/***/ }),
/* 41 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.initialize = exports.Action = void 0;
var Client_1 = __webpack_require__(76);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Client_1.Action; } });
var types_1 = __webpack_require__(7);
var helper_1 = __webpack_require__(6);
function initialize() {
    return helper_1.actionWrapper({
        group: types_1.Group.Client,
        type: Client_1.Action.INITIALIZE,
    });
}
exports.initialize = initialize;


/***/ }),
/* 42 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(77), exports);


/***/ }),
/* 43 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.isV1Config = exports.ClientApplication = exports.MessageType = exports.AppConfigV2 = exports.FeaturesState = exports.FeaturesAvailable = exports.TransportSubscription = exports.PathValue = exports.Path = exports.LifecycleHandler = exports.DispatchActionHandler = exports.DispatchActionHook = exports.UpdateActionHandler = exports.UpdateActionHook = exports.LifecycleHook = exports.HooksInterface = exports.StateWithoutFeatures = exports.PermissionType = exports.FeaturePermission = exports.FeaturesAction = exports.StaffMemberDetails = exports.AppBridgeState = exports.TransportDispatch = exports.Dispatcher = void 0;
var types_1 = __webpack_require__(13);
Object.defineProperty(exports, "AppConfigV2", { enumerable: true, get: function () { return types_1.AppConfigV2; } });
Object.defineProperty(exports, "MessageType", { enumerable: true, get: function () { return types_1.MessageType; } });
Object.defineProperty(exports, "ClientApplication", { enumerable: true, get: function () { return types_1.ClientApplication; } });
var types_2 = __webpack_require__(13);
Object.defineProperty(exports, "Dispatcher", { enumerable: true, get: function () { return types_2.Dispatcher; } });
Object.defineProperty(exports, "TransportDispatch", { enumerable: true, get: function () { return types_2.TransportDispatch; } });
Object.defineProperty(exports, "AppBridgeState", { enumerable: true, get: function () { return types_2.AppBridgeState; } });
Object.defineProperty(exports, "StaffMemberDetails", { enumerable: true, get: function () { return types_2.StaffMemberDetails; } });
Object.defineProperty(exports, "FeaturesAction", { enumerable: true, get: function () { return types_2.FeaturesAction; } });
Object.defineProperty(exports, "FeaturePermission", { enumerable: true, get: function () { return types_2.FeaturePermission; } });
Object.defineProperty(exports, "PermissionType", { enumerable: true, get: function () { return types_2.PermissionType; } });
Object.defineProperty(exports, "StateWithoutFeatures", { enumerable: true, get: function () { return types_2.StateWithoutFeatures; } });
Object.defineProperty(exports, "HooksInterface", { enumerable: true, get: function () { return types_2.HooksInterface; } });
Object.defineProperty(exports, "LifecycleHook", { enumerable: true, get: function () { return types_2.LifecycleHook; } });
Object.defineProperty(exports, "UpdateActionHook", { enumerable: true, get: function () { return types_2.UpdateActionHook; } });
Object.defineProperty(exports, "UpdateActionHandler", { enumerable: true, get: function () { return types_2.UpdateActionHandler; } });
Object.defineProperty(exports, "DispatchActionHook", { enumerable: true, get: function () { return types_2.DispatchActionHook; } });
Object.defineProperty(exports, "DispatchActionHandler", { enumerable: true, get: function () { return types_2.DispatchActionHandler; } });
Object.defineProperty(exports, "LifecycleHandler", { enumerable: true, get: function () { return types_2.LifecycleHandler; } });
Object.defineProperty(exports, "Path", { enumerable: true, get: function () { return types_2.Path; } });
Object.defineProperty(exports, "PathValue", { enumerable: true, get: function () { return types_2.PathValue; } });
Object.defineProperty(exports, "TransportSubscription", { enumerable: true, get: function () { return types_2.TransportSubscription; } });
Object.defineProperty(exports, "FeaturesAvailable", { enumerable: true, get: function () { return types_2.FeaturesAvailable; } });
Object.defineProperty(exports, "FeaturesState", { enumerable: true, get: function () { return types_2.FeaturesState; } });
/**
 * @internal
 * @param config
 */
function isV1Config(config) {
    return !config.host;
}
exports.isV1Config = isV1Config;


/***/ }),
/* 44 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.generateUuid = void 0;
/**
 * Convert a number or array of integers to a string of padded hex octets.
 */
function asHex(value) {
    return Array.from(value)
        .map(function (i) { return ("00" + i.toString(16)).slice(-2); })
        .join('');
}
/**
 * Attempt to securely generate random bytes/
 */
function getRandomBytes(size) {
    // SPRNG
    if (typeof Uint8Array === 'function' && typeof window === 'object' && window.crypto) {
        var buffer = new Uint8Array(size);
        var randomValues = window.crypto.getRandomValues(buffer);
        if (randomValues) {
            return randomValues;
        }
    }
    // Insecure random
    return Array.from(new Array(size), function () { return (Math.random() * 255) | 0; });
}
/**
 * Generate a RFC4122-compliant v4 UUID.
 *
 * @see http://www.ietf.org/rfc/rfc4122.txt
 */
function generateUuid() {
    var version = 64;
    var clockSeqHiAndReserved = getRandomBytes(1);
    var timeHiAndVersion = getRandomBytes(2);
    clockSeqHiAndReserved[0] &= 63 | 128;
    // tslint:disable-next-line:binary-expression-operand-order
    timeHiAndVersion[0] &= 15 | version;
    return [
        // time-low
        asHex(getRandomBytes(4)),
        '-',
        // time-mid
        asHex(getRandomBytes(2)),
        '-',
        // time-high-and-version
        asHex(timeHiAndVersion),
        '-',
        // clock-seq-and-reserved
        asHex(clockSeqHiAndReserved),
        // clock-seq-loq
        asHex(getRandomBytes(1)),
        '-',
        // node
        asHex(getRandomBytes(6)),
    ].join('');
}
exports.generateUuid = generateUuid;
exports.default = generateUuid;


/***/ }),
/* 45 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = exports.validateAction = exports.validateProps = exports.buttonGroupSchema = void 0;
var ButtonGroup_1 = __webpack_require__(9);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return ButtonGroup_1.Action; } });
var type_validate_1 = __webpack_require__(3);
var utils_1 = __webpack_require__(4);
var button_1 = __webpack_require__(16);
exports.buttonGroupSchema = type_validate_1.composeSchemas(button_1.buttonSchema, type_validate_1.matchesObject({
    buttons: type_validate_1.matchesArray(type_validate_1.makeOptional(button_1.buttonSchemaWithId)),
}));
function validateProps(props) {
    return type_validate_1.validate(props, exports.buttonGroupSchema);
}
exports.validateProps = validateProps;
function validateAction(action) {
    var validator = utils_1.createActionValidator(ButtonGroup_1.Action, exports.buttonGroupSchema, true, true);
    return type_validate_1.validate(action, validator);
}
exports.validateAction = validateAction;


/***/ }),
/* 46 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContextualSaveBar = exports.update = exports.discard = exports.save = exports.hide = exports.show = exports.Action = void 0;
var helper_1 = __webpack_require__(0);
var ActionSet_1 = __webpack_require__(2);
var types_1 = __webpack_require__(1);
/**
 * ContextualSaveBar action enum
 */
var Action;
(function (Action) {
    Action["DISCARD"] = "APP::CONTEXTUAL_SAVE_BAR::DISCARD";
    Action["SAVE"] = "APP::CONTEXTUAL_SAVE_BAR::SAVE";
    Action["SHOW"] = "APP::CONTEXTUAL_SAVE_BAR::SHOW";
    Action["HIDE"] = "APP::CONTEXTUAL_SAVE_BAR::HIDE";
    Action["UPDATE"] = "APP::CONTEXTUAL_SAVE_BAR::UPDATE";
})(Action = exports.Action || (exports.Action = {}));
function createContextBarAction(action, payload) {
    return helper_1.actionWrapper({
        group: types_1.Group.ContextualSaveBar,
        type: action,
        payload: payload,
    });
}
function show(payload) {
    return createContextBarAction(Action.SHOW, payload);
}
exports.show = show;
function hide(payload) {
    return createContextBarAction(Action.HIDE, payload);
}
exports.hide = hide;
function save(payload) {
    return createContextBarAction(Action.SAVE, payload);
}
exports.save = save;
function discard(payload) {
    return createContextBarAction(Action.DISCARD, payload);
}
exports.discard = discard;
function update(payload) {
    return createContextBarAction(Action.UPDATE, payload);
}
exports.update = update;
/**
 * ContextualSaveBar action set
 */
var ContextualSaveBar = /** @class */ (function (_super) {
    __extends(ContextualSaveBar, _super);
    /**
     * Returns a new instance of a ContextualSaveBar action set
     * @param app the client application
     */
    function ContextualSaveBar(app, options) {
        if (options === void 0) { options = {}; }
        var _this = _super.call(this, app, types_1.Group.ContextualSaveBar, types_1.Group.ContextualSaveBar) || this;
        _this.options = options;
        _this.set(options, false);
        return _this;
    }
    Object.defineProperty(ContextualSaveBar.prototype, "payload", {
        /**
         * Returns the action set payload
         */
        get: function () {
            return __assign({ id: this.id }, this.options);
        },
        enumerable: false,
        configurable: true
    });
    ContextualSaveBar.prototype.set = function (options, shouldUpdate) {
        if (shouldUpdate === void 0) { shouldUpdate = true; }
        var mergedOptions = helper_1.getMergedProps(this.options, options);
        this.options = mergedOptions;
        if (shouldUpdate) {
            this.dispatch(Action.UPDATE);
        }
        return this;
    };
    /**
     * Dispatches a given action with the action set payload
     * @param action the action enum
     * @returns the action set instance
     */
    ContextualSaveBar.prototype.dispatch = function (action) {
        this.app.dispatch(createContextBarAction(action, this.payload));
        return this;
    };
    return ContextualSaveBar;
}(ActionSet_1.ActionSet));
exports.ContextualSaveBar = ContextualSaveBar;


/***/ }),
/* 47 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.FeedbackModal = exports.close = exports.open = exports.Action = void 0;
var helper_1 = __webpack_require__(0);
var ActionSet_1 = __webpack_require__(2);
var types_1 = __webpack_require__(1);
/**
 * Action for the Feedback Modal group
 * @public
 */
var Action;
(function (Action) {
    Action["OPEN"] = "APP::FEEDBACK_MODAL::OPEN";
    Action["CLOSE"] = "APP::FEEDBACK_MODAL::CLOSE";
})(Action = exports.Action || (exports.Action = {}));
function open(payload) {
    return helper_1.actionWrapper({
        group: types_1.Group.FeedbackModal,
        payload: payload,
        type: Action.OPEN,
    });
}
exports.open = open;
function close(payload) {
    return helper_1.actionWrapper({
        group: types_1.Group.FeedbackModal,
        payload: payload,
        type: Action.CLOSE,
    });
}
exports.close = close;
/**
 * FeedbackModal action set
 */
var FeedbackModal = /** @class */ (function (_super) {
    __extends(FeedbackModal, _super);
    /**
     * Returns a new instance of a FeedbackModal action set
     * @param app the client application
     */
    function FeedbackModal(app, options) {
        var _this = _super.call(this, app, types_1.Group.FeedbackModal, types_1.Group.FeedbackModal) || this;
        _this.options = options;
        _this.set(options);
        return _this;
    }
    Object.defineProperty(FeedbackModal.prototype, "payload", {
        /**
         * Returns the action set payload
         */
        get: function () {
            return __assign({ id: this.id }, this.options);
        },
        enumerable: false,
        configurable: true
    });
    FeedbackModal.prototype.set = function (options) {
        this.options = helper_1.getMergedProps(this.options, options);
        return this;
    };
    /**
     * Dispatches a given action with the action set payload
     * @param action the action enum
     * @returns the action set instance
     */
    FeedbackModal.prototype.dispatch = function (action) {
        switch (action) {
            case Action.OPEN: {
                var openAction = open(this.payload);
                this.app.dispatch(openAction);
                break;
            }
            case Action.CLOSE: {
                var closeAction = close(this.payload);
                this.app.dispatch(closeAction);
                break;
            }
        }
        return this;
    };
    return FeedbackModal;
}(ActionSet_1.ActionSet));
exports.FeedbackModal = FeedbackModal;
/**
 * Returns a new instance of a FeedbackModal action set
 * @param app the client application
 */
function create(app, options) {
    return new FeedbackModal(app, options);
}
exports.create = create;


/***/ }),
/* 48 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = exports.validateAction = exports.validateProps = exports.linkActionSchema = exports.linkPropsSchema = void 0;
var AppLink_1 = __webpack_require__(14);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return AppLink_1.Action; } });
var type_validate_1 = __webpack_require__(3);
var utils_1 = __webpack_require__(4);
var AllowedRedirectType;
(function (AllowedRedirectType) {
    AllowedRedirectType["APP"] = "APP::NAVIGATION::REDIRECT::APP";
    AllowedRedirectType["LEGACY_APP"] = "APP";
})(AllowedRedirectType || (AllowedRedirectType = {}));
exports.linkPropsSchema = type_validate_1.matchesObject({
    label: type_validate_1.matchesString(),
    destination: utils_1.relativeUrlSchema,
    redirectType: type_validate_1.matchesEnum(AllowedRedirectType),
});
exports.linkActionSchema = type_validate_1.matchesObject({
    label: type_validate_1.matchesString(),
    destination: utils_1.relativePathSchema,
    redirectType: type_validate_1.matchesEnum(AllowedRedirectType),
});
function validateProps(props) {
    return type_validate_1.validate(props, exports.linkPropsSchema);
}
exports.validateProps = validateProps;
function validateAction(action) {
    return type_validate_1.validate(action, utils_1.createActionValidator(AppLink_1.Action, exports.linkActionSchema, true, true));
}
exports.validateAction = validateAction;


/***/ }),
/* 49 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.setLineItemProperties = exports.removeLineItemDiscount = exports.setLineItemDiscount = exports.removeLineItem = exports.updateLineItem = exports.addLineItem = exports.removeProperties = exports.setProperties = exports.setDiscount = exports.updateCustomerAddress = exports.addCustomerAddress = exports.setCustomer = exports.update = exports.fetch = exports.Properties = exports.NoteAttributes = exports.LineItem = exports.Discount = exports.DiscountCode = exports.DiscountAmount = exports.Address = exports.CustomerWithAddresses = exports.Customer = exports.Cart = exports.RemoveLineItemPropertiesPayload = exports.SetLineItemPropertiesPayload = exports.RemoveLineItemDiscountPayload = exports.SetLineItemDiscountPayload = exports.RemoveLineItemPayload = exports.UpdateLineItemPayload = exports.UpdateLineItemData = exports.RemovePropertiesPayload = exports.SetPropertiesPayload = exports.SetDiscountPayload = exports.UpdateCustomerAddressPayload = exports.SetCustomerPayload = exports.AddLineItemPayload = exports.AddCustomerAddressPayload = exports.Options = exports.Payload = exports.Data = exports.Action = void 0;
var Cart_1 = __webpack_require__(99);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Cart_1.Action; } });
Object.defineProperty(exports, "Data", { enumerable: true, get: function () { return Cart_1.Data; } });
Object.defineProperty(exports, "Payload", { enumerable: true, get: function () { return Cart_1.Payload; } });
Object.defineProperty(exports, "Options", { enumerable: true, get: function () { return Cart_1.Options; } });
Object.defineProperty(exports, "AddCustomerAddressPayload", { enumerable: true, get: function () { return Cart_1.AddCustomerAddressPayload; } });
Object.defineProperty(exports, "AddLineItemPayload", { enumerable: true, get: function () { return Cart_1.AddLineItemPayload; } });
Object.defineProperty(exports, "SetCustomerPayload", { enumerable: true, get: function () { return Cart_1.SetCustomerPayload; } });
Object.defineProperty(exports, "UpdateCustomerAddressPayload", { enumerable: true, get: function () { return Cart_1.UpdateCustomerAddressPayload; } });
Object.defineProperty(exports, "SetDiscountPayload", { enumerable: true, get: function () { return Cart_1.SetDiscountPayload; } });
Object.defineProperty(exports, "SetPropertiesPayload", { enumerable: true, get: function () { return Cart_1.SetPropertiesPayload; } });
Object.defineProperty(exports, "RemovePropertiesPayload", { enumerable: true, get: function () { return Cart_1.RemovePropertiesPayload; } });
Object.defineProperty(exports, "UpdateLineItemData", { enumerable: true, get: function () { return Cart_1.UpdateLineItemData; } });
Object.defineProperty(exports, "UpdateLineItemPayload", { enumerable: true, get: function () { return Cart_1.UpdateLineItemPayload; } });
Object.defineProperty(exports, "RemoveLineItemPayload", { enumerable: true, get: function () { return Cart_1.RemoveLineItemPayload; } });
Object.defineProperty(exports, "SetLineItemDiscountPayload", { enumerable: true, get: function () { return Cart_1.SetLineItemDiscountPayload; } });
Object.defineProperty(exports, "RemoveLineItemDiscountPayload", { enumerable: true, get: function () { return Cart_1.RemoveLineItemDiscountPayload; } });
Object.defineProperty(exports, "SetLineItemPropertiesPayload", { enumerable: true, get: function () { return Cart_1.SetLineItemPropertiesPayload; } });
Object.defineProperty(exports, "RemoveLineItemPropertiesPayload", { enumerable: true, get: function () { return Cart_1.RemoveLineItemPropertiesPayload; } });
Object.defineProperty(exports, "Cart", { enumerable: true, get: function () { return Cart_1.Cart; } });
Object.defineProperty(exports, "Customer", { enumerable: true, get: function () { return Cart_1.Customer; } });
Object.defineProperty(exports, "CustomerWithAddresses", { enumerable: true, get: function () { return Cart_1.CustomerWithAddresses; } });
Object.defineProperty(exports, "Address", { enumerable: true, get: function () { return Cart_1.Address; } });
Object.defineProperty(exports, "DiscountAmount", { enumerable: true, get: function () { return Cart_1.DiscountAmount; } });
Object.defineProperty(exports, "DiscountCode", { enumerable: true, get: function () { return Cart_1.DiscountCode; } });
Object.defineProperty(exports, "Discount", { enumerable: true, get: function () { return Cart_1.Discount; } });
Object.defineProperty(exports, "LineItem", { enumerable: true, get: function () { return Cart_1.LineItem; } });
Object.defineProperty(exports, "NoteAttributes", { enumerable: true, get: function () { return Cart_1.NoteAttributes; } });
Object.defineProperty(exports, "Properties", { enumerable: true, get: function () { return Cart_1.Properties; } });
Object.defineProperty(exports, "fetch", { enumerable: true, get: function () { return Cart_1.fetch; } });
Object.defineProperty(exports, "update", { enumerable: true, get: function () { return Cart_1.update; } });
Object.defineProperty(exports, "setCustomer", { enumerable: true, get: function () { return Cart_1.setCustomer; } });
Object.defineProperty(exports, "addCustomerAddress", { enumerable: true, get: function () { return Cart_1.addCustomerAddress; } });
Object.defineProperty(exports, "updateCustomerAddress", { enumerable: true, get: function () { return Cart_1.updateCustomerAddress; } });
Object.defineProperty(exports, "setDiscount", { enumerable: true, get: function () { return Cart_1.setDiscount; } });
Object.defineProperty(exports, "setProperties", { enumerable: true, get: function () { return Cart_1.setProperties; } });
Object.defineProperty(exports, "removeProperties", { enumerable: true, get: function () { return Cart_1.removeProperties; } });
Object.defineProperty(exports, "addLineItem", { enumerable: true, get: function () { return Cart_1.addLineItem; } });
Object.defineProperty(exports, "updateLineItem", { enumerable: true, get: function () { return Cart_1.updateLineItem; } });
Object.defineProperty(exports, "removeLineItem", { enumerable: true, get: function () { return Cart_1.removeLineItem; } });
Object.defineProperty(exports, "setLineItemDiscount", { enumerable: true, get: function () { return Cart_1.setLineItemDiscount; } });
Object.defineProperty(exports, "removeLineItemDiscount", { enumerable: true, get: function () { return Cart_1.removeLineItemDiscount; } });
Object.defineProperty(exports, "setLineItemProperties", { enumerable: true, get: function () { return Cart_1.setLineItemProperties; } });
function create(app, options) {
    return new Cart_1.Cart(app, options);
}
exports.create = create;


/***/ }),
/* 50 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.Action = exports.Fullscreen = exports.exit = exports.enter = exports.FullscreenAction = exports.Payload = void 0;
var Fullscreen_1 = __webpack_require__(51);
Object.defineProperty(exports, "Fullscreen", { enumerable: true, get: function () { return Fullscreen_1.Fullscreen; } });
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Fullscreen_1.Action; } });
var Fullscreen_2 = __webpack_require__(51);
Object.defineProperty(exports, "Payload", { enumerable: true, get: function () { return Fullscreen_2.Payload; } });
Object.defineProperty(exports, "FullscreenAction", { enumerable: true, get: function () { return Fullscreen_2.FullscreenAction; } });
Object.defineProperty(exports, "enter", { enumerable: true, get: function () { return Fullscreen_2.enter; } });
Object.defineProperty(exports, "exit", { enumerable: true, get: function () { return Fullscreen_2.exit; } });
/**
 * Returns a new instance of a Fullscreen action set
 * @param app the client application
 *
 * @beta
 */
function create(app) {
    return new Fullscreen_1.Fullscreen(app);
}
exports.create = create;


/***/ }),
/* 51 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Fullscreen = exports.exit = exports.enter = exports.Action = void 0;
var helper_1 = __webpack_require__(0);
var ActionSet_1 = __webpack_require__(2);
var types_1 = __webpack_require__(1);
/**
 * Fullscreen action type enum
 * @remarks includes the action prefix and group
 *
 * @beta
 */
var Action;
(function (Action) {
    Action["ENTER"] = "APP::FULLSCREEN::ENTER";
    Action["EXIT"] = "APP::FULLSCREEN::EXIT";
})(Action = exports.Action || (exports.Action = {}));
function enter() {
    return helper_1.actionWrapper({
        group: types_1.Group.Fullscreen,
        type: Action.ENTER,
    });
}
exports.enter = enter;
function exit() {
    return helper_1.actionWrapper({
        group: types_1.Group.Fullscreen,
        type: Action.EXIT,
    });
}
exports.exit = exit;
/**
 * Fullscreen action set
 * @beta
 */
var Fullscreen = /** @class */ (function (_super) {
    __extends(Fullscreen, _super);
    /**
     * Returns a new instance of a Fullscreen action set
     * @param app the client application
     */
    function Fullscreen(app) {
        return _super.call(this, app, types_1.Group.Fullscreen, types_1.Group.Fullscreen) || this;
    }
    Object.defineProperty(Fullscreen.prototype, "payload", {
        /**
         * Returns the action set payload
         */
        get: function () {
            return { id: this.id };
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Dispatches a given action with the action set payload
     * @param action the action enum
     * @returns the action set instance
     */
    Fullscreen.prototype.dispatch = function (action) {
        this.app.dispatch(helper_1.actionWrapper({
            group: this.group,
            type: action,
            payload: this.payload,
        }));
        return this;
    };
    return Fullscreen;
}(ActionSet_1.ActionSet));
exports.Fullscreen = Fullscreen;


/***/ }),
/* 52 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.stop = exports.start = exports.LoadingAction = exports.Payload = exports.Action = exports.Loading = void 0;
var Loading_1 = __webpack_require__(53);
Object.defineProperty(exports, "Loading", { enumerable: true, get: function () { return Loading_1.Loading; } });
var Loading_2 = __webpack_require__(53);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Loading_2.Action; } });
Object.defineProperty(exports, "Payload", { enumerable: true, get: function () { return Loading_2.Payload; } });
Object.defineProperty(exports, "LoadingAction", { enumerable: true, get: function () { return Loading_2.LoadingAction; } });
Object.defineProperty(exports, "start", { enumerable: true, get: function () { return Loading_2.start; } });
Object.defineProperty(exports, "stop", { enumerable: true, get: function () { return Loading_2.stop; } });
function create(app) {
    return new Loading_1.Loading(app);
}
exports.create = create;


/***/ }),
/* 53 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Loading = exports.stop = exports.start = exports.Action = void 0;
var helper_1 = __webpack_require__(0);
var ActionSet_1 = __webpack_require__(2);
var types_1 = __webpack_require__(1);
var Action;
(function (Action) {
    Action["START"] = "APP::LOADING::START";
    Action["STOP"] = "APP::LOADING::STOP";
})(Action = exports.Action || (exports.Action = {}));
function start(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.Loading,
        type: Action.START,
    });
}
exports.start = start;
function stop(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.Loading,
        type: Action.STOP,
    });
}
exports.stop = stop;
var Loading = /** @class */ (function (_super) {
    __extends(Loading, _super);
    function Loading(app) {
        return _super.call(this, app, types_1.Group.Loading, types_1.Group.Loading) || this;
    }
    Object.defineProperty(Loading.prototype, "payload", {
        get: function () {
            return { id: this.id };
        },
        enumerable: false,
        configurable: true
    });
    Loading.prototype.dispatch = function (action) {
        switch (action) {
            case Action.START:
                this.app.dispatch(start(this.payload));
                break;
            case Action.STOP:
                this.app.dispatch(stop(this.payload));
                break;
        }
        return this;
    };
    return Loading;
}(ActionSet_1.ActionSet));
exports.Loading = Loading;


/***/ }),
/* 54 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.capture = exports.openCamera = exports.Scanner = exports.Options = exports.Payload = exports.Data = exports.Action = void 0;
var Scanner_1 = __webpack_require__(104);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Scanner_1.Action; } });
Object.defineProperty(exports, "Data", { enumerable: true, get: function () { return Scanner_1.Data; } });
Object.defineProperty(exports, "Payload", { enumerable: true, get: function () { return Scanner_1.Payload; } });
Object.defineProperty(exports, "Options", { enumerable: true, get: function () { return Scanner_1.Options; } });
Object.defineProperty(exports, "Scanner", { enumerable: true, get: function () { return Scanner_1.Scanner; } });
Object.defineProperty(exports, "openCamera", { enumerable: true, get: function () { return Scanner_1.openCamera; } });
Object.defineProperty(exports, "capture", { enumerable: true, get: function () { return Scanner_1.capture; } });
/**
 * @public
 */
function create(app, options) {
    return new Scanner_1.Scanner(app, options);
}
exports.create = create;


/***/ }),
/* 55 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.WebVitals = exports.unstable_Picker = exports.Performance = exports.Pos = exports.AppLink = exports.ChannelMenu = exports.NavigationMenu = exports.Share = exports.ContextualSaveBar = exports.MarketingExternalActivityTopBar = exports.TitleBar = exports.SessionToken = exports.ResourcePicker = exports.Redirect = exports.Print = exports.ModalContent = exports.Modal = exports.Loading = exports.LeaveConfirmation = exports.History = exports.Toast = exports.Fullscreen = exports.FeedbackModal = exports.Features = exports.Flash = exports.Error = exports.Client = exports.Cart = exports.Scanner = exports.ButtonGroup = exports.Button = exports.AuthCode = exports.isAppBridgeAction = void 0;
var AuthCode = __importStar(__webpack_require__(56));
exports.AuthCode = AuthCode;
var Button = __importStar(__webpack_require__(58));
exports.Button = Button;
var ButtonGroup = __importStar(__webpack_require__(106));
exports.ButtonGroup = ButtonGroup;
var Cart = __importStar(__webpack_require__(49));
exports.Cart = Cart;
var Client = __importStar(__webpack_require__(41));
exports.Client = Client;
var Error = __importStar(__webpack_require__(11));
exports.Error = Error;
var Flash = __importStar(__webpack_require__(107));
exports.Flash = Flash;
var Features = __importStar(__webpack_require__(109));
exports.Features = Features;
var FeedbackModal = __importStar(__webpack_require__(113));
exports.FeedbackModal = FeedbackModal;
var Fullscreen = __importStar(__webpack_require__(50));
exports.Fullscreen = Fullscreen;
var LeaveConfirmation = __importStar(__webpack_require__(114));
exports.LeaveConfirmation = LeaveConfirmation;
var Loading = __importStar(__webpack_require__(52));
exports.Loading = Loading;
var Modal = __importStar(__webpack_require__(60));
exports.Modal = Modal;
var ModalContent = __importStar(__webpack_require__(115));
exports.ModalContent = ModalContent;
var History = __importStar(__webpack_require__(116));
exports.History = History;
var Redirect = __importStar(__webpack_require__(117));
exports.Redirect = Redirect;
var Print = __importStar(__webpack_require__(21));
exports.Print = Print;
var ResourcePicker = __importStar(__webpack_require__(118));
exports.ResourcePicker = ResourcePicker;
var Scanner = __importStar(__webpack_require__(54));
exports.Scanner = Scanner;
var SessionToken = __importStar(__webpack_require__(119));
exports.SessionToken = SessionToken;
var TitleBar = __importStar(__webpack_require__(120));
exports.TitleBar = TitleBar;
var Toast = __importStar(__webpack_require__(121));
exports.Toast = Toast;
var ContextualSaveBar = __importStar(__webpack_require__(122));
exports.ContextualSaveBar = ContextualSaveBar;
var Share = __importStar(__webpack_require__(123));
exports.Share = Share;
var NavigationMenu = __importStar(__webpack_require__(124));
exports.NavigationMenu = NavigationMenu;
var ChannelMenu = __importStar(__webpack_require__(125));
exports.ChannelMenu = ChannelMenu;
var AppLink = __importStar(__webpack_require__(126));
exports.AppLink = AppLink;
var Pos = __importStar(__webpack_require__(127));
exports.Pos = Pos;
var MarketingExternalActivityTopBar = __importStar(__webpack_require__(128));
exports.MarketingExternalActivityTopBar = MarketingExternalActivityTopBar;
var Performance = __importStar(__webpack_require__(132));
exports.Performance = Performance;
var unstable_Picker = __importStar(__webpack_require__(134));
exports.unstable_Picker = unstable_Picker;
var WebVitals = __importStar(__webpack_require__(42));
exports.WebVitals = WebVitals;
var validator_1 = __webpack_require__(135);
Object.defineProperty(exports, "isAppBridgeAction", { enumerable: true, get: function () { return validator_1.isAppBridgeAction; } });
__exportStar(__webpack_require__(7), exports);


/***/ }),
/* 56 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.request = exports.RequestAuthCodeAction = exports.Action = exports.RespondWithAuthCodeAction = exports.ActionBase = exports.RequestPayload = exports.ResponsePayload = exports.FailedResponsePayload = exports.ExchangeRequiredPayload = exports.respond = void 0;
var AuthCode_1 = __webpack_require__(57);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return AuthCode_1.Action; } });
Object.defineProperty(exports, "RequestAuthCodeAction", { enumerable: true, get: function () { return AuthCode_1.RequestAuthCodeAction; } });
var helper_1 = __webpack_require__(6);
var types_1 = __webpack_require__(7);
var AuthCode_2 = __webpack_require__(57);
Object.defineProperty(exports, "respond", { enumerable: true, get: function () { return AuthCode_2.respond; } });
Object.defineProperty(exports, "ExchangeRequiredPayload", { enumerable: true, get: function () { return AuthCode_2.ExchangeRequiredPayload; } });
Object.defineProperty(exports, "FailedResponsePayload", { enumerable: true, get: function () { return AuthCode_2.FailedResponsePayload; } });
Object.defineProperty(exports, "ResponsePayload", { enumerable: true, get: function () { return AuthCode_2.ResponsePayload; } });
Object.defineProperty(exports, "RequestPayload", { enumerable: true, get: function () { return AuthCode_2.RequestPayload; } });
Object.defineProperty(exports, "ActionBase", { enumerable: true, get: function () { return AuthCode_2.ActionBase; } });
Object.defineProperty(exports, "RespondWithAuthCodeAction", { enumerable: true, get: function () { return AuthCode_2.RespondWithAuthCodeAction; } });
function request(id) {
    return helper_1.actionWrapper({
        group: types_1.Group.AuthCode,
        type: AuthCode_1.Action.REQUEST,
        payload: { id: id },
    });
}
exports.request = request;


/***/ }),
/* 57 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.respond = exports.Action = void 0;
var helper_1 = __webpack_require__(0);
var types_1 = __webpack_require__(1);
var Action;
(function (Action) {
    Action["REQUEST"] = "APP::AUTH_CODE::REQUEST";
    Action["RESPOND"] = "APP::AUTH_CODE::RESPOND";
})(Action = exports.Action || (exports.Action = {}));
function respond(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.AuthCode,
        type: Action.RESPOND,
    });
}
exports.respond = respond;


/***/ }),
/* 58 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.isValidButtonProps = exports.Payload = exports.Options = exports.Button = exports.update = exports.Style = exports.Presentation = exports.Icon = exports.ClickPayload = exports.clickButton = exports.ButtonUpdateAction = exports.ButtonAction = exports.Action = void 0;
var Button_1 = __webpack_require__(5);
Object.defineProperty(exports, "Button", { enumerable: true, get: function () { return Button_1.Button; } });
Object.defineProperty(exports, "Options", { enumerable: true, get: function () { return Button_1.Options; } });
Object.defineProperty(exports, "Payload", { enumerable: true, get: function () { return Button_1.Payload; } });
var Button_2 = __webpack_require__(5);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Button_2.Action; } });
Object.defineProperty(exports, "ButtonAction", { enumerable: true, get: function () { return Button_2.ButtonAction; } });
Object.defineProperty(exports, "ButtonUpdateAction", { enumerable: true, get: function () { return Button_2.ButtonUpdateAction; } });
Object.defineProperty(exports, "clickButton", { enumerable: true, get: function () { return Button_2.clickButton; } });
Object.defineProperty(exports, "ClickPayload", { enumerable: true, get: function () { return Button_2.ClickPayload; } });
Object.defineProperty(exports, "Icon", { enumerable: true, get: function () { return Button_2.Icon; } });
Object.defineProperty(exports, "Presentation", { enumerable: true, get: function () { return Button_2.Presentation; } });
Object.defineProperty(exports, "Style", { enumerable: true, get: function () { return Button_2.Style; } });
Object.defineProperty(exports, "update", { enumerable: true, get: function () { return Button_2.update; } });
function isValidButtonProps(button) {
    return typeof button.id === 'string' && typeof button.label === 'string';
}
exports.isValidButtonProps = isValidButtonProps;
function create(app, options) {
    return new Button_1.Button(app, options);
}
exports.create = create;


/***/ }),
/* 59 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = void 0;
/**
 * Action Types for the Features group
 * @public
 */
var Action;
(function (Action) {
    Action["UPDATE"] = "APP::FEATURES::UPDATE";
    Action["REQUEST"] = "APP::FEATURES::REQUEST";
    /**
     * @deprecated as of 2.1.0. Use "APP::FEATURES::UPDATE" instead
     */
    Action["REQUEST_UPDATE"] = "APP::FEATURES::REQUEST::UPDATE";
})(Action = exports.Action || (exports.Action = {}));


/***/ }),
/* 60 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.Modal = exports.isMessageModal = exports.data = exports.update = exports.clickFooterButton = exports.updateModalSize = exports.closeModal = exports.openModal = exports.ModalAction = exports.UpdateSizeAction = exports.CloseAction = exports.UpdateAction = exports.OpenAction = exports.ActionBase = exports.ModalDataPayload = exports.Footer = exports.FooterOptions = exports.ClosePayload = exports.UpdateSizePayload = exports.BasePayload = exports.Size = exports.Action = exports.isIframeModal = exports.IframePayload = exports.MessagePayload = exports.ModalMessage = exports.ModalIframe = exports.IframeOptions = exports.MessageOptions = void 0;
var Modal_1 = __webpack_require__(19);
Object.defineProperty(exports, "MessageOptions", { enumerable: true, get: function () { return Modal_1.MessageOptions; } });
Object.defineProperty(exports, "IframeOptions", { enumerable: true, get: function () { return Modal_1.IframeOptions; } });
Object.defineProperty(exports, "ModalIframe", { enumerable: true, get: function () { return Modal_1.ModalIframe; } });
Object.defineProperty(exports, "ModalMessage", { enumerable: true, get: function () { return Modal_1.ModalMessage; } });
Object.defineProperty(exports, "MessagePayload", { enumerable: true, get: function () { return Modal_1.MessagePayload; } });
Object.defineProperty(exports, "IframePayload", { enumerable: true, get: function () { return Modal_1.IframePayload; } });
Object.defineProperty(exports, "isIframeModal", { enumerable: true, get: function () { return Modal_1.isIframeModal; } });
var Modal_2 = __webpack_require__(19);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Modal_2.Action; } });
Object.defineProperty(exports, "Size", { enumerable: true, get: function () { return Modal_2.Size; } });
Object.defineProperty(exports, "BasePayload", { enumerable: true, get: function () { return Modal_2.BasePayload; } });
Object.defineProperty(exports, "UpdateSizePayload", { enumerable: true, get: function () { return Modal_2.UpdateSizePayload; } });
Object.defineProperty(exports, "ClosePayload", { enumerable: true, get: function () { return Modal_2.ClosePayload; } });
Object.defineProperty(exports, "FooterOptions", { enumerable: true, get: function () { return Modal_2.FooterOptions; } });
Object.defineProperty(exports, "Footer", { enumerable: true, get: function () { return Modal_2.Footer; } });
Object.defineProperty(exports, "ModalDataPayload", { enumerable: true, get: function () { return Modal_2.ModalDataPayload; } });
Object.defineProperty(exports, "ActionBase", { enumerable: true, get: function () { return Modal_2.ActionBase; } });
Object.defineProperty(exports, "OpenAction", { enumerable: true, get: function () { return Modal_2.OpenAction; } });
Object.defineProperty(exports, "UpdateAction", { enumerable: true, get: function () { return Modal_2.UpdateAction; } });
Object.defineProperty(exports, "CloseAction", { enumerable: true, get: function () { return Modal_2.CloseAction; } });
Object.defineProperty(exports, "UpdateSizeAction", { enumerable: true, get: function () { return Modal_2.UpdateSizeAction; } });
Object.defineProperty(exports, "ModalAction", { enumerable: true, get: function () { return Modal_2.ModalAction; } });
Object.defineProperty(exports, "openModal", { enumerable: true, get: function () { return Modal_2.openModal; } });
Object.defineProperty(exports, "closeModal", { enumerable: true, get: function () { return Modal_2.closeModal; } });
Object.defineProperty(exports, "updateModalSize", { enumerable: true, get: function () { return Modal_2.updateModalSize; } });
Object.defineProperty(exports, "clickFooterButton", { enumerable: true, get: function () { return Modal_2.clickFooterButton; } });
Object.defineProperty(exports, "update", { enumerable: true, get: function () { return Modal_2.update; } });
Object.defineProperty(exports, "data", { enumerable: true, get: function () { return Modal_2.data; } });
Object.defineProperty(exports, "isMessageModal", { enumerable: true, get: function () { return Modal_2.isMessageModal; } });
Object.defineProperty(exports, "Modal", { enumerable: true, get: function () { return Modal_2.Modal; } });
var create = function (app, options) {
    if (Modal_1.isIframeModal(options)) {
        return new Modal_1.ModalIframe(app, options);
    }
    return new Modal_1.ModalMessage(app, options);
};
exports.create = create;


/***/ }),
/* 61 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ModalContent = exports.Action = void 0;
var helper_1 = __webpack_require__(0);
var ActionSet_1 = __webpack_require__(2);
var types_1 = __webpack_require__(1);
var index_1 = __webpack_require__(19);
var Action;
(function (Action) {
    Action["LOADING"] = "LOADING";
    Action["LOADED"] = "LOADED";
})(Action = exports.Action || (exports.Action = {}));
/**
 * A set of Actions for updating the modal component
 * @public
 */
var ModalContent = /** @class */ (function (_super) {
    __extends(ModalContent, _super);
    function ModalContent(app, options) {
        return _super.call(this, app, types_1.Group.Modal, types_1.Group.Modal, options ? options.id : undefined) || this;
    }
    ModalContent.prototype.loaded = function () {
        this.dispatch(Action.LOADED);
    };
    ModalContent.prototype.loading = function () {
        this.dispatch(Action.LOADING);
    };
    /**
     * @private
     */
    ModalContent.prototype.dispatch = function (action) {
        switch (action) {
            case Action.LOADED:
                this.dispatchModalAction(index_1.Action.UPDATE_CONTENT, { loading: false });
                break;
            case Action.LOADING:
                this.dispatchModalAction(index_1.Action.UPDATE_CONTENT, { loading: true });
                break;
        }
        return this;
    };
    /**
     * @internal
     */
    ModalContent.prototype.dispatchModalAction = function (type, payload) {
        return __awaiter(this, void 0, void 0, function () {
            var updateAction;
            return __generator(this, function (_a) {
                updateAction = helper_1.actionWrapper({
                    type: type,
                    group: types_1.Group.Modal,
                    payload: __assign({}, payload),
                });
                this.app.dispatch(updateAction);
                return [2 /*return*/];
            });
        });
    };
    return ModalContent;
}(ActionSet_1.ActionSet));
exports.ModalContent = ModalContent;


/***/ }),
/* 62 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.respond = exports.request = exports.Action = void 0;
var helper_1 = __webpack_require__(0);
var types_1 = __webpack_require__(1);
var Action;
(function (Action) {
    Action["REQUEST"] = "APP::SESSION_TOKEN::REQUEST";
    Action["RESPOND"] = "APP::SESSION_TOKEN::RESPOND";
})(Action = exports.Action || (exports.Action = {}));
function request() {
    return helper_1.actionWrapper({
        group: types_1.Group.SessionToken,
        type: Action.REQUEST,
    });
}
exports.request = request;
function respond(sessionToken) {
    return helper_1.actionWrapper({
        payload: sessionToken,
        group: types_1.Group.SessionToken,
        type: Action.RESPOND,
    });
}
exports.respond = respond;


/***/ }),
/* 63 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.close = exports.show = exports.Share = exports.Action = void 0;
var types_1 = __webpack_require__(1);
var helper_1 = __webpack_require__(0);
var ActionSet_1 = __webpack_require__(2);
/**
 * Types
 */
/**
 * @public
 */
var Action;
(function (Action) {
    Action["SHOW"] = "APP::SHARE::SHOW";
    Action["CLOSE"] = "APP::SHARE::CLOSE";
})(Action = exports.Action || (exports.Action = {}));
/**
 * Action
 */
/**
 * A set of actions for displaying a Share Sheet component
 * @public
 */
var Share = /** @class */ (function (_super) {
    __extends(Share, _super);
    function Share(app) {
        return _super.call(this, app, types_1.Group.Share, types_1.Group.Share) || this;
    }
    Share.prototype.dispatch = function (action, payload) {
        switch (action) {
            case Action.SHOW:
                this.dispatchShareAction(Action.SHOW, payload);
                break;
            case Action.CLOSE:
                this.dispatchShareAction(Action.CLOSE, payload);
                break;
            default:
                throw new Error("Action: " + action + " not supported");
        }
        return this;
    };
    /**
     * @internal
     */
    Share.prototype.dispatchShareAction = function (actionType, payload) {
        this.app.dispatch(helper_1.actionWrapper({
            type: actionType,
            group: types_1.Group.Share,
            payload: __assign({ id: this.id }, payload),
        }));
    };
    return Share;
}(ActionSet_1.ActionSet));
exports.Share = Share;
function show() {
    return helper_1.actionWrapper({
        group: types_1.Group.Share,
        type: Action.SHOW,
    });
}
exports.show = show;
function close(payload) {
    return helper_1.actionWrapper({
        group: types_1.Group.Share,
        type: Action.CLOSE,
        payload: payload,
    });
}
exports.close = close;


/***/ }),
/* 64 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pos = exports.close = exports.Action = void 0;
var helper_1 = __webpack_require__(0);
var ActionSet_1 = __webpack_require__(2);
var types_1 = __webpack_require__(1);
/**
 * Pos action type enum
 * @remarks includes the action prefix and group
 *
 */
var Action;
(function (Action) {
    Action["CLOSE"] = "APP::POS::CLOSE";
    Action["LOCATION_UPDATE"] = "APP::POS::LOCATION::UPDATE";
    Action["USER_UPDATE"] = "APP::POS::USER::UPDATE";
    Action["DEVICE_UPDATE"] = "APP::POS::DEVICE::UPDATE";
})(Action = exports.Action || (exports.Action = {}));
function close() {
    return helper_1.actionWrapper({
        group: types_1.Group.Pos,
        type: Action.CLOSE,
    });
}
exports.close = close;
var Pos = /** @class */ (function (_super) {
    __extends(Pos, _super);
    function Pos(app) {
        return _super.call(this, app, types_1.Group.Pos, types_1.Group.Pos) || this;
    }
    Pos.prototype.dispatch = function (action) {
        switch (action) {
            case Action.CLOSE:
                this.app.dispatch(close());
                break;
        }
        return this;
    };
    return Pos;
}(ActionSet_1.ActionSet));
exports.Pos = Pos;


/***/ }),
/* 65 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global) {/*!
 * The buffer module from node.js, for the browser.
 *
 * @author   Feross Aboukhadijeh <http://feross.org>
 * @license  MIT
 */
/* eslint-disable no-proto */



var base64 = __webpack_require__(140)
var ieee754 = __webpack_require__(141)
var isArray = __webpack_require__(142)

exports.Buffer = Buffer
exports.SlowBuffer = SlowBuffer
exports.INSPECT_MAX_BYTES = 50

/**
 * If `Buffer.TYPED_ARRAY_SUPPORT`:
 *   === true    Use Uint8Array implementation (fastest)
 *   === false   Use Object implementation (most compatible, even IE6)
 *
 * Browsers that support typed arrays are IE 10+, Firefox 4+, Chrome 7+, Safari 5.1+,
 * Opera 11.6+, iOS 4.2+.
 *
 * Due to various browser bugs, sometimes the Object implementation will be used even
 * when the browser supports typed arrays.
 *
 * Note:
 *
 *   - Firefox 4-29 lacks support for adding new properties to `Uint8Array` instances,
 *     See: https://bugzilla.mozilla.org/show_bug.cgi?id=695438.
 *
 *   - Chrome 9-10 is missing the `TypedArray.prototype.subarray` function.
 *
 *   - IE10 has a broken `TypedArray.prototype.subarray` function which returns arrays of
 *     incorrect length in some situations.

 * We detect these buggy browsers and set `Buffer.TYPED_ARRAY_SUPPORT` to `false` so they
 * get the Object implementation, which is slower but behaves correctly.
 */
Buffer.TYPED_ARRAY_SUPPORT = global.TYPED_ARRAY_SUPPORT !== undefined
  ? global.TYPED_ARRAY_SUPPORT
  : typedArraySupport()

/*
 * Export kMaxLength after typed array support is determined.
 */
exports.kMaxLength = kMaxLength()

function typedArraySupport () {
  try {
    var arr = new Uint8Array(1)
    arr.__proto__ = {__proto__: Uint8Array.prototype, foo: function () { return 42 }}
    return arr.foo() === 42 && // typed array instances can be augmented
        typeof arr.subarray === 'function' && // chrome 9-10 lack `subarray`
        arr.subarray(1, 1).byteLength === 0 // ie10 has broken `subarray`
  } catch (e) {
    return false
  }
}

function kMaxLength () {
  return Buffer.TYPED_ARRAY_SUPPORT
    ? 0x7fffffff
    : 0x3fffffff
}

function createBuffer (that, length) {
  if (kMaxLength() < length) {
    throw new RangeError('Invalid typed array length')
  }
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    // Return an augmented `Uint8Array` instance, for best performance
    that = new Uint8Array(length)
    that.__proto__ = Buffer.prototype
  } else {
    // Fallback: Return an object instance of the Buffer class
    if (that === null) {
      that = new Buffer(length)
    }
    that.length = length
  }

  return that
}

/**
 * The Buffer constructor returns instances of `Uint8Array` that have their
 * prototype changed to `Buffer.prototype`. Furthermore, `Buffer` is a subclass of
 * `Uint8Array`, so the returned instances will have all the node `Buffer` methods
 * and the `Uint8Array` methods. Square bracket notation works as expected -- it
 * returns a single octet.
 *
 * The `Uint8Array` prototype remains unmodified.
 */

function Buffer (arg, encodingOrOffset, length) {
  if (!Buffer.TYPED_ARRAY_SUPPORT && !(this instanceof Buffer)) {
    return new Buffer(arg, encodingOrOffset, length)
  }

  // Common case.
  if (typeof arg === 'number') {
    if (typeof encodingOrOffset === 'string') {
      throw new Error(
        'If encoding is specified then the first argument must be a string'
      )
    }
    return allocUnsafe(this, arg)
  }
  return from(this, arg, encodingOrOffset, length)
}

Buffer.poolSize = 8192 // not used by this implementation

// TODO: Legacy, not needed anymore. Remove in next major version.
Buffer._augment = function (arr) {
  arr.__proto__ = Buffer.prototype
  return arr
}

function from (that, value, encodingOrOffset, length) {
  if (typeof value === 'number') {
    throw new TypeError('"value" argument must not be a number')
  }

  if (typeof ArrayBuffer !== 'undefined' && value instanceof ArrayBuffer) {
    return fromArrayBuffer(that, value, encodingOrOffset, length)
  }

  if (typeof value === 'string') {
    return fromString(that, value, encodingOrOffset)
  }

  return fromObject(that, value)
}

/**
 * Functionally equivalent to Buffer(arg, encoding) but throws a TypeError
 * if value is a number.
 * Buffer.from(str[, encoding])
 * Buffer.from(array)
 * Buffer.from(buffer)
 * Buffer.from(arrayBuffer[, byteOffset[, length]])
 **/
Buffer.from = function (value, encodingOrOffset, length) {
  return from(null, value, encodingOrOffset, length)
}

if (Buffer.TYPED_ARRAY_SUPPORT) {
  Buffer.prototype.__proto__ = Uint8Array.prototype
  Buffer.__proto__ = Uint8Array
  if (typeof Symbol !== 'undefined' && Symbol.species &&
      Buffer[Symbol.species] === Buffer) {
    // Fix subarray() in ES2016. See: https://github.com/feross/buffer/pull/97
    Object.defineProperty(Buffer, Symbol.species, {
      value: null,
      configurable: true
    })
  }
}

function assertSize (size) {
  if (typeof size !== 'number') {
    throw new TypeError('"size" argument must be a number')
  } else if (size < 0) {
    throw new RangeError('"size" argument must not be negative')
  }
}

function alloc (that, size, fill, encoding) {
  assertSize(size)
  if (size <= 0) {
    return createBuffer(that, size)
  }
  if (fill !== undefined) {
    // Only pay attention to encoding if it's a string. This
    // prevents accidentally sending in a number that would
    // be interpretted as a start offset.
    return typeof encoding === 'string'
      ? createBuffer(that, size).fill(fill, encoding)
      : createBuffer(that, size).fill(fill)
  }
  return createBuffer(that, size)
}

/**
 * Creates a new filled Buffer instance.
 * alloc(size[, fill[, encoding]])
 **/
Buffer.alloc = function (size, fill, encoding) {
  return alloc(null, size, fill, encoding)
}

function allocUnsafe (that, size) {
  assertSize(size)
  that = createBuffer(that, size < 0 ? 0 : checked(size) | 0)
  if (!Buffer.TYPED_ARRAY_SUPPORT) {
    for (var i = 0; i < size; ++i) {
      that[i] = 0
    }
  }
  return that
}

/**
 * Equivalent to Buffer(num), by default creates a non-zero-filled Buffer instance.
 * */
Buffer.allocUnsafe = function (size) {
  return allocUnsafe(null, size)
}
/**
 * Equivalent to SlowBuffer(num), by default creates a non-zero-filled Buffer instance.
 */
Buffer.allocUnsafeSlow = function (size) {
  return allocUnsafe(null, size)
}

function fromString (that, string, encoding) {
  if (typeof encoding !== 'string' || encoding === '') {
    encoding = 'utf8'
  }

  if (!Buffer.isEncoding(encoding)) {
    throw new TypeError('"encoding" must be a valid string encoding')
  }

  var length = byteLength(string, encoding) | 0
  that = createBuffer(that, length)

  var actual = that.write(string, encoding)

  if (actual !== length) {
    // Writing a hex string, for example, that contains invalid characters will
    // cause everything after the first invalid character to be ignored. (e.g.
    // 'abxxcd' will be treated as 'ab')
    that = that.slice(0, actual)
  }

  return that
}

function fromArrayLike (that, array) {
  var length = array.length < 0 ? 0 : checked(array.length) | 0
  that = createBuffer(that, length)
  for (var i = 0; i < length; i += 1) {
    that[i] = array[i] & 255
  }
  return that
}

function fromArrayBuffer (that, array, byteOffset, length) {
  array.byteLength // this throws if `array` is not a valid ArrayBuffer

  if (byteOffset < 0 || array.byteLength < byteOffset) {
    throw new RangeError('\'offset\' is out of bounds')
  }

  if (array.byteLength < byteOffset + (length || 0)) {
    throw new RangeError('\'length\' is out of bounds')
  }

  if (byteOffset === undefined && length === undefined) {
    array = new Uint8Array(array)
  } else if (length === undefined) {
    array = new Uint8Array(array, byteOffset)
  } else {
    array = new Uint8Array(array, byteOffset, length)
  }

  if (Buffer.TYPED_ARRAY_SUPPORT) {
    // Return an augmented `Uint8Array` instance, for best performance
    that = array
    that.__proto__ = Buffer.prototype
  } else {
    // Fallback: Return an object instance of the Buffer class
    that = fromArrayLike(that, array)
  }
  return that
}

function fromObject (that, obj) {
  if (Buffer.isBuffer(obj)) {
    var len = checked(obj.length) | 0
    that = createBuffer(that, len)

    if (that.length === 0) {
      return that
    }

    obj.copy(that, 0, 0, len)
    return that
  }

  if (obj) {
    if ((typeof ArrayBuffer !== 'undefined' &&
        obj.buffer instanceof ArrayBuffer) || 'length' in obj) {
      if (typeof obj.length !== 'number' || isnan(obj.length)) {
        return createBuffer(that, 0)
      }
      return fromArrayLike(that, obj)
    }

    if (obj.type === 'Buffer' && isArray(obj.data)) {
      return fromArrayLike(that, obj.data)
    }
  }

  throw new TypeError('First argument must be a string, Buffer, ArrayBuffer, Array, or array-like object.')
}

function checked (length) {
  // Note: cannot use `length < kMaxLength()` here because that fails when
  // length is NaN (which is otherwise coerced to zero.)
  if (length >= kMaxLength()) {
    throw new RangeError('Attempt to allocate Buffer larger than maximum ' +
                         'size: 0x' + kMaxLength().toString(16) + ' bytes')
  }
  return length | 0
}

function SlowBuffer (length) {
  if (+length != length) { // eslint-disable-line eqeqeq
    length = 0
  }
  return Buffer.alloc(+length)
}

Buffer.isBuffer = function isBuffer (b) {
  return !!(b != null && b._isBuffer)
}

Buffer.compare = function compare (a, b) {
  if (!Buffer.isBuffer(a) || !Buffer.isBuffer(b)) {
    throw new TypeError('Arguments must be Buffers')
  }

  if (a === b) return 0

  var x = a.length
  var y = b.length

  for (var i = 0, len = Math.min(x, y); i < len; ++i) {
    if (a[i] !== b[i]) {
      x = a[i]
      y = b[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

Buffer.isEncoding = function isEncoding (encoding) {
  switch (String(encoding).toLowerCase()) {
    case 'hex':
    case 'utf8':
    case 'utf-8':
    case 'ascii':
    case 'latin1':
    case 'binary':
    case 'base64':
    case 'ucs2':
    case 'ucs-2':
    case 'utf16le':
    case 'utf-16le':
      return true
    default:
      return false
  }
}

Buffer.concat = function concat (list, length) {
  if (!isArray(list)) {
    throw new TypeError('"list" argument must be an Array of Buffers')
  }

  if (list.length === 0) {
    return Buffer.alloc(0)
  }

  var i
  if (length === undefined) {
    length = 0
    for (i = 0; i < list.length; ++i) {
      length += list[i].length
    }
  }

  var buffer = Buffer.allocUnsafe(length)
  var pos = 0
  for (i = 0; i < list.length; ++i) {
    var buf = list[i]
    if (!Buffer.isBuffer(buf)) {
      throw new TypeError('"list" argument must be an Array of Buffers')
    }
    buf.copy(buffer, pos)
    pos += buf.length
  }
  return buffer
}

function byteLength (string, encoding) {
  if (Buffer.isBuffer(string)) {
    return string.length
  }
  if (typeof ArrayBuffer !== 'undefined' && typeof ArrayBuffer.isView === 'function' &&
      (ArrayBuffer.isView(string) || string instanceof ArrayBuffer)) {
    return string.byteLength
  }
  if (typeof string !== 'string') {
    string = '' + string
  }

  var len = string.length
  if (len === 0) return 0

  // Use a for loop to avoid recursion
  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'ascii':
      case 'latin1':
      case 'binary':
        return len
      case 'utf8':
      case 'utf-8':
      case undefined:
        return utf8ToBytes(string).length
      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return len * 2
      case 'hex':
        return len >>> 1
      case 'base64':
        return base64ToBytes(string).length
      default:
        if (loweredCase) return utf8ToBytes(string).length // assume utf8
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}
Buffer.byteLength = byteLength

function slowToString (encoding, start, end) {
  var loweredCase = false

  // No need to verify that "this.length <= MAX_UINT32" since it's a read-only
  // property of a typed array.

  // This behaves neither like String nor Uint8Array in that we set start/end
  // to their upper/lower bounds if the value passed is out of range.
  // undefined is handled specially as per ECMA-262 6th Edition,
  // Section 13.3.3.7 Runtime Semantics: KeyedBindingInitialization.
  if (start === undefined || start < 0) {
    start = 0
  }
  // Return early if start > this.length. Done here to prevent potential uint32
  // coercion fail below.
  if (start > this.length) {
    return ''
  }

  if (end === undefined || end > this.length) {
    end = this.length
  }

  if (end <= 0) {
    return ''
  }

  // Force coersion to uint32. This will also coerce falsey/NaN values to 0.
  end >>>= 0
  start >>>= 0

  if (end <= start) {
    return ''
  }

  if (!encoding) encoding = 'utf8'

  while (true) {
    switch (encoding) {
      case 'hex':
        return hexSlice(this, start, end)

      case 'utf8':
      case 'utf-8':
        return utf8Slice(this, start, end)

      case 'ascii':
        return asciiSlice(this, start, end)

      case 'latin1':
      case 'binary':
        return latin1Slice(this, start, end)

      case 'base64':
        return base64Slice(this, start, end)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return utf16leSlice(this, start, end)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = (encoding + '').toLowerCase()
        loweredCase = true
    }
  }
}

// The property is used by `Buffer.isBuffer` and `is-buffer` (in Safari 5-7) to detect
// Buffer instances.
Buffer.prototype._isBuffer = true

function swap (b, n, m) {
  var i = b[n]
  b[n] = b[m]
  b[m] = i
}

Buffer.prototype.swap16 = function swap16 () {
  var len = this.length
  if (len % 2 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 16-bits')
  }
  for (var i = 0; i < len; i += 2) {
    swap(this, i, i + 1)
  }
  return this
}

Buffer.prototype.swap32 = function swap32 () {
  var len = this.length
  if (len % 4 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 32-bits')
  }
  for (var i = 0; i < len; i += 4) {
    swap(this, i, i + 3)
    swap(this, i + 1, i + 2)
  }
  return this
}

Buffer.prototype.swap64 = function swap64 () {
  var len = this.length
  if (len % 8 !== 0) {
    throw new RangeError('Buffer size must be a multiple of 64-bits')
  }
  for (var i = 0; i < len; i += 8) {
    swap(this, i, i + 7)
    swap(this, i + 1, i + 6)
    swap(this, i + 2, i + 5)
    swap(this, i + 3, i + 4)
  }
  return this
}

Buffer.prototype.toString = function toString () {
  var length = this.length | 0
  if (length === 0) return ''
  if (arguments.length === 0) return utf8Slice(this, 0, length)
  return slowToString.apply(this, arguments)
}

Buffer.prototype.equals = function equals (b) {
  if (!Buffer.isBuffer(b)) throw new TypeError('Argument must be a Buffer')
  if (this === b) return true
  return Buffer.compare(this, b) === 0
}

Buffer.prototype.inspect = function inspect () {
  var str = ''
  var max = exports.INSPECT_MAX_BYTES
  if (this.length > 0) {
    str = this.toString('hex', 0, max).match(/.{2}/g).join(' ')
    if (this.length > max) str += ' ... '
  }
  return '<Buffer ' + str + '>'
}

Buffer.prototype.compare = function compare (target, start, end, thisStart, thisEnd) {
  if (!Buffer.isBuffer(target)) {
    throw new TypeError('Argument must be a Buffer')
  }

  if (start === undefined) {
    start = 0
  }
  if (end === undefined) {
    end = target ? target.length : 0
  }
  if (thisStart === undefined) {
    thisStart = 0
  }
  if (thisEnd === undefined) {
    thisEnd = this.length
  }

  if (start < 0 || end > target.length || thisStart < 0 || thisEnd > this.length) {
    throw new RangeError('out of range index')
  }

  if (thisStart >= thisEnd && start >= end) {
    return 0
  }
  if (thisStart >= thisEnd) {
    return -1
  }
  if (start >= end) {
    return 1
  }

  start >>>= 0
  end >>>= 0
  thisStart >>>= 0
  thisEnd >>>= 0

  if (this === target) return 0

  var x = thisEnd - thisStart
  var y = end - start
  var len = Math.min(x, y)

  var thisCopy = this.slice(thisStart, thisEnd)
  var targetCopy = target.slice(start, end)

  for (var i = 0; i < len; ++i) {
    if (thisCopy[i] !== targetCopy[i]) {
      x = thisCopy[i]
      y = targetCopy[i]
      break
    }
  }

  if (x < y) return -1
  if (y < x) return 1
  return 0
}

// Finds either the first index of `val` in `buffer` at offset >= `byteOffset`,
// OR the last index of `val` in `buffer` at offset <= `byteOffset`.
//
// Arguments:
// - buffer - a Buffer to search
// - val - a string, Buffer, or number
// - byteOffset - an index into `buffer`; will be clamped to an int32
// - encoding - an optional encoding, relevant is val is a string
// - dir - true for indexOf, false for lastIndexOf
function bidirectionalIndexOf (buffer, val, byteOffset, encoding, dir) {
  // Empty buffer means no match
  if (buffer.length === 0) return -1

  // Normalize byteOffset
  if (typeof byteOffset === 'string') {
    encoding = byteOffset
    byteOffset = 0
  } else if (byteOffset > 0x7fffffff) {
    byteOffset = 0x7fffffff
  } else if (byteOffset < -0x80000000) {
    byteOffset = -0x80000000
  }
  byteOffset = +byteOffset  // Coerce to Number.
  if (isNaN(byteOffset)) {
    // byteOffset: it it's undefined, null, NaN, "foo", etc, search whole buffer
    byteOffset = dir ? 0 : (buffer.length - 1)
  }

  // Normalize byteOffset: negative offsets start from the end of the buffer
  if (byteOffset < 0) byteOffset = buffer.length + byteOffset
  if (byteOffset >= buffer.length) {
    if (dir) return -1
    else byteOffset = buffer.length - 1
  } else if (byteOffset < 0) {
    if (dir) byteOffset = 0
    else return -1
  }

  // Normalize val
  if (typeof val === 'string') {
    val = Buffer.from(val, encoding)
  }

  // Finally, search either indexOf (if dir is true) or lastIndexOf
  if (Buffer.isBuffer(val)) {
    // Special case: looking for empty string/buffer always fails
    if (val.length === 0) {
      return -1
    }
    return arrayIndexOf(buffer, val, byteOffset, encoding, dir)
  } else if (typeof val === 'number') {
    val = val & 0xFF // Search for a byte value [0-255]
    if (Buffer.TYPED_ARRAY_SUPPORT &&
        typeof Uint8Array.prototype.indexOf === 'function') {
      if (dir) {
        return Uint8Array.prototype.indexOf.call(buffer, val, byteOffset)
      } else {
        return Uint8Array.prototype.lastIndexOf.call(buffer, val, byteOffset)
      }
    }
    return arrayIndexOf(buffer, [ val ], byteOffset, encoding, dir)
  }

  throw new TypeError('val must be string, number or Buffer')
}

function arrayIndexOf (arr, val, byteOffset, encoding, dir) {
  var indexSize = 1
  var arrLength = arr.length
  var valLength = val.length

  if (encoding !== undefined) {
    encoding = String(encoding).toLowerCase()
    if (encoding === 'ucs2' || encoding === 'ucs-2' ||
        encoding === 'utf16le' || encoding === 'utf-16le') {
      if (arr.length < 2 || val.length < 2) {
        return -1
      }
      indexSize = 2
      arrLength /= 2
      valLength /= 2
      byteOffset /= 2
    }
  }

  function read (buf, i) {
    if (indexSize === 1) {
      return buf[i]
    } else {
      return buf.readUInt16BE(i * indexSize)
    }
  }

  var i
  if (dir) {
    var foundIndex = -1
    for (i = byteOffset; i < arrLength; i++) {
      if (read(arr, i) === read(val, foundIndex === -1 ? 0 : i - foundIndex)) {
        if (foundIndex === -1) foundIndex = i
        if (i - foundIndex + 1 === valLength) return foundIndex * indexSize
      } else {
        if (foundIndex !== -1) i -= i - foundIndex
        foundIndex = -1
      }
    }
  } else {
    if (byteOffset + valLength > arrLength) byteOffset = arrLength - valLength
    for (i = byteOffset; i >= 0; i--) {
      var found = true
      for (var j = 0; j < valLength; j++) {
        if (read(arr, i + j) !== read(val, j)) {
          found = false
          break
        }
      }
      if (found) return i
    }
  }

  return -1
}

Buffer.prototype.includes = function includes (val, byteOffset, encoding) {
  return this.indexOf(val, byteOffset, encoding) !== -1
}

Buffer.prototype.indexOf = function indexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, true)
}

Buffer.prototype.lastIndexOf = function lastIndexOf (val, byteOffset, encoding) {
  return bidirectionalIndexOf(this, val, byteOffset, encoding, false)
}

function hexWrite (buf, string, offset, length) {
  offset = Number(offset) || 0
  var remaining = buf.length - offset
  if (!length) {
    length = remaining
  } else {
    length = Number(length)
    if (length > remaining) {
      length = remaining
    }
  }

  // must be an even number of digits
  var strLen = string.length
  if (strLen % 2 !== 0) throw new TypeError('Invalid hex string')

  if (length > strLen / 2) {
    length = strLen / 2
  }
  for (var i = 0; i < length; ++i) {
    var parsed = parseInt(string.substr(i * 2, 2), 16)
    if (isNaN(parsed)) return i
    buf[offset + i] = parsed
  }
  return i
}

function utf8Write (buf, string, offset, length) {
  return blitBuffer(utf8ToBytes(string, buf.length - offset), buf, offset, length)
}

function asciiWrite (buf, string, offset, length) {
  return blitBuffer(asciiToBytes(string), buf, offset, length)
}

function latin1Write (buf, string, offset, length) {
  return asciiWrite(buf, string, offset, length)
}

function base64Write (buf, string, offset, length) {
  return blitBuffer(base64ToBytes(string), buf, offset, length)
}

function ucs2Write (buf, string, offset, length) {
  return blitBuffer(utf16leToBytes(string, buf.length - offset), buf, offset, length)
}

Buffer.prototype.write = function write (string, offset, length, encoding) {
  // Buffer#write(string)
  if (offset === undefined) {
    encoding = 'utf8'
    length = this.length
    offset = 0
  // Buffer#write(string, encoding)
  } else if (length === undefined && typeof offset === 'string') {
    encoding = offset
    length = this.length
    offset = 0
  // Buffer#write(string, offset[, length][, encoding])
  } else if (isFinite(offset)) {
    offset = offset | 0
    if (isFinite(length)) {
      length = length | 0
      if (encoding === undefined) encoding = 'utf8'
    } else {
      encoding = length
      length = undefined
    }
  // legacy write(string, encoding, offset, length) - remove in v0.13
  } else {
    throw new Error(
      'Buffer.write(string, encoding, offset[, length]) is no longer supported'
    )
  }

  var remaining = this.length - offset
  if (length === undefined || length > remaining) length = remaining

  if ((string.length > 0 && (length < 0 || offset < 0)) || offset > this.length) {
    throw new RangeError('Attempt to write outside buffer bounds')
  }

  if (!encoding) encoding = 'utf8'

  var loweredCase = false
  for (;;) {
    switch (encoding) {
      case 'hex':
        return hexWrite(this, string, offset, length)

      case 'utf8':
      case 'utf-8':
        return utf8Write(this, string, offset, length)

      case 'ascii':
        return asciiWrite(this, string, offset, length)

      case 'latin1':
      case 'binary':
        return latin1Write(this, string, offset, length)

      case 'base64':
        // Warning: maxLength not taken into account in base64Write
        return base64Write(this, string, offset, length)

      case 'ucs2':
      case 'ucs-2':
      case 'utf16le':
      case 'utf-16le':
        return ucs2Write(this, string, offset, length)

      default:
        if (loweredCase) throw new TypeError('Unknown encoding: ' + encoding)
        encoding = ('' + encoding).toLowerCase()
        loweredCase = true
    }
  }
}

Buffer.prototype.toJSON = function toJSON () {
  return {
    type: 'Buffer',
    data: Array.prototype.slice.call(this._arr || this, 0)
  }
}

function base64Slice (buf, start, end) {
  if (start === 0 && end === buf.length) {
    return base64.fromByteArray(buf)
  } else {
    return base64.fromByteArray(buf.slice(start, end))
  }
}

function utf8Slice (buf, start, end) {
  end = Math.min(buf.length, end)
  var res = []

  var i = start
  while (i < end) {
    var firstByte = buf[i]
    var codePoint = null
    var bytesPerSequence = (firstByte > 0xEF) ? 4
      : (firstByte > 0xDF) ? 3
      : (firstByte > 0xBF) ? 2
      : 1

    if (i + bytesPerSequence <= end) {
      var secondByte, thirdByte, fourthByte, tempCodePoint

      switch (bytesPerSequence) {
        case 1:
          if (firstByte < 0x80) {
            codePoint = firstByte
          }
          break
        case 2:
          secondByte = buf[i + 1]
          if ((secondByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0x1F) << 0x6 | (secondByte & 0x3F)
            if (tempCodePoint > 0x7F) {
              codePoint = tempCodePoint
            }
          }
          break
        case 3:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0xC | (secondByte & 0x3F) << 0x6 | (thirdByte & 0x3F)
            if (tempCodePoint > 0x7FF && (tempCodePoint < 0xD800 || tempCodePoint > 0xDFFF)) {
              codePoint = tempCodePoint
            }
          }
          break
        case 4:
          secondByte = buf[i + 1]
          thirdByte = buf[i + 2]
          fourthByte = buf[i + 3]
          if ((secondByte & 0xC0) === 0x80 && (thirdByte & 0xC0) === 0x80 && (fourthByte & 0xC0) === 0x80) {
            tempCodePoint = (firstByte & 0xF) << 0x12 | (secondByte & 0x3F) << 0xC | (thirdByte & 0x3F) << 0x6 | (fourthByte & 0x3F)
            if (tempCodePoint > 0xFFFF && tempCodePoint < 0x110000) {
              codePoint = tempCodePoint
            }
          }
      }
    }

    if (codePoint === null) {
      // we did not generate a valid codePoint so insert a
      // replacement char (U+FFFD) and advance only 1 byte
      codePoint = 0xFFFD
      bytesPerSequence = 1
    } else if (codePoint > 0xFFFF) {
      // encode to utf16 (surrogate pair dance)
      codePoint -= 0x10000
      res.push(codePoint >>> 10 & 0x3FF | 0xD800)
      codePoint = 0xDC00 | codePoint & 0x3FF
    }

    res.push(codePoint)
    i += bytesPerSequence
  }

  return decodeCodePointsArray(res)
}

// Based on http://stackoverflow.com/a/22747272/680742, the browser with
// the lowest limit is Chrome, with 0x10000 args.
// We go 1 magnitude less, for safety
var MAX_ARGUMENTS_LENGTH = 0x1000

function decodeCodePointsArray (codePoints) {
  var len = codePoints.length
  if (len <= MAX_ARGUMENTS_LENGTH) {
    return String.fromCharCode.apply(String, codePoints) // avoid extra slice()
  }

  // Decode in chunks to avoid "call stack size exceeded".
  var res = ''
  var i = 0
  while (i < len) {
    res += String.fromCharCode.apply(
      String,
      codePoints.slice(i, i += MAX_ARGUMENTS_LENGTH)
    )
  }
  return res
}

function asciiSlice (buf, start, end) {
  var ret = ''
  end = Math.min(buf.length, end)

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i] & 0x7F)
  }
  return ret
}

function latin1Slice (buf, start, end) {
  var ret = ''
  end = Math.min(buf.length, end)

  for (var i = start; i < end; ++i) {
    ret += String.fromCharCode(buf[i])
  }
  return ret
}

function hexSlice (buf, start, end) {
  var len = buf.length

  if (!start || start < 0) start = 0
  if (!end || end < 0 || end > len) end = len

  var out = ''
  for (var i = start; i < end; ++i) {
    out += toHex(buf[i])
  }
  return out
}

function utf16leSlice (buf, start, end) {
  var bytes = buf.slice(start, end)
  var res = ''
  for (var i = 0; i < bytes.length; i += 2) {
    res += String.fromCharCode(bytes[i] + bytes[i + 1] * 256)
  }
  return res
}

Buffer.prototype.slice = function slice (start, end) {
  var len = this.length
  start = ~~start
  end = end === undefined ? len : ~~end

  if (start < 0) {
    start += len
    if (start < 0) start = 0
  } else if (start > len) {
    start = len
  }

  if (end < 0) {
    end += len
    if (end < 0) end = 0
  } else if (end > len) {
    end = len
  }

  if (end < start) end = start

  var newBuf
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    newBuf = this.subarray(start, end)
    newBuf.__proto__ = Buffer.prototype
  } else {
    var sliceLen = end - start
    newBuf = new Buffer(sliceLen, undefined)
    for (var i = 0; i < sliceLen; ++i) {
      newBuf[i] = this[i + start]
    }
  }

  return newBuf
}

/*
 * Need to make sure that buffer isn't trying to write out of bounds.
 */
function checkOffset (offset, ext, length) {
  if ((offset % 1) !== 0 || offset < 0) throw new RangeError('offset is not uint')
  if (offset + ext > length) throw new RangeError('Trying to access beyond buffer length')
}

Buffer.prototype.readUIntLE = function readUIntLE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var val = this[offset]
  var mul = 1
  var i = 0
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul
  }

  return val
}

Buffer.prototype.readUIntBE = function readUIntBE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) {
    checkOffset(offset, byteLength, this.length)
  }

  var val = this[offset + --byteLength]
  var mul = 1
  while (byteLength > 0 && (mul *= 0x100)) {
    val += this[offset + --byteLength] * mul
  }

  return val
}

Buffer.prototype.readUInt8 = function readUInt8 (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 1, this.length)
  return this[offset]
}

Buffer.prototype.readUInt16LE = function readUInt16LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  return this[offset] | (this[offset + 1] << 8)
}

Buffer.prototype.readUInt16BE = function readUInt16BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  return (this[offset] << 8) | this[offset + 1]
}

Buffer.prototype.readUInt32LE = function readUInt32LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return ((this[offset]) |
      (this[offset + 1] << 8) |
      (this[offset + 2] << 16)) +
      (this[offset + 3] * 0x1000000)
}

Buffer.prototype.readUInt32BE = function readUInt32BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset] * 0x1000000) +
    ((this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    this[offset + 3])
}

Buffer.prototype.readIntLE = function readIntLE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var val = this[offset]
  var mul = 1
  var i = 0
  while (++i < byteLength && (mul *= 0x100)) {
    val += this[offset + i] * mul
  }
  mul *= 0x80

  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

  return val
}

Buffer.prototype.readIntBE = function readIntBE (offset, byteLength, noAssert) {
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) checkOffset(offset, byteLength, this.length)

  var i = byteLength
  var mul = 1
  var val = this[offset + --i]
  while (i > 0 && (mul *= 0x100)) {
    val += this[offset + --i] * mul
  }
  mul *= 0x80

  if (val >= mul) val -= Math.pow(2, 8 * byteLength)

  return val
}

Buffer.prototype.readInt8 = function readInt8 (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 1, this.length)
  if (!(this[offset] & 0x80)) return (this[offset])
  return ((0xff - this[offset] + 1) * -1)
}

Buffer.prototype.readInt16LE = function readInt16LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  var val = this[offset] | (this[offset + 1] << 8)
  return (val & 0x8000) ? val | 0xFFFF0000 : val
}

Buffer.prototype.readInt16BE = function readInt16BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 2, this.length)
  var val = this[offset + 1] | (this[offset] << 8)
  return (val & 0x8000) ? val | 0xFFFF0000 : val
}

Buffer.prototype.readInt32LE = function readInt32LE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset]) |
    (this[offset + 1] << 8) |
    (this[offset + 2] << 16) |
    (this[offset + 3] << 24)
}

Buffer.prototype.readInt32BE = function readInt32BE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)

  return (this[offset] << 24) |
    (this[offset + 1] << 16) |
    (this[offset + 2] << 8) |
    (this[offset + 3])
}

Buffer.prototype.readFloatLE = function readFloatLE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)
  return ieee754.read(this, offset, true, 23, 4)
}

Buffer.prototype.readFloatBE = function readFloatBE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 4, this.length)
  return ieee754.read(this, offset, false, 23, 4)
}

Buffer.prototype.readDoubleLE = function readDoubleLE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 8, this.length)
  return ieee754.read(this, offset, true, 52, 8)
}

Buffer.prototype.readDoubleBE = function readDoubleBE (offset, noAssert) {
  if (!noAssert) checkOffset(offset, 8, this.length)
  return ieee754.read(this, offset, false, 52, 8)
}

function checkInt (buf, value, offset, ext, max, min) {
  if (!Buffer.isBuffer(buf)) throw new TypeError('"buffer" argument must be a Buffer instance')
  if (value > max || value < min) throw new RangeError('"value" argument is out of bounds')
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
}

Buffer.prototype.writeUIntLE = function writeUIntLE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1
    checkInt(this, value, offset, byteLength, maxBytes, 0)
  }

  var mul = 1
  var i = 0
  this[offset] = value & 0xFF
  while (++i < byteLength && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeUIntBE = function writeUIntBE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  byteLength = byteLength | 0
  if (!noAssert) {
    var maxBytes = Math.pow(2, 8 * byteLength) - 1
    checkInt(this, value, offset, byteLength, maxBytes, 0)
  }

  var i = byteLength - 1
  var mul = 1
  this[offset + i] = value & 0xFF
  while (--i >= 0 && (mul *= 0x100)) {
    this[offset + i] = (value / mul) & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeUInt8 = function writeUInt8 (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 1, 0xff, 0)
  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
  this[offset] = (value & 0xff)
  return offset + 1
}

function objectWriteUInt16 (buf, value, offset, littleEndian) {
  if (value < 0) value = 0xffff + value + 1
  for (var i = 0, j = Math.min(buf.length - offset, 2); i < j; ++i) {
    buf[offset + i] = (value & (0xff << (8 * (littleEndian ? i : 1 - i)))) >>>
      (littleEndian ? i : 1 - i) * 8
  }
}

Buffer.prototype.writeUInt16LE = function writeUInt16LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff)
    this[offset + 1] = (value >>> 8)
  } else {
    objectWriteUInt16(this, value, offset, true)
  }
  return offset + 2
}

Buffer.prototype.writeUInt16BE = function writeUInt16BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0xffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 8)
    this[offset + 1] = (value & 0xff)
  } else {
    objectWriteUInt16(this, value, offset, false)
  }
  return offset + 2
}

function objectWriteUInt32 (buf, value, offset, littleEndian) {
  if (value < 0) value = 0xffffffff + value + 1
  for (var i = 0, j = Math.min(buf.length - offset, 4); i < j; ++i) {
    buf[offset + i] = (value >>> (littleEndian ? i : 3 - i) * 8) & 0xff
  }
}

Buffer.prototype.writeUInt32LE = function writeUInt32LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset + 3] = (value >>> 24)
    this[offset + 2] = (value >>> 16)
    this[offset + 1] = (value >>> 8)
    this[offset] = (value & 0xff)
  } else {
    objectWriteUInt32(this, value, offset, true)
  }
  return offset + 4
}

Buffer.prototype.writeUInt32BE = function writeUInt32BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0xffffffff, 0)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 24)
    this[offset + 1] = (value >>> 16)
    this[offset + 2] = (value >>> 8)
    this[offset + 3] = (value & 0xff)
  } else {
    objectWriteUInt32(this, value, offset, false)
  }
  return offset + 4
}

Buffer.prototype.writeIntLE = function writeIntLE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) {
    var limit = Math.pow(2, 8 * byteLength - 1)

    checkInt(this, value, offset, byteLength, limit - 1, -limit)
  }

  var i = 0
  var mul = 1
  var sub = 0
  this[offset] = value & 0xFF
  while (++i < byteLength && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i - 1] !== 0) {
      sub = 1
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeIntBE = function writeIntBE (value, offset, byteLength, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) {
    var limit = Math.pow(2, 8 * byteLength - 1)

    checkInt(this, value, offset, byteLength, limit - 1, -limit)
  }

  var i = byteLength - 1
  var mul = 1
  var sub = 0
  this[offset + i] = value & 0xFF
  while (--i >= 0 && (mul *= 0x100)) {
    if (value < 0 && sub === 0 && this[offset + i + 1] !== 0) {
      sub = 1
    }
    this[offset + i] = ((value / mul) >> 0) - sub & 0xFF
  }

  return offset + byteLength
}

Buffer.prototype.writeInt8 = function writeInt8 (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 1, 0x7f, -0x80)
  if (!Buffer.TYPED_ARRAY_SUPPORT) value = Math.floor(value)
  if (value < 0) value = 0xff + value + 1
  this[offset] = (value & 0xff)
  return offset + 1
}

Buffer.prototype.writeInt16LE = function writeInt16LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff)
    this[offset + 1] = (value >>> 8)
  } else {
    objectWriteUInt16(this, value, offset, true)
  }
  return offset + 2
}

Buffer.prototype.writeInt16BE = function writeInt16BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 2, 0x7fff, -0x8000)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 8)
    this[offset + 1] = (value & 0xff)
  } else {
    objectWriteUInt16(this, value, offset, false)
  }
  return offset + 2
}

Buffer.prototype.writeInt32LE = function writeInt32LE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value & 0xff)
    this[offset + 1] = (value >>> 8)
    this[offset + 2] = (value >>> 16)
    this[offset + 3] = (value >>> 24)
  } else {
    objectWriteUInt32(this, value, offset, true)
  }
  return offset + 4
}

Buffer.prototype.writeInt32BE = function writeInt32BE (value, offset, noAssert) {
  value = +value
  offset = offset | 0
  if (!noAssert) checkInt(this, value, offset, 4, 0x7fffffff, -0x80000000)
  if (value < 0) value = 0xffffffff + value + 1
  if (Buffer.TYPED_ARRAY_SUPPORT) {
    this[offset] = (value >>> 24)
    this[offset + 1] = (value >>> 16)
    this[offset + 2] = (value >>> 8)
    this[offset + 3] = (value & 0xff)
  } else {
    objectWriteUInt32(this, value, offset, false)
  }
  return offset + 4
}

function checkIEEE754 (buf, value, offset, ext, max, min) {
  if (offset + ext > buf.length) throw new RangeError('Index out of range')
  if (offset < 0) throw new RangeError('Index out of range')
}

function writeFloat (buf, value, offset, littleEndian, noAssert) {
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 4, 3.4028234663852886e+38, -3.4028234663852886e+38)
  }
  ieee754.write(buf, value, offset, littleEndian, 23, 4)
  return offset + 4
}

Buffer.prototype.writeFloatLE = function writeFloatLE (value, offset, noAssert) {
  return writeFloat(this, value, offset, true, noAssert)
}

Buffer.prototype.writeFloatBE = function writeFloatBE (value, offset, noAssert) {
  return writeFloat(this, value, offset, false, noAssert)
}

function writeDouble (buf, value, offset, littleEndian, noAssert) {
  if (!noAssert) {
    checkIEEE754(buf, value, offset, 8, 1.7976931348623157E+308, -1.7976931348623157E+308)
  }
  ieee754.write(buf, value, offset, littleEndian, 52, 8)
  return offset + 8
}

Buffer.prototype.writeDoubleLE = function writeDoubleLE (value, offset, noAssert) {
  return writeDouble(this, value, offset, true, noAssert)
}

Buffer.prototype.writeDoubleBE = function writeDoubleBE (value, offset, noAssert) {
  return writeDouble(this, value, offset, false, noAssert)
}

// copy(targetBuffer, targetStart=0, sourceStart=0, sourceEnd=buffer.length)
Buffer.prototype.copy = function copy (target, targetStart, start, end) {
  if (!start) start = 0
  if (!end && end !== 0) end = this.length
  if (targetStart >= target.length) targetStart = target.length
  if (!targetStart) targetStart = 0
  if (end > 0 && end < start) end = start

  // Copy 0 bytes; we're done
  if (end === start) return 0
  if (target.length === 0 || this.length === 0) return 0

  // Fatal error conditions
  if (targetStart < 0) {
    throw new RangeError('targetStart out of bounds')
  }
  if (start < 0 || start >= this.length) throw new RangeError('sourceStart out of bounds')
  if (end < 0) throw new RangeError('sourceEnd out of bounds')

  // Are we oob?
  if (end > this.length) end = this.length
  if (target.length - targetStart < end - start) {
    end = target.length - targetStart + start
  }

  var len = end - start
  var i

  if (this === target && start < targetStart && targetStart < end) {
    // descending copy from end
    for (i = len - 1; i >= 0; --i) {
      target[i + targetStart] = this[i + start]
    }
  } else if (len < 1000 || !Buffer.TYPED_ARRAY_SUPPORT) {
    // ascending copy from start
    for (i = 0; i < len; ++i) {
      target[i + targetStart] = this[i + start]
    }
  } else {
    Uint8Array.prototype.set.call(
      target,
      this.subarray(start, start + len),
      targetStart
    )
  }

  return len
}

// Usage:
//    buffer.fill(number[, offset[, end]])
//    buffer.fill(buffer[, offset[, end]])
//    buffer.fill(string[, offset[, end]][, encoding])
Buffer.prototype.fill = function fill (val, start, end, encoding) {
  // Handle string cases:
  if (typeof val === 'string') {
    if (typeof start === 'string') {
      encoding = start
      start = 0
      end = this.length
    } else if (typeof end === 'string') {
      encoding = end
      end = this.length
    }
    if (val.length === 1) {
      var code = val.charCodeAt(0)
      if (code < 256) {
        val = code
      }
    }
    if (encoding !== undefined && typeof encoding !== 'string') {
      throw new TypeError('encoding must be a string')
    }
    if (typeof encoding === 'string' && !Buffer.isEncoding(encoding)) {
      throw new TypeError('Unknown encoding: ' + encoding)
    }
  } else if (typeof val === 'number') {
    val = val & 255
  }

  // Invalid ranges are not set to a default, so can range check early.
  if (start < 0 || this.length < start || this.length < end) {
    throw new RangeError('Out of range index')
  }

  if (end <= start) {
    return this
  }

  start = start >>> 0
  end = end === undefined ? this.length : end >>> 0

  if (!val) val = 0

  var i
  if (typeof val === 'number') {
    for (i = start; i < end; ++i) {
      this[i] = val
    }
  } else {
    var bytes = Buffer.isBuffer(val)
      ? val
      : utf8ToBytes(new Buffer(val, encoding).toString())
    var len = bytes.length
    for (i = 0; i < end - start; ++i) {
      this[i + start] = bytes[i % len]
    }
  }

  return this
}

// HELPER FUNCTIONS
// ================

var INVALID_BASE64_RE = /[^+\/0-9A-Za-z-_]/g

function base64clean (str) {
  // Node strips out invalid characters like \n and \t from the string, base64-js does not
  str = stringtrim(str).replace(INVALID_BASE64_RE, '')
  // Node converts strings with length < 2 to ''
  if (str.length < 2) return ''
  // Node allows for non-padded base64 strings (missing trailing ===), base64-js does not
  while (str.length % 4 !== 0) {
    str = str + '='
  }
  return str
}

function stringtrim (str) {
  if (str.trim) return str.trim()
  return str.replace(/^\s+|\s+$/g, '')
}

function toHex (n) {
  if (n < 16) return '0' + n.toString(16)
  return n.toString(16)
}

function utf8ToBytes (string, units) {
  units = units || Infinity
  var codePoint
  var length = string.length
  var leadSurrogate = null
  var bytes = []

  for (var i = 0; i < length; ++i) {
    codePoint = string.charCodeAt(i)

    // is surrogate component
    if (codePoint > 0xD7FF && codePoint < 0xE000) {
      // last char was a lead
      if (!leadSurrogate) {
        // no lead yet
        if (codePoint > 0xDBFF) {
          // unexpected trail
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
          continue
        } else if (i + 1 === length) {
          // unpaired lead
          if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
          continue
        }

        // valid lead
        leadSurrogate = codePoint

        continue
      }

      // 2 leads in a row
      if (codePoint < 0xDC00) {
        if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
        leadSurrogate = codePoint
        continue
      }

      // valid surrogate pair
      codePoint = (leadSurrogate - 0xD800 << 10 | codePoint - 0xDC00) + 0x10000
    } else if (leadSurrogate) {
      // valid bmp char, but last char was a lead
      if ((units -= 3) > -1) bytes.push(0xEF, 0xBF, 0xBD)
    }

    leadSurrogate = null

    // encode utf8
    if (codePoint < 0x80) {
      if ((units -= 1) < 0) break
      bytes.push(codePoint)
    } else if (codePoint < 0x800) {
      if ((units -= 2) < 0) break
      bytes.push(
        codePoint >> 0x6 | 0xC0,
        codePoint & 0x3F | 0x80
      )
    } else if (codePoint < 0x10000) {
      if ((units -= 3) < 0) break
      bytes.push(
        codePoint >> 0xC | 0xE0,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      )
    } else if (codePoint < 0x110000) {
      if ((units -= 4) < 0) break
      bytes.push(
        codePoint >> 0x12 | 0xF0,
        codePoint >> 0xC & 0x3F | 0x80,
        codePoint >> 0x6 & 0x3F | 0x80,
        codePoint & 0x3F | 0x80
      )
    } else {
      throw new Error('Invalid code point')
    }
  }

  return bytes
}

function asciiToBytes (str) {
  var byteArray = []
  for (var i = 0; i < str.length; ++i) {
    // Node's code seems to be doing this and not & 0x7F..
    byteArray.push(str.charCodeAt(i) & 0xFF)
  }
  return byteArray
}

function utf16leToBytes (str, units) {
  var c, hi, lo
  var byteArray = []
  for (var i = 0; i < str.length; ++i) {
    if ((units -= 2) < 0) break

    c = str.charCodeAt(i)
    hi = c >> 8
    lo = c % 256
    byteArray.push(lo)
    byteArray.push(hi)
  }

  return byteArray
}

function base64ToBytes (str) {
  return base64.toByteArray(base64clean(str))
}

function blitBuffer (src, dst, offset, length) {
  for (var i = 0; i < length; ++i) {
    if ((i + offset >= dst.length) || (i >= src.length)) break
    dst[i + offset] = src[i]
  }
  return i
}

function isnan (val) {
  return val !== val // eslint-disable-line no-self-compare
}

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(139)))

/***/ }),
/* 66 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSessionToken = void 0;
var Error_1 = __webpack_require__(12);
var SessionToken = __importStar(__webpack_require__(62));
function getSessionToken(appBridge) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2 /*return*/, new Promise(function (resolve, reject) {
                    var unsubscribe = appBridge.subscribe(SessionToken.Action.RESPOND, function (_a) {
                        var sessionToken = _a.sessionToken;
                        if (sessionToken) {
                            resolve(sessionToken);
                        }
                        else {
                            reject(Error_1.fromAction('Failed to retrieve a session token', Error_1.Action.FAILED_AUTHENTICATION));
                        }
                        unsubscribe();
                    });
                    appBridge.dispatch(SessionToken.request());
                })];
        });
    });
}
exports.getSessionToken = getSessionToken;


/***/ }),
/* 67 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAuthorizationCodePayload = void 0;
var AuthCode = __importStar(__webpack_require__(56));
var Error_1 = __webpack_require__(11);
var uuid_1 = __importDefault(__webpack_require__(149));
function getAuthorizationCodePayload(app) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            return [2 /*return*/, new Promise(function (resolve, reject) {
                    var requestId = uuid_1.default();
                    var unsubscribe = app.subscribe(AuthCode.Action.RESPOND, function (payload) {
                        switch (payload === null || payload === void 0 ? void 0 : payload.status) {
                            case 'needsExchange':
                                resolve(payload);
                                break;
                            default:
                                reject(Error_1.fromAction('Failed to retrieve an authorization code', Error_1.Action.FAILED_AUTHENTICATION));
                        }
                        unsubscribe();
                    }, requestId);
                    app.dispatch(AuthCode.request(requestId));
                })];
        });
    });
}
exports.getAuthorizationCodePayload = getAuthorizationCodePayload;


/***/ }),
/* 68 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

/**
 * This entry file is specifically made for the UMD build (development) hosted on a CDN.
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.utilities = exports.createApp = exports.default = exports.actions = void 0;
var development_1 = __webpack_require__(36);
var CompatibilityActions_1 = __webpack_require__(105);
Object.defineProperty(exports, "actions", { enumerable: true, get: function () { return CompatibilityActions_1.compatibilityActions; } });
var CompatibilityClient_1 = __webpack_require__(136);
__exportStar(__webpack_require__(36), exports);
function devCreateApp(config) {
    return CompatibilityClient_1.compatibilityCreateApp(config, development_1.createApp);
}
exports.default = devCreateApp;
exports.createApp = devCreateApp;
exports.utilities = __importStar(__webpack_require__(144));


/***/ }),
/* 69 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var validator_1 = __webpack_require__(70);
exports.default = validator_1.validatorMiddleware;


/***/ }),
/* 70 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __spreadArray = (this && this.__spreadArray) || function (to, from) {
    for (var i = 0, il = from.length, j = to.length; i < il; i++, j++)
        to[j] = from[i];
    return to;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.validatorMiddleware = exports.connectValidatorToDispatchHook = exports.connectValidatorToUpdateHook = void 0;
var client_1 = __webpack_require__(15);
var types_1 = __webpack_require__(7);
var Error_1 = __webpack_require__(11);
var helper_1 = __webpack_require__(6);
var actions_1 = __webpack_require__(83);
var type_validate_1 = __webpack_require__(10);
var utils_1 = __webpack_require__(8);
function updateValidator(localOrigin, group, options) {
    switch (group) {
        case types_1.Group.Button:
            return actions_1.Button.validateProps(options);
        case types_1.Group.ButtonGroup:
            return actions_1.ButtonGroup.validateProps(options);
        case types_1.Group.Modal:
            return actions_1.Modal.validateProps(options, localOrigin);
        case types_1.Group.Menu:
            return actions_1.Menu.validateProps(options);
        case types_1.Group.Link:
            return actions_1.Link.validateProps(options);
        case types_1.Group.TitleBar:
            return actions_1.TitleBar.validateProps(options);
        case types_1.Group.ResourcePicker:
            return actions_1.ResourcePicker.validateProps(options);
        case types_1.Group.Toast:
            return actions_1.Toast.validateProps(options);
        case types_1.Group.ContextualSaveBar:
            return actions_1.ContextualSaveBar.validateProps(options);
        case types_1.Group.unstable_Picker:
            return actions_1.unstable_Picker.validateProps(options);
    }
}
function dispatchPayloadValidator(action, localOrigin) {
    switch (action.group) {
        case types_1.Group.Button:
            return actions_1.Button.validateAction(action);
        case types_1.Group.ButtonGroup:
            return actions_1.ButtonGroup.validateAction(action);
        case types_1.Group.Modal:
            return actions_1.Modal.validateAction(action, localOrigin);
        case types_1.Group.Menu:
            return actions_1.Menu.validateAction(action);
        case types_1.Group.TitleBar:
            return actions_1.TitleBar.validateAction(action);
        case types_1.Group.ResourcePicker:
            return actions_1.ResourcePicker.validateAction(action);
        case types_1.Group.Loading:
            return actions_1.Loading.validateAction(action);
        case types_1.Group.Toast:
            return actions_1.Toast.validateAction(action);
        case types_1.Group.Cart:
            return actions_1.Cart.validateAction(action);
        case types_1.Group.Navigation:
            return actions_1.Navigation.validateAction(action);
        case types_1.Group.Print:
            return actions_1.Print.validateAction(action);
        case types_1.Group.Scanner:
            return actions_1.Scanner.validateAction(action);
        case types_1.Group.Fullscreen:
            return actions_1.Fullscreen.validateAction(action);
        case types_1.Group.ContextualSaveBar:
            return actions_1.ContextualSaveBar.validateAction(action);
        case types_1.Group.Link:
            return actions_1.Link.validateAction(action);
        case types_1.Group.unstable_Picker:
            return actions_1.unstable_Picker.validateAction(action);
    }
}
function dispatchValidator(action, origin) {
    var errors = type_validate_1.validate(action, type_validate_1.matchesObject({
        group: type_validate_1.matchesEnum(types_1.Group, {
            message: function (_, value) { return "Unknown or unsupported action group `" + value + "`"; },
        }),
        version: type_validate_1.matchesString(),
    }));
    if (errors) {
        return Error_1.invalidAction(action, utils_1.actionMessage(errors));
    }
    var payloadErrors = dispatchPayloadValidator(action, origin);
    return payloadErrors ? Error_1.invalidPayload(action, utils_1.actionMessage(payloadErrors)) : action;
}
var connectValidatorToUpdateHook = function (next) {
    return function (options) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        // The group should be statically set to the default initial group as certain components
        // (ex. Button and ButtonGroup) can be dynamically grouped under a new group (ex. TitleBar)
        // We accept partial options so the validator should be called on merged new and old options
        var mergedOptions = helper_1.getMergedProps(this.options, options);
        var errors = updateValidator(this.app.localOrigin, this.defaultGroup, mergedOptions);
        if (errors) {
            throw Error_1.fromAction(utils_1.actionMessage(errors), Error_1.Action.INVALID_OPTIONS);
        }
        return next.apply(void 0, __spreadArray([options], args));
    };
};
exports.connectValidatorToUpdateHook = connectValidatorToUpdateHook;
var connectValidatorToDispatchHook = function (next) {
    return function (action) {
        var finalAction = dispatchValidator(action, this.localOrigin);
        return next(finalAction);
    };
};
exports.connectValidatorToDispatchHook = connectValidatorToDispatchHook;
var validatorMiddleware = function (hooks) {
    hooks.set(client_1.LifecycleHook.UpdateAction, exports.connectValidatorToUpdateHook);
    hooks.set(client_1.LifecycleHook.DispatchAction, exports.connectValidatorToDispatchHook);
};
exports.validatorMiddleware = validatorMiddleware;


/***/ }),
/* 71 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Returns a deeply merged object with properties from the 2 provided objects
 * @remarks - Only deeply merge objects. The second argument overrides the
 * first if it is provided as `null`, `undefined` or an array.
 * @public
 * */
function mergeProps(obj, newObj) {
    if (newObj == null) {
        return newObj;
    }
    // If setting to a different prototype or a non-object or non-array, don't merge any props
    if (typeof obj === 'undefined' ||
        !Object.prototype.isPrototypeOf.call(Object.getPrototypeOf(obj), newObj) ||
        (newObj.constructor.name !== 'Object' && newObj.constructor.name !== 'Array')) {
        return newObj;
    }
    var clone = {};
    Object.keys(newObj).forEach(function (key) {
        var exists = Object.prototype.hasOwnProperty.call(obj, key);
        if (!exists) {
            clone[key] = newObj[key];
        }
        else if (typeof obj[key] === 'object' && !Array.isArray(obj[key])) {
            clone[key] = mergeProps(obj[key], newObj[key]);
        }
        else {
            clone[key] = newObj[key];
        }
    });
    // Copy old props that are not present in new object only if this is a simple object
    Object.keys(obj).forEach(function (key) {
        var exists = Object.prototype.hasOwnProperty.call(newObj, key);
        if (!exists) {
            clone[key] = obj[key];
        }
    });
    // Set prototype of cloned object to match original
    Object.setPrototypeOf(clone, Object.getPrototypeOf(obj));
    return clone;
}
exports.default = mergeProps;


/***/ }),
/* 72 */
/***/ (function(module) {

module.exports = JSON.parse("{\"name\":\"@shopify/app-bridge\",\"version\":\"3.7.10\",\"types\":\"index.d.ts\",\"main\":\"index.js\",\"unpkg\":\"umd/index.js\",\"jsdelivr\":\"umd/index.js\",\"files\":[\"/actions/\",\"/client/\",\"/umd/\",\"/utilities/\",\"/util/\",\"/validate/\",\"/development.d.ts\",\"/development.js\",\"/index.d.ts\",\"/index.js\",\"/MessageTransport.d.ts\",\"/MessageTransport.js\",\"/production.d.ts\",\"/production.js\"],\"private\":false,\"publishConfig\":{\"access\":\"public\",\"@shopify:registry\":\"https://registry.npmjs.org\"},\"repository\":\"git@github.com:Shopify/app-bridge.git\",\"homepage\":\"https://shopify.dev/docs/api/app-bridge/previous-versions/app-bridge-from-npm/app-setup\",\"author\":\"Shopify Inc.\",\"license\":\"MIT\",\"scripts\":{\"build\":\"yarn build:tsc && yarn build:npm && yarn build:umd\",\"build:tsc\":\"NODE_ENV=production tsc\",\"build:umd\":\"NODE_ENV=production webpack -p\",\"build:npm\":\"shx cp -r ./npm/index.js ./index.js\",\"check\":\"tsc\",\"clean\":\"yarn clean:tsc && yarn clean:npm && yarn clean:umd\",\"clean:tsc\":\"NODE_ENV=production tsc --build --clean\",\"clean:umd\":\"rm -rf ./umd\",\"clean:npm\":\"rm -rf ./index.js\",\"pack\":\"yarn pack\",\"size\":\"size-limit\"},\"sideEffects\":false,\"size-limit\":[{\"limit\":\"10.5 KB\",\"path\":\"production.js\"}],\"dependencies\":{\"@shopify/app-bridge-core\":\"1.1.1\",\"base64url\":\"^3.0.1\",\"web-vitals\":\"^3.0.1\"},\"devDependencies\":{\"@types/node\":\"^10.12.5\",\"shx\":\"^0.3.3\"}}");

/***/ }),
/* 73 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.app = exports.Action = void 0;
var helper_1 = __webpack_require__(0);
var types_1 = __webpack_require__(1);
var Action;
(function (Action) {
    Action["APP"] = "APP::PRINT::APP";
})(Action = exports.Action || (exports.Action = {}));
function app() {
    return helper_1.actionWrapper({
        group: types_1.Group.Print,
        type: Action.APP,
    });
}
exports.app = app;


/***/ }),
/* 74 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.createTransportListener = exports.fromWindow = exports.fromFrame = exports.Context = void 0;
var Error_1 = __webpack_require__(12);
var validator_1 = __webpack_require__(39);
var types_1 = __webpack_require__(13);
var collection_1 = __webpack_require__(23);
var env_1 = __webpack_require__(24);
var Context;
(function (Context) {
    Context["Modal"] = "Modal";
    Context["Main"] = "Main";
})(Context = exports.Context || (exports.Context = {}));
/**
 * Create a MessageTransport from a Frame.
 * @remarks
 * Used on the host-side to create a postMessage MessageTransport.
 * @beta
 */
function fromFrame(frame, localOrigin, context) {
    var handlers = [];
    var host = frame.host, frameWindow = frame.window;
    if (!host) {
        throw Error_1.fromAction('App frame is undefined', Error_1.AppActionType.WINDOW_UNDEFINED);
    }
    if (env_1.isUnframed && window.MobileWebView) {
        Object.assign(window.MobileWebView, {
            postMessageToIframe: function (message, origin) {
                frameWindow === null || frameWindow === void 0 ? void 0 : frameWindow.postMessage(message, origin);
                if (isDispatchAction(message)) {
                    host.postMessage(JSON.stringify(message.payload), location.origin);
                }
            },
            updateIframeUrl: function (newUrl) {
                var currentWindowLocation = window.location;
                var frameWindowLocation = (frame.window || {}).location;
                try {
                    var newUrlOrigin = new URL(newUrl).origin;
                    if (newUrlOrigin === localOrigin && frameWindowLocation) {
                        frameWindowLocation.replace(newUrl);
                    }
                    else {
                        currentWindowLocation.href = newUrl;
                    }
                }
                catch (_) {
                    // Noop
                }
            },
        });
    }
    host.addEventListener('message', function (event) {
        if (event.source === host || !validator_1.isAppMessage(event)) {
            return;
        }
        if (event.origin !== localOrigin) {
            var errorMessage = "Message origin '" + event.origin + "' does not match app origin '" + localOrigin + "'.";
            var payload = Error_1.invalidOriginAction(errorMessage);
            var message = {
                type: 'dispatch',
                payload: payload,
            };
            frameWindow === null || frameWindow === void 0 ? void 0 : frameWindow.postMessage(message, event.origin);
            return;
        }
        if (env_1.isUnframed && window.MobileWebView) {
            var payload = JSON.stringify({
                id: 'unframed://fromClient',
                origin: localOrigin,
                data: event.data,
            });
            window.MobileWebView.postMessage(payload);
            return;
        }
        for (var _i = 0, handlers_1 = handlers; _i < handlers_1.length; _i++) {
            var handler = handlers_1[_i];
            handler(event);
        }
    });
    return {
        context: context,
        localOrigin: localOrigin,
        frameWindow: frameWindow,
        hostFrame: host,
        dispatch: function (message) {
            frameWindow === null || frameWindow === void 0 ? void 0 : frameWindow.postMessage(message, localOrigin);
        },
        subscribe: function (handler) {
            return collection_1.addAndRemoveFromCollection(handlers, handler);
        },
    };
}
exports.fromFrame = fromFrame;
/**
 * Create a MessageTransport from a parent window.
 * @remarks
 * Used on the client-side to create a postMessage MessageTransport.
 * @internalremarks
 * In unframed mode, message should be dispatched via MobileWebView.postMessage instead of postMessage.
 * @beta
 */
function fromWindow(contentWindow, localOrigin) {
    var handlers = [];
    if (typeof window !== undefined) {
        window.addEventListener('message', function (event) {
            if ((window === contentWindow && !env_1.isUnframed) ||
                event.source !== contentWindow ||
                !(validator_1.isAppBridgeAction(event.data.payload) || validator_1.isAppMessage(event))) {
                return;
            }
            for (var _i = 0, handlers_2 = handlers; _i < handlers_2.length; _i++) {
                var handler = handlers_2[_i];
                handler(event);
            }
        });
    }
    return {
        localOrigin: localOrigin,
        hostFrame: contentWindow,
        dispatch: function (message) {
            var _a;
            if (!((_a = message.source) === null || _a === void 0 ? void 0 : _a.host)) {
                return;
            }
            if (env_1.isUnframed && window && window.MobileWebView) {
                var payload = JSON.stringify({
                    id: 'unframed://fromClient',
                    origin: localOrigin,
                    data: message,
                });
                window.MobileWebView.postMessage(payload);
                return;
            }
            var messageOrigin = new URL("https://" + message.source.host).origin;
            contentWindow.postMessage(message, messageOrigin);
        },
        subscribe: function (handler) {
            return collection_1.addAndRemoveFromCollection(handlers, handler);
        },
    };
}
exports.fromWindow = fromWindow;
function createTransportListener() {
    var listeners = [];
    var actionListeners = {};
    function createSubscribeHandler(dispatcher) {
        function subscribe() {
            if (arguments.length < 2) {
                // eslint-disable-next-line prefer-rest-params
                return collection_1.addAndRemoveFromCollection(listeners, { callback: arguments[0] });
            }
            // eslint-disable-next-line prefer-rest-params
            var _a = Array.from(arguments), type = _a[0], callback = _a[1], id = _a[2];
            var actionCallback = { callback: callback, id: id };
            var payload = { type: type, id: id };
            if (!Object.prototype.hasOwnProperty.call(actionListeners, type)) {
                actionListeners[type] = [];
            }
            if (dispatcher) {
                dispatcher(types_1.MessageType.Subscribe, payload);
            }
            return collection_1.addAndRemoveFromCollection(actionListeners[type], actionCallback, function () {
                if (dispatcher) {
                    dispatcher(types_1.MessageType.Unsubscribe, payload);
                }
            });
        }
        return subscribe;
    }
    return {
        createSubscribeHandler: createSubscribeHandler,
        handleMessage: function (message) {
            listeners.forEach(function (listener) { return listener.callback(message); });
        },
        handleActionDispatch: function (_a) {
            var type = _a.type, payload = _a.payload;
            var hasCallback = false;
            if (Object.prototype.hasOwnProperty.call(actionListeners, type)) {
                for (var _i = 0, _b = actionListeners[type]; _i < _b.length; _i++) {
                    var listener = _b[_i];
                    var id = listener.id, callback = listener.callback;
                    var matchId = payload && payload.id === id;
                    if (matchId || !id) {
                        callback(payload);
                        hasCallback = true;
                    }
                }
            }
            return hasCallback;
        },
    };
}
exports.createTransportListener = createTransportListener;
function isDispatchAction(message) {
    return (message !== null &&
        typeof message === 'object' &&
        !Array.isArray(message) &&
        message.type === 'dispatch' &&
        typeof message.payload === 'object');
}


/***/ }),
/* 75 */
/***/ (function(module, exports) {

// shim for using process in browser
var process = module.exports = {};

// cached from whatever global is present so that test runners that stub it
// don't break things.  But we need to wrap it in a try catch in case it is
// wrapped in strict mode code which doesn't define any globals.  It's inside a
// function because try/catches deoptimize in certain engines.

var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout () {
    throw new Error('clearTimeout has not been defined');
}
(function () {
    try {
        if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
        } else {
            cachedSetTimeout = defaultSetTimout;
        }
    } catch (e) {
        cachedSetTimeout = defaultSetTimout;
    }
    try {
        if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
        } else {
            cachedClearTimeout = defaultClearTimeout;
        }
    } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
    }
} ())
function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch(e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch(e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }


}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e){
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e){
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }



}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while(len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}

process.nextTick = function (fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
};

// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];
process.version = ''; // empty string to avoid regexp issues
process.versions = {};

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;
process.prependListener = noop;
process.prependOnceListener = noop;

process.listeners = function (name) { return [] }

process.binding = function (name) {
    throw new Error('process.binding is not supported');
};

process.cwd = function () { return '/' };
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};
process.umask = function() { return 0; };


/***/ }),
/* 76 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = void 0;
var Action;
(function (Action) {
    Action["INITIALIZE"] = "APP::CLIENT::INITIALIZE";
})(Action = exports.Action || (exports.Action = {}));


/***/ }),
/* 77 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeWebVitals = exports.interactionToNextPaint = exports.timeToFirstByte = exports.firstContentfulPaint = exports.cumulativeLayoutShift = exports.firstInputDelay = exports.largestContentfulPaint = exports.Action = void 0;
var web_vitals_1 = __webpack_require__(78);
var WebVitals_1 = __webpack_require__(79);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return WebVitals_1.Action; } });
var env_1 = __webpack_require__(25);
var types_1 = __webpack_require__(7);
var helper_1 = __webpack_require__(6);
var platform_1 = __webpack_require__(26);
function largestContentfulPaint(payload) {
    return helper_1.actionWrapper({
        group: types_1.Group.WebVitals,
        type: WebVitals_1.Action.LARGEST_CONTENTFUL_PAINT,
        payload: payload,
    });
}
exports.largestContentfulPaint = largestContentfulPaint;
function firstInputDelay(payload) {
    return helper_1.actionWrapper({
        group: types_1.Group.WebVitals,
        type: WebVitals_1.Action.FIRST_INPUT_DELAY,
        payload: payload,
    });
}
exports.firstInputDelay = firstInputDelay;
function cumulativeLayoutShift(payload) {
    return helper_1.actionWrapper({
        group: types_1.Group.WebVitals,
        type: WebVitals_1.Action.CUMULATIVE_LAYOUT_SHIFT,
        payload: payload,
    });
}
exports.cumulativeLayoutShift = cumulativeLayoutShift;
function firstContentfulPaint(payload) {
    return helper_1.actionWrapper({
        group: types_1.Group.WebVitals,
        type: WebVitals_1.Action.FIRST_CONTENTFUL_PAINT,
        payload: payload,
    });
}
exports.firstContentfulPaint = firstContentfulPaint;
function timeToFirstByte(payload) {
    return helper_1.actionWrapper({
        group: types_1.Group.WebVitals,
        type: WebVitals_1.Action.TIME_TO_FIRST_BYTE,
        payload: payload,
    });
}
exports.timeToFirstByte = timeToFirstByte;
function interactionToNextPaint(payload) {
    return helper_1.actionWrapper({
        group: types_1.Group.WebVitals,
        type: WebVitals_1.Action.INTERACTION_TO_NEXT_PAINT,
        payload: payload,
    });
}
exports.interactionToNextPaint = interactionToNextPaint;
function initializeWebVitals(app) {
    function onReport(cb) {
        return function (data) {
            var id = data.id, metricName = data.name, value = data.value;
            var payload = { id: id, metricName: metricName, value: value };
            var event = cb(payload);
            app.dispatch(event);
        };
    }
    var untypedWindow = window;
    if (env_1.isServer || (env_1.isClient && untypedWindow.__is_web_vitals_initialized__) || platform_1.isMobile()) {
        // We need to prevent the Web Vitals functions from being called more than once per page load,
        // which can cause a memory leak as per the web-vitals docs.
        return;
    }
    untypedWindow.__is_web_vitals_initialized__ = true;
    web_vitals_1.onLCP(onReport(largestContentfulPaint));
    web_vitals_1.onFID(onReport(firstInputDelay));
    web_vitals_1.onCLS(onReport(cumulativeLayoutShift));
    web_vitals_1.onFCP(onReport(firstContentfulPaint));
    web_vitals_1.onTTFB(onReport(timeToFirstByte));
    web_vitals_1.onINP(onReport(interactionToNextPaint));
}
exports.initializeWebVitals = initializeWebVitals;


/***/ }),
/* 78 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getCLS", function() { return b; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFCP", function() { return L; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getFID", function() { return M; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getINP", function() { return z; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getLCP", function() { return J; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "getTTFB", function() { return Q; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "onCLS", function() { return b; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "onFCP", function() { return L; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "onFID", function() { return M; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "onINP", function() { return z; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "onLCP", function() { return J; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "onTTFB", function() { return Q; });
var e,n,t,r,i,a=-1,o=function(e){addEventListener("pageshow",(function(n){n.persisted&&(a=n.timeStamp,e(n))}),!0)},c=function(){return window.performance&&performance.getEntriesByType&&performance.getEntriesByType("navigation")[0]},u=function(){var e=c();return e&&e.activationStart||0},f=function(e,n){var t=c(),r="navigate";return a>=0?r="back-forward-cache":t&&(r=document.prerendering||u()>0?"prerender":document.wasDiscarded?"restore":t.type.replace(/_/g,"-")),{name:e,value:void 0===n?-1:n,rating:"good",delta:0,entries:[],id:"v3-".concat(Date.now(),"-").concat(Math.floor(8999999999999*Math.random())+1e12),navigationType:r}},s=function(e,n,t){try{if(PerformanceObserver.supportedEntryTypes.includes(e)){var r=new PerformanceObserver((function(e){Promise.resolve().then((function(){n(e.getEntries())}))}));return r.observe(Object.assign({type:e,buffered:!0},t||{})),r}}catch(e){}},d=function(e,n,t,r){var i,a;return function(o){n.value>=0&&(o||r)&&((a=n.value-(i||0))||void 0===i)&&(i=n.value,n.delta=a,n.rating=function(e,n){return e>n[1]?"poor":e>n[0]?"needs-improvement":"good"}(n.value,t),e(n))}},l=function(e){requestAnimationFrame((function(){return requestAnimationFrame((function(){return e()}))}))},v=function(e){var n=function(n){"pagehide"!==n.type&&"hidden"!==document.visibilityState||e(n)};addEventListener("visibilitychange",n,!0),addEventListener("pagehide",n,!0)},p=function(e){var n=!1;return function(t){n||(e(t),n=!0)}},m=-1,h=function(){return"hidden"!==document.visibilityState||document.prerendering?1/0:0},g=function(e){"hidden"===document.visibilityState&&m>-1&&(m="visibilitychange"===e.type?e.timeStamp:0,T())},y=function(){addEventListener("visibilitychange",g,!0),addEventListener("prerenderingchange",g,!0)},T=function(){removeEventListener("visibilitychange",g,!0),removeEventListener("prerenderingchange",g,!0)},E=function(){return m<0&&(m=h(),y(),o((function(){setTimeout((function(){m=h(),y()}),0)}))),{get firstHiddenTime(){return m}}},C=function(e){document.prerendering?addEventListener("prerenderingchange",(function(){return e()}),!0):e()},L=function(e,n){n=n||{},C((function(){var t,r=[1800,3e3],i=E(),a=f("FCP"),c=s("paint",(function(e){e.forEach((function(e){"first-contentful-paint"===e.name&&(c.disconnect(),e.startTime<i.firstHiddenTime&&(a.value=Math.max(e.startTime-u(),0),a.entries.push(e),t(!0)))}))}));c&&(t=d(e,a,r,n.reportAllChanges),o((function(i){a=f("FCP"),t=d(e,a,r,n.reportAllChanges),l((function(){a.value=performance.now()-i.timeStamp,t(!0)}))})))}))},b=function(e,n){n=n||{},L(p((function(){var t,r=[.1,.25],i=f("CLS",0),a=0,c=[],u=function(e){e.forEach((function(e){if(!e.hadRecentInput){var n=c[0],t=c[c.length-1];a&&e.startTime-t.startTime<1e3&&e.startTime-n.startTime<5e3?(a+=e.value,c.push(e)):(a=e.value,c=[e])}})),a>i.value&&(i.value=a,i.entries=c,t())},p=s("layout-shift",u);p&&(t=d(e,i,r,n.reportAllChanges),v((function(){u(p.takeRecords()),t(!0)})),o((function(){a=0,i=f("CLS",0),t=d(e,i,r,n.reportAllChanges),l((function(){return t()}))})),setTimeout(t,0))})))},w={passive:!0,capture:!0},S=new Date,A=function(r,i){e||(e=i,n=r,t=new Date,F(removeEventListener),I())},I=function(){if(n>=0&&n<t-S){var i={entryType:"first-input",name:e.type,target:e.target,cancelable:e.cancelable,startTime:e.timeStamp,processingStart:e.timeStamp+n};r.forEach((function(e){e(i)})),r=[]}},P=function(e){if(e.cancelable){var n=(e.timeStamp>1e12?new Date:performance.now())-e.timeStamp;"pointerdown"==e.type?function(e,n){var t=function(){A(e,n),i()},r=function(){i()},i=function(){removeEventListener("pointerup",t,w),removeEventListener("pointercancel",r,w)};addEventListener("pointerup",t,w),addEventListener("pointercancel",r,w)}(n,e):A(n,e)}},F=function(e){["mousedown","keydown","touchstart","pointerdown"].forEach((function(n){return e(n,P,w)}))},M=function(t,i){i=i||{},C((function(){var a,c=[100,300],u=E(),l=f("FID"),m=function(e){e.startTime<u.firstHiddenTime&&(l.value=e.processingStart-e.startTime,l.entries.push(e),a(!0))},h=function(e){e.forEach(m)},g=s("first-input",h);a=d(t,l,c,i.reportAllChanges),g&&v(p((function(){h(g.takeRecords()),g.disconnect()}))),g&&o((function(){var o;l=f("FID"),a=d(t,l,c,i.reportAllChanges),r=[],n=-1,e=null,F(addEventListener),o=m,r.push(o),I()}))}))},k=0,D=1/0,x=0,B=function(e){e.forEach((function(e){e.interactionId&&(D=Math.min(D,e.interactionId),x=Math.max(x,e.interactionId),k=x?(x-D)/7+1:0)}))},R=function(){return i?k:performance.interactionCount||0},H=function(){"interactionCount"in performance||i||(i=s("event",B,{type:"event",buffered:!0,durationThreshold:0}))},N=0,O=function(){return R()-N},q=[],j={},_=function(e){var n=q[q.length-1],t=j[e.interactionId];if(t||q.length<10||e.duration>n.latency){if(t)t.entries.push(e),t.latency=Math.max(t.latency,e.duration);else{var r={id:e.interactionId,latency:e.duration,entries:[e]};j[r.id]=r,q.push(r)}q.sort((function(e,n){return n.latency-e.latency})),q.splice(10).forEach((function(e){delete j[e.id]}))}},z=function(e,n){n=n||{},C((function(){var t=[200,500];H();var r,i=f("INP"),a=function(e){e.forEach((function(e){(e.interactionId&&_(e),"first-input"===e.entryType)&&(!q.some((function(n){return n.entries.some((function(n){return e.duration===n.duration&&e.startTime===n.startTime}))}))&&_(e))}));var n,t=(n=Math.min(q.length-1,Math.floor(O()/50)),q[n]);t&&t.latency!==i.value&&(i.value=t.latency,i.entries=t.entries,r())},c=s("event",a,{durationThreshold:n.durationThreshold||40});r=d(e,i,t,n.reportAllChanges),c&&(c.observe({type:"first-input",buffered:!0}),v((function(){a(c.takeRecords()),i.value<0&&O()>0&&(i.value=0,i.entries=[]),r(!0)})),o((function(){q=[],N=R(),i=f("INP"),r=d(e,i,t,n.reportAllChanges)})))}))},G={},J=function(e,n){n=n||{},C((function(){var t,r=[2500,4e3],i=E(),a=f("LCP"),c=function(e){var n=e[e.length-1];if(n){var r=Math.max(n.startTime-u(),0);r<i.firstHiddenTime&&(a.value=r,a.entries=[n],t())}},m=s("largest-contentful-paint",c);if(m){t=d(e,a,r,n.reportAllChanges);var h=p((function(){G[a.id]||(c(m.takeRecords()),m.disconnect(),G[a.id]=!0,t(!0))}));["keydown","click"].forEach((function(e){addEventListener(e,h,!0)})),v(h),o((function(i){a=f("LCP"),t=d(e,a,r,n.reportAllChanges),l((function(){a.value=performance.now()-i.timeStamp,G[a.id]=!0,t(!0)}))}))}}))},K=function e(n){document.prerendering?C((function(){return e(n)})):"complete"!==document.readyState?addEventListener("load",(function(){return e(n)}),!0):setTimeout(n,0)},Q=function(e,n){n=n||{};var t=[800,1800],r=f("TTFB"),i=d(e,r,t,n.reportAllChanges);K((function(){var a=c();if(a){var s=a.responseStart;if(s<=0||s>performance.now())return;r.value=Math.max(s-u(),0),r.entries=[a],i(!0),o((function(){r=f("TTFB",0),(i=d(e,r,t,n.reportAllChanges))(!0)}))}}))};


/***/ }),
/* 79 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = void 0;
var Action;
(function (Action) {
    Action["LARGEST_CONTENTFUL_PAINT"] = "APP::WEB_VITALS::LARGEST_CONTENTFUL_PAINT";
    Action["FIRST_INPUT_DELAY"] = "APP::WEB_VITALS::FIRST_INPUT_DELAY";
    Action["CUMULATIVE_LAYOUT_SHIFT"] = "APP::WEB_VITALS::CUMULATIVE_LAYOUT_SHIFT";
    Action["FIRST_CONTENTFUL_PAINT"] = "APP::WEB_VITALS::FIRST_CONTENTFUL_PAINT";
    Action["TIME_TO_FIRST_BYTE"] = "APP::WEB_VITALS::TIME_TO_FIRST_BYTE";
    Action["INTERACTION_TO_NEXT_PAINT"] = "APP::WEB_VITALS::INTERACTION_TO_NEXT_PAINT";
})(Action = exports.Action || (exports.Action = {}));


/***/ }),
/* 80 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.handleAppPrint = void 0;
var redirect_1 = __webpack_require__(27);
function isRunningOniOS() {
    return navigator.userAgent.indexOf('iOS') >= 0;
}
function createHiddenInput() {
    var currentWindow = redirect_1.getWindow();
    if (!currentWindow || !currentWindow.document || !currentWindow.document.body) {
        return;
    }
    var inputElement = currentWindow.document.createElement('input');
    inputElement.style.display = 'none';
    currentWindow.document.body.appendChild(inputElement);
    return inputElement;
}
function printWindow() {
    var _a;
    (_a = redirect_1.getWindow()) === null || _a === void 0 ? void 0 : _a.print();
}
function handleMobileAppPrint() {
    var input = createHiddenInput();
    if (!input) {
        return;
    }
    input.select();
    printWindow();
    input.remove();
}
function handleAppPrint() {
    if (isRunningOniOS()) {
        handleMobileAppPrint();
    }
    else {
        printWindow();
    }
}
exports.handleAppPrint = handleAppPrint;


/***/ }),
/* 81 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var collection_1 = __webpack_require__(82);
/**
 * Shopify App Bridge can be extended with hooks, which run when actions are dispatched and updated.
 * Hooks are middleware functions that can modify or cancel actions.
 *
 * The [validation middleware](../validate/README.md) is implemented using hooks.
 *
 * @remarks
 * Here’s an example hook that modifies all Toast show actions to have a duration of five seconds.
 *
 * ```ts
 * import createApp, {LifecycleHook, DispatchActionHook} from '@shopify/app-bridge';
 * import {Toast} from '@shopify/app-bridge/actions'
 *
 * const app = createApp({apiKey: API_KEY, host: HOST});
 *
 * function makeToastsFiveSeconds: DispatchActionHook(next) {
 *   return function(action){
 *       if(action.type === Toast.Action.SHOW) {
 *         const modifiedAction = {
 *           ...action,
 *           payload: {
 *             ...action.payload,
 *             duration: 5000,
 *           },
 *         };
 *         return next(modifiedAction);
 *       } else {
 *         // don’t modify non-Toast actions
 *         return next(action);
 *       }
 *   }
 * }
 *
 * app.hooks.set(LifecycleHook.DispatchAction, makeToastsFiveSeconds);
 * ```
 *
 * The hook function `makeToastsFiveSeconds()` takes a `next()` function as its argument.
 * The hook function returns an anonymous function, which takes the action being dispatched as its argument.
 *
 * To modify an action, call `next()` with the modified action, as in the example.
 * To cancel an action, don’t call `next()`, and the action will not be dispatched.
 */
var Hooks = /** @class */ (function () {
    function Hooks() {
        this.map = {};
    }
    Hooks.prototype.set = function (hook, handler) {
        if (!Object.prototype.hasOwnProperty.call(this.map, hook)) {
            this.map[hook] = [];
        }
        var value = { handler: handler, remove: function () { } };
        var remove = collection_1.addAndRemoveFromCollection(this.map[hook], value);
        value = { handler: handler, remove: remove };
        return remove;
    };
    Hooks.prototype.get = function (hook) {
        var value = this.map[hook];
        return value ? value.map(function (val) { return val.handler; }) : undefined;
    };
    // eslint-disable-next-line @typescript-eslint/ban-types
    Hooks.prototype.run = function (hook, final, context) {
        var initialArgs = [];
        for (var _i = 3; _i < arguments.length; _i++) {
            initialArgs[_i - 3] = arguments[_i];
        }
        var index = 0;
        var handlers = this.get(hook) || [];
        function handler() {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            var childHandler = handlers[index++];
            if (childHandler) {
                return childHandler(handler).apply(context, args);
            }
            return final.apply(context, args);
        }
        return handler.apply(context, initialArgs);
    };
    return Hooks;
}());
exports.default = Hooks;


/***/ }),
/* 82 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.removeFromCollection = exports.addAndRemoveFromCollection = void 0;
var collection_1 = __webpack_require__(23);
Object.defineProperty(exports, "addAndRemoveFromCollection", { enumerable: true, get: function () { return collection_1.addAndRemoveFromCollection; } });
Object.defineProperty(exports, "removeFromCollection", { enumerable: true, get: function () { return collection_1.removeFromCollection; } });


/***/ }),
/* 83 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.unstable_Picker = exports.Toast = exports.TitleBar = exports.Scanner = exports.ResourcePicker = exports.Print = exports.Navigation = exports.Modal = exports.Menu = exports.Loading = exports.Link = exports.LeaveConfirmation = exports.Fullscreen = exports.FeedbackModal = exports.ContextualSaveBar = exports.Cart = exports.ButtonGroup = exports.Button = void 0;
var actions_1 = __webpack_require__(84);
Object.defineProperty(exports, "Button", { enumerable: true, get: function () { return actions_1.Button; } });
Object.defineProperty(exports, "ButtonGroup", { enumerable: true, get: function () { return actions_1.ButtonGroup; } });
Object.defineProperty(exports, "ContextualSaveBar", { enumerable: true, get: function () { return actions_1.ContextualSaveBar; } });
Object.defineProperty(exports, "FeedbackModal", { enumerable: true, get: function () { return actions_1.FeedbackModal; } });
Object.defineProperty(exports, "LeaveConfirmation", { enumerable: true, get: function () { return actions_1.LeaveConfirmation; } });
Object.defineProperty(exports, "Link", { enumerable: true, get: function () { return actions_1.Link; } });
Object.defineProperty(exports, "Menu", { enumerable: true, get: function () { return actions_1.Menu; } });
Object.defineProperty(exports, "Modal", { enumerable: true, get: function () { return actions_1.Modal; } });
Object.defineProperty(exports, "Navigation", { enumerable: true, get: function () { return actions_1.Navigation; } });
Object.defineProperty(exports, "ResourcePicker", { enumerable: true, get: function () { return actions_1.ResourcePicker; } });
Object.defineProperty(exports, "TitleBar", { enumerable: true, get: function () { return actions_1.TitleBar; } });
Object.defineProperty(exports, "Toast", { enumerable: true, get: function () { return actions_1.Toast; } });
Object.defineProperty(exports, "unstable_Picker", { enumerable: true, get: function () { return actions_1.unstable_Picker; } });
var Cart = __importStar(__webpack_require__(98));
exports.Cart = Cart;
var Fullscreen = __importStar(__webpack_require__(100));
exports.Fullscreen = Fullscreen;
var Loading = __importStar(__webpack_require__(101));
exports.Loading = Loading;
var Print = __importStar(__webpack_require__(102));
exports.Print = Print;
var Scanner = __importStar(__webpack_require__(103));
exports.Scanner = Scanner;


/***/ }),
/* 84 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.unstable_Picker = exports.Toast = exports.TitleBar = exports.ResourcePicker = exports.Navigation = exports.Modal = exports.Menu = exports.Link = exports.LeaveConfirmation = exports.FeedbackModal = exports.ContextualSaveBar = exports.ButtonGroup = exports.Button = void 0;
var Button = __importStar(__webpack_require__(16));
exports.Button = Button;
var ButtonGroup = __importStar(__webpack_require__(45));
exports.ButtonGroup = ButtonGroup;
var ContextualSaveBar = __importStar(__webpack_require__(85));
exports.ContextualSaveBar = ContextualSaveBar;
var FeedbackModal = __importStar(__webpack_require__(86));
exports.FeedbackModal = FeedbackModal;
var LeaveConfirmation = __importStar(__webpack_require__(87));
exports.LeaveConfirmation = LeaveConfirmation;
var Link = __importStar(__webpack_require__(48));
exports.Link = Link;
var Menu = __importStar(__webpack_require__(88));
exports.Menu = Menu;
var Modal = __importStar(__webpack_require__(89));
exports.Modal = Modal;
var Navigation = __importStar(__webpack_require__(92));
exports.Navigation = Navigation;
var ResourcePicker = __importStar(__webpack_require__(93));
exports.ResourcePicker = ResourcePicker;
var TitleBar = __importStar(__webpack_require__(94));
exports.TitleBar = TitleBar;
var Toast = __importStar(__webpack_require__(96));
exports.Toast = Toast;
var unstable_Picker = __importStar(__webpack_require__(97));
exports.unstable_Picker = unstable_Picker;


/***/ }),
/* 85 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = exports.validateAction = exports.validateProps = exports.contextSaveBarSchema = void 0;
var type_validate_1 = __webpack_require__(3);
var ContextualSaveBar_1 = __webpack_require__(46);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return ContextualSaveBar_1.Action; } });
var utils_1 = __webpack_require__(4);
exports.contextSaveBarSchema = type_validate_1.makeOptional(type_validate_1.matchesObject({
    fullWidth: type_validate_1.makeOptional(type_validate_1.matchesBoolean()),
    discardAction: type_validate_1.makeOptional(type_validate_1.matchesObject({
        disabled: type_validate_1.makeOptional(type_validate_1.matchesBoolean()),
        discardConfirmationModal: type_validate_1.makeOptional(type_validate_1.matchesBoolean()),
    })),
    saveAction: type_validate_1.makeOptional(type_validate_1.matchesObject({
        disabled: type_validate_1.makeOptional(type_validate_1.matchesBoolean()),
    })),
    leaveConfirmationDisable: type_validate_1.makeOptional(type_validate_1.matchesBoolean()),
}));
function validateProps(props) {
    return type_validate_1.validate(props, exports.contextSaveBarSchema);
}
exports.validateProps = validateProps;
function validateAction(action) {
    var validator = utils_1.createActionValidator(ContextualSaveBar_1.Action, exports.contextSaveBarSchema);
    return type_validate_1.validate(action, validator);
}
exports.validateAction = validateAction;


/***/ }),
/* 86 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = exports.validateAction = exports.validateProps = exports.feedbackModalSchema = void 0;
var FeedbackModal_1 = __webpack_require__(47);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return FeedbackModal_1.Action; } });
var type_validate_1 = __webpack_require__(3);
var utils_1 = __webpack_require__(4);
exports.feedbackModalSchema = type_validate_1.matchesObject({
    formId: type_validate_1.matchesPositiveInteger(),
});
function validateProps(props) {
    return type_validate_1.validate(props, exports.feedbackModalSchema);
}
exports.validateProps = validateProps;
function validateAction(action) {
    switch (action.type) {
        case FeedbackModal_1.Action.OPEN:
            return type_validate_1.validate(action, utils_1.createActionValidator(FeedbackModal_1.Action, exports.feedbackModalSchema, true));
        case FeedbackModal_1.Action.CLOSE:
        default:
            return type_validate_1.validate(action, utils_1.createActionValidator(FeedbackModal_1.Action));
    }
}
exports.validateAction = validateAction;


/***/ }),
/* 87 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = exports.validateAction = void 0;
var LeaveConfirmation_1 = __webpack_require__(28);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return LeaveConfirmation_1.Action; } });
var type_validate_1 = __webpack_require__(3);
var utils_1 = __webpack_require__(4);
function validateAction(action) {
    var validator = utils_1.createActionValidator(LeaveConfirmation_1.Action);
    return type_validate_1.validate(action, validator);
}
exports.validateAction = validateAction;


/***/ }),
/* 88 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.validateAction = exports.validateProps = void 0;
var NavigationMenu_1 = __webpack_require__(29);
var ChannelMenu_1 = __webpack_require__(30);
var type_validate_1 = __webpack_require__(3);
var utils_1 = __webpack_require__(4);
var helper_1 = __webpack_require__(0);
var link_1 = __webpack_require__(48);
var linkOptionsValidator = type_validate_1.matchesObject({ id: type_validate_1.matchesString(), options: link_1.linkPropsSchema });
function activeLinkError(value) {
    return [
        {
            error: 'invalid_active_item',
            value: value,
            message: 'expected active item to exist in menu items',
        },
    ];
}
function getOptionsSchema(options) {
    var baseSchema = type_validate_1.matchesObject({
        items: type_validate_1.makeOptional(type_validate_1.matchesArray(linkOptionsValidator)),
        active: type_validate_1.makeOptional(linkOptionsValidator),
    });
    var items = options.items, active = options.active;
    if (items && active) {
        var activeItemSchema = type_validate_1.matchesObject({
            active: type_validate_1.composeSchemas(linkOptionsValidator, function (value) {
                return items.find(function (item) { return item.id === value.id; }) ? undefined : activeLinkError(value);
            }),
        });
        return type_validate_1.composeSchemas(baseSchema, activeItemSchema);
    }
    return baseSchema;
}
function getPayloadSchema(payload) {
    var baseSchema = type_validate_1.matchesObject({
        items: type_validate_1.makeOptional(type_validate_1.matchesArray(link_1.linkActionSchema)),
        active: type_validate_1.makeOptional(type_validate_1.matchesString()),
    });
    var items = payload.items, active = payload.active;
    if (items && active) {
        var activeItemSchema = type_validate_1.matchesObject({
            active: type_validate_1.composeSchemas(type_validate_1.matchesString(), function (value) {
                return items.find(function (item) { return item.id === value; })
                    ? undefined
                    : activeLinkError(value);
            }),
        });
        return type_validate_1.composeSchemas(baseSchema, activeItemSchema);
    }
    return baseSchema;
}
function validateProps(props) {
    var result = type_validate_1.validate(props, getOptionsSchema(props));
    return result;
}
exports.validateProps = validateProps;
function validateAction(action) {
    var actionType = NavigationMenu_1.Action;
    if (helper_1.findMatchInEnum(ChannelMenu_1.Action, action.type)) {
        actionType = ChannelMenu_1.Action;
    }
    return type_validate_1.validate(action, utils_1.createActionValidator(actionType, getPayloadSchema(action.payload), true, false));
}
exports.validateAction = validateAction;


/***/ }),
/* 89 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = exports.validateAction = exports.validateProps = void 0;
var type_validate_1 = __webpack_require__(3);
var utils_1 = __webpack_require__(4);
var Modal_1 = __webpack_require__(19);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Modal_1.Action; } });
var Button_1 = __webpack_require__(5);
var safe_redirect_1 = __webpack_require__(90);
var button_1 = __webpack_require__(16);
function matchesSafeOrigin(value, localOrigin) {
    var hostName;
    try {
        hostName = new URL(localOrigin).hostname;
    }
    catch (error) {
        return [
            {
                error: 'invalid_app_origin',
                value: localOrigin,
                message: "Provided value for app origin: `" + localOrigin + "` is invalid",
            },
        ];
    }
    var isSafeSrc = safe_redirect_1.isSafe(value, {
        requireAbsolute: true,
        requireSSL: true,
        allowInternalProtocol: true,
        allowedDomains: [hostName],
    });
    if (!isSafeSrc) {
        return [
            {
                error: 'not_matching_app_origin',
                value: value,
                message: "Provided URL origin does not match app origin `" + hostName + "`",
            },
        ];
    }
}
function matchesSize() {
    return function (value) {
        var values = [Modal_1.Size.Small, Modal_1.Size.Medium, Modal_1.Size.Large];
        if (values.includes(value)) {
            return;
        }
        var message = "expected:" + values.map(function (val) { return "`" + val + "`"; }).join(' or ');
        if (value === Modal_1.Size.Full) {
            message += ". Size `" + value + "` is deprecated as of version 1.6.5 and will fall back to size `medium`";
        }
        if (value === Modal_1.Size.Auto) {
            message += ". Size `" + value + "` is deprecated as of version 1.12.x and will fall back to size `medium`. Use the `setUpModalAutoSizing` utility from `app-bridge` instead";
        }
        return [
            {
                error: 'invalid_enum_value',
                value: value,
                message: message,
            },
        ];
    };
}
function getModalSchema(props, localOrigin) {
    if (props === void 0) { props = {}; }
    var baseModalSchema = type_validate_1.matchesObject({
        title: type_validate_1.makeOptional(type_validate_1.matchesString()),
        footer: type_validate_1.makeOptional(type_validate_1.matchesObject({
            buttons: type_validate_1.matchesObject({
                primary: type_validate_1.makeOptional(button_1.buttonSchemaWithId),
                secondary: type_validate_1.makeOptional(type_validate_1.matchesArray(button_1.buttonSchemaWithId)),
            }),
        })),
        size: type_validate_1.makeOptional(matchesSize()),
    });
    if (Modal_1.isIframeModal(props)) {
        if (props.url) {
            var urlSchema = type_validate_1.matchesObject({
                url: type_validate_1.composeSchemas(type_validate_1.matchesString(), function (value) {
                    return localOrigin ? matchesSafeOrigin(value, localOrigin) : undefined;
                }),
            });
            return type_validate_1.composeSchemas(baseModalSchema, urlSchema);
        }
        return type_validate_1.composeSchemas(baseModalSchema, utils_1.relativePathSchema);
    }
    return type_validate_1.composeSchemas(baseModalSchema, type_validate_1.matchesObject({ message: type_validate_1.matchesString() }));
}
function validateProps(props, localOrigin) {
    return type_validate_1.validate(props, getModalSchema(props, localOrigin));
}
exports.validateProps = validateProps;
function validateAction(action, localOrigin) {
    var schema = getModalSchema(action.payload, localOrigin);
    switch (action.type) {
        case Modal_1.Action.OPEN:
        case Modal_1.Action.UPDATE:
            return type_validate_1.validate(action, utils_1.createActionValidator(Modal_1.Action, schema, true, action.type === Modal_1.Action.UPDATE));
        case Modal_1.Action.FOOTER_BUTTON_CLICK:
            return button_1.validateAction(__assign(__assign({}, action), { type: Button_1.Action.CLICK }));
        case Modal_1.Action.FOOTER_BUTTON_UPDATE:
            return button_1.validateAction(__assign(__assign({}, action), { type: Button_1.Action.UPDATE }));
        case Modal_1.Action.CLOSE:
        default:
            return type_validate_1.validate(action, utils_1.createActionValidator(Modal_1.Action));
    }
}
exports.validateAction = validateAction;


/***/ }),
/* 90 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.isSafe = void 0;
var constants_1 = __webpack_require__(91);
var FILE_URI_MATCH = /\/\/\//;
var INVALID_RELATIVE_URL = /[/\\][/\\]/;
var VALID_PROTOCOLS = ['https:', 'http:'];
var DUMMY_HOSTNAME = 'http://test.com';
function isSafe(redirectUrl, _a) {
    var _b = _a === void 0 ? {} : _a, _c = _b.allowedDomains, allowedDomains = _c === void 0 ? [] : _c, _d = _b.subdomains, subdomains = _d === void 0 ? [] : _d, matchPath = _b.matchPath, requireAbsolute = _b.requireAbsolute, requireSSL = _b.requireSSL, allowInternalProtocol = _b.allowInternalProtocol;
    if (FILE_URI_MATCH.test(redirectUrl)) {
        return false;
    }
    if (redirectUrl.startsWith('/')) {
        if (allowedDomains.length > 0 || subdomains.length > 0 || requireAbsolute || requireSSL) {
            return false;
        }
        if (matchPath) {
            // Creating a new URL expands the pathname in case of things like `/a/../b`
            return pathMatches(new URL(redirectUrl, DUMMY_HOSTNAME), redirectUrl, matchPath);
        }
        return !INVALID_RELATIVE_URL.test(redirectUrl);
    }
    var url;
    try {
        url = new URL(redirectUrl);
    }
    catch (error) {
        return false;
    }
    if (allowInternalProtocol && url.protocol === constants_1.INTERNAL_PROTOCOL) {
        return true;
    }
    if (!VALID_PROTOCOLS.includes(url.protocol)) {
        return false;
    }
    if (requireSSL && url.protocol !== 'https:') {
        return false;
    }
    if (url.username || url.password) {
        return false;
    }
    if (matchPath && !pathMatches(url, redirectUrl, matchPath)) {
        return false;
    }
    if (!hostIsValid(url, allowedDomains, subdomains)) {
        return false;
    }
    return true;
}
exports.isSafe = isSafe;
function hostIsValid(url, allowedDomains, subdomains) {
    if (!subdomains.every(function (subdomain) { return subdomain.startsWith('.'); })) {
        throw new TypeError('Subdomains must begin with .');
    }
    var hostname = url.hostname;
    return ((allowedDomains.length === 0 && subdomains.length === 0) ||
        allowedDomains.includes(hostname) ||
        subdomains.some(function (subdomain) { return hostname.endsWith(subdomain); }));
}
function pathMatches(url, originalUrl, matcher) {
    var pathname = url.pathname;
    // Gets just the unresolve pathname, i.e., `http://foo.com/a/../b => /a/../b
    var originalPathname = originalUrl.replace(url.origin, '').split('?')[0];
    return typeof matcher === 'string'
        ? pathname === matcher && originalPathname === matcher
        : matcher.test(pathname) && matcher.test(originalPathname);
}


/***/ }),
/* 91 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.INTERNAL_PROTOCOL = void 0;
exports.INTERNAL_PROTOCOL = 'shopify:';


/***/ }),
/* 92 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.validateAction = exports.getSectionSchema = exports.matchesAbsolutePath = void 0;
var History = __importStar(__webpack_require__(31));
var Redirect = __importStar(__webpack_require__(18));
var type_validate_1 = __webpack_require__(3);
var utils_1 = __webpack_require__(4);
function matchesAbsolutePath(value) {
    return value.match('^https?://')
        ? undefined
        : [
            {
                value: value,
                error: 'invalid_absolute_url',
                message: 'expected string to start with `https://` or `http://`',
            },
        ];
}
exports.matchesAbsolutePath = matchesAbsolutePath;
function getSectionSchema(payload) {
    var isProductVariant = payload &&
        payload.section &&
        payload.section.resource &&
        payload.section.name === Redirect.ResourceType.Product;
    var resourceSchema = {
        create: type_validate_1.makeOptional(type_validate_1.matchesBoolean()),
        id: type_validate_1.makeOptional(type_validate_1.matchesString()),
    };
    var productVariantSchema = __assign(__assign({}, resourceSchema), { variant: type_validate_1.makeOptional(type_validate_1.matchesObject(resourceSchema)) });
    return type_validate_1.matchesObject({
        section: type_validate_1.matchesObject({
            name: type_validate_1.matchesEnum(Redirect.ResourceType),
            resource: type_validate_1.makeOptional(type_validate_1.matchesObject(isProductVariant ? productVariantSchema : resourceSchema)),
        }),
    });
}
exports.getSectionSchema = getSectionSchema;
function validateAction(action) {
    var newContextSchema = type_validate_1.matchesObject({ newContext: type_validate_1.makeOptional(type_validate_1.matchesBoolean()) });
    var actionType = Redirect.Action;
    var schema;
    switch (action.type) {
        case History.Action.PUSH:
        case History.Action.REPLACE:
            actionType = History.Action;
            schema = utils_1.relativePathSchema;
            break;
        case Redirect.Action.APP:
            schema = utils_1.relativePathSchema;
            break;
        case Redirect.Action.REMOTE:
            schema = type_validate_1.composeSchemas(type_validate_1.matchesObject({
                url: type_validate_1.composeSchemas(type_validate_1.matchesString(), function (value) { return matchesAbsolutePath(value); }),
            }), newContextSchema);
            break;
        case Redirect.Action.ADMIN_PATH:
            schema = type_validate_1.composeSchemas(utils_1.relativePathSchema, newContextSchema);
            break;
        case Redirect.Action.ADMIN_SECTION:
            schema = type_validate_1.composeSchemas(getSectionSchema(action.payload), newContextSchema);
            break;
    }
    return type_validate_1.validate(action, utils_1.createActionValidator(actionType, schema));
}
exports.validateAction = validateAction;


/***/ }),
/* 93 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = exports.validateAction = exports.validateProps = void 0;
var ResourcePicker_1 = __webpack_require__(32);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return ResourcePicker_1.Action; } });
var type_validate_1 = __webpack_require__(3);
var utils_1 = __webpack_require__(4);
var resourceSelectionSchema = type_validate_1.matchesArray(type_validate_1.matchesObject({
    id: type_validate_1.matchesString(),
}));
var resourcePickerOptions = type_validate_1.matchesObject({
    initialQuery: type_validate_1.makeOptional(type_validate_1.matchesString()),
    filterQuery: type_validate_1.makeOptional(type_validate_1.matchesString()),
    initialSelectionIds: type_validate_1.makeOptional(resourceSelectionSchema),
    selectMultiple: type_validate_1.makeOptional(type_validate_1.oneOf(type_validate_1.matchesBoolean(), type_validate_1.matchesPositiveInteger())),
    showHidden: type_validate_1.makeOptional(type_validate_1.matchesBoolean()),
    showVariants: type_validate_1.makeOptional(type_validate_1.matchesBoolean()),
    showDraft: type_validate_1.makeOptional(type_validate_1.matchesBoolean()),
    showArchived: type_validate_1.makeOptional(type_validate_1.matchesBoolean()),
    showDraftBadge: type_validate_1.makeOptional(type_validate_1.matchesBoolean()),
    showArchivedBadge: type_validate_1.makeOptional(type_validate_1.matchesBoolean()),
    actionVerb: type_validate_1.makeOptional(type_validate_1.matchesEnum(ResourcePicker_1.ActionVerb)),
});
var resourcePickerActionSchema = type_validate_1.matchesObject({
    resourceType: type_validate_1.matchesEnum(ResourcePicker_1.ResourceType),
    options: type_validate_1.makeOptional(resourcePickerOptions),
});
var selectionSchema = type_validate_1.matchesObject({
    selection: resourceSelectionSchema,
});
function validateProps(props) {
    return type_validate_1.validate(props, resourcePickerOptions);
}
exports.validateProps = validateProps;
function validateAction(action) {
    switch (action.type) {
        case ResourcePicker_1.Action.UPDATE:
        case ResourcePicker_1.Action.OPEN:
            return type_validate_1.validate(action, utils_1.createActionValidator(ResourcePicker_1.Action, resourcePickerActionSchema, false, true));
        case ResourcePicker_1.Action.SELECT:
            return type_validate_1.validate(action, utils_1.createActionValidator(ResourcePicker_1.Action, selectionSchema, true, true));
        case ResourcePicker_1.Action.CANCEL:
        case ResourcePicker_1.Action.CLOSE:
        default:
            return type_validate_1.validate(action, utils_1.createActionValidator(ResourcePicker_1.Action));
    }
}
exports.validateAction = validateAction;


/***/ }),
/* 94 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = exports.validateAction = exports.validateProps = exports.titleBarSchema = void 0;
var TitleBar_1 = __webpack_require__(33);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return TitleBar_1.Action; } });
var Button_1 = __webpack_require__(5);
var ButtonGroup_1 = __webpack_require__(9);
var type_validate_1 = __webpack_require__(3);
var utils_1 = __webpack_require__(4);
var button_1 = __webpack_require__(16);
var buttonGroup_1 = __webpack_require__(45);
var buttonSchemaWithId = type_validate_1.composeSchemas(button_1.buttonSchema, type_validate_1.matchesObject({
    id: type_validate_1.matchesString(),
}));
exports.titleBarSchema = type_validate_1.matchesObject({
    breadcrumbs: type_validate_1.makeOptional(button_1.buttonSchema),
    title: type_validate_1.makeOptional(type_validate_1.matchesString()),
    buttons: type_validate_1.makeOptional(type_validate_1.matchesObject({
        primary: type_validate_1.makeOptional(buttonSchemaWithId),
        secondary: type_validate_1.makeOptional(type_validate_1.matchesArray(type_validate_1.composeSchemas(buttonSchemaWithId, type_validate_1.matchesObject({
            buttons: type_validate_1.makeOptional(type_validate_1.matchesArray(buttonSchemaWithId)),
        })))),
    })),
});
function validateProps(props) {
    return type_validate_1.validate(props, exports.titleBarSchema);
}
exports.validateProps = validateProps;
function validateAction(action) {
    switch (action.type) {
        default:
        case TitleBar_1.Action.UPDATE:
            return type_validate_1.validate(action, utils_1.createActionValidator(TitleBar_1.Action, exports.titleBarSchema, true, false));
        case TitleBar_1.Action.BUTTON_CLICK:
        case TitleBar_1.Action.BREADCRUMBS_CLICK:
            return button_1.validateAction(__assign(__assign({}, action), { type: Button_1.Action.CLICK }));
        case TitleBar_1.Action.BUTTON_UPDATE:
        case TitleBar_1.Action.BREADCRUMBS_UPDATE:
            return button_1.validateAction(__assign(__assign({}, action), { type: Button_1.Action.UPDATE }));
        case TitleBar_1.Action.BUTTON_GROUP_UPDATE:
            return buttonGroup_1.validateAction(__assign(__assign({}, action), { type: ButtonGroup_1.Action.UPDATE }));
    }
}
exports.validateAction = validateAction;


/***/ }),
/* 95 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getGroupedButton = void 0;
var ButtonGroup_1 = __webpack_require__(9);
function getGroupedButton(action, button, subgroups, updateCb) {
    action.addChild(button, action.group, subgroups);
    var id = button.id, label = button.label, disabled = button.disabled, buttons = button.buttons, plain = button.plain;
    action.subscribeToChild(button, ButtonGroup_1.Action.UPDATE, updateCb);
    return { id: id, label: label, buttons: buttons, disabled: disabled, plain: plain };
}
exports.getGroupedButton = getGroupedButton;


/***/ }),
/* 96 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = exports.validateProps = exports.validateAction = exports.toastSchema = void 0;
var Toast_1 = __webpack_require__(20);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Toast_1.Action; } });
var type_validate_1 = __webpack_require__(3);
var utils_1 = __webpack_require__(4);
exports.toastSchema = type_validate_1.matchesObject({
    message: type_validate_1.matchesString(),
    duration: type_validate_1.matchesPositiveInteger(),
    isError: type_validate_1.makeOptional(type_validate_1.matchesBoolean()),
    action: type_validate_1.makeOptional(type_validate_1.matchesObject({
        content: type_validate_1.matchesString(),
    })),
});
function validateAction(action) {
    switch (action.type) {
        case Toast_1.Action.SHOW:
            return type_validate_1.validate(action, utils_1.createActionValidator(Toast_1.Action, exports.toastSchema, true));
        default:
            return type_validate_1.validate(action, utils_1.createActionValidator(Toast_1.Action));
    }
}
exports.validateAction = validateAction;
function validateProps(props) {
    return type_validate_1.validate(props, exports.toastSchema);
}
exports.validateProps = validateProps;


/***/ }),
/* 97 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = exports.validateAction = exports.validateProps = void 0;
var Picker_1 = __webpack_require__(34);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Picker_1.Action; } });
var type_validate_1 = __webpack_require__(3);
var utils_1 = __webpack_require__(4);
var resourceBadge = type_validate_1.matchesObject({
    content: type_validate_1.matchesString(),
    id: type_validate_1.matchesString(),
    progress: type_validate_1.matchesEnum(Picker_1.ALL_BADGE_PROGRESSES),
    status: type_validate_1.matchesEnum(Picker_1.ALL_BADGE_STATUSES),
});
var resourceMedia = type_validate_1.matchesObject({
    accessibilityLabel: type_validate_1.makeOptional(type_validate_1.matchesString()),
    alt: type_validate_1.makeOptional(type_validate_1.matchesString()),
    initials: type_validate_1.makeOptional(type_validate_1.matchesString()),
    kind: type_validate_1.makeOptional(type_validate_1.matchesEnum(Picker_1.ALL_MEDIA_KINDS)),
    name: type_validate_1.makeOptional(type_validate_1.matchesString()),
    source: type_validate_1.matchesString(),
});
var sharedResourceSchema = {
    accessibilityLabel: type_validate_1.makeOptional(type_validate_1.matchesString()),
    badges: type_validate_1.makeOptional(type_validate_1.matchesArray(resourceBadge)),
    disabled: type_validate_1.makeOptional(type_validate_1.matchesBoolean()),
    id: type_validate_1.matchesString(),
    loading: type_validate_1.makeOptional(type_validate_1.matchesBoolean()),
    media: type_validate_1.makeOptional(resourceMedia),
    name: type_validate_1.makeOptional(type_validate_1.matchesString()),
    caption: type_validate_1.makeOptional(type_validate_1.matchesString()),
    selectable: type_validate_1.makeOptional(type_validate_1.matchesBoolean()),
};
var resourceOption = type_validate_1.matchesObject(__assign({}, sharedResourceSchema));
var resourceSelectionSchema = type_validate_1.matchesArray(type_validate_1.matchesObject(__assign(__assign({}, sharedResourceSchema), { options: type_validate_1.makeOptional(type_validate_1.matchesArray(resourceOption)) })));
var resourceName = type_validate_1.matchesObject({
    plural: type_validate_1.matchesString(),
    singular: type_validate_1.matchesString(),
});
var pickerOptions = type_validate_1.matchesObject({
    canLoadMore: type_validate_1.makeOptional(type_validate_1.matchesBoolean()),
    emptySearchLabel: type_validate_1.makeOptional(type_validate_1.matchesObject({
        title: type_validate_1.matchesString(),
        description: type_validate_1.matchesString(),
        withIllustration: type_validate_1.matchesBoolean(),
    })),
    items: type_validate_1.makeOptional(resourceSelectionSchema),
    loading: type_validate_1.makeOptional(type_validate_1.matchesBoolean()),
    loadingMore: type_validate_1.makeOptional(type_validate_1.matchesBoolean()),
    maxSelectable: type_validate_1.makeOptional(type_validate_1.matchesPositiveInteger()),
    primaryActionLabel: type_validate_1.makeOptional(type_validate_1.matchesString()),
    searchQuery: type_validate_1.makeOptional(type_validate_1.matchesString()),
    searchQueryPlaceholder: type_validate_1.makeOptional(type_validate_1.matchesString()),
    secondaryActionLabel: type_validate_1.makeOptional(type_validate_1.matchesString()),
    selectedItems: type_validate_1.makeOptional(type_validate_1.matchesArray(type_validate_1.matchesObject(sharedResourceSchema))),
    title: type_validate_1.makeOptional(type_validate_1.matchesString()),
    verticalAlignment: type_validate_1.makeOptional(type_validate_1.matchesEnum(Picker_1.ALL_RESOURCE_VERTICAL_ALIGNMENT)),
    allowEmptySelection: type_validate_1.makeOptional(type_validate_1.matchesBoolean()),
    resourceName: type_validate_1.makeOptional(resourceName),
});
var pickerActionSchema = type_validate_1.matchesObject({
    options: type_validate_1.makeOptional(resourceSelectionSchema),
});
var selectionSchema = type_validate_1.matchesObject({
    selectedItems: resourceSelectionSchema,
});
var searchSchema = type_validate_1.matchesObject({
    searchQuery: type_validate_1.makeOptional(type_validate_1.matchesString()),
});
/**
 * @unstable This API may be updated without warning in the future
 */
function validateProps(props) {
    return type_validate_1.validate(props, pickerOptions);
}
exports.validateProps = validateProps;
/**
 * @unstable This API may be updated without warning in the future
 */
function validateAction(action) {
    switch (action.type) {
        case Picker_1.Action.UPDATE:
        case Picker_1.Action.OPEN:
            return type_validate_1.validate(action, utils_1.createActionValidator(Picker_1.Action, pickerActionSchema, false, true));
        case Picker_1.Action.SELECT:
            return type_validate_1.validate(action, utils_1.createActionValidator(Picker_1.Action, selectionSchema, true, true));
        case Picker_1.Action.SEARCH:
            return type_validate_1.validate(action, utils_1.createActionValidator(Picker_1.Action, searchSchema, true, true));
        case Picker_1.Action.CANCEL:
        case Picker_1.Action.LOAD_MORE:
            return type_validate_1.validate(action, utils_1.createActionValidator(Picker_1.Action));
        default:
            return type_validate_1.validate(action, utils_1.createActionValidator(Picker_1.Action));
    }
}
exports.validateAction = validateAction;


/***/ }),
/* 98 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = exports.validateAction = void 0;
var Cart_1 = __webpack_require__(49);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Cart_1.Action; } });
var type_validate_1 = __webpack_require__(10);
var utils_1 = __webpack_require__(8);
var addressSchema = type_validate_1.matchesObject({
    address1: type_validate_1.makeOptional(type_validate_1.matchesString()),
    address2: type_validate_1.makeOptional(type_validate_1.matchesString()),
    city: type_validate_1.makeOptional(type_validate_1.matchesString()),
    company: type_validate_1.makeOptional(type_validate_1.matchesString()),
    firstName: type_validate_1.makeOptional(type_validate_1.matchesString()),
    lastName: type_validate_1.makeOptional(type_validate_1.matchesString()),
    phone: type_validate_1.makeOptional(type_validate_1.matchesString()),
    province: type_validate_1.makeOptional(type_validate_1.matchesString()),
    country: type_validate_1.makeOptional(type_validate_1.matchesString()),
    zip: type_validate_1.makeOptional(type_validate_1.matchesString()),
    name: type_validate_1.makeOptional(type_validate_1.matchesString()),
    provinceCode: type_validate_1.makeOptional(type_validate_1.matchesString()),
    countryCode: type_validate_1.makeOptional(type_validate_1.matchesString()),
});
var discountSchema = type_validate_1.matchesObject({
    amount: type_validate_1.makeOptional(type_validate_1.matchesPositiveInteger()),
    discountDescription: type_validate_1.makeOptional(type_validate_1.matchesString()),
    type: type_validate_1.makeOptional(type_validate_1.matchesString()),
    discountCode: type_validate_1.makeOptional(type_validate_1.matchesString()),
});
var discountAmount = type_validate_1.matchesObject({
    amount: type_validate_1.matchesPositiveNumber(),
    discountDescription: type_validate_1.makeOptional(type_validate_1.matchesString()),
    type: type_validate_1.makeOptional(type_validate_1.matchesString()),
});
var discountCode = type_validate_1.matchesObject({
    discountCode: type_validate_1.matchesString(),
});
var lineItemSchema = type_validate_1.matchesObject({
    price: type_validate_1.makeOptional(type_validate_1.matchesPositiveNumber()),
    quantity: type_validate_1.makeOptional(type_validate_1.matchesPositiveInteger()),
    title: type_validate_1.makeOptional(type_validate_1.matchesString()),
    variantId: type_validate_1.makeOptional(type_validate_1.matchesPositiveInteger()),
    discount: type_validate_1.makeOptional(discountAmount),
});
var updateLineItemSchema = type_validate_1.matchesObject({
    quantity: type_validate_1.matchesPositiveInteger(),
});
var customerSchema = type_validate_1.matchesObject({
    id: type_validate_1.makeOptional(type_validate_1.matchesPositiveInteger()),
    email: type_validate_1.makeOptional(type_validate_1.matchesString()),
    firstName: type_validate_1.makeOptional(type_validate_1.matchesString()),
    lastName: type_validate_1.makeOptional(type_validate_1.matchesString()),
    note: type_validate_1.makeOptional(type_validate_1.matchesString()),
    addresses: type_validate_1.makeOptional(type_validate_1.matchesArray(addressSchema)),
});
var noteSchema = type_validate_1.matchesObject({
    name: type_validate_1.matchesString(),
    value: type_validate_1.matchesString(),
});
var cartSchema = type_validate_1.matchesObject({
    cartDiscount: type_validate_1.makeOptional(discountSchema),
    customer: type_validate_1.makeOptional(customerSchema),
    grandTotal: type_validate_1.makeOptional(type_validate_1.matchesString()),
    lineItems: type_validate_1.makeOptional(type_validate_1.matchesArray(lineItemSchema)),
    noteAttributes: type_validate_1.makeOptional(type_validate_1.matchesArray(noteSchema)),
    subTotal: type_validate_1.makeOptional(type_validate_1.matchesString()),
    taxTotal: type_validate_1.makeOptional(type_validate_1.matchesString()),
});
var propertiesSchema = type_validate_1.composeSchemas(type_validate_1.matchesObject({}), function (value) {
    var validator = type_validate_1.matchesString();
    var schema = Object.keys(value).reduce(function (acc, key) {
        acc[key] = validator;
        return acc;
    }, {});
    return type_validate_1.validate(value, type_validate_1.matchesObject(schema));
});
var matchesStringArray = type_validate_1.matchesArray(type_validate_1.matchesString());
function createDataValidator(data) {
    return utils_1.createActionValidator(Cart_1.Action, data ? type_validate_1.matchesObject({ data: data }) : undefined, true, true);
}
function createDataValidatorWithIndex(data) {
    var indexSchema = type_validate_1.matchesObject({ index: type_validate_1.matchesPositiveInteger() });
    if (data) {
        var dataSchema = type_validate_1.matchesObject({ data: data });
        return utils_1.createActionValidator(Cart_1.Action, type_validate_1.composeSchemas(indexSchema, dataSchema), true, true);
    }
    return utils_1.createActionValidator(Cart_1.Action, indexSchema, true, true);
}
function getDiscountSchema(data) {
    if (data.amount) {
        return discountAmount;
    }
    return discountCode;
}
function validateAction(action) {
    switch (action.type) {
        case Cart_1.Action.UPDATE:
            return type_validate_1.validate(action, createDataValidator(cartSchema));
        case Cart_1.Action.SET_CUSTOMER:
            return type_validate_1.validate(action, createDataValidator(customerSchema));
        case Cart_1.Action.ADD_CUSTOMER_ADDRESS:
            return type_validate_1.validate(action, createDataValidator(addressSchema));
        case Cart_1.Action.UPDATE_CUSTOMER_ADDRESS:
            return type_validate_1.validate(action, createDataValidatorWithIndex(addressSchema));
        case Cart_1.Action.SET_DISCOUNT:
            return type_validate_1.validate(action, createDataValidator(getDiscountSchema(action.payload.data)));
        case Cart_1.Action.SET_PROPERTIES:
            return type_validate_1.validate(action, createDataValidator(propertiesSchema));
        case Cart_1.Action.REMOVE_PROPERTIES:
            return type_validate_1.validate(action, createDataValidator(matchesStringArray));
        case Cart_1.Action.ADD_LINE_ITEM:
            return type_validate_1.validate(action, createDataValidator(lineItemSchema));
        case Cart_1.Action.UPDATE_LINE_ITEM:
            return type_validate_1.validate(action, createDataValidatorWithIndex(updateLineItemSchema));
        case Cart_1.Action.REMOVE_LINE_ITEM:
            return type_validate_1.validate(action, createDataValidatorWithIndex());
        case Cart_1.Action.SET_LINE_ITEM_DISCOUNT:
            return type_validate_1.validate(action, createDataValidatorWithIndex(discountAmount));
        case Cart_1.Action.REMOVE_LINE_ITEM_DISCOUNT:
            return type_validate_1.validate(action, createDataValidatorWithIndex());
        case Cart_1.Action.SET_LINE_ITEM_PROPERTIES:
            return type_validate_1.validate(action, createDataValidatorWithIndex(propertiesSchema));
        case Cart_1.Action.REMOVE_LINE_ITEM_PROPERTIES:
            return type_validate_1.validate(action, createDataValidatorWithIndex(matchesStringArray));
        case Cart_1.Action.FETCH:
        case Cart_1.Action.REMOVE_CUSTOMER:
        case Cart_1.Action.REMOVE_DISCOUNT:
        case Cart_1.Action.CLEAR:
        default:
            return type_validate_1.validate(action, utils_1.createActionValidator(Cart_1.Action, undefined, false, true));
    }
}
exports.validateAction = validateAction;


/***/ }),
/* 99 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cart = exports.setLineItemProperties = exports.removeLineItemDiscount = exports.setLineItemDiscount = exports.removeLineItem = exports.updateLineItem = exports.addLineItem = exports.removeProperties = exports.setProperties = exports.setDiscount = exports.updateCustomerAddress = exports.addCustomerAddress = exports.setCustomer = exports.update = exports.fetch = exports.Action = void 0;
var helper_1 = __webpack_require__(0);
var ActionSet_1 = __webpack_require__(2);
var types_1 = __webpack_require__(1);
var Action;
(function (Action) {
    Action["FETCH"] = "APP::CART::FETCH";
    Action["UPDATE"] = "APP::CART::UPDATE";
    Action["SET_CUSTOMER"] = "APP::CART::SET_CUSTOMER";
    Action["REMOVE_CUSTOMER"] = "APP::CART::REMOVE_CUSTOMER";
    Action["ADD_CUSTOMER_ADDRESS"] = "APP::CART::ADD_CUSTOMER_ADDRESS";
    Action["UPDATE_CUSTOMER_ADDRESS"] = "APP::CART::UPDATE_CUSTOMER_ADDRESS";
    Action["SET_DISCOUNT"] = "APP::CART::SET_DISCOUNT";
    Action["REMOVE_DISCOUNT"] = "APP::CART::REMOVE_DISCOUNT";
    Action["SET_PROPERTIES"] = "APP::CART::SET_PROPERTIES";
    Action["REMOVE_PROPERTIES"] = "APP::CART::REMOVE_PROPERTIES";
    Action["CLEAR"] = "APP::CART::CLEAR";
    Action["ADD_LINE_ITEM"] = "APP::CART::ADD_LINE_ITEM";
    Action["UPDATE_LINE_ITEM"] = "APP::CART::UPDATE_LINE_ITEM";
    Action["REMOVE_LINE_ITEM"] = "APP::CART::REMOVE_LINE_ITEM";
    Action["SET_LINE_ITEM_DISCOUNT"] = "APP::CART::SET_LINE_ITEM_DISCOUNT";
    Action["REMOVE_LINE_ITEM_DISCOUNT"] = "APP::CART::REMOVE_LINE_ITEM_DISCOUNT";
    Action["SET_LINE_ITEM_PROPERTIES"] = "APP::CART::SET_LINE_ITEM_PROPERTIES";
    Action["REMOVE_LINE_ITEM_PROPERTIES"] = "APP::CART::REMOVE_LINE_ITEM_PROPERTIES";
})(Action = exports.Action || (exports.Action = {}));
/**
 * Cart action
 * @internal
 */
function createCartAction(type, payload) {
    if (payload === void 0) { payload = {}; }
    return helper_1.actionWrapper({
        group: types_1.Group.Cart,
        type: type,
        payload: payload,
    });
}
function fetch() {
    return createCartAction(Action.FETCH);
}
exports.fetch = fetch;
function update(payload) {
    return createCartAction(Action.UPDATE, payload);
}
exports.update = update;
function setCustomer(payload) {
    return createCartAction(Action.SET_CUSTOMER, payload);
}
exports.setCustomer = setCustomer;
function addCustomerAddress(payload) {
    return createCartAction(Action.ADD_CUSTOMER_ADDRESS, payload);
}
exports.addCustomerAddress = addCustomerAddress;
function updateCustomerAddress(payload) {
    return createCartAction(Action.UPDATE_CUSTOMER_ADDRESS, payload);
}
exports.updateCustomerAddress = updateCustomerAddress;
function setDiscount(payload) {
    return createCartAction(Action.SET_DISCOUNT, payload);
}
exports.setDiscount = setDiscount;
function setProperties(payload) {
    return createCartAction(Action.SET_PROPERTIES, payload);
}
exports.setProperties = setProperties;
function removeProperties(payload) {
    return createCartAction(Action.REMOVE_PROPERTIES, payload);
}
exports.removeProperties = removeProperties;
function addLineItem(payload) {
    return createCartAction(Action.ADD_LINE_ITEM, payload);
}
exports.addLineItem = addLineItem;
function updateLineItem(payload) {
    return createCartAction(Action.UPDATE_LINE_ITEM, payload);
}
exports.updateLineItem = updateLineItem;
function removeLineItem(payload) {
    return createCartAction(Action.REMOVE_LINE_ITEM, payload);
}
exports.removeLineItem = removeLineItem;
function setLineItemDiscount(payload) {
    return createCartAction(Action.SET_LINE_ITEM_DISCOUNT, payload);
}
exports.setLineItemDiscount = setLineItemDiscount;
function removeLineItemDiscount(payload) {
    return createCartAction(Action.REMOVE_LINE_ITEM_DISCOUNT, payload);
}
exports.removeLineItemDiscount = removeLineItemDiscount;
function setLineItemProperties(payload) {
    return createCartAction(Action.SET_LINE_ITEM_PROPERTIES, payload);
}
exports.setLineItemProperties = setLineItemProperties;
/**
 * Cart
 */
var Cart = /** @class */ (function (_super) {
    __extends(Cart, _super);
    function Cart(app, options) {
        return _super.call(this, app, types_1.Group.Cart, types_1.Group.Cart, options ? options.id : undefined) || this;
    }
    Cart.prototype.dispatch = function (action, payload) {
        switch (action) {
            case Action.FETCH:
                this.dispatchCartAction(Action.FETCH);
                break;
            case Action.UPDATE:
                this.dispatchCartAction(Action.UPDATE, payload);
                break;
            case Action.SET_CUSTOMER:
                this.dispatchCartAction(Action.SET_CUSTOMER, payload);
                break;
            case Action.REMOVE_CUSTOMER:
                this.dispatchCartAction(Action.REMOVE_CUSTOMER, payload);
                break;
            case Action.ADD_CUSTOMER_ADDRESS:
                this.dispatchCartAction(Action.ADD_CUSTOMER_ADDRESS, payload);
                break;
            case Action.UPDATE_CUSTOMER_ADDRESS:
                this.dispatchCartAction(Action.UPDATE_CUSTOMER_ADDRESS, payload);
                break;
            case Action.SET_DISCOUNT:
                this.dispatchCartAction(Action.SET_DISCOUNT, payload);
                break;
            case Action.REMOVE_DISCOUNT:
                this.dispatchCartAction(Action.REMOVE_DISCOUNT, payload);
                break;
            case Action.SET_PROPERTIES:
                this.dispatchCartAction(Action.SET_PROPERTIES, payload);
                break;
            case Action.REMOVE_PROPERTIES:
                this.dispatchCartAction(Action.REMOVE_PROPERTIES, payload);
                break;
            case Action.CLEAR:
                this.dispatchCartAction(Action.CLEAR, payload);
                break;
            case Action.ADD_LINE_ITEM:
                this.dispatchCartAction(Action.ADD_LINE_ITEM, payload);
                break;
            case Action.UPDATE_LINE_ITEM:
                this.dispatchCartAction(Action.UPDATE_LINE_ITEM, payload);
                break;
            case Action.REMOVE_LINE_ITEM:
                this.dispatchCartAction(Action.REMOVE_LINE_ITEM, payload);
                break;
            case Action.SET_LINE_ITEM_DISCOUNT:
                this.dispatchCartAction(Action.SET_LINE_ITEM_DISCOUNT, payload);
                break;
            case Action.REMOVE_LINE_ITEM_DISCOUNT:
                this.dispatchCartAction(Action.REMOVE_LINE_ITEM_DISCOUNT, payload);
                break;
            case Action.SET_LINE_ITEM_PROPERTIES:
                this.dispatchCartAction(Action.SET_LINE_ITEM_PROPERTIES, payload);
                break;
            case Action.REMOVE_LINE_ITEM_PROPERTIES:
                this.dispatchCartAction(Action.REMOVE_LINE_ITEM_PROPERTIES, payload);
                break;
        }
        return this;
    };
    Cart.prototype.dispatchCartAction = function (type, payload) {
        this.app.dispatch(createCartAction(type, __assign(__assign({}, payload), { id: this.id })));
    };
    return Cart;
}(ActionSet_1.ActionSet));
exports.Cart = Cart;


/***/ }),
/* 100 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = exports.validateAction = void 0;
var Fullscreen_1 = __webpack_require__(50);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Fullscreen_1.Action; } });
var type_validate_1 = __webpack_require__(10);
var utils_1 = __webpack_require__(8);
/**
 * Performs validation for an fullscreen action
 * @param action the action being dispatched
 * @returns undefined or an array of validation errors
 *
 * @beta
 */
function validateAction(action) {
    var validator = utils_1.createActionValidator(Fullscreen_1.Action);
    return type_validate_1.validate(action, validator);
}
exports.validateAction = validateAction;


/***/ }),
/* 101 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = exports.validateAction = void 0;
var Loading_1 = __webpack_require__(52);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Loading_1.Action; } });
var type_validate_1 = __webpack_require__(10);
var utils_1 = __webpack_require__(8);
function validateAction(action) {
    var validator = utils_1.createActionValidator(Loading_1.Action);
    return type_validate_1.validate(action, validator);
}
exports.validateAction = validateAction;


/***/ }),
/* 102 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = exports.validateAction = void 0;
var Print_1 = __webpack_require__(21);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Print_1.Action; } });
var type_validate_1 = __webpack_require__(10);
var utils_1 = __webpack_require__(8);
function validateAction(action) {
    return type_validate_1.validate(action, utils_1.createActionValidator(Print_1.Action));
}
exports.validateAction = validateAction;


/***/ }),
/* 103 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = exports.validateAction = void 0;
var Scanner_1 = __webpack_require__(54);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Scanner_1.Action; } });
var type_validate_1 = __webpack_require__(10);
var utils_1 = __webpack_require__(8);
function validateAction(action) {
    return type_validate_1.validate(action, utils_1.createActionValidator(Scanner_1.Action));
}
exports.validateAction = validateAction;


/***/ }),
/* 104 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.capture = exports.openCamera = exports.Scanner = exports.Action = void 0;
var helper_1 = __webpack_require__(0);
var ActionSet_1 = __webpack_require__(2);
var types_1 = __webpack_require__(1);
/**
 * Action Types for the Features group
 * @public
 */
var Action;
(function (Action) {
    Action["OPEN_CAMERA"] = "APP::SCANNER::OPEN::CAMERA";
    Action["CAPTURE"] = "APP::SCANNER::CAPTURE";
})(Action = exports.Action || (exports.Action = {}));
/**
 * A set of Actions for displaying a Camera Scanner component
 * @public
 */
var Scanner = /** @class */ (function (_super) {
    __extends(Scanner, _super);
    function Scanner(app, options) {
        return _super.call(this, app, types_1.Group.Scanner, types_1.Group.Scanner, options ? options.id : undefined) || this;
    }
    /**
     * @public
     */
    Scanner.prototype.dispatch = function (action) {
        switch (action) {
            case Action.OPEN_CAMERA:
                this.dispatchScannerAction(Action.OPEN_CAMERA);
                break;
        }
        return this;
    };
    /**
     * @internal
     */
    Scanner.prototype.dispatchScannerAction = function (type) {
        this.app.dispatch(helper_1.actionWrapper({
            type: type,
            group: types_1.Group.Scanner,
            payload: {
                id: this.id,
            },
        }));
    };
    return Scanner;
}(ActionSet_1.ActionSet));
exports.Scanner = Scanner;
function openCamera() {
    return helper_1.actionWrapper({
        group: types_1.Group.Scanner,
        type: Action.OPEN_CAMERA,
    });
}
exports.openCamera = openCamera;
function capture(payload) {
    return helper_1.actionWrapper({
        group: types_1.Group.Scanner,
        type: Action.CAPTURE,
        payload: payload,
    });
}
exports.capture = capture;


/***/ }),
/* 105 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.compatibilityActions = void 0;
var actions = __importStar(__webpack_require__(55));
/**
 * Support backward compatible action sets by aliasing `ActionType` to `Action` during run-time.
 * @internal
 */
exports.compatibilityActions = Object.entries(actions).reduce(function (actionTypes, entry) {
    var _a, _b;
    var group = entry[0], actionSet = entry[1];
    if (!Object.keys(actions.Group).includes(group)) {
        return __assign(__assign({}, actionTypes), (_a = {}, _a[group] = actionSet, _a));
    }
    return __assign(__assign({}, actionTypes), (_b = {}, _b[group] = __assign(__assign({}, actionSet), { ActionType: actionSet.Action }), _b));
}, {});


/***/ }),
/* 106 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.Options = exports.ButtonGroup = exports.isGroupedButtonPayload = exports.isGroupedButton = exports.update = exports.ButtonGroupAction = exports.ButtonGroupUpdateAction = exports.Payload = exports.Action = void 0;
var ButtonGroup_1 = __webpack_require__(9);
Object.defineProperty(exports, "ButtonGroup", { enumerable: true, get: function () { return ButtonGroup_1.ButtonGroup; } });
Object.defineProperty(exports, "Options", { enumerable: true, get: function () { return ButtonGroup_1.Options; } });
var ButtonGroup_2 = __webpack_require__(9);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return ButtonGroup_2.Action; } });
Object.defineProperty(exports, "Payload", { enumerable: true, get: function () { return ButtonGroup_2.Payload; } });
Object.defineProperty(exports, "ButtonGroupUpdateAction", { enumerable: true, get: function () { return ButtonGroup_2.ButtonGroupUpdateAction; } });
Object.defineProperty(exports, "ButtonGroupAction", { enumerable: true, get: function () { return ButtonGroup_2.ButtonGroupAction; } });
Object.defineProperty(exports, "update", { enumerable: true, get: function () { return ButtonGroup_2.update; } });
Object.defineProperty(exports, "isGroupedButton", { enumerable: true, get: function () { return ButtonGroup_2.isGroupedButton; } });
Object.defineProperty(exports, "isGroupedButtonPayload", { enumerable: true, get: function () { return ButtonGroup_2.isGroupedButtonPayload; } });
function create(app, options) {
    return new ButtonGroup_1.ButtonGroup(app, options);
}
exports.create = create;


/***/ }),
/* 107 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(108), exports);


/***/ }),
/* 108 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.Flash = exports.FlashAction = exports.ShowAction = exports.show = exports.ClearAction = exports.clear = exports.ActionBase = void 0;
var Toast_1 = __webpack_require__(20);
Object.defineProperty(exports, "ActionBase", { enumerable: true, get: function () { return Toast_1.ActionBase; } });
Object.defineProperty(exports, "clear", { enumerable: true, get: function () { return Toast_1.clear; } });
Object.defineProperty(exports, "ClearAction", { enumerable: true, get: function () { return Toast_1.ClearAction; } });
Object.defineProperty(exports, "show", { enumerable: true, get: function () { return Toast_1.show; } });
Object.defineProperty(exports, "ShowAction", { enumerable: true, get: function () { return Toast_1.ShowAction; } });
Object.defineProperty(exports, "FlashAction", { enumerable: true, get: function () { return Toast_1.ToastAction; } });
var Flash = /** @class */ (function (_super) {
    __extends(Flash, _super);
    function Flash() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return Flash;
}(Toast_1.Toast));
exports.Flash = Flash;
function create(app, options) {
    return new Flash(app, options);
}
exports.create = create;


/***/ }),
/* 109 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(110), exports);
__exportStar(__webpack_require__(112), exports);


/***/ }),
/* 110 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.Features = exports.FeaturesAction = void 0;
var Features_1 = __webpack_require__(35);
Object.defineProperty(exports, "Features", { enumerable: true, get: function () { return Features_1.Features; } });
var Features_2 = __webpack_require__(35);
Object.defineProperty(exports, "FeaturesAction", { enumerable: true, get: function () { return Features_2.FeaturesAction; } });
/**
 * @public
 */
function create(app, options) {
    return new Features_1.Features(app, options);
}
exports.create = create;


/***/ }),
/* 111 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Features = void 0;
var helper_1 = __webpack_require__(0);
var ActionSet_1 = __webpack_require__(2);
var types_1 = __webpack_require__(1);
var types_2 = __webpack_require__(59);
/**
 * A set of Actions for Updating, Requesting Features of AppBridge
 * @public
 */
var Features = /** @class */ (function (_super) {
    __extends(Features, _super);
    function Features(app, options) {
        return _super.call(this, app, types_1.Group.Features, types_1.Group.Features, options ? options.id : undefined) || this;
    }
    /**
     * @public
     */
    Features.prototype.dispatch = function (action, payload) {
        switch (action) {
            case types_2.Action.REQUEST:
                this.dispatchFeaturesAction(types_2.Action.REQUEST, payload);
                break;
        }
        return this;
    };
    /**
     * @internal
     */
    Features.prototype.dispatchFeaturesAction = function (type, payload) {
        this.app.dispatch(helper_1.actionWrapper({
            group: types_1.Group.Features,
            type: type,
            payload: __assign(__assign({}, (payload || {})), { id: this.id }),
        }));
    };
    return Features;
}(ActionSet_1.ActionSet));
exports.Features = Features;


/***/ }),
/* 112 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.RequestUpdateOptions = exports.RequestOptions = exports.Options = exports.Action = void 0;
var Features_1 = __webpack_require__(35);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Features_1.Action; } });
Object.defineProperty(exports, "Options", { enumerable: true, get: function () { return Features_1.Options; } });
Object.defineProperty(exports, "RequestOptions", { enumerable: true, get: function () { return Features_1.RequestOptions; } });
Object.defineProperty(exports, "RequestUpdateOptions", { enumerable: true, get: function () { return Features_1.RequestUpdateOptions; } });


/***/ }),
/* 113 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.FeedbackModal = exports.close = exports.open = exports.CloseAction = exports.OpenAction = exports.ActionBase = exports.ClosePayload = exports.OpenPayload = exports.Options = exports.Action = void 0;
var FeedbackModal_1 = __webpack_require__(47);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return FeedbackModal_1.Action; } });
Object.defineProperty(exports, "Options", { enumerable: true, get: function () { return FeedbackModal_1.Options; } });
Object.defineProperty(exports, "OpenPayload", { enumerable: true, get: function () { return FeedbackModal_1.OpenPayload; } });
Object.defineProperty(exports, "ClosePayload", { enumerable: true, get: function () { return FeedbackModal_1.ClosePayload; } });
Object.defineProperty(exports, "ActionBase", { enumerable: true, get: function () { return FeedbackModal_1.ActionBase; } });
Object.defineProperty(exports, "OpenAction", { enumerable: true, get: function () { return FeedbackModal_1.OpenAction; } });
Object.defineProperty(exports, "CloseAction", { enumerable: true, get: function () { return FeedbackModal_1.CloseAction; } });
Object.defineProperty(exports, "open", { enumerable: true, get: function () { return FeedbackModal_1.open; } });
Object.defineProperty(exports, "close", { enumerable: true, get: function () { return FeedbackModal_1.close; } });
Object.defineProperty(exports, "FeedbackModal", { enumerable: true, get: function () { return FeedbackModal_1.FeedbackModal; } });
Object.defineProperty(exports, "create", { enumerable: true, get: function () { return FeedbackModal_1.create; } });


/***/ }),
/* 114 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.Options = exports.LeaveConfirmation = exports.confirm = exports.disable = exports.enable = exports.ConfirmAction = exports.DisableAction = exports.EnableAction = exports.ActionBase = exports.Payload = exports.Action = void 0;
var LeaveConfirmation_1 = __webpack_require__(28);
Object.defineProperty(exports, "LeaveConfirmation", { enumerable: true, get: function () { return LeaveConfirmation_1.LeaveConfirmation; } });
Object.defineProperty(exports, "Options", { enumerable: true, get: function () { return LeaveConfirmation_1.Options; } });
var LeaveConfirmation_2 = __webpack_require__(28);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return LeaveConfirmation_2.Action; } });
Object.defineProperty(exports, "Payload", { enumerable: true, get: function () { return LeaveConfirmation_2.Payload; } });
Object.defineProperty(exports, "ActionBase", { enumerable: true, get: function () { return LeaveConfirmation_2.ActionBase; } });
Object.defineProperty(exports, "EnableAction", { enumerable: true, get: function () { return LeaveConfirmation_2.EnableAction; } });
Object.defineProperty(exports, "DisableAction", { enumerable: true, get: function () { return LeaveConfirmation_2.DisableAction; } });
Object.defineProperty(exports, "ConfirmAction", { enumerable: true, get: function () { return LeaveConfirmation_2.ConfirmAction; } });
Object.defineProperty(exports, "enable", { enumerable: true, get: function () { return LeaveConfirmation_2.enable; } });
Object.defineProperty(exports, "disable", { enumerable: true, get: function () { return LeaveConfirmation_2.disable; } });
Object.defineProperty(exports, "confirm", { enumerable: true, get: function () { return LeaveConfirmation_2.confirm; } });
/**
 * Returns a new instance of a Leave Confirmation action set
 * @param app the client application
 */
function create(app, options) {
    if (options === void 0) { options = {}; }
    return new LeaveConfirmation_1.LeaveConfirmation(app, options);
}
exports.create = create;


/***/ }),
/* 115 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.ModalContent = exports.Options = exports.ModalContentPayload = exports.Action = void 0;
var ModalContent_1 = __webpack_require__(61);
Object.defineProperty(exports, "Options", { enumerable: true, get: function () { return ModalContent_1.Options; } });
Object.defineProperty(exports, "ModalContent", { enumerable: true, get: function () { return ModalContent_1.ModalContent; } });
var ModalContent_2 = __webpack_require__(61);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return ModalContent_2.Action; } });
Object.defineProperty(exports, "ModalContentPayload", { enumerable: true, get: function () { return ModalContent_2.ModalContentPayload; } });
/**
 * @public
 */
function create(app, options) {
    return new ModalContent_1.ModalContent(app, options);
}
exports.create = create;


/***/ }),
/* 116 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.replace = exports.push = exports.HistoryAction = exports.Payload = exports.Action = exports.History = void 0;
var History_1 = __webpack_require__(31);
Object.defineProperty(exports, "History", { enumerable: true, get: function () { return History_1.History; } });
var History_2 = __webpack_require__(31);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return History_2.Action; } });
Object.defineProperty(exports, "Payload", { enumerable: true, get: function () { return History_2.Payload; } });
Object.defineProperty(exports, "HistoryAction", { enumerable: true, get: function () { return History_2.HistoryAction; } });
Object.defineProperty(exports, "push", { enumerable: true, get: function () { return History_2.push; } });
Object.defineProperty(exports, "replace", { enumerable: true, get: function () { return History_2.replace; } });
function create(app) {
    return new History_1.History(app);
}
exports.create = create;


/***/ }),
/* 117 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.isProductVariantCreateResourcePayload = exports.isProductVariantResourcePayload = exports.isCreateResourcePayload = exports.isAdminSection = exports.isRemotePayload = exports.isAdminSectionPayload = exports.isAdminPathPayload = exports.isAppPayload = exports.getRelativePath = exports.normalizeUrl = exports.getPathWithSearchAndHash = exports.toDestination = exports.toApp = exports.toRemote = exports.toAdminSection = exports.toAdminPath = exports.isResourcePayload = exports.Navigate = exports.SectionStringName = exports.To = exports.Options = exports.HostOptions = exports.AppOptions = exports.Location = exports.RedirectAction = exports.RemoteAction = exports.AppAction = exports.AdminSectionAction = exports.AdminPathAction = exports.ActionBase = exports.ResourceType = exports.Action = exports.AdminSectionPayload = exports.Section = exports.ResourceInfo = exports.RemotePayload = exports.AdminPathPayload = exports.AppPayload = exports.BaseAdminPayload = exports.BasePayload = exports.Redirect = exports.ProductVariantResource = exports.CreateResource = void 0;
var Redirect_1 = __webpack_require__(18);
Object.defineProperty(exports, "CreateResource", { enumerable: true, get: function () { return Redirect_1.CreateResource; } });
Object.defineProperty(exports, "ProductVariantResource", { enumerable: true, get: function () { return Redirect_1.ProductVariantResource; } });
Object.defineProperty(exports, "Redirect", { enumerable: true, get: function () { return Redirect_1.Redirect; } });
Object.defineProperty(exports, "isCreateResourcePayload", { enumerable: true, get: function () { return Redirect_1.isCreateResourcePayload; } });
Object.defineProperty(exports, "isProductVariantResourcePayload", { enumerable: true, get: function () { return Redirect_1.isProductVariantResourcePayload; } });
var Redirect_2 = __webpack_require__(18);
Object.defineProperty(exports, "BasePayload", { enumerable: true, get: function () { return Redirect_2.BasePayload; } });
Object.defineProperty(exports, "BaseAdminPayload", { enumerable: true, get: function () { return Redirect_2.BaseAdminPayload; } });
Object.defineProperty(exports, "AppPayload", { enumerable: true, get: function () { return Redirect_2.AppPayload; } });
Object.defineProperty(exports, "AdminPathPayload", { enumerable: true, get: function () { return Redirect_2.AdminPathPayload; } });
Object.defineProperty(exports, "RemotePayload", { enumerable: true, get: function () { return Redirect_2.RemotePayload; } });
Object.defineProperty(exports, "ResourceInfo", { enumerable: true, get: function () { return Redirect_2.ResourceInfo; } });
Object.defineProperty(exports, "Section", { enumerable: true, get: function () { return Redirect_2.Section; } });
Object.defineProperty(exports, "AdminSectionPayload", { enumerable: true, get: function () { return Redirect_2.AdminSectionPayload; } });
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Redirect_2.Action; } });
Object.defineProperty(exports, "ResourceType", { enumerable: true, get: function () { return Redirect_2.ResourceType; } });
Object.defineProperty(exports, "ActionBase", { enumerable: true, get: function () { return Redirect_2.ActionBase; } });
Object.defineProperty(exports, "AdminPathAction", { enumerable: true, get: function () { return Redirect_2.AdminPathAction; } });
Object.defineProperty(exports, "AdminSectionAction", { enumerable: true, get: function () { return Redirect_2.AdminSectionAction; } });
Object.defineProperty(exports, "AppAction", { enumerable: true, get: function () { return Redirect_2.AppAction; } });
Object.defineProperty(exports, "RemoteAction", { enumerable: true, get: function () { return Redirect_2.RemoteAction; } });
Object.defineProperty(exports, "RedirectAction", { enumerable: true, get: function () { return Redirect_2.RedirectAction; } });
Object.defineProperty(exports, "Location", { enumerable: true, get: function () { return Redirect_2.Location; } });
Object.defineProperty(exports, "AppOptions", { enumerable: true, get: function () { return Redirect_2.AppOptions; } });
Object.defineProperty(exports, "HostOptions", { enumerable: true, get: function () { return Redirect_2.HostOptions; } });
Object.defineProperty(exports, "Options", { enumerable: true, get: function () { return Redirect_2.Options; } });
Object.defineProperty(exports, "To", { enumerable: true, get: function () { return Redirect_2.To; } });
Object.defineProperty(exports, "SectionStringName", { enumerable: true, get: function () { return Redirect_2.SectionStringName; } });
Object.defineProperty(exports, "Navigate", { enumerable: true, get: function () { return Redirect_2.Navigate; } });
Object.defineProperty(exports, "isResourcePayload", { enumerable: true, get: function () { return Redirect_2.isResourcePayload; } });
Object.defineProperty(exports, "toAdminPath", { enumerable: true, get: function () { return Redirect_2.toAdminPath; } });
Object.defineProperty(exports, "toAdminSection", { enumerable: true, get: function () { return Redirect_2.toAdminSection; } });
Object.defineProperty(exports, "toRemote", { enumerable: true, get: function () { return Redirect_2.toRemote; } });
Object.defineProperty(exports, "toApp", { enumerable: true, get: function () { return Redirect_2.toApp; } });
Object.defineProperty(exports, "toDestination", { enumerable: true, get: function () { return Redirect_2.toDestination; } });
Object.defineProperty(exports, "getPathWithSearchAndHash", { enumerable: true, get: function () { return Redirect_2.getPathWithSearchAndHash; } });
Object.defineProperty(exports, "normalizeUrl", { enumerable: true, get: function () { return Redirect_2.normalizeUrl; } });
Object.defineProperty(exports, "getRelativePath", { enumerable: true, get: function () { return Redirect_2.getRelativePath; } });
Object.defineProperty(exports, "isAppPayload", { enumerable: true, get: function () { return Redirect_2.isAppPayload; } });
Object.defineProperty(exports, "isAdminPathPayload", { enumerable: true, get: function () { return Redirect_2.isAdminPathPayload; } });
Object.defineProperty(exports, "isAdminSectionPayload", { enumerable: true, get: function () { return Redirect_2.isAdminSectionPayload; } });
Object.defineProperty(exports, "isRemotePayload", { enumerable: true, get: function () { return Redirect_2.isRemotePayload; } });
Object.defineProperty(exports, "isAdminSection", { enumerable: true, get: function () { return Redirect_2.isAdminSection; } });
function isProductVariantCreateResourcePayload(resource) {
    if (!Redirect_1.isProductVariantResourcePayload(resource)) {
        return false;
    }
    return Redirect_1.isCreateResourcePayload(resource.variant);
}
exports.isProductVariantCreateResourcePayload = isProductVariantCreateResourcePayload;
function create(app) {
    return new Redirect_1.Redirect(app);
}
exports.create = create;


/***/ }),
/* 118 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.BaseOptions = exports.ResourcePicker = exports.WeightUnit = exports.UpdateAction = exports.update = exports.SelectPayload = exports.SelectAction = exports.select = exports.RuleSet = exports.ResourceType = exports.ResourceSelection = exports.ResourcePickerAction = exports.Resource = exports.ProductVariantInventoryPolicy = exports.ProductVariantInventoryManagement = exports.ProductVariant = exports.ProductStatus = exports.ProductOptions = exports.Product = exports.Payload = exports.Options = exports.OpenAction = exports.open = exports.Money = exports.Image = exports.FulfillmentServiceType = exports.CollectionSortOrder = exports.CollectionRule = exports.Collection = exports.ClosePayload = exports.CloseAction = exports.close = exports.CancelPayload = exports.CancelAction = exports.cancel = exports.BaseResource = exports.ActionVerb = exports.ActionBase = exports.Action = void 0;
var ResourcePicker_1 = __webpack_require__(32);
Object.defineProperty(exports, "ResourcePicker", { enumerable: true, get: function () { return ResourcePicker_1.ResourcePicker; } });
Object.defineProperty(exports, "BaseOptions", { enumerable: true, get: function () { return ResourcePicker_1.BaseOptions; } });
var ResourcePicker_2 = __webpack_require__(32);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return ResourcePicker_2.Action; } });
Object.defineProperty(exports, "ActionBase", { enumerable: true, get: function () { return ResourcePicker_2.ActionBase; } });
Object.defineProperty(exports, "ActionVerb", { enumerable: true, get: function () { return ResourcePicker_2.ActionVerb; } });
Object.defineProperty(exports, "BaseResource", { enumerable: true, get: function () { return ResourcePicker_2.BaseResource; } });
Object.defineProperty(exports, "cancel", { enumerable: true, get: function () { return ResourcePicker_2.cancel; } });
Object.defineProperty(exports, "CancelAction", { enumerable: true, get: function () { return ResourcePicker_2.CancelAction; } });
Object.defineProperty(exports, "CancelPayload", { enumerable: true, get: function () { return ResourcePicker_2.CancelPayload; } });
Object.defineProperty(exports, "close", { enumerable: true, get: function () { return ResourcePicker_2.close; } });
Object.defineProperty(exports, "CloseAction", { enumerable: true, get: function () { return ResourcePicker_2.CloseAction; } });
Object.defineProperty(exports, "ClosePayload", { enumerable: true, get: function () { return ResourcePicker_2.ClosePayload; } });
Object.defineProperty(exports, "Collection", { enumerable: true, get: function () { return ResourcePicker_2.Collection; } });
Object.defineProperty(exports, "CollectionRule", { enumerable: true, get: function () { return ResourcePicker_2.CollectionRule; } });
Object.defineProperty(exports, "CollectionSortOrder", { enumerable: true, get: function () { return ResourcePicker_2.CollectionSortOrder; } });
Object.defineProperty(exports, "FulfillmentServiceType", { enumerable: true, get: function () { return ResourcePicker_2.FulfillmentServiceType; } });
Object.defineProperty(exports, "Image", { enumerable: true, get: function () { return ResourcePicker_2.Image; } });
Object.defineProperty(exports, "Money", { enumerable: true, get: function () { return ResourcePicker_2.Money; } });
Object.defineProperty(exports, "open", { enumerable: true, get: function () { return ResourcePicker_2.open; } });
Object.defineProperty(exports, "OpenAction", { enumerable: true, get: function () { return ResourcePicker_2.OpenAction; } });
Object.defineProperty(exports, "Options", { enumerable: true, get: function () { return ResourcePicker_2.Options; } });
Object.defineProperty(exports, "Payload", { enumerable: true, get: function () { return ResourcePicker_2.Payload; } });
Object.defineProperty(exports, "Product", { enumerable: true, get: function () { return ResourcePicker_2.Product; } });
Object.defineProperty(exports, "ProductOptions", { enumerable: true, get: function () { return ResourcePicker_2.ProductOptions; } });
Object.defineProperty(exports, "ProductStatus", { enumerable: true, get: function () { return ResourcePicker_2.ProductStatus; } });
Object.defineProperty(exports, "ProductVariant", { enumerable: true, get: function () { return ResourcePicker_2.ProductVariant; } });
Object.defineProperty(exports, "ProductVariantInventoryManagement", { enumerable: true, get: function () { return ResourcePicker_2.ProductVariantInventoryManagement; } });
Object.defineProperty(exports, "ProductVariantInventoryPolicy", { enumerable: true, get: function () { return ResourcePicker_2.ProductVariantInventoryPolicy; } });
Object.defineProperty(exports, "Resource", { enumerable: true, get: function () { return ResourcePicker_2.Resource; } });
Object.defineProperty(exports, "ResourcePickerAction", { enumerable: true, get: function () { return ResourcePicker_2.ResourcePickerAction; } });
Object.defineProperty(exports, "ResourceSelection", { enumerable: true, get: function () { return ResourcePicker_2.ResourceSelection; } });
Object.defineProperty(exports, "ResourceType", { enumerable: true, get: function () { return ResourcePicker_2.ResourceType; } });
Object.defineProperty(exports, "RuleSet", { enumerable: true, get: function () { return ResourcePicker_2.RuleSet; } });
Object.defineProperty(exports, "select", { enumerable: true, get: function () { return ResourcePicker_2.select; } });
Object.defineProperty(exports, "SelectAction", { enumerable: true, get: function () { return ResourcePicker_2.SelectAction; } });
Object.defineProperty(exports, "SelectPayload", { enumerable: true, get: function () { return ResourcePicker_2.SelectPayload; } });
Object.defineProperty(exports, "update", { enumerable: true, get: function () { return ResourcePicker_2.update; } });
Object.defineProperty(exports, "UpdateAction", { enumerable: true, get: function () { return ResourcePicker_2.UpdateAction; } });
Object.defineProperty(exports, "WeightUnit", { enumerable: true, get: function () { return ResourcePicker_2.WeightUnit; } });
var create = function (app, baseOptions) {
    var resourceType = baseOptions.resourceType, _a = baseOptions.options, options = _a === void 0 ? {} : _a;
    return new ResourcePicker_1.ResourcePicker(app, options, resourceType);
};
exports.create = create;


/***/ }),
/* 119 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.respond = exports.request = exports.SessionTokenApi = exports.RespondWithSessionTokenAction = exports.RequestSessionTokenAction = exports.ActionBase = exports.Payload = exports.Action = void 0;
var SessionToken_1 = __webpack_require__(62);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return SessionToken_1.Action; } });
Object.defineProperty(exports, "Payload", { enumerable: true, get: function () { return SessionToken_1.Payload; } });
Object.defineProperty(exports, "ActionBase", { enumerable: true, get: function () { return SessionToken_1.ActionBase; } });
Object.defineProperty(exports, "RequestSessionTokenAction", { enumerable: true, get: function () { return SessionToken_1.RequestSessionTokenAction; } });
Object.defineProperty(exports, "RespondWithSessionTokenAction", { enumerable: true, get: function () { return SessionToken_1.RespondWithSessionTokenAction; } });
Object.defineProperty(exports, "SessionTokenApi", { enumerable: true, get: function () { return SessionToken_1.SessionTokenApi; } });
Object.defineProperty(exports, "request", { enumerable: true, get: function () { return SessionToken_1.request; } });
Object.defineProperty(exports, "respond", { enumerable: true, get: function () { return SessionToken_1.respond; } });


/***/ }),
/* 120 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.TitleBar = exports.Options = exports.TitleBarApi = exports.UpdatePayload = exports.DeepPartial = exports.ActionProps = exports.Target = exports.update = exports.clickBreadcrumb = exports.clickActionButton = exports.TitleBarAction = exports.UpdateAction = exports.Payload = exports.ButtonsPayload = exports.ButtonsOptions = exports.Breadcrumb = exports.Action = void 0;
var TitleBar_1 = __webpack_require__(33);
Object.defineProperty(exports, "Options", { enumerable: true, get: function () { return TitleBar_1.Options; } });
Object.defineProperty(exports, "TitleBar", { enumerable: true, get: function () { return TitleBar_1.TitleBar; } });
var TitleBar_2 = __webpack_require__(33);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return TitleBar_2.Action; } });
Object.defineProperty(exports, "Breadcrumb", { enumerable: true, get: function () { return TitleBar_2.Breadcrumb; } });
Object.defineProperty(exports, "ButtonsOptions", { enumerable: true, get: function () { return TitleBar_2.ButtonsOptions; } });
Object.defineProperty(exports, "ButtonsPayload", { enumerable: true, get: function () { return TitleBar_2.ButtonsPayload; } });
Object.defineProperty(exports, "Payload", { enumerable: true, get: function () { return TitleBar_2.Payload; } });
Object.defineProperty(exports, "UpdateAction", { enumerable: true, get: function () { return TitleBar_2.UpdateAction; } });
Object.defineProperty(exports, "TitleBarAction", { enumerable: true, get: function () { return TitleBar_2.TitleBarAction; } });
Object.defineProperty(exports, "clickActionButton", { enumerable: true, get: function () { return TitleBar_2.clickActionButton; } });
Object.defineProperty(exports, "clickBreadcrumb", { enumerable: true, get: function () { return TitleBar_2.clickBreadcrumb; } });
Object.defineProperty(exports, "update", { enumerable: true, get: function () { return TitleBar_2.update; } });
Object.defineProperty(exports, "Target", { enumerable: true, get: function () { return TitleBar_2.Target; } });
Object.defineProperty(exports, "ActionProps", { enumerable: true, get: function () { return TitleBar_2.ActionProps; } });
Object.defineProperty(exports, "DeepPartial", { enumerable: true, get: function () { return TitleBar_2.DeepPartial; } });
Object.defineProperty(exports, "UpdatePayload", { enumerable: true, get: function () { return TitleBar_2.UpdatePayload; } });
Object.defineProperty(exports, "TitleBarApi", { enumerable: true, get: function () { return TitleBar_2.TitleBarApi; } });
function create(app, options) {
    return new TitleBar_1.TitleBar(app, options);
}
exports.create = create;


/***/ }),
/* 121 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.Toast = exports.primaryAction = exports.clear = exports.show = exports.ToastApi = exports.ShowPayload = exports.ToastAction = exports.PrimaryAction = exports.ClearAction = exports.ShowAction = exports.ActionBase = exports.Payload = exports.ClearPayload = exports.Action = void 0;
var Toast_1 = __webpack_require__(20);
Object.defineProperty(exports, "Toast", { enumerable: true, get: function () { return Toast_1.Toast; } });
var Toast_2 = __webpack_require__(20);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Toast_2.Action; } });
Object.defineProperty(exports, "ClearPayload", { enumerable: true, get: function () { return Toast_2.ClearPayload; } });
Object.defineProperty(exports, "Payload", { enumerable: true, get: function () { return Toast_2.Payload; } });
Object.defineProperty(exports, "ActionBase", { enumerable: true, get: function () { return Toast_2.ActionBase; } });
Object.defineProperty(exports, "ShowAction", { enumerable: true, get: function () { return Toast_2.ShowAction; } });
Object.defineProperty(exports, "ClearAction", { enumerable: true, get: function () { return Toast_2.ClearAction; } });
Object.defineProperty(exports, "PrimaryAction", { enumerable: true, get: function () { return Toast_2.PrimaryAction; } });
Object.defineProperty(exports, "ToastAction", { enumerable: true, get: function () { return Toast_2.ToastAction; } });
Object.defineProperty(exports, "ShowPayload", { enumerable: true, get: function () { return Toast_2.ShowPayload; } });
Object.defineProperty(exports, "ToastApi", { enumerable: true, get: function () { return Toast_2.ToastApi; } });
Object.defineProperty(exports, "show", { enumerable: true, get: function () { return Toast_2.show; } });
Object.defineProperty(exports, "clear", { enumerable: true, get: function () { return Toast_2.clear; } });
Object.defineProperty(exports, "primaryAction", { enumerable: true, get: function () { return Toast_2.primaryAction; } });
function create(app, options) {
    return new Toast_1.Toast(app, options);
}
exports.create = create;


/***/ }),
/* 122 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.ContextualSaveBar = exports.update = exports.discard = exports.save = exports.hide = exports.show = exports.ContextualSaveBarApi = exports.DiscardActionOptions = exports.SaveActionOptions = exports.ShowOptions = exports.ContextualSaveBarAction = exports.Payload = exports.Options = exports.DiscardAction = exports.ContextAction = exports.Action = void 0;
var ContextualSaveBar_1 = __webpack_require__(46);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return ContextualSaveBar_1.Action; } });
Object.defineProperty(exports, "ContextAction", { enumerable: true, get: function () { return ContextualSaveBar_1.ContextAction; } });
Object.defineProperty(exports, "DiscardAction", { enumerable: true, get: function () { return ContextualSaveBar_1.DiscardAction; } });
Object.defineProperty(exports, "Options", { enumerable: true, get: function () { return ContextualSaveBar_1.Options; } });
Object.defineProperty(exports, "Payload", { enumerable: true, get: function () { return ContextualSaveBar_1.Payload; } });
Object.defineProperty(exports, "ContextualSaveBarAction", { enumerable: true, get: function () { return ContextualSaveBar_1.ContextualSaveBarAction; } });
Object.defineProperty(exports, "ShowOptions", { enumerable: true, get: function () { return ContextualSaveBar_1.ShowOptions; } });
Object.defineProperty(exports, "SaveActionOptions", { enumerable: true, get: function () { return ContextualSaveBar_1.SaveActionOptions; } });
Object.defineProperty(exports, "DiscardActionOptions", { enumerable: true, get: function () { return ContextualSaveBar_1.DiscardActionOptions; } });
Object.defineProperty(exports, "ContextualSaveBarApi", { enumerable: true, get: function () { return ContextualSaveBar_1.ContextualSaveBarApi; } });
Object.defineProperty(exports, "show", { enumerable: true, get: function () { return ContextualSaveBar_1.show; } });
Object.defineProperty(exports, "hide", { enumerable: true, get: function () { return ContextualSaveBar_1.hide; } });
Object.defineProperty(exports, "save", { enumerable: true, get: function () { return ContextualSaveBar_1.save; } });
Object.defineProperty(exports, "discard", { enumerable: true, get: function () { return ContextualSaveBar_1.discard; } });
Object.defineProperty(exports, "update", { enumerable: true, get: function () { return ContextualSaveBar_1.update; } });
Object.defineProperty(exports, "ContextualSaveBar", { enumerable: true, get: function () { return ContextualSaveBar_1.ContextualSaveBar; } });
/**
 * Returns a new instance of a ContextualSaveBar action set
 * @param app the client application
 *
 */
function create(app, options) {
    return new ContextualSaveBar_1.ContextualSaveBar(app, options);
}
exports.create = create;


/***/ }),
/* 123 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.Share = exports.close = exports.show = exports.ShareAction = exports.OutputPayload = exports.InputPayload = exports.UrlPayload = exports.TextPayload = exports.Action = void 0;
var Share_1 = __webpack_require__(63);
Object.defineProperty(exports, "Share", { enumerable: true, get: function () { return Share_1.Share; } });
var Share_2 = __webpack_require__(63);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Share_2.Action; } });
Object.defineProperty(exports, "TextPayload", { enumerable: true, get: function () { return Share_2.TextPayload; } });
Object.defineProperty(exports, "UrlPayload", { enumerable: true, get: function () { return Share_2.UrlPayload; } });
Object.defineProperty(exports, "InputPayload", { enumerable: true, get: function () { return Share_2.InputPayload; } });
Object.defineProperty(exports, "OutputPayload", { enumerable: true, get: function () { return Share_2.OutputPayload; } });
Object.defineProperty(exports, "ShareAction", { enumerable: true, get: function () { return Share_2.ShareAction; } });
Object.defineProperty(exports, "show", { enumerable: true, get: function () { return Share_2.show; } });
Object.defineProperty(exports, "close", { enumerable: true, get: function () { return Share_2.close; } });
/**
 * @public
 */
function create(app) {
    return new Share_1.Share(app);
}
exports.create = create;


/***/ }),
/* 124 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.Options = exports.NavigationMenu = exports.update = exports.NavigationMenuAction = exports.MenuAction = exports.Payload = exports.Action = void 0;
var NavigationMenu_1 = __webpack_require__(29);
Object.defineProperty(exports, "NavigationMenu", { enumerable: true, get: function () { return NavigationMenu_1.NavigationMenu; } });
Object.defineProperty(exports, "Options", { enumerable: true, get: function () { return NavigationMenu_1.Options; } });
var NavigationMenu_2 = __webpack_require__(29);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return NavigationMenu_2.Action; } });
Object.defineProperty(exports, "Payload", { enumerable: true, get: function () { return NavigationMenu_2.Payload; } });
Object.defineProperty(exports, "MenuAction", { enumerable: true, get: function () { return NavigationMenu_2.MenuAction; } });
Object.defineProperty(exports, "NavigationMenuAction", { enumerable: true, get: function () { return NavigationMenu_2.NavigationMenuAction; } });
Object.defineProperty(exports, "update", { enumerable: true, get: function () { return NavigationMenu_2.update; } });
function create(app, options) {
    return new NavigationMenu_1.NavigationMenu(app, options);
}
exports.create = create;


/***/ }),
/* 125 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.Options = exports.ChannelMenu = exports.update = exports.ChannelMenuAction = exports.MenuAction = exports.Payload = exports.Action = void 0;
var ChannelMenu_1 = __webpack_require__(30);
Object.defineProperty(exports, "ChannelMenu", { enumerable: true, get: function () { return ChannelMenu_1.ChannelMenu; } });
Object.defineProperty(exports, "Options", { enumerable: true, get: function () { return ChannelMenu_1.Options; } });
var ChannelMenu_2 = __webpack_require__(30);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return ChannelMenu_2.Action; } });
Object.defineProperty(exports, "Payload", { enumerable: true, get: function () { return ChannelMenu_2.Payload; } });
Object.defineProperty(exports, "MenuAction", { enumerable: true, get: function () { return ChannelMenu_2.MenuAction; } });
Object.defineProperty(exports, "ChannelMenuAction", { enumerable: true, get: function () { return ChannelMenu_2.ChannelMenuAction; } });
Object.defineProperty(exports, "update", { enumerable: true, get: function () { return ChannelMenu_2.update; } });
function create(app, options) {
    return new ChannelMenu_1.ChannelMenu(app, options);
}
exports.create = create;


/***/ }),
/* 126 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.Options = exports.AppLink = exports.update = exports.UpdateAction = exports.Payload = exports.InternalOptions = exports.Action = void 0;
var AppLink_1 = __webpack_require__(14);
Object.defineProperty(exports, "AppLink", { enumerable: true, get: function () { return AppLink_1.AppLink; } });
Object.defineProperty(exports, "Options", { enumerable: true, get: function () { return AppLink_1.Options; } });
var AppLink_2 = __webpack_require__(14);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return AppLink_2.Action; } });
Object.defineProperty(exports, "InternalOptions", { enumerable: true, get: function () { return AppLink_2.InternalOptions; } });
Object.defineProperty(exports, "Payload", { enumerable: true, get: function () { return AppLink_2.Payload; } });
Object.defineProperty(exports, "UpdateAction", { enumerable: true, get: function () { return AppLink_2.UpdateAction; } });
Object.defineProperty(exports, "update", { enumerable: true, get: function () { return AppLink_2.update; } });
function create(app, options) {
    return new AppLink_1.AppLink(app, options);
}
exports.create = create;


/***/ }),
/* 127 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.Pos = exports.close = exports.CloseAction = exports.Device = exports.User = exports.Location = exports.Action = void 0;
var Pos_1 = __webpack_require__(64);
Object.defineProperty(exports, "Pos", { enumerable: true, get: function () { return Pos_1.Pos; } });
var Pos_2 = __webpack_require__(64);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Pos_2.Action; } });
Object.defineProperty(exports, "Location", { enumerable: true, get: function () { return Pos_2.Location; } });
Object.defineProperty(exports, "User", { enumerable: true, get: function () { return Pos_2.User; } });
Object.defineProperty(exports, "Device", { enumerable: true, get: function () { return Pos_2.Device; } });
Object.defineProperty(exports, "CloseAction", { enumerable: true, get: function () { return Pos_2.CloseAction; } });
Object.defineProperty(exports, "close", { enumerable: true, get: function () { return Pos_2.close; } });
function create(app) {
    return new Pos_1.Pos(app);
}
exports.create = create;


/***/ }),
/* 128 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.MarketingExternalActivityTopBar = exports.update = exports.clickActionButton = exports.MarketingActivityStatusBadgeType = exports.Action = void 0;
var MarketingExternalActivityTopBar_1 = __webpack_require__(129);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return MarketingExternalActivityTopBar_1.Action; } });
var Button_1 = __webpack_require__(58);
var buttonHelper_1 = __webpack_require__(130);
var helper_1 = __webpack_require__(6);
var ActionSet_1 = __webpack_require__(131);
var types_1 = __webpack_require__(7);
var MarketingActivityStatusBadgeType;
(function (MarketingActivityStatusBadgeType) {
    MarketingActivityStatusBadgeType["Default"] = "DEFAULT";
    MarketingActivityStatusBadgeType["Success"] = "SUCCESS";
    MarketingActivityStatusBadgeType["Attention"] = "ATTENTION";
    MarketingActivityStatusBadgeType["Warning"] = "WARNING";
    MarketingActivityStatusBadgeType["Info"] = "INFO";
})(MarketingActivityStatusBadgeType = exports.MarketingActivityStatusBadgeType || (exports.MarketingActivityStatusBadgeType = {}));
var MARKETING_ACTIVITY_TOPBAR_BUTTON_PROPS = {
    group: types_1.Group.MarketingExternalActivityTopBar,
    subgroups: ['Buttons'],
};
function clickActionButton(id, payload) {
    var type = types_1.ComponentType.Button;
    var component = __assign({ id: id, type: type }, MARKETING_ACTIVITY_TOPBAR_BUTTON_PROPS);
    return Button_1.clickButton(types_1.Group.MarketingExternalActivityTopBar, component, payload);
}
exports.clickActionButton = clickActionButton;
function update(payload) {
    return helper_1.actionWrapper({
        payload: payload,
        group: types_1.Group.MarketingExternalActivityTopBar,
        type: MarketingExternalActivityTopBar_1.Action.UPDATE,
    });
}
exports.update = update;
var MarketingExternalActivityTopBar = /** @class */ (function (_super) {
    __extends(MarketingExternalActivityTopBar, _super);
    function MarketingExternalActivityTopBar(app, options) {
        var _this = _super.call(this, app, types_1.Group.MarketingExternalActivityTopBar, types_1.Group.MarketingExternalActivityTopBar) || this;
        // Trigger 'update' on creation
        _this.set(options);
        return _this;
    }
    Object.defineProperty(MarketingExternalActivityTopBar.prototype, "buttons", {
        get: function () {
            if (!this.primary && !this.secondary) {
                return undefined;
            }
            return {
                primary: this.primary,
                secondary: this.secondary,
            };
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MarketingExternalActivityTopBar.prototype, "buttonsOptions", {
        get: function () {
            if (!this.primaryOptions && !this.secondaryOptions) {
                return undefined;
            }
            return {
                primary: this.primaryOptions,
                secondary: this.secondaryOptions,
            };
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MarketingExternalActivityTopBar.prototype, "options", {
        get: function () {
            return {
                title: this.title,
                status: this.status,
                saving: this.saving,
                saved: this.saved,
                buttons: this.buttonsOptions,
            };
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MarketingExternalActivityTopBar.prototype, "payload", {
        get: function () {
            return __assign(__assign({}, this.options), { buttons: this.buttons, id: this.id });
        },
        enumerable: false,
        configurable: true
    });
    MarketingExternalActivityTopBar.prototype.set = function (options, shouldUpdate) {
        if (shouldUpdate === void 0) { shouldUpdate = true; }
        var mergedOptions = helper_1.getMergedProps(this.options, options);
        var title = mergedOptions.title, buttons = mergedOptions.buttons, saved = mergedOptions.saved, saving = mergedOptions.saving, status = mergedOptions.status;
        this.title = title;
        this.saving = saving;
        this.saved = saved;
        this.status = status;
        this.setPrimaryButton(buttons ? buttons.primary : undefined);
        this.setSecondaryButtons(buttons ? buttons.secondary : undefined);
        if (shouldUpdate) {
            this.dispatch(MarketingExternalActivityTopBar_1.Action.UPDATE);
        }
        return this;
    };
    MarketingExternalActivityTopBar.prototype.dispatch = function (action) {
        switch (action) {
            case MarketingExternalActivityTopBar_1.Action.UPDATE:
                this.app.dispatch(update(this.payload));
                break;
        }
        return this;
    };
    MarketingExternalActivityTopBar.prototype.getButton = function (button, subgroups, updateCb) {
        return buttonHelper_1.getSingleButton(this, button, subgroups, updateCb);
    };
    MarketingExternalActivityTopBar.prototype.updatePrimaryButton = function (newPayload) {
        if (!this.primary) {
            return;
        }
        if (helper_1.updateActionFromPayload(this.primary, newPayload)) {
            this.dispatch(MarketingExternalActivityTopBar_1.Action.UPDATE);
        }
    };
    MarketingExternalActivityTopBar.prototype.updateSecondaryButtons = function (newPayload) {
        if (!this.secondary) {
            return;
        }
        var buttonToUpdate = this.secondary.find(function (action) { return action.id === newPayload.id; });
        if (!buttonToUpdate) {
            return;
        }
        var updated = helper_1.updateActionFromPayload(buttonToUpdate, newPayload);
        if (updated) {
            this.dispatch(MarketingExternalActivityTopBar_1.Action.UPDATE);
        }
    };
    MarketingExternalActivityTopBar.prototype.setPrimaryButton = function (newOptions) {
        this.primaryOptions = this.getChildButton(newOptions, this.primaryOptions);
        this.primary = this.primaryOptions
            ? this.getButton(this.primaryOptions, MARKETING_ACTIVITY_TOPBAR_BUTTON_PROPS.subgroups, this.updatePrimaryButton)
            : undefined;
    };
    MarketingExternalActivityTopBar.prototype.setSecondaryButtons = function (newOptions) {
        var _this = this;
        var newButtons = newOptions || [];
        var currentButtons = this.secondaryOptions || [];
        this.secondaryOptions = this.getUpdatedChildActions(newButtons, currentButtons);
        this.secondary = this.secondaryOptions
            ? this.secondaryOptions.map(function (action) {
                return _this.getButton(action, MARKETING_ACTIVITY_TOPBAR_BUTTON_PROPS.subgroups, _this.updateSecondaryButtons);
            })
            : undefined;
    };
    MarketingExternalActivityTopBar.prototype.updateSaving = function (saving) {
        this.saving = saving;
        this.dispatch(MarketingExternalActivityTopBar_1.Action.UPDATE);
    };
    MarketingExternalActivityTopBar.prototype.updateSaved = function (saved) {
        this.saved = saved;
        this.dispatch(MarketingExternalActivityTopBar_1.Action.UPDATE);
    };
    MarketingExternalActivityTopBar.prototype.updateStatus = function (newPayload) {
        this.status = newPayload;
        this.dispatch(MarketingExternalActivityTopBar_1.Action.UPDATE);
    };
    MarketingExternalActivityTopBar.prototype.getChildButton = function (newAction, currentAction) {
        var newButtons = newAction ? [newAction] : [];
        var currentButtons = currentAction ? [currentAction] : [];
        var updatedButton = this.getUpdatedChildActions(newButtons, currentButtons);
        return updatedButton ? updatedButton[0] : undefined;
    };
    return MarketingExternalActivityTopBar;
}(ActionSet_1.ActionSetWithChildren));
exports.MarketingExternalActivityTopBar = MarketingExternalActivityTopBar;
function create(app, options) {
    return new MarketingExternalActivityTopBar(app, options);
}
exports.create = create;


/***/ }),
/* 129 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.Action = void 0;
var Action;
(function (Action) {
    Action["UPDATE"] = "APP::MARKETING_EXTERNAL_ACTIVITY_TOP_BAR::UPDATE";
    Action["BUTTON_CLICK"] = "APP::MARKETING_EXTERNAL_ACTIVITY_TOP_BAR::BUTTONS::BUTTON::CLICK";
    Action["BUTTON_UPDATE"] = "APP::MARKETING_EXTERNAL_ACTIVITY_TOP_BAR::BUTTONS::BUTTON::UPDATE";
})(Action = exports.Action || (exports.Action = {}));


/***/ }),
/* 130 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.getSingleButton = void 0;
var buttonHelper_1 = __webpack_require__(17);
Object.defineProperty(exports, "getSingleButton", { enumerable: true, get: function () { return buttonHelper_1.getSingleButton; } });


/***/ }),
/* 131 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionSetChildAction = exports.unsubscribeActions = exports.ActionSetWithChildren = exports.ActionSet = void 0;
var ActionSet_1 = __webpack_require__(2);
Object.defineProperty(exports, "ActionSet", { enumerable: true, get: function () { return ActionSet_1.ActionSet; } });
Object.defineProperty(exports, "ActionSetWithChildren", { enumerable: true, get: function () { return ActionSet_1.ActionSetWithChildren; } });
Object.defineProperty(exports, "unsubscribeActions", { enumerable: true, get: function () { return ActionSet_1.unsubscribeActions; } });
Object.defineProperty(exports, "ActionSetChildAction", { enumerable: true, get: function () { return ActionSet_1.ActionSetChildAction; } });


/***/ }),
/* 132 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.fullPageLoad = exports.skeletonPageLoad = exports.FullPageLoadAction = exports.SkeletonPageLoadAction = exports.ActionBase = exports.Action = void 0;
var Performance_1 = __webpack_require__(133);
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Performance_1.Action; } });
Object.defineProperty(exports, "ActionBase", { enumerable: true, get: function () { return Performance_1.ActionBase; } });
Object.defineProperty(exports, "SkeletonPageLoadAction", { enumerable: true, get: function () { return Performance_1.SkeletonPageLoadAction; } });
Object.defineProperty(exports, "FullPageLoadAction", { enumerable: true, get: function () { return Performance_1.FullPageLoadAction; } });
Object.defineProperty(exports, "skeletonPageLoad", { enumerable: true, get: function () { return Performance_1.skeletonPageLoad; } });
Object.defineProperty(exports, "fullPageLoad", { enumerable: true, get: function () { return Performance_1.fullPageLoad; } });


/***/ }),
/* 133 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.fullPageLoad = exports.skeletonPageLoad = exports.Action = void 0;
var types_1 = __webpack_require__(1);
var helper_1 = __webpack_require__(0);
var Action;
(function (Action) {
    Action["SKELETON_PAGE_LOAD"] = "APP::PERFORMANCE::SKELETON_PAGE_LOAD";
    Action["FULL_PAGE_LOAD"] = "APP::PERFORMANCE::FULL_PAGE_LOAD";
})(Action = exports.Action || (exports.Action = {}));
function skeletonPageLoad() {
    return helper_1.actionWrapper({
        group: types_1.Group.Performance,
        type: Action.SKELETON_PAGE_LOAD,
    });
}
exports.skeletonPageLoad = skeletonPageLoad;
function fullPageLoad() {
    return helper_1.actionWrapper({
        group: types_1.Group.Performance,
        type: Action.FULL_PAGE_LOAD,
    });
}
exports.fullPageLoad = fullPageLoad;


/***/ }),
/* 134 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.create = exports.Options = exports.unstable_Picker = exports.VerticalAlignment = exports.UpdateAction = exports.update = exports.ThumbnailProps = exports.SelectPayload = exports.SelectEventListener = exports.SelectAction = exports.select = exports.SearchPayload = exports.SearchEventListener = exports.SearchAction = exports.search = exports.Resource = exports.PickerApi = exports.PickerAction = exports.Payload = exports.OpenAction = exports.open = exports.MediaKind = exports.LoadMorePayload = exports.LoadMoreAction = exports.loadMore = exports.Handlers = exports.EventListener = exports.EmptySearchLabel = exports.CancelPayload = exports.CancelAction = exports.cancel = exports.BaseResource = exports.BadgeStatus = exports.BadgeProgress = exports.Badge = exports.AvatarProps = exports.ALL_RESOURCE_VERTICAL_ALIGNMENT = exports.ALL_MEDIA_KINDS = exports.ALL_BADGE_STATUSES = exports.ALL_BADGE_PROGRESSES = exports.Action = exports.ActionBase = void 0;
var Picker_1 = __webpack_require__(34);
Object.defineProperty(exports, "unstable_Picker", { enumerable: true, get: function () { return Picker_1.unstable_Picker; } });
Object.defineProperty(exports, "Options", { enumerable: true, get: function () { return Picker_1.Options; } });
var Picker_2 = __webpack_require__(34);
Object.defineProperty(exports, "ActionBase", { enumerable: true, get: function () { return Picker_2.ActionBase; } });
Object.defineProperty(exports, "Action", { enumerable: true, get: function () { return Picker_2.Action; } });
Object.defineProperty(exports, "ALL_BADGE_PROGRESSES", { enumerable: true, get: function () { return Picker_2.ALL_BADGE_PROGRESSES; } });
Object.defineProperty(exports, "ALL_BADGE_STATUSES", { enumerable: true, get: function () { return Picker_2.ALL_BADGE_STATUSES; } });
Object.defineProperty(exports, "ALL_MEDIA_KINDS", { enumerable: true, get: function () { return Picker_2.ALL_MEDIA_KINDS; } });
Object.defineProperty(exports, "ALL_RESOURCE_VERTICAL_ALIGNMENT", { enumerable: true, get: function () { return Picker_2.ALL_RESOURCE_VERTICAL_ALIGNMENT; } });
Object.defineProperty(exports, "AvatarProps", { enumerable: true, get: function () { return Picker_2.AvatarProps; } });
Object.defineProperty(exports, "Badge", { enumerable: true, get: function () { return Picker_2.Badge; } });
Object.defineProperty(exports, "BadgeProgress", { enumerable: true, get: function () { return Picker_2.BadgeProgress; } });
Object.defineProperty(exports, "BadgeStatus", { enumerable: true, get: function () { return Picker_2.BadgeStatus; } });
Object.defineProperty(exports, "BaseResource", { enumerable: true, get: function () { return Picker_2.BaseResource; } });
Object.defineProperty(exports, "cancel", { enumerable: true, get: function () { return Picker_2.cancel; } });
Object.defineProperty(exports, "CancelAction", { enumerable: true, get: function () { return Picker_2.CancelAction; } });
Object.defineProperty(exports, "CancelPayload", { enumerable: true, get: function () { return Picker_2.CancelPayload; } });
Object.defineProperty(exports, "EmptySearchLabel", { enumerable: true, get: function () { return Picker_2.EmptySearchLabel; } });
Object.defineProperty(exports, "EventListener", { enumerable: true, get: function () { return Picker_2.EventListener; } });
Object.defineProperty(exports, "Handlers", { enumerable: true, get: function () { return Picker_2.Handlers; } });
Object.defineProperty(exports, "loadMore", { enumerable: true, get: function () { return Picker_2.loadMore; } });
Object.defineProperty(exports, "LoadMoreAction", { enumerable: true, get: function () { return Picker_2.LoadMoreAction; } });
Object.defineProperty(exports, "LoadMorePayload", { enumerable: true, get: function () { return Picker_2.LoadMorePayload; } });
Object.defineProperty(exports, "MediaKind", { enumerable: true, get: function () { return Picker_2.MediaKind; } });
Object.defineProperty(exports, "open", { enumerable: true, get: function () { return Picker_2.open; } });
Object.defineProperty(exports, "OpenAction", { enumerable: true, get: function () { return Picker_2.OpenAction; } });
Object.defineProperty(exports, "Payload", { enumerable: true, get: function () { return Picker_2.Payload; } });
Object.defineProperty(exports, "PickerAction", { enumerable: true, get: function () { return Picker_2.PickerAction; } });
Object.defineProperty(exports, "PickerApi", { enumerable: true, get: function () { return Picker_2.PickerApi; } });
Object.defineProperty(exports, "Resource", { enumerable: true, get: function () { return Picker_2.Resource; } });
Object.defineProperty(exports, "search", { enumerable: true, get: function () { return Picker_2.search; } });
Object.defineProperty(exports, "SearchAction", { enumerable: true, get: function () { return Picker_2.SearchAction; } });
Object.defineProperty(exports, "SearchEventListener", { enumerable: true, get: function () { return Picker_2.SearchEventListener; } });
Object.defineProperty(exports, "SearchPayload", { enumerable: true, get: function () { return Picker_2.SearchPayload; } });
Object.defineProperty(exports, "select", { enumerable: true, get: function () { return Picker_2.select; } });
Object.defineProperty(exports, "SelectAction", { enumerable: true, get: function () { return Picker_2.SelectAction; } });
Object.defineProperty(exports, "SelectEventListener", { enumerable: true, get: function () { return Picker_2.SelectEventListener; } });
Object.defineProperty(exports, "SelectPayload", { enumerable: true, get: function () { return Picker_2.SelectPayload; } });
Object.defineProperty(exports, "ThumbnailProps", { enumerable: true, get: function () { return Picker_2.ThumbnailProps; } });
Object.defineProperty(exports, "update", { enumerable: true, get: function () { return Picker_2.update; } });
Object.defineProperty(exports, "UpdateAction", { enumerable: true, get: function () { return Picker_2.UpdateAction; } });
Object.defineProperty(exports, "VerticalAlignment", { enumerable: true, get: function () { return Picker_2.VerticalAlignment; } });
var create = function (app, options) {
    // eslint-disable-next-line @babel/new-cap
    return new Picker_1.unstable_Picker(app, options);
};
exports.create = create;


/***/ }),
/* 135 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.isFromApp = exports.isPerformanceOrWebVitalsAction = exports.getPermissionKey = exports.isPermitted = exports.isAppMessage = exports.isAppBridgeAction = void 0;
var validator_1 = __webpack_require__(39);
Object.defineProperty(exports, "isAppBridgeAction", { enumerable: true, get: function () { return validator_1.isAppBridgeAction; } });
Object.defineProperty(exports, "isAppMessage", { enumerable: true, get: function () { return validator_1.isAppMessage; } });
Object.defineProperty(exports, "isPermitted", { enumerable: true, get: function () { return validator_1.isPermitted; } });
Object.defineProperty(exports, "getPermissionKey", { enumerable: true, get: function () { return validator_1.getPermissionKey; } });
Object.defineProperty(exports, "isPerformanceOrWebVitalsAction", { enumerable: true, get: function () { return validator_1.isPerformanceOrWebVitalsAction; } });
/**
 * Predicate to determine if an action originated from an application.
 * @internal
 */
function isFromApp(action) {
    if (typeof action !== 'object' || typeof action.source !== 'object') {
        return false;
    }
    return typeof action.source.apiKey === 'string';
}
exports.isFromApp = isFromApp;


/***/ }),
/* 136 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.compatibilityCreateApp = exports.setClientInterfaceHook = void 0;
var base64url_1 = __importDefault(__webpack_require__(137));
var client_1 = __webpack_require__(15);
function toV2Config(config) {
    // App Bridge 1.0 client expects shopOrigin - hostname only, no protocol: `shopname.myshopify.com`
    // App Bridge 2.0 client expects host - shopOrigin with `/admin` appended, and base64 URL encoded: `c2hvcG5hbWUubXlzaG9waWZ5LmNvbQ`
    var shopOriginWithAdmin = config.shopOrigin + "/admin";
    var host = base64url_1.default(shopOriginWithAdmin);
    var apiKey = config.apiKey, forceRedirect = config.forceRedirect;
    var v2Config = {
        apiKey: apiKey,
        host: host,
        forceRedirect: forceRedirect,
    };
    return v2Config;
}
/**
 * Augment actions with clientInterface metadata, identifying use of this library in compatibility mode
 * @internal
 */
var setClientInterfaceHook = function (next) {
    return function (action) {
        action.clientInterface.name = '@shopify/app-bridge [CDN Compatibility]';
        return next(action);
    };
};
exports.setClientInterfaceHook = setClientInterfaceHook;
/**
 * Backward compatible `createApp`
 * @internal
 */
function compatibilityCreateApp(config, createApp) {
    var v2Config = client_1.isV1Config(config) ? toV2Config(config) : config;
    var app = createApp(v2Config);
    if (client_1.isV1Config(config)) {
        app.hooks.set(client_1.LifecycleHook.DispatchAction, exports.setClientInterfaceHook);
    }
    return app;
}
exports.compatibilityCreateApp = compatibilityCreateApp;


/***/ }),
/* 137 */
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__(138).default;
module.exports.default = module.exports;


/***/ }),
/* 138 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(Buffer) {
Object.defineProperty(exports, "__esModule", { value: true });
var pad_string_1 = __webpack_require__(143);
function encode(input, encoding) {
    if (encoding === void 0) { encoding = "utf8"; }
    if (Buffer.isBuffer(input)) {
        return fromBase64(input.toString("base64"));
    }
    return fromBase64(Buffer.from(input, encoding).toString("base64"));
}
;
function decode(base64url, encoding) {
    if (encoding === void 0) { encoding = "utf8"; }
    return Buffer.from(toBase64(base64url), "base64").toString(encoding);
}
function toBase64(base64url) {
    base64url = base64url.toString();
    return pad_string_1.default(base64url)
        .replace(/\-/g, "+")
        .replace(/_/g, "/");
}
function fromBase64(base64) {
    return base64
        .replace(/=/g, "")
        .replace(/\+/g, "-")
        .replace(/\//g, "_");
}
function toBuffer(base64url) {
    return Buffer.from(toBase64(base64url), "base64");
}
var base64url = encode;
base64url.encode = encode;
base64url.decode = decode;
base64url.toBase64 = toBase64;
base64url.fromBase64 = fromBase64;
base64url.toBuffer = toBuffer;
exports.default = base64url;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(65).Buffer))

/***/ }),
/* 139 */
/***/ (function(module, exports) {

var g;

// This works in non-strict mode
g = (function() {
	return this;
})();

try {
	// This works if eval is allowed (see CSP)
	g = g || new Function("return this")();
} catch (e) {
	// This works if the window reference is available
	if (typeof window === "object") g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ }),
/* 140 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


exports.byteLength = byteLength
exports.toByteArray = toByteArray
exports.fromByteArray = fromByteArray

var lookup = []
var revLookup = []
var Arr = typeof Uint8Array !== 'undefined' ? Uint8Array : Array

var code = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/'
for (var i = 0, len = code.length; i < len; ++i) {
  lookup[i] = code[i]
  revLookup[code.charCodeAt(i)] = i
}

// Support decoding URL-safe base64 strings, as Node.js does.
// See: https://en.wikipedia.org/wiki/Base64#URL_applications
revLookup['-'.charCodeAt(0)] = 62
revLookup['_'.charCodeAt(0)] = 63

function getLens (b64) {
  var len = b64.length

  if (len % 4 > 0) {
    throw new Error('Invalid string. Length must be a multiple of 4')
  }

  // Trim off extra bytes after placeholder bytes are found
  // See: https://github.com/beatgammit/base64-js/issues/42
  var validLen = b64.indexOf('=')
  if (validLen === -1) validLen = len

  var placeHoldersLen = validLen === len
    ? 0
    : 4 - (validLen % 4)

  return [validLen, placeHoldersLen]
}

// base64 is 4/3 + up to two characters of the original data
function byteLength (b64) {
  var lens = getLens(b64)
  var validLen = lens[0]
  var placeHoldersLen = lens[1]
  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
}

function _byteLength (b64, validLen, placeHoldersLen) {
  return ((validLen + placeHoldersLen) * 3 / 4) - placeHoldersLen
}

function toByteArray (b64) {
  var tmp
  var lens = getLens(b64)
  var validLen = lens[0]
  var placeHoldersLen = lens[1]

  var arr = new Arr(_byteLength(b64, validLen, placeHoldersLen))

  var curByte = 0

  // if there are placeholders, only get up to the last complete 4 chars
  var len = placeHoldersLen > 0
    ? validLen - 4
    : validLen

  var i
  for (i = 0; i < len; i += 4) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 18) |
      (revLookup[b64.charCodeAt(i + 1)] << 12) |
      (revLookup[b64.charCodeAt(i + 2)] << 6) |
      revLookup[b64.charCodeAt(i + 3)]
    arr[curByte++] = (tmp >> 16) & 0xFF
    arr[curByte++] = (tmp >> 8) & 0xFF
    arr[curByte++] = tmp & 0xFF
  }

  if (placeHoldersLen === 2) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 2) |
      (revLookup[b64.charCodeAt(i + 1)] >> 4)
    arr[curByte++] = tmp & 0xFF
  }

  if (placeHoldersLen === 1) {
    tmp =
      (revLookup[b64.charCodeAt(i)] << 10) |
      (revLookup[b64.charCodeAt(i + 1)] << 4) |
      (revLookup[b64.charCodeAt(i + 2)] >> 2)
    arr[curByte++] = (tmp >> 8) & 0xFF
    arr[curByte++] = tmp & 0xFF
  }

  return arr
}

function tripletToBase64 (num) {
  return lookup[num >> 18 & 0x3F] +
    lookup[num >> 12 & 0x3F] +
    lookup[num >> 6 & 0x3F] +
    lookup[num & 0x3F]
}

function encodeChunk (uint8, start, end) {
  var tmp
  var output = []
  for (var i = start; i < end; i += 3) {
    tmp =
      ((uint8[i] << 16) & 0xFF0000) +
      ((uint8[i + 1] << 8) & 0xFF00) +
      (uint8[i + 2] & 0xFF)
    output.push(tripletToBase64(tmp))
  }
  return output.join('')
}

function fromByteArray (uint8) {
  var tmp
  var len = uint8.length
  var extraBytes = len % 3 // if we have 1 byte left, pad 2 bytes
  var parts = []
  var maxChunkLength = 16383 // must be multiple of 3

  // go through the array every three bytes, we'll deal with trailing stuff later
  for (var i = 0, len2 = len - extraBytes; i < len2; i += maxChunkLength) {
    parts.push(encodeChunk(uint8, i, (i + maxChunkLength) > len2 ? len2 : (i + maxChunkLength)))
  }

  // pad the end with zeros, but make sure to not forget the extra bytes
  if (extraBytes === 1) {
    tmp = uint8[len - 1]
    parts.push(
      lookup[tmp >> 2] +
      lookup[(tmp << 4) & 0x3F] +
      '=='
    )
  } else if (extraBytes === 2) {
    tmp = (uint8[len - 2] << 8) + uint8[len - 1]
    parts.push(
      lookup[tmp >> 10] +
      lookup[(tmp >> 4) & 0x3F] +
      lookup[(tmp << 2) & 0x3F] +
      '='
    )
  }

  return parts.join('')
}


/***/ }),
/* 141 */
/***/ (function(module, exports) {

/*! ieee754. BSD-3-Clause License. Feross Aboukhadijeh <https://feross.org/opensource> */
exports.read = function (buffer, offset, isLE, mLen, nBytes) {
  var e, m
  var eLen = (nBytes * 8) - mLen - 1
  var eMax = (1 << eLen) - 1
  var eBias = eMax >> 1
  var nBits = -7
  var i = isLE ? (nBytes - 1) : 0
  var d = isLE ? -1 : 1
  var s = buffer[offset + i]

  i += d

  e = s & ((1 << (-nBits)) - 1)
  s >>= (-nBits)
  nBits += eLen
  for (; nBits > 0; e = (e * 256) + buffer[offset + i], i += d, nBits -= 8) {}

  m = e & ((1 << (-nBits)) - 1)
  e >>= (-nBits)
  nBits += mLen
  for (; nBits > 0; m = (m * 256) + buffer[offset + i], i += d, nBits -= 8) {}

  if (e === 0) {
    e = 1 - eBias
  } else if (e === eMax) {
    return m ? NaN : ((s ? -1 : 1) * Infinity)
  } else {
    m = m + Math.pow(2, mLen)
    e = e - eBias
  }
  return (s ? -1 : 1) * m * Math.pow(2, e - mLen)
}

exports.write = function (buffer, value, offset, isLE, mLen, nBytes) {
  var e, m, c
  var eLen = (nBytes * 8) - mLen - 1
  var eMax = (1 << eLen) - 1
  var eBias = eMax >> 1
  var rt = (mLen === 23 ? Math.pow(2, -24) - Math.pow(2, -77) : 0)
  var i = isLE ? 0 : (nBytes - 1)
  var d = isLE ? 1 : -1
  var s = value < 0 || (value === 0 && 1 / value < 0) ? 1 : 0

  value = Math.abs(value)

  if (isNaN(value) || value === Infinity) {
    m = isNaN(value) ? 1 : 0
    e = eMax
  } else {
    e = Math.floor(Math.log(value) / Math.LN2)
    if (value * (c = Math.pow(2, -e)) < 1) {
      e--
      c *= 2
    }
    if (e + eBias >= 1) {
      value += rt / c
    } else {
      value += rt * Math.pow(2, 1 - eBias)
    }
    if (value * c >= 2) {
      e++
      c /= 2
    }

    if (e + eBias >= eMax) {
      m = 0
      e = eMax
    } else if (e + eBias >= 1) {
      m = ((value * c) - 1) * Math.pow(2, mLen)
      e = e + eBias
    } else {
      m = value * Math.pow(2, eBias - 1) * Math.pow(2, mLen)
      e = 0
    }
  }

  for (; mLen >= 8; buffer[offset + i] = m & 0xff, i += d, m /= 256, mLen -= 8) {}

  e = (e << mLen) | m
  eLen += mLen
  for (; eLen > 0; buffer[offset + i] = e & 0xff, i += d, e /= 256, eLen -= 8) {}

  buffer[offset + i - d] |= s * 128
}


/***/ }),
/* 142 */
/***/ (function(module, exports) {

var toString = {}.toString;

module.exports = Array.isArray || function (arr) {
  return toString.call(arr) == '[object Array]';
};


/***/ }),
/* 143 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(Buffer) {
Object.defineProperty(exports, "__esModule", { value: true });
function padString(input) {
    var segmentLength = 4;
    var stringLength = input.length;
    var diff = stringLength % segmentLength;
    if (!diff) {
        return input;
    }
    var position = stringLength;
    var padLength = segmentLength - diff;
    var paddedStringLength = stringLength + padLength;
    var buffer = Buffer.alloc(paddedStringLength);
    buffer.write(input);
    while (padLength--) {
        buffer.write("=", position++);
    }
    return buffer.toString();
}
exports.default = padString;

/* WEBPACK VAR INJECTION */}.call(this, __webpack_require__(65).Buffer))

/***/ }),
/* 144 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(145), exports);
__exportStar(__webpack_require__(26), exports);
__exportStar(__webpack_require__(146), exports);
__exportStar(__webpack_require__(148), exports);


/***/ }),
/* 145 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createMutationObserver = exports.setupModalAutoSizing = void 0;
var Modal_1 = __webpack_require__(60);
var MessageTransport_1 = __webpack_require__(22);
var platform_1 = __webpack_require__(26);
var AUTO_SIZE_CLASS = 'app-bridge-utils-modal-auto-size';
var autoSizeStylesheet = createAutoSizeStylesheet();
function createAutoSizeStylesheet() {
    if (typeof document === 'undefined') {
        return null;
    }
    var autoSizeStylesheet = document.createElement('style');
    autoSizeStylesheet.type = 'text/css';
    autoSizeStylesheet.innerHTML = "." + AUTO_SIZE_CLASS + " { overflow: hidden; height: auto; min-height: auto; }";
    return autoSizeStylesheet;
}
function addAutoSizing(app, id) {
    if (!autoSizeStylesheet) {
        return function () { };
    }
    var head = document.getElementsByTagName('head')[0];
    var classList = document.body.classList;
    head.appendChild(autoSizeStylesheet);
    classList.add(AUTO_SIZE_CLASS);
    var mutationObserver = createMutationObserver(app, id);
    return function () {
        classList.remove(AUTO_SIZE_CLASS);
        if (head.contains(autoSizeStylesheet)) {
            head.removeChild(autoSizeStylesheet);
        }
        if (mutationObserver) {
            mutationObserver.disconnect();
        }
    };
}
/**
 * Automatically track changes to the document.body height and dispatch and action to update the modal size
 * @remarks This utility should only be used for an app that is meant to open inside a Modal
 * @param app App Bridge client application instance
 * @returns function to remove the auto-size tracker for the document.body
 *
 * @public
 */
function setupModalAutoSizing(app) {
    return __awaiter(this, void 0, void 0, function () {
        function cleanup() {
            if (removeAutoSizing) {
                removeAutoSizing();
                removeAutoSizing = undefined;
            }
        }
        function handleModalSizeUpdate(appState) {
            var context = appState.context, id = appState.modal.id;
            if (platform_1.isMobile() || context !== MessageTransport_1.Context.Modal) {
                cleanup();
                return cleanup;
            }
            if (!removeAutoSizing) {
                removeAutoSizing = addAutoSizing(app, id);
            }
            return cleanup;
        }
        var removeAutoSizing;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, app.getState().then(handleModalSizeUpdate)];
                case 1:
                    _a.sent();
                    return [2 /*return*/, cleanup];
            }
        });
    });
}
exports.setupModalAutoSizing = setupModalAutoSizing;
/**
 * Sets up modal auto sizing, using a MutationObserver.
 *
 * @param app App Bridge client application instance
 * @param id Currently active modal instance ID
 *
 * @internal
 */
function createMutationObserver(app, id) {
    if (typeof document === 'undefined') {
        return;
    }
    var lastKnownWindowHeight = -1;
    var mutationTimeoutId;
    var mutationObserverConfig = {
        attributes: true,
        attributeOldValue: false,
        characterData: true,
        characterDataOldValue: false,
        childList: true,
        subtree: true,
    };
    var mutationObserver = new MutationObserver(debouncedResizeHandler);
    mutationObserver.observe(document, mutationObserverConfig);
    updateHeight();
    function debouncedResizeHandler() {
        if (mutationTimeoutId) {
            window.clearTimeout(mutationTimeoutId);
        }
        mutationTimeoutId = window.setTimeout(updateHeight, 16);
    }
    function updateHeight() {
        var height = document.body.scrollHeight;
        if (height !== lastKnownWindowHeight) {
            lastKnownWindowHeight = height;
            app.dispatch(Modal_1.updateModalSize({ id: id, height: String(height) }));
        }
    }
    return mutationObserver;
}
exports.createMutationObserver = createMutationObserver;


/***/ }),
/* 146 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(66), exports);
__exportStar(__webpack_require__(147), exports);


/***/ }),
/* 147 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.authenticatedFetch = void 0;
var actions_1 = __webpack_require__(55);
var session_token_1 = __webpack_require__(66);
function authenticatedFetch(app, fetchOperationOrOptions) {
    var _this = this;
    if (fetchOperationOrOptions === void 0) { fetchOperationOrOptions = undefined; }
    return function (uri, options) {
        if (options === void 0) { options = {}; }
        return __awaiter(_this, void 0, void 0, function () {
            var sessionToken, headers, finalHeaders, authenticatedFetchOptions, fetchOperation, response, reauthorizeUrl_1, requestFailureReauthorizeUrlHeader_1;
            var _a;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0: return [4 /*yield*/, session_token_1.getSessionToken(app)];
                    case 1:
                        sessionToken = _b.sent();
                        headers = new Headers(options.headers);
                        headers.append('Authorization', "Bearer " + sessionToken);
                        headers.append('X-Requested-With', 'XMLHttpRequest');
                        finalHeaders = {};
                        headers.forEach(function (value, key) {
                            finalHeaders[key] = value;
                        });
                        authenticatedFetchOptions = typeof fetchOperationOrOptions === 'object' ? fetchOperationOrOptions : undefined;
                        fetchOperation = typeof fetchOperationOrOptions === 'function'
                            ? fetchOperationOrOptions
                            : (_a = authenticatedFetchOptions === null || authenticatedFetchOptions === void 0 ? void 0 : authenticatedFetchOptions.fetchOperation) !== null && _a !== void 0 ? _a : fetch;
                        return [4 /*yield*/, fetchOperation(uri, __assign(__assign({}, options), { headers: finalHeaders }))];
                    case 2:
                        response = _b.sent();
                        if (authenticatedFetchOptions) {
                            reauthorizeUrl_1 = authenticatedFetchOptions.reauthorizeUrl, requestFailureReauthorizeUrlHeader_1 = authenticatedFetchOptions.requestFailureReauthorizeUrlHeader;
                            response.headers.forEach(function (value, name) {
                                if (requestFailureReauthorizeUrlHeader_1.toLowerCase() === name.toLowerCase()) {
                                    var redirectUrl = new URL(reauthorizeUrl_1 || value, location.href).href;
                                    var redirect = actions_1.Redirect.create(app);
                                    if (redirectUrl) {
                                        redirect.dispatch(actions_1.Redirect.Action.REMOTE, redirectUrl);
                                    }
                                    else {
                                        // eslint-disable-next-line no-console
                                        console.warn("Couldn't find a fallback auth path to redirect to.");
                                    }
                                }
                            });
                        }
                        return [2 /*return*/, response];
                }
            });
        });
    };
}
exports.authenticatedFetch = authenticatedFetch;


/***/ }),
/* 148 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
__exportStar(__webpack_require__(67), exports);
__exportStar(__webpack_require__(150), exports);


/***/ }),
/* 149 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.generateUuid = void 0;
var uuid_1 = __webpack_require__(44);
Object.defineProperty(exports, "generateUuid", { enumerable: true, get: function () { return uuid_1.generateUuid; } });
exports.default = uuid_1.generateUuid;


/***/ }),
/* 150 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.userAuthorizedFetch = void 0;
var authorization_code_1 = __webpack_require__(67);
var DEFAULT_CALLBACK_URI = 'auth/shopify/callback';
function needsAuthorizationCode(response) {
    var headerValue = response.headers.get('X-Shopify-API-Request-Failure-Unauthorized');
    if (headerValue) {
        return headerValue.toLowerCase() === 'true';
    }
    return false;
}
function userAuthorizedFetch(_a) {
    var _this = this;
    var app = _a.app, _b = _a.callbackUri, callbackUri = _b === void 0 ? DEFAULT_CALLBACK_URI : _b, _c = _a.isAuthorizationCodeRequired, isAuthorizationCodeRequired = _c === void 0 ? needsAuthorizationCode : _c, fetchOperation = _a.fetchOperation;
    return function (uri, options) { return __awaiter(_this, void 0, void 0, function () {
        var response, _a, code, hmac, shop, timestamp, formattedCallbackUri, callbackResponse;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0: return [4 /*yield*/, fetchOperation(uri, options)];
                case 1:
                    response = _b.sent();
                    if (!isAuthorizationCodeRequired(response)) {
                        return [2 /*return*/, response];
                    }
                    return [4 /*yield*/, authorization_code_1.getAuthorizationCodePayload(app)];
                case 2:
                    _a = _b.sent(), code = _a.code, hmac = _a.hmac, shop = _a.shop, timestamp = _a.timestamp;
                    formattedCallbackUri = encodeURI("https://" + window.location.hostname + "/" + callbackUri + "?code=" + code + "&hmac=" + hmac + "&shop=" + shop + "&timestamp=" + timestamp);
                    return [4 /*yield*/, fetchOperation(formattedCallbackUri, {})];
                case 3:
                    callbackResponse = _b.sent();
                    if (!callbackResponse.ok) {
                        throw new Error('Failed to authorize request.');
                    }
                    return [2 /*return*/, fetchOperation(uri, options)];
            }
        });
    }); };
}
exports.userAuthorizedFetch = userAuthorizedFetch;


/***/ })
/******/ ]);
});