import { gql } from 'graphql-request';
export const AppVersionByTagQuery = gql `
  query AppVersionByTag($apiKey: String!, $versionTag: String!) {
    app(apiKey: $apiKey) {
      appVersion(versionTag: $versionTag) {
        id
        uuid
        versionTag
        location
        message
        appModuleVersions {
          config
          specification {
            identifier
            name
            experience
            options {
              managementExperience
            }
          }
        }
      }
    }
  }
`;
//# sourceMappingURL=app_version_by_tag.js.map