import { gql } from 'graphql-request';
export const AppVersionsDiffQuery = gql `
  query AppVersionsDiff($apiKey: String!, $versionId: ID!) {
    app(apiKey: $apiKey) {
      versionsDiff(appVersionId: $versionId) {
        added {
          uuid
          registrationTitle
          specification {
            identifier
            experience
            options {
              managementExperience
            }
          }
        }
        updated {
          uuid
          registrationTitle
          specification {
            identifier
            experience
            options {
              managementExperience
            }
          }
        }
        removed {
          uuid
          registrationTitle
          specification {
            identifier
            experience
            options {
              managementExperience
            }
          }
        }
      }
    }
  }
`;
//# sourceMappingURL=app_versions_diff.js.map