export declare const CreateAppQuery: string;
export interface CreateAppQueryVariables {
    org: number;
    title: string;
    appUrl: string;
    redir: string[];
    type: string;
    requestedAccessScopes?: string[];
}
export interface CreateAppQuerySchema {
    appCreate: {
        app: {
            id: string;
            title: string;
            apiKey: string;
            organizationId: string;
            apiSecretKeys: {
                secret: string;
            }[];
            appType: string;
            grantedScopes: string[];
            applicationUrl: string;
            redirectUrlWhitelist: string[];
            requestedAccessScopes?: string[];
        };
        userErrors: {
            field: string[];
            message: string;
        }[];
    };
}
