import { gql } from 'graphql-request';
export const CreateAppQuery = gql `
  mutation AppCreate(
    $org: Int!
    $title: String!
    $appUrl: Url!
    $redir: [Url]!
    $type: AppType
    $requestedAccessScopes: [String!]
  ) {
    appCreate(
      input: {
        organizationID: $org
        title: $title
        applicationUrl: $appUrl
        redirectUrlWhitelist: $redir
        appType: $type
        requestedAccessScopes: $requestedAccessScopes
      }
    ) {
      app {
        id
        title
        apiKey
        organizationId
        apiSecretKeys {
          secret
        }
        appType
        grantedScopes
        applicationUrl
        redirectUrlWhitelist
        requestedAccessScopes
      }
      userErrors {
        field
        message
      }
    }
  }
`;
//# sourceMappingURL=create_app.js.map