import { partnersRequest } from '@shopify/cli-kit/node/api/partners';
import { AbortError } from '@shopify/cli-kit/node/error';
import { gql } from 'graphql-request';
const CurrentAccountInfoQuery = gql `
  query currentAccountInfo {
    currentAccountInfo {
      __typename
      ... on ServiceAccount {
        orgName
      }
      ... on UserAccount {
        email
      }
    }
  }
`;
export async function geCurrentAccountInfo(token) {
    const { currentAccountInfo } = await partnersRequest(CurrentAccountInfoQuery, token);
    if (!currentAccountInfo) {
        throw new AbortError('Unable to get current user account');
    }
    return mapAccountInfo(currentAccountInfo);
}
function mapAccountInfo(accountInfo) {
    if (accountInfo.__typename === 'UserAccount') {
        return {
            type: 'UserAccount',
            email: accountInfo.email,
        };
    }
    else if (accountInfo.__typename === 'ServiceAccount') {
        return {
            type: 'ServiceAccount',
            orgName: accountInfo.orgName,
        };
    }
    else {
        return { type: 'UnknownAccount' };
    }
}
//# sourceMappingURL=current_account_info.js.map