import { appFlags } from '../../flags.js';
import { loadApp } from '../../models/app/loader.js';
import { importFlowExtensions } from '../../services/import-flow-legacy-extensions.js';
import Command from '../../utilities/app-command.js';
import { loadLocalExtensionsSpecifications } from '../../models/extensions/load-specifications.js';
import { Flags } from '@oclif/core';
import { globalFlags } from '@shopify/cli-kit/node/cli';
class AppImportFlowExtension extends Command {
    async run() {
        const { flags } = await this.parse(AppImportFlowExtension);
        const specifications = await loadLocalExtensionsSpecifications();
        const app = await loadApp({ specifications, directory: flags.path, configName: flags.config });
        await importFlowExtensions({ app, apiKey: flags['client-id'] });
    }
}
AppImportFlowExtension.description = 'Import dashboard-managed flow extensions into your app.';
AppImportFlowExtension.flags = {
    ...globalFlags,
    ...appFlags,
    'client-id': Flags.string({
        hidden: false,
        description: 'The Client ID of your app.',
        env: 'SHOPIFY_FLAG_CLIENT_ID',
        exclusive: ['config'],
    }),
};
export default AppImportFlowExtension;
//# sourceMappingURL=import-flow-legacy-extensions.js.map