import { appFlags } from '../../../flags.js';
import Command from '../../../utilities/app-command.js';
import versionList from '../../../services/versions-list.js';
import { loadLocalExtensionsSpecifications } from '../../../models/extensions/load-specifications.js';
import { loadApp } from '../../../models/app/loader.js';
import { showApiKeyDeprecationWarning } from '../../../prompts/deprecation-warnings.js';
import { globalFlags } from '@shopify/cli-kit/node/cli';
import { Args, Flags } from '@oclif/core';
class VersionsList extends Command {
    async run() {
        const { flags } = await this.parse(VersionsList);
        if (flags['api-key']) {
            await showApiKeyDeprecationWarning();
        }
        const apiKey = flags['client-id'] || flags['api-key'];
        const specifications = await loadLocalExtensionsSpecifications();
        const app = await loadApp({ specifications, directory: flags.path, configName: flags.config });
        await versionList({
            app,
            apiKey,
            reset: false,
            json: flags.json,
        });
    }
}
VersionsList.description = 'List deployed versions of your app.';
VersionsList.examples = ['<%= config.bin %> <%= command.id %>'];
VersionsList.flags = {
    ...globalFlags,
    ...appFlags,
    'api-key': Flags.string({
        hidden: true,
        description: "Application's API key to fetch versions for.",
        env: 'SHOPIFY_FLAG_API_KEY',
        exclusive: ['config'],
    }),
    'client-id': Flags.string({
        hidden: false,
        description: 'The Client ID to fetch versions for.',
        env: 'SHOPIFY_FLAG_CLIENT_ID',
        exclusive: ['config'],
    }),
    json: Flags.boolean({
        description: 'Output the versions list as JSON.',
        default: false,
        env: 'SHOPIFY_FLAG_JSON',
    }),
};
VersionsList.args = {
    file: Args.string(),
};
export default VersionsList;
//# sourceMappingURL=list.js.map