import { AppErrors } from './loader.js';
import { ExtensionInstance } from '../extensions/extension-instance.js';
import { FunctionConfigType } from '../extensions/specifications/function.js';
import { ExtensionSpecification } from '../extensions/specification.js';
import { SpecsAppConfiguration } from '../extensions/specifications/types/app_config.js';
import { BetaFlag } from '../../services/dev/fetch.js';
import { zod } from '@shopify/cli-kit/node/schema';
import { DotEnvFile } from '@shopify/cli-kit/node/dot-env';
import { PackageManager } from '@shopify/cli-kit/node/node-package-manager';
export declare const LegacyAppSchema: zod.ZodObject<{
    client_id: zod.ZodOptional<zod.ZodNumber>;
    name: zod.ZodOptional<zod.ZodString>;
    scopes: zod.ZodDefault<zod.ZodString>;
    extension_directories: zod.ZodOptional<zod.ZodArray<zod.ZodString, "many">>;
    web_directories: zod.ZodOptional<zod.ZodArray<zod.ZodString, "many">>;
}, "strict", zod.ZodTypeAny, {
    scopes: string;
    client_id?: number | undefined;
    name?: string | undefined;
    extension_directories?: string[] | undefined;
    web_directories?: string[] | undefined;
}, {
    client_id?: number | undefined;
    name?: string | undefined;
    scopes?: string | undefined;
    extension_directories?: string[] | undefined;
    web_directories?: string[] | undefined;
}>;
export declare const AppSchema: zod.ZodObject<{
    client_id: zod.ZodString;
    build: zod.ZodOptional<zod.ZodObject<{
        automatically_update_urls_on_dev: zod.ZodOptional<zod.ZodBoolean>;
        dev_store_url: zod.ZodOptional<zod.ZodString>;
        include_config_on_deploy: zod.ZodOptional<zod.ZodBoolean>;
    }, "strip", zod.ZodTypeAny, {
        automatically_update_urls_on_dev?: boolean | undefined;
        dev_store_url?: string | undefined;
        include_config_on_deploy?: boolean | undefined;
    }, {
        automatically_update_urls_on_dev?: boolean | undefined;
        dev_store_url?: string | undefined;
        include_config_on_deploy?: boolean | undefined;
    }>>;
    extension_directories: zod.ZodOptional<zod.ZodArray<zod.ZodString, "many">>;
    web_directories: zod.ZodOptional<zod.ZodArray<zod.ZodString, "many">>;
}, "strip", zod.ZodTypeAny, {
    client_id: string;
    build?: {
        automatically_update_urls_on_dev?: boolean | undefined;
        dev_store_url?: string | undefined;
        include_config_on_deploy?: boolean | undefined;
    } | undefined;
    extension_directories?: string[] | undefined;
    web_directories?: string[] | undefined;
}, {
    client_id: string;
    build?: {
        automatically_update_urls_on_dev?: boolean | undefined;
        dev_store_url?: string | undefined;
        include_config_on_deploy?: boolean | undefined;
    } | undefined;
    extension_directories?: string[] | undefined;
    web_directories?: string[] | undefined;
}>;
export declare const AppConfigurationSchema: zod.ZodUnion<[zod.ZodObject<{
    client_id: zod.ZodOptional<zod.ZodNumber>;
    name: zod.ZodOptional<zod.ZodString>;
    scopes: zod.ZodDefault<zod.ZodString>;
    extension_directories: zod.ZodOptional<zod.ZodArray<zod.ZodString, "many">>;
    web_directories: zod.ZodOptional<zod.ZodArray<zod.ZodString, "many">>;
}, "strict", zod.ZodTypeAny, {
    scopes: string;
    client_id?: number | undefined;
    name?: string | undefined;
    extension_directories?: string[] | undefined;
    web_directories?: string[] | undefined;
}, {
    client_id?: number | undefined;
    name?: string | undefined;
    scopes?: string | undefined;
    extension_directories?: string[] | undefined;
    web_directories?: string[] | undefined;
}>, zod.ZodObject<{
    client_id: zod.ZodString;
    build: zod.ZodOptional<zod.ZodObject<{
        automatically_update_urls_on_dev: zod.ZodOptional<zod.ZodBoolean>;
        dev_store_url: zod.ZodOptional<zod.ZodString>;
        include_config_on_deploy: zod.ZodOptional<zod.ZodBoolean>;
    }, "strip", zod.ZodTypeAny, {
        automatically_update_urls_on_dev?: boolean | undefined;
        dev_store_url?: string | undefined;
        include_config_on_deploy?: boolean | undefined;
    }, {
        automatically_update_urls_on_dev?: boolean | undefined;
        dev_store_url?: string | undefined;
        include_config_on_deploy?: boolean | undefined;
    }>>;
    extension_directories: zod.ZodOptional<zod.ZodArray<zod.ZodString, "many">>;
    web_directories: zod.ZodOptional<zod.ZodArray<zod.ZodString, "many">>;
}, "strip", zod.ZodTypeAny, {
    client_id: string;
    build?: {
        automatically_update_urls_on_dev?: boolean | undefined;
        dev_store_url?: string | undefined;
        include_config_on_deploy?: boolean | undefined;
    } | undefined;
    extension_directories?: string[] | undefined;
    web_directories?: string[] | undefined;
}, {
    client_id: string;
    build?: {
        automatically_update_urls_on_dev?: boolean | undefined;
        dev_store_url?: string | undefined;
        include_config_on_deploy?: boolean | undefined;
    } | undefined;
    extension_directories?: string[] | undefined;
    web_directories?: string[] | undefined;
}>]>;
export declare function getAppVersionedSchema(specs: ExtensionSpecification[]): any;
/**
 * Check whether a shopify.app.toml schema is valid against the legacy schema definition.
 * @param item - the item to validate
 */
export declare function isLegacyAppSchema(item: AppConfiguration): item is LegacyAppConfiguration;
/**
 * Check whether a shopify.app.toml schema is valid against the current schema definition.
 * @param item - the item to validate
 */
export declare function isCurrentAppSchema(item: AppConfiguration): item is CurrentAppConfiguration;
/**
 * Get scopes from a given app.toml config file.
 * @param config - a configuration file
 */
export declare function getAppScopes(config: AppConfiguration): string;
/**
 * Get scopes as an array from a given app.toml config file.
 * @param config - a configuration file
 */
export declare function getAppScopesArray(config: AppConfiguration): string[];
export declare function usesLegacyScopesBehavior(config: AppConfiguration): boolean;
export declare function appIsLaunchable(app: AppInterface): boolean;
export declare function filterNonVersionedAppFields(configuration: {
    [key: string]: unknown;
}): string[];
export declare enum WebType {
    Frontend = "frontend",
    Backend = "backend",
    Background = "background"
}
export declare const WebConfigurationSchema: zod.ZodUnion<[zod.ZodObject<{
    name: zod.ZodOptional<zod.ZodString>;
    auth_callback_path: zod.ZodOptional<zod.ZodUnion<[zod.ZodEffects<zod.ZodString, string, unknown>, zod.ZodArray<zod.ZodEffects<zod.ZodString, string, unknown>, "many">]>>;
    webhooks_path: zod.ZodOptional<zod.ZodEffects<zod.ZodString, string, unknown>>;
    port: zod.ZodOptional<zod.ZodNumber>;
    commands: zod.ZodObject<{
        build: zod.ZodOptional<zod.ZodString>;
        dev: zod.ZodString;
    }, "strip", zod.ZodTypeAny, {
        dev: string;
        build?: string | undefined;
    }, {
        dev: string;
        build?: string | undefined;
    }>;
    hmr_server: zod.ZodOptional<zod.ZodObject<{
        http_paths: zod.ZodArray<zod.ZodString, "many">;
    }, "strip", zod.ZodTypeAny, {
        http_paths: string[];
    }, {
        http_paths: string[];
    }>>;
    roles: zod.ZodArray<zod.ZodDefault<zod.ZodEnum<[WebType.Frontend, WebType.Backend, WebType.Background]>>, "many">;
}, "strip", zod.ZodTypeAny, {
    commands: {
        dev: string;
        build?: string | undefined;
    };
    roles: WebType[];
    name?: string | undefined;
    auth_callback_path?: string | string[] | undefined;
    webhooks_path?: string | undefined;
    port?: number | undefined;
    hmr_server?: {
        http_paths: string[];
    } | undefined;
}, {
    commands: {
        dev: string;
        build?: string | undefined;
    };
    roles: (WebType | undefined)[];
    name?: string | undefined;
    auth_callback_path?: unknown;
    webhooks_path?: unknown;
    port?: number | undefined;
    hmr_server?: {
        http_paths: string[];
    } | undefined;
}>, zod.ZodObject<{
    name: zod.ZodOptional<zod.ZodString>;
    auth_callback_path: zod.ZodOptional<zod.ZodUnion<[zod.ZodEffects<zod.ZodString, string, unknown>, zod.ZodArray<zod.ZodEffects<zod.ZodString, string, unknown>, "many">]>>;
    webhooks_path: zod.ZodOptional<zod.ZodEffects<zod.ZodString, string, unknown>>;
    port: zod.ZodOptional<zod.ZodNumber>;
    commands: zod.ZodObject<{
        build: zod.ZodOptional<zod.ZodString>;
        dev: zod.ZodString;
    }, "strip", zod.ZodTypeAny, {
        dev: string;
        build?: string | undefined;
    }, {
        dev: string;
        build?: string | undefined;
    }>;
    hmr_server: zod.ZodOptional<zod.ZodObject<{
        http_paths: zod.ZodArray<zod.ZodString, "many">;
    }, "strip", zod.ZodTypeAny, {
        http_paths: string[];
    }, {
        http_paths: string[];
    }>>;
    type: zod.ZodDefault<zod.ZodEnum<[WebType.Frontend, WebType.Backend, WebType.Background]>>;
}, "strip", zod.ZodTypeAny, {
    type: WebType;
    commands: {
        dev: string;
        build?: string | undefined;
    };
    name?: string | undefined;
    auth_callback_path?: string | string[] | undefined;
    webhooks_path?: string | undefined;
    port?: number | undefined;
    hmr_server?: {
        http_paths: string[];
    } | undefined;
}, {
    commands: {
        dev: string;
        build?: string | undefined;
    };
    name?: string | undefined;
    auth_callback_path?: unknown;
    webhooks_path?: unknown;
    port?: number | undefined;
    hmr_server?: {
        http_paths: string[];
    } | undefined;
    type?: WebType | undefined;
}>]>;
export declare const ProcessedWebConfigurationSchema: zod.ZodObject<{
    name: zod.ZodOptional<zod.ZodString>;
    auth_callback_path: zod.ZodOptional<zod.ZodUnion<[zod.ZodEffects<zod.ZodString, string, unknown>, zod.ZodArray<zod.ZodEffects<zod.ZodString, string, unknown>, "many">]>>;
    webhooks_path: zod.ZodOptional<zod.ZodEffects<zod.ZodString, string, unknown>>;
    port: zod.ZodOptional<zod.ZodNumber>;
    commands: zod.ZodObject<{
        build: zod.ZodOptional<zod.ZodString>;
        dev: zod.ZodString;
    }, "strip", zod.ZodTypeAny, {
        dev: string;
        build?: string | undefined;
    }, {
        dev: string;
        build?: string | undefined;
    }>;
    hmr_server: zod.ZodOptional<zod.ZodObject<{
        http_paths: zod.ZodArray<zod.ZodString, "many">;
    }, "strip", zod.ZodTypeAny, {
        http_paths: string[];
    }, {
        http_paths: string[];
    }>>;
    roles: zod.ZodArray<zod.ZodDefault<zod.ZodEnum<[WebType.Frontend, WebType.Backend, WebType.Background]>>, "many">;
}, "strip", zod.ZodTypeAny, {
    commands: {
        dev: string;
        build?: string | undefined;
    };
    roles: WebType[];
    name?: string | undefined;
    auth_callback_path?: string | string[] | undefined;
    webhooks_path?: string | undefined;
    port?: number | undefined;
    hmr_server?: {
        http_paths: string[];
    } | undefined;
}, {
    commands: {
        dev: string;
        build?: string | undefined;
    };
    roles: (WebType | undefined)[];
    name?: string | undefined;
    auth_callback_path?: unknown;
    webhooks_path?: unknown;
    port?: number | undefined;
    hmr_server?: {
        http_paths: string[];
    } | undefined;
}>;
export type AppConfiguration = zod.infer<typeof AppConfigurationSchema> & {
    path: string;
};
export type CurrentAppConfiguration = zod.infer<typeof AppSchema> & {
    path: string;
} & SpecsAppConfiguration;
export type LegacyAppConfiguration = zod.infer<typeof LegacyAppSchema> & {
    path: string;
};
export type WebConfiguration = zod.infer<typeof WebConfigurationSchema>;
export type ProcessedWebConfiguration = zod.infer<typeof ProcessedWebConfigurationSchema>;
export type WebConfigurationCommands = keyof WebConfiguration['commands'];
export interface Web {
    directory: string;
    configuration: ProcessedWebConfiguration;
    framework?: string;
}
export interface AppConfigurationInterface {
    directory: string;
    configuration: AppConfiguration;
    configSchema: zod.ZodTypeAny;
}
export interface AppInterface extends AppConfigurationInterface {
    name: string;
    idEnvironmentVariableName: string;
    packageManager: PackageManager;
    nodeDependencies: {
        [key: string]: string;
    };
    webs: Web[];
    usesWorkspaces: boolean;
    dotenv?: DotEnvFile;
    allExtensions: ExtensionInstance[];
    draftableExtensions: ExtensionInstance[];
    specifications?: ExtensionSpecification[];
    errors?: AppErrors;
    includeConfigOnDeploy: boolean | undefined;
    hasExtensions: () => boolean;
    updateDependencies: () => Promise<void>;
    extensionsForType: (spec: {
        identifier: string;
        externalIdentifier: string;
    }) => ExtensionInstance[];
    updateExtensionUUIDS: (uuids: {
        [key: string]: string;
    }) => void;
    preDeployValidation: () => Promise<void>;
}
interface AppConstructor {
    name: string;
    idEnvironmentVariableName: string;
    directory: string;
    packageManager: PackageManager;
    configuration: AppConfiguration;
    nodeDependencies: {
        [key: string]: string;
    };
    webs: Web[];
    modules: ExtensionInstance[];
    usesWorkspaces: boolean;
    dotenv?: DotEnvFile;
    errors?: AppErrors;
    specifications?: ExtensionSpecification[];
    configSchema?: zod.ZodTypeAny;
    remoteBetaFlags?: BetaFlag[];
}
export declare class App implements AppInterface {
    name: string;
    idEnvironmentVariableName: string;
    directory: string;
    packageManager: PackageManager;
    configuration: AppConfiguration;
    nodeDependencies: {
        [key: string]: string;
    };
    webs: Web[];
    usesWorkspaces: boolean;
    dotenv?: DotEnvFile;
    errors?: AppErrors;
    specifications?: ExtensionSpecification[];
    configSchema: zod.ZodTypeAny;
    private remoteBetaFlags;
    private realExtensions;
    constructor({ name, idEnvironmentVariableName, directory, packageManager, configuration, nodeDependencies, webs, modules, usesWorkspaces, dotenv, errors, specifications, configSchema, remoteBetaFlags, }: AppConstructor);
    get allExtensions(): ExtensionInstance<{
        name: string;
        type: string;
        metafields: {
            namespace: string;
            key: string;
        }[];
        handle?: string | undefined;
        description?: string | undefined;
        api_version?: string | undefined;
        extension_points?: any;
        capabilities?: {
            network_access?: boolean | undefined;
            block_progress?: boolean | undefined;
            api_access?: boolean | undefined;
            collect_buyer_consent?: {
                sms_marketing?: boolean | undefined;
                customer_privacy?: boolean | undefined;
            } | undefined;
        } | undefined;
        settings?: {
            fields?: {
                type: string;
                key?: string | undefined;
                name?: string | undefined;
                description?: string | undefined;
                required?: boolean | undefined;
                validations?: any[] | undefined;
            }[] | undefined;
        } | undefined;
    }>[];
    get draftableExtensions(): ExtensionInstance<{
        name: string;
        type: string;
        metafields: {
            namespace: string;
            key: string;
        }[];
        handle?: string | undefined;
        description?: string | undefined;
        api_version?: string | undefined;
        extension_points?: any;
        capabilities?: {
            network_access?: boolean | undefined;
            block_progress?: boolean | undefined;
            api_access?: boolean | undefined;
            collect_buyer_consent?: {
                sms_marketing?: boolean | undefined;
                customer_privacy?: boolean | undefined;
            } | undefined;
        } | undefined;
        settings?: {
            fields?: {
                type: string;
                key?: string | undefined;
                name?: string | undefined;
                description?: string | undefined;
                required?: boolean | undefined;
                validations?: any[] | undefined;
            }[] | undefined;
        } | undefined;
    }>[];
    updateDependencies(): Promise<void>;
    preDeployValidation(): Promise<void>;
    hasExtensions(): boolean;
    extensionsForType(specification: {
        identifier: string;
        externalIdentifier: string;
    }): ExtensionInstance[];
    updateExtensionUUIDS(uuids: {
        [key: string]: string;
    }): void;
    get includeConfigOnDeploy(): boolean | undefined;
    private configurationTyped;
}
export declare function buildSpecsAppConfiguration(content: object): {
    auth?: {
        redirect_urls: string[];
    } | undefined;
    access_scopes?: {
        scopes: string | undefined;
        use_legacy_install_flow: boolean | undefined;
    } | undefined;
    webhooks: {
        api_version?: string | undefined;
        privacy_compliance?: import("../extensions/specifications/types/app_config_webhook.js").PrivacyComplianceConfig | undefined;
        subscriptions?: import("../extensions/specifications/types/app_config_webhook.js").WebhookSubscription[] | undefined;
    };
    pos?: {
        embedded: boolean;
    } | undefined;
    app_proxy?: {
        url: string;
        prefix: string;
        subpath: string;
    } | undefined;
    app_preferences?: {
        url: string;
    } | undefined;
    name: string;
    application_url: string;
    embedded: boolean;
};
export declare function validateFunctionExtensionsWithUiHandle(functionExtensionsWithUiHandle: ExtensionInstance<FunctionConfigType>[], allExtensions: ExtensionInstance[]): string[] | undefined;
export declare class EmptyApp extends App {
    constructor(specifications?: ExtensionSpecification[], betas?: BetaFlag[], clientId?: string);
}
type RendererVersionResult = {
    name: string;
    version: string;
} | undefined | 'not_found';
/**
 * Given a UI extension, it returns the version of the renderer package.
 * Looks for `/node_modules/@shopify/{renderer-package-name}/package.json` to find the real version used.
 * @param extension - UI extension whose renderer version will be obtained.
 * @returns The version if the dependency exists.
 */
export declare function getUIExtensionRendererVersion(extension: ExtensionInstance): Promise<RendererVersionResult>;
export declare function getDependencyVersion(dependency: string, directory: string): Promise<RendererVersionResult>;
export {};
