import { AppInterface } from './app.js';
import { ExtensionTemplate } from './template.js';
import { RemoteSpecification } from '../../api/graphql/extension_specifications.js';
import { ExtensionInstance } from '../extensions/extension-instance.js';
import { FunctionConfigType } from '../extensions/specifications/function.js';
import { OrganizationApp } from '../organization.js';
import { BaseConfigType } from '../extensions/schemas.js';
import { PartnersSession } from '../../services/context/partner-account-info.js';
import { WebhooksConfig } from '../extensions/specifications/types/app_config_webhook.js';
import { PaymentsAppExtensionConfigType } from '../extensions/specifications/payments_app_extension.js';
export declare const DEFAULT_CONFIG: {
    path: string;
    application_url: string;
    client_id: string;
    name: string;
    webhooks: {
        api_version: string;
    };
    embedded: boolean;
    access_scopes: {
        scopes: string;
    };
};
export declare function testApp(app?: Partial<AppInterface>, schemaType?: 'current' | 'legacy'): AppInterface;
interface TestAppWithConfigOptions {
    app?: Partial<AppInterface>;
    config: object;
}
export declare function testAppWithLegacyConfig({ app, config }: TestAppWithConfigOptions): AppInterface;
export declare function testAppWithConfig(options?: TestAppWithConfigOptions): AppInterface;
export declare function getWebhookConfig(webhookConfigOverrides?: WebhooksConfig): {
    webhooks: {
        api_version: string;
        privacy_compliance?: import("../extensions/specifications/types/app_config_webhook.js").PrivacyComplianceConfig | undefined;
        subscriptions?: import("../extensions/specifications/types/app_config_webhook.js").WebhookSubscription[] | undefined;
    };
    path: string;
    application_url: string;
    client_id: string;
    name: string;
    embedded: boolean;
    access_scopes: {
        scopes: string;
    };
};
export declare function testOrganizationApp(app?: Partial<OrganizationApp>): OrganizationApp;
export declare function testUIExtension(uiExtension?: Omit<Partial<ExtensionInstance>, 'configuration'> & {
    configuration?: Partial<BaseConfigType> & {
        path?: string;
    };
}): Promise<ExtensionInstance>;
export declare function testThemeExtensions(directory?: string): Promise<ExtensionInstance>;
export declare function testAppConfigExtensions(emptyConfig?: boolean): Promise<ExtensionInstance>;
export declare function testPaymentExtensions(directory?: string): Promise<ExtensionInstance>;
export declare function testWebhookExtensions(emptyConfig?: boolean): Promise<ExtensionInstance>;
export declare function testWebPixelExtension(directory?: string): Promise<ExtensionInstance>;
export declare function testTaxCalculationExtension(directory?: string): Promise<ExtensionInstance>;
export declare function testFlowActionExtension(directory?: string): Promise<ExtensionInstance>;
interface TestFunctionExtensionOptions {
    dir?: string;
    config?: FunctionConfigType;
    entryPath?: string;
}
export declare function testFunctionExtension(opts?: TestFunctionExtensionOptions): Promise<ExtensionInstance<FunctionConfigType>>;
interface TestPaymentsAppExtensionOptions {
    dir?: string;
    config: PaymentsAppExtensionConfigType;
    entryPath?: string;
}
export declare function testPaymentsAppExtension(opts: TestPaymentsAppExtensionOptions): Promise<ExtensionInstance<PaymentsAppExtensionConfigType>>;
export declare const testRemoteSpecifications: RemoteSpecification[];
export declare const testRemoteExtensionTemplates: ExtensionTemplate[];
export declare const testLocalExtensionTemplates: ExtensionTemplate[];
export declare const testPartnersUserSession: PartnersSession;
export declare const testPartnersServiceSession: PartnersSession;
export declare function buildVersionedAppSchema(): Promise<{
    schema: any;
    configSpecifications: import("../extensions/specification.js").ExtensionSpecification<{
        name: string;
        type: string;
        metafields: {
            namespace: string;
            key: string;
        }[];
        handle?: string | undefined;
        description?: string | undefined;
        api_version?: string | undefined;
        extension_points?: any;
        capabilities?: {
            network_access?: boolean | undefined;
            block_progress?: boolean | undefined;
            api_access?: boolean | undefined;
            collect_buyer_consent?: {
                sms_marketing?: boolean | undefined;
                customer_privacy?: boolean | undefined;
            } | undefined;
        } | undefined;
        settings?: {
            fields?: {
                type: string;
                key?: string | undefined;
                name?: string | undefined;
                description?: string | undefined;
                required?: boolean | undefined;
                validations?: any[] | undefined;
            }[] | undefined;
        } | undefined;
    }>[];
}>;
export declare function configurationSpecifications(): Promise<import("../extensions/specification.js").ExtensionSpecification<{
    name: string;
    type: string;
    metafields: {
        namespace: string;
        key: string;
    }[];
    handle?: string | undefined;
    description?: string | undefined;
    api_version?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    } | undefined;
    settings?: {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    } | undefined;
}>[]>;
export {};
