import { Web, AppInterface, WebType, AppConfigurationInterface } from './app.js';
import { ExtensionSpecification } from '../extensions/specification.js';
import { BetaFlag } from '../../services/dev/fetch.js';
import { zod } from '@shopify/cli-kit/node/schema';
import { DotEnvFile } from '@shopify/cli-kit/node/dot-env';
import { OutputMessage } from '@shopify/cli-kit/node/output';
export type AppLoaderMode = 'strict' | 'report';
type AbortOrReport = <T>(errorMessage: OutputMessage, fallback: T, configurationPath: string, rawErrors?: zod.ZodIssueBase[]) => T;
export declare function loadConfigurationFile(filepath: string, abortOrReport?: AbortOrReport, decode?: (input: string) => object): Promise<unknown>;
export declare function parseConfigurationFile<TSchema extends zod.ZodType>(schema: TSchema, filepath: string, abortOrReport?: AbortOrReport, decode?: (input: string) => object): Promise<zod.TypeOf<TSchema> & {
    path: string;
}>;
export declare function parseConfigurationObject<TSchema extends zod.ZodType>(schema: TSchema, filepath: string, configurationObject: unknown, abortOrReport: AbortOrReport): Promise<zod.TypeOf<TSchema>>;
export declare function findSpecificationForType(specifications: ExtensionSpecification[], type: string): ExtensionSpecification<{
    name: string;
    type: string;
    metafields: {
        namespace: string;
        key: string;
    }[];
    handle?: string | undefined;
    description?: string | undefined;
    api_version?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    } | undefined;
    settings?: {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    } | undefined;
}> | undefined;
export declare class AppErrors {
    private errors;
    addError(path: string, message: OutputMessage): void;
    getError(path: string): OutputMessage | undefined;
    isEmpty(): boolean;
    toJSON(): OutputMessage[];
}
interface AppLoaderConstructorArgs {
    directory: string;
    mode?: AppLoaderMode;
    configName?: string;
    specifications?: ExtensionSpecification[];
    remoteBetas?: BetaFlag[];
}
/**
 * Load the local app from the given directory and using the provided extensions/functions specifications.
 * If the App contains extensions not supported by the current specs and mode is strict, it will throw an error.
 */
export declare function loadApp(options: AppLoaderConstructorArgs): Promise<AppInterface>;
export declare function getDotEnvFileName(configurationPath: string): string;
export declare function loadDotEnv(appDirectory: string, configurationPath: string): Promise<DotEnvFile | undefined>;
/**
 * Parse the app configuration file from the given directory.
 * If the app configuration does not match any known schemas, it will throw an error.
 */
export declare function loadAppConfiguration(options: AppConfigurationLoaderConstructorArgs): Promise<AppConfigurationInterface>;
interface AppConfigurationLoaderConstructorArgs {
    directory: string;
    configName?: string;
    specifications?: ExtensionSpecification[];
    remoteBetas?: BetaFlag[];
}
export declare function loadAppName(appDirectory: string): Promise<string>;
export declare function isWebType(web: Web, type: WebType): boolean;
export declare const appConfigurationFileNameRegex: RegExp;
export declare function getAppConfigurationFileName(configName?: string): string;
export declare function getAppConfigurationShorthand(path: string): string | undefined;
export {};
