// adding http or https presence and absence of new lines to url validation
export const httpsRegex = /^(https:\/\/)/;
export const validateUrl = (zodType, { httpsOnly = false, message = 'Invalid url' } = {}) => {
    const regex = httpsOnly ? httpsRegex : /^(https?:\/\/)/;
    return zodType
        .url()
        .refine((value) => Boolean(value.match(regex)), { message })
        .refine((value) => !value.includes('\n'), { message });
};
export const ensurePathStartsWithSlash = (arg) => typeof arg === 'string' && !arg.startsWith('/') ? `/${arg}` : arg;
//# sourceMappingURL=common.js.map