import { BaseConfigType } from './schemas.js';
import { ExtensionFeature, ExtensionSpecification } from './specification.js';
import { ExtensionBuildOptions } from '../../services/build/extension.js';
import { Identifiers } from '../app/identifiers.js';
/**
 * Class that represents an instance of a local extension
 * Before creating this class we've validated that:
 * - There is a spec for this type of extension
 * - The Schema for that spec is followed by the extension config toml file
 * - We were able to find an entry point file for that extension
 *
 * It supports extension points, making this Class compatible with both new ui-extension
 * and legacy extension types. Extension points are optional and this class will handle them if present.
 *
 * This class holds the public interface to interact with extensions
 */
export declare class ExtensionInstance<TConfiguration extends BaseConfigType = BaseConfigType> {
    entrySourceFilePath: string;
    devUUID: string;
    localIdentifier: string;
    idEnvironmentVariableName: string;
    directory: string;
    configuration: TConfiguration;
    configurationPath: string;
    outputPath: string;
    handle: string;
    specification: ExtensionSpecification;
    get graphQLType(): string;
    get type(): string;
    get humanName(): string;
    get name(): string;
    get dependency(): string | undefined;
    get externalType(): string;
    get surface(): string;
    get isPreviewable(): boolean;
    get isThemeExtension(): boolean;
    get isFunctionExtension(): boolean;
    get isESBuildExtension(): boolean;
    get isAppConfigExtension(): boolean;
    get isFlow(): boolean;
    get features(): ExtensionFeature[];
    get outputFileName(): string;
    constructor(options: {
        configuration: TConfiguration;
        configurationPath: string;
        entryPath?: string;
        directory: string;
        specification: ExtensionSpecification;
    });
    isDraftable(): boolean;
    get draftMessages(): {
        successMessage: string | undefined;
        errorMessage: string | undefined;
    };
    isUuidManaged(): boolean;
    isSentToMetrics(): boolean;
    isReturnedAsInfo(): boolean;
    deployConfig({ apiKey, token }: ExtensionDeployConfigOptions): Promise<{
        [key: string]: unknown;
    } | undefined>;
    functionDeployConfig({ apiKey, token, }: ExtensionDeployConfigOptions): Promise<{
        [key: string]: unknown;
    } | undefined>;
    commonDeployConfig(apiKey: string): Promise<{
        [key: string]: unknown;
    } | undefined>;
    validate(): Promise<import("@shopify/cli-kit/node/result").Result<unknown, string>>;
    preDeployValidation(): Promise<void>;
    buildValidation(): Promise<void>;
    publishURL(options: {
        orgId: string;
        appId: string;
        extensionId?: string;
    }): Promise<string>;
    getBundleExtensionStdinContent(): string;
    shouldFetchCartUrl(): boolean;
    hasExtensionPointTarget(target: string): boolean;
    get buildCommand(): string | undefined;
    get watchBuildPaths(): string[] | null;
    watchConfigurationPaths(): Promise<string[]>;
    get inputQueryPath(): string;
    get isJavaScript(): boolean;
    build(options: ExtensionBuildOptions): Promise<void>;
    buildForBundle(options: ExtensionBuildOptions, identifiers: Identifiers, bundleDirectory: string): Promise<void>;
    get singleTarget(): string | undefined;
    get contextValue(): string;
    bundleConfig({ identifiers, token, apiKey }: ExtensionBundleConfigOptions): Promise<{
        uuid: string | undefined;
        config: string;
        context: string;
        handle: string;
    } | undefined>;
}
export interface ExtensionDeployConfigOptions {
    apiKey: string;
    token: string;
}
export interface ExtensionBundleConfigOptions {
    identifiers: Identifiers;
    token: string;
    apiKey: string;
}
