import { zod } from '@shopify/cli-kit/node/schema';
export type ZodSchemaType<T> = zod.ZodType<T, any, any>;
export declare const MetafieldSchema: zod.ZodObject<{
    namespace: zod.ZodString;
    key: zod.ZodString;
}, "strip", zod.ZodTypeAny, {
    namespace: string;
    key: string;
}, {
    namespace: string;
    key: string;
}>;
export declare const CollectBuyerConsentCapabilitySchema: zod.ZodObject<{
    sms_marketing: zod.ZodOptional<zod.ZodBoolean>;
    customer_privacy: zod.ZodOptional<zod.ZodBoolean>;
}, "strip", zod.ZodTypeAny, {
    sms_marketing?: boolean | undefined;
    customer_privacy?: boolean | undefined;
}, {
    sms_marketing?: boolean | undefined;
    customer_privacy?: boolean | undefined;
}>;
export declare const CapabilitiesSchema: zod.ZodObject<{
    network_access: zod.ZodOptional<zod.ZodBoolean>;
    block_progress: zod.ZodOptional<zod.ZodBoolean>;
    api_access: zod.ZodOptional<zod.ZodBoolean>;
    collect_buyer_consent: zod.ZodOptional<zod.ZodObject<{
        sms_marketing: zod.ZodOptional<zod.ZodBoolean>;
        customer_privacy: zod.ZodOptional<zod.ZodBoolean>;
    }, "strip", zod.ZodTypeAny, {
        sms_marketing?: boolean | undefined;
        customer_privacy?: boolean | undefined;
    }, {
        sms_marketing?: boolean | undefined;
        customer_privacy?: boolean | undefined;
    }>>;
}, "strip", zod.ZodTypeAny, {
    network_access?: boolean | undefined;
    block_progress?: boolean | undefined;
    api_access?: boolean | undefined;
    collect_buyer_consent?: {
        sms_marketing?: boolean | undefined;
        customer_privacy?: boolean | undefined;
    } | undefined;
}, {
    network_access?: boolean | undefined;
    block_progress?: boolean | undefined;
    api_access?: boolean | undefined;
    collect_buyer_consent?: {
        sms_marketing?: boolean | undefined;
        customer_privacy?: boolean | undefined;
    } | undefined;
}>;
export declare const ExtensionsArraySchema: zod.ZodObject<{
    type: zod.ZodOptional<zod.ZodString>;
    extensions: zod.ZodOptional<zod.ZodArray<zod.ZodAny, "many">>;
}, "strip", zod.ZodTypeAny, {
    type?: string | undefined;
    extensions?: any[] | undefined;
}, {
    type?: string | undefined;
    extensions?: any[] | undefined;
}>;
export declare const NewExtensionPointSchema: zod.ZodObject<{
    target: zod.ZodString;
    module: zod.ZodString;
    metafields: zod.ZodOptional<zod.ZodArray<zod.ZodObject<{
        namespace: zod.ZodString;
        key: zod.ZodString;
    }, "strip", zod.ZodTypeAny, {
        namespace: string;
        key: string;
    }, {
        namespace: string;
        key: string;
    }>, "many">>;
}, "strip", zod.ZodTypeAny, {
    target: string;
    module: string;
    metafields?: {
        namespace: string;
        key: string;
    }[] | undefined;
}, {
    target: string;
    module: string;
    metafields?: {
        namespace: string;
        key: string;
    }[] | undefined;
}>;
export declare const OldExtensionPointsSchema: zod.ZodDefault<zod.ZodArray<zod.ZodString, "many">>;
export declare const NewExtensionPointsSchema: zod.ZodArray<zod.ZodObject<{
    target: zod.ZodString;
    module: zod.ZodString;
    metafields: zod.ZodOptional<zod.ZodArray<zod.ZodObject<{
        namespace: zod.ZodString;
        key: zod.ZodString;
    }, "strip", zod.ZodTypeAny, {
        namespace: string;
        key: string;
    }, {
        namespace: string;
        key: string;
    }>, "many">>;
}, "strip", zod.ZodTypeAny, {
    target: string;
    module: string;
    metafields?: {
        namespace: string;
        key: string;
    }[] | undefined;
}, {
    target: string;
    module: string;
    metafields?: {
        namespace: string;
        key: string;
    }[] | undefined;
}>, "many">;
export declare const ExtensionPointSchema: zod.ZodUnion<[zod.ZodDefault<zod.ZodArray<zod.ZodString, "many">>, zod.ZodArray<zod.ZodObject<{
    target: zod.ZodString;
    module: zod.ZodString;
    metafields: zod.ZodOptional<zod.ZodArray<zod.ZodObject<{
        namespace: zod.ZodString;
        key: zod.ZodString;
    }, "strip", zod.ZodTypeAny, {
        namespace: string;
        key: string;
    }, {
        namespace: string;
        key: string;
    }>, "many">>;
}, "strip", zod.ZodTypeAny, {
    target: string;
    module: string;
    metafields?: {
        namespace: string;
        key: string;
    }[] | undefined;
}, {
    target: string;
    module: string;
    metafields?: {
        namespace: string;
        key: string;
    }[] | undefined;
}>, "many">]>;
export declare const ApiVersionSchema: zod.ZodString;
export type ApiVersionSchemaType = zod.infer<typeof ApiVersionSchema>;
export declare const FieldSchema: zod.ZodObject<{
    key: zod.ZodOptional<zod.ZodString>;
    name: zod.ZodOptional<zod.ZodString>;
    description: zod.ZodOptional<zod.ZodString>;
    required: zod.ZodOptional<zod.ZodBoolean>;
    type: zod.ZodString;
    validations: zod.ZodOptional<zod.ZodArray<zod.ZodAny, "many">>;
}, "strip", zod.ZodTypeAny, {
    type: string;
    key?: string | undefined;
    name?: string | undefined;
    description?: string | undefined;
    required?: boolean | undefined;
    validations?: any[] | undefined;
}, {
    type: string;
    key?: string | undefined;
    name?: string | undefined;
    description?: string | undefined;
    required?: boolean | undefined;
    validations?: any[] | undefined;
}>;
export declare const SettingsSchema: zod.ZodObject<{
    fields: zod.ZodOptional<zod.ZodArray<zod.ZodObject<{
        key: zod.ZodOptional<zod.ZodString>;
        name: zod.ZodOptional<zod.ZodString>;
        description: zod.ZodOptional<zod.ZodString>;
        required: zod.ZodOptional<zod.ZodBoolean>;
        type: zod.ZodString;
        validations: zod.ZodOptional<zod.ZodArray<zod.ZodAny, "many">>;
    }, "strip", zod.ZodTypeAny, {
        type: string;
        key?: string | undefined;
        name?: string | undefined;
        description?: string | undefined;
        required?: boolean | undefined;
        validations?: any[] | undefined;
    }, {
        type: string;
        key?: string | undefined;
        name?: string | undefined;
        description?: string | undefined;
        required?: boolean | undefined;
        validations?: any[] | undefined;
    }>, "many">>;
}, "strip", zod.ZodTypeAny, {
    fields?: {
        type: string;
        key?: string | undefined;
        name?: string | undefined;
        description?: string | undefined;
        required?: boolean | undefined;
        validations?: any[] | undefined;
    }[] | undefined;
}, {
    fields?: {
        type: string;
        key?: string | undefined;
        name?: string | undefined;
        description?: string | undefined;
        required?: boolean | undefined;
        validations?: any[] | undefined;
    }[] | undefined;
}>;
export declare const HandleSchema: zod.ZodEffects<zod.ZodEffects<zod.ZodString, string, string>, string, string>;
export declare const BaseSchema: zod.ZodObject<{
    name: zod.ZodString;
    type: zod.ZodString;
    handle: zod.ZodOptional<zod.ZodEffects<zod.ZodEffects<zod.ZodString, string, string>, string, string>>;
    description: zod.ZodOptional<zod.ZodString>;
    api_version: zod.ZodOptional<zod.ZodString>;
    extension_points: zod.ZodOptional<zod.ZodAny>;
    capabilities: zod.ZodOptional<zod.ZodObject<{
        network_access: zod.ZodOptional<zod.ZodBoolean>;
        block_progress: zod.ZodOptional<zod.ZodBoolean>;
        api_access: zod.ZodOptional<zod.ZodBoolean>;
        collect_buyer_consent: zod.ZodOptional<zod.ZodObject<{
            sms_marketing: zod.ZodOptional<zod.ZodBoolean>;
            customer_privacy: zod.ZodOptional<zod.ZodBoolean>;
        }, "strip", zod.ZodTypeAny, {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        }, {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        }>>;
    }, "strip", zod.ZodTypeAny, {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    }, {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    }>>;
    metafields: zod.ZodDefault<zod.ZodOptional<zod.ZodArray<zod.ZodObject<{
        namespace: zod.ZodString;
        key: zod.ZodString;
    }, "strip", zod.ZodTypeAny, {
        namespace: string;
        key: string;
    }, {
        namespace: string;
        key: string;
    }>, "many">>>;
    settings: zod.ZodOptional<zod.ZodObject<{
        fields: zod.ZodOptional<zod.ZodArray<zod.ZodObject<{
            key: zod.ZodOptional<zod.ZodString>;
            name: zod.ZodOptional<zod.ZodString>;
            description: zod.ZodOptional<zod.ZodString>;
            required: zod.ZodOptional<zod.ZodBoolean>;
            type: zod.ZodString;
            validations: zod.ZodOptional<zod.ZodArray<zod.ZodAny, "many">>;
        }, "strip", zod.ZodTypeAny, {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }, {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }>, "many">>;
    }, "strip", zod.ZodTypeAny, {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    }, {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    }>>;
}, "strip", zod.ZodTypeAny, {
    name: string;
    type: string;
    metafields: {
        namespace: string;
        key: string;
    }[];
    handle?: string | undefined;
    description?: string | undefined;
    api_version?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    } | undefined;
    settings?: {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    } | undefined;
}, {
    name: string;
    type: string;
    handle?: string | undefined;
    description?: string | undefined;
    api_version?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    } | undefined;
    metafields?: {
        namespace: string;
        key: string;
    }[] | undefined;
    settings?: {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    } | undefined;
}>;
export declare const BaseSchemaWithHandle: zod.ZodObject<{
    name: zod.ZodString;
    description: zod.ZodOptional<zod.ZodString>;
    type: zod.ZodString;
    metafields: zod.ZodDefault<zod.ZodOptional<zod.ZodArray<zod.ZodObject<{
        namespace: zod.ZodString;
        key: zod.ZodString;
    }, "strip", zod.ZodTypeAny, {
        namespace: string;
        key: string;
    }, {
        namespace: string;
        key: string;
    }>, "many">>>;
    api_version: zod.ZodOptional<zod.ZodString>;
    extension_points: zod.ZodOptional<zod.ZodAny>;
    capabilities: zod.ZodOptional<zod.ZodObject<{
        network_access: zod.ZodOptional<zod.ZodBoolean>;
        block_progress: zod.ZodOptional<zod.ZodBoolean>;
        api_access: zod.ZodOptional<zod.ZodBoolean>;
        collect_buyer_consent: zod.ZodOptional<zod.ZodObject<{
            sms_marketing: zod.ZodOptional<zod.ZodBoolean>;
            customer_privacy: zod.ZodOptional<zod.ZodBoolean>;
        }, "strip", zod.ZodTypeAny, {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        }, {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        }>>;
    }, "strip", zod.ZodTypeAny, {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    }, {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    }>>;
    settings: zod.ZodOptional<zod.ZodObject<{
        fields: zod.ZodOptional<zod.ZodArray<zod.ZodObject<{
            key: zod.ZodOptional<zod.ZodString>;
            name: zod.ZodOptional<zod.ZodString>;
            description: zod.ZodOptional<zod.ZodString>;
            required: zod.ZodOptional<zod.ZodBoolean>;
            type: zod.ZodString;
            validations: zod.ZodOptional<zod.ZodArray<zod.ZodAny, "many">>;
        }, "strip", zod.ZodTypeAny, {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }, {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }>, "many">>;
    }, "strip", zod.ZodTypeAny, {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    }, {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    }>>;
    handle: zod.ZodEffects<zod.ZodEffects<zod.ZodString, string, string>, string, string>;
}, "strip", zod.ZodTypeAny, {
    name: string;
    type: string;
    metafields: {
        namespace: string;
        key: string;
    }[];
    handle: string;
    description?: string | undefined;
    api_version?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    } | undefined;
    settings?: {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    } | undefined;
}, {
    name: string;
    type: string;
    handle: string;
    description?: string | undefined;
    metafields?: {
        namespace: string;
        key: string;
    }[] | undefined;
    api_version?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    } | undefined;
    settings?: {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    } | undefined;
}>;
export declare const UnifiedSchema: zod.ZodObject<{
    api_version: zod.ZodOptional<zod.ZodString>;
    description: zod.ZodOptional<zod.ZodString>;
    extensions: zod.ZodArray<zod.ZodAny, "many">;
    settings: zod.ZodOptional<zod.ZodObject<{
        fields: zod.ZodOptional<zod.ZodArray<zod.ZodObject<{
            key: zod.ZodOptional<zod.ZodString>;
            name: zod.ZodOptional<zod.ZodString>;
            description: zod.ZodOptional<zod.ZodString>;
            required: zod.ZodOptional<zod.ZodBoolean>;
            type: zod.ZodString;
            validations: zod.ZodOptional<zod.ZodArray<zod.ZodAny, "many">>;
        }, "strip", zod.ZodTypeAny, {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }, {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }>, "many">>;
    }, "strip", zod.ZodTypeAny, {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    }, {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    }>>;
}, "strip", zod.ZodTypeAny, {
    extensions: any[];
    api_version?: string | undefined;
    description?: string | undefined;
    settings?: {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    } | undefined;
}, {
    extensions: any[];
    api_version?: string | undefined;
    description?: string | undefined;
    settings?: {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    } | undefined;
}>;
export type NewExtensionPointSchemaType = zod.infer<typeof NewExtensionPointSchema>;
export type BaseConfigType = zod.infer<typeof BaseSchema>;
