import { validateUrl } from '../../app/validation/common.js';
import { createConfigExtensionSpecification } from '../specification.js';
import { normalizeDelimitedString } from '@shopify/cli-kit/common/string';
import { zod } from '@shopify/cli-kit/node/schema';
const AppAccessSchema = zod.object({
    access: zod
        .object({
        admin: zod
            .object({
            direct_api_mode: zod.union([zod.literal('online'), zod.literal('offline')]).optional(),
            embedded_app_direct_api_access: zod.boolean().optional(),
        })
            .optional(),
    })
        .optional(),
    access_scopes: zod
        .object({
        scopes: zod
            .string()
            .transform((scopes) => normalizeDelimitedString(scopes))
            .optional(),
        use_legacy_install_flow: zod.boolean().optional(),
    })
        .optional(),
    auth: zod.object({
        redirect_urls: zod.array(validateUrl(zod.string())),
    }),
});
export const AppAccessSpecIdentifier = 'app_access';
const AppAccessTransformConfig = {
    access: 'access',
    scopes: 'access_scopes.scopes',
    use_legacy_install_flow: 'access_scopes.use_legacy_install_flow',
    redirect_url_allowlist: 'auth.redirect_urls',
};
const spec = createConfigExtensionSpecification({
    identifier: AppAccessSpecIdentifier,
    schema: AppAccessSchema,
    transformConfig: AppAccessTransformConfig,
});
export default spec;
//# sourceMappingURL=app_config_app_access.js.map