import { validateUrl } from '../../app/validation/common.js';
import { createConfigExtensionSpecification } from '../specification.js';
import { zod } from '@shopify/cli-kit/node/schema';
const AppProxySchema = zod.object({
    app_proxy: zod
        .object({
        url: validateUrl(zod.string()),
        subpath: zod.string(),
        prefix: zod.string(),
    })
        .optional(),
});
export const AppProxySpecIdentifier = 'app_proxy';
const spec = createConfigExtensionSpecification({
    identifier: AppProxySpecIdentifier,
    schema: AppProxySchema,
});
export default spec;
//# sourceMappingURL=app_config_app_proxy.js.map