import { zod } from '@shopify/cli-kit/node/schema';
export declare const WebhooksSchemaWithDeclarative: zod.ZodEffects<zod.ZodObject<{
    api_version: zod.ZodString;
    privacy_compliance: zod.ZodOptional<zod.ZodObject<{
        customer_deletion_url: zod.ZodOptional<zod.ZodUnion<[zod.ZodString, zod.ZodString, zod.ZodString]>>;
        customer_data_request_url: zod.ZodOptional<zod.ZodUnion<[zod.ZodString, zod.ZodString, zod.ZodString]>>;
        shop_deletion_url: zod.ZodOptional<zod.ZodUnion<[zod.ZodString, zod.ZodString, zod.ZodString]>>;
    }, "strip", zod.ZodTypeAny, {
        customer_deletion_url?: string | undefined;
        customer_data_request_url?: string | undefined;
        shop_deletion_url?: string | undefined;
    }, {
        customer_deletion_url?: string | undefined;
        customer_data_request_url?: string | undefined;
        shop_deletion_url?: string | undefined;
    }>>;
    subscriptions: zod.ZodOptional<zod.ZodArray<zod.ZodObject<{
        topics: zod.ZodArray<zod.ZodString, "atleastone">;
        uri: zod.ZodEffects<zod.ZodUnion<[zod.ZodString, zod.ZodString, zod.ZodString]>, string, unknown>;
        sub_topic: zod.ZodOptional<zod.ZodString>;
        include_fields: zod.ZodOptional<zod.ZodArray<zod.ZodString, "many">>;
        metafield_namespaces: zod.ZodOptional<zod.ZodArray<zod.ZodString, "many">>;
        compliance_topics: zod.ZodOptional<zod.ZodArray<zod.ZodEnum<["customers/redact", "customers/data_request", "shop/redact"]>, "many">>;
    }, "strip", zod.ZodTypeAny, {
        topics: [string, ...string[]];
        uri: string;
        sub_topic?: string | undefined;
        include_fields?: string[] | undefined;
        metafield_namespaces?: string[] | undefined;
        compliance_topics?: ("customers/redact" | "customers/data_request" | "shop/redact")[] | undefined;
    }, {
        topics: [string, ...string[]];
        uri?: unknown;
        sub_topic?: string | undefined;
        include_fields?: string[] | undefined;
        metafield_namespaces?: string[] | undefined;
        compliance_topics?: ("customers/redact" | "customers/data_request" | "shop/redact")[] | undefined;
    }>, "many">>;
}, "strip", zod.ZodTypeAny, {
    api_version: string;
    privacy_compliance?: {
        customer_deletion_url?: string | undefined;
        customer_data_request_url?: string | undefined;
        shop_deletion_url?: string | undefined;
    } | undefined;
    subscriptions?: {
        topics: [string, ...string[]];
        uri: string;
        sub_topic?: string | undefined;
        include_fields?: string[] | undefined;
        metafield_namespaces?: string[] | undefined;
        compliance_topics?: ("customers/redact" | "customers/data_request" | "shop/redact")[] | undefined;
    }[] | undefined;
}, {
    api_version: string;
    privacy_compliance?: {
        customer_deletion_url?: string | undefined;
        customer_data_request_url?: string | undefined;
        shop_deletion_url?: string | undefined;
    } | undefined;
    subscriptions?: {
        topics: [string, ...string[]];
        uri?: unknown;
        sub_topic?: string | undefined;
        include_fields?: string[] | undefined;
        metafield_namespaces?: string[] | undefined;
        compliance_topics?: ("customers/redact" | "customers/data_request" | "shop/redact")[] | undefined;
    }[] | undefined;
}>, {
    api_version: string;
    privacy_compliance?: {
        customer_deletion_url?: string | undefined;
        customer_data_request_url?: string | undefined;
        shop_deletion_url?: string | undefined;
    } | undefined;
    subscriptions?: {
        topics: [string, ...string[]];
        uri: string;
        sub_topic?: string | undefined;
        include_fields?: string[] | undefined;
        metafield_namespaces?: string[] | undefined;
        compliance_topics?: ("customers/redact" | "customers/data_request" | "shop/redact")[] | undefined;
    }[] | undefined;
}, {
    api_version: string;
    privacy_compliance?: {
        customer_deletion_url?: string | undefined;
        customer_data_request_url?: string | undefined;
        shop_deletion_url?: string | undefined;
    } | undefined;
    subscriptions?: {
        topics: [string, ...string[]];
        uri?: unknown;
        sub_topic?: string | undefined;
        include_fields?: string[] | undefined;
        metafield_namespaces?: string[] | undefined;
        compliance_topics?: ("customers/redact" | "customers/data_request" | "shop/redact")[] | undefined;
    }[] | undefined;
}>;
export declare const WebhookSchema: zod.ZodObject<{
    webhooks: zod.ZodEffects<zod.ZodObject<{
        api_version: zod.ZodString;
        privacy_compliance: zod.ZodOptional<zod.ZodObject<{
            customer_deletion_url: zod.ZodOptional<zod.ZodUnion<[zod.ZodString, zod.ZodString, zod.ZodString]>>;
            customer_data_request_url: zod.ZodOptional<zod.ZodUnion<[zod.ZodString, zod.ZodString, zod.ZodString]>>;
            shop_deletion_url: zod.ZodOptional<zod.ZodUnion<[zod.ZodString, zod.ZodString, zod.ZodString]>>;
        }, "strip", zod.ZodTypeAny, {
            customer_deletion_url?: string | undefined;
            customer_data_request_url?: string | undefined;
            shop_deletion_url?: string | undefined;
        }, {
            customer_deletion_url?: string | undefined;
            customer_data_request_url?: string | undefined;
            shop_deletion_url?: string | undefined;
        }>>;
        subscriptions: zod.ZodOptional<zod.ZodArray<zod.ZodObject<{
            topics: zod.ZodArray<zod.ZodString, "atleastone">;
            uri: zod.ZodEffects<zod.ZodUnion<[zod.ZodString, zod.ZodString, zod.ZodString]>, string, unknown>;
            sub_topic: zod.ZodOptional<zod.ZodString>;
            include_fields: zod.ZodOptional<zod.ZodArray<zod.ZodString, "many">>;
            metafield_namespaces: zod.ZodOptional<zod.ZodArray<zod.ZodString, "many">>;
            compliance_topics: zod.ZodOptional<zod.ZodArray<zod.ZodEnum<["customers/redact", "customers/data_request", "shop/redact"]>, "many">>;
        }, "strip", zod.ZodTypeAny, {
            topics: [string, ...string[]];
            uri: string;
            sub_topic?: string | undefined;
            include_fields?: string[] | undefined;
            metafield_namespaces?: string[] | undefined;
            compliance_topics?: ("customers/redact" | "customers/data_request" | "shop/redact")[] | undefined;
        }, {
            topics: [string, ...string[]];
            uri?: unknown;
            sub_topic?: string | undefined;
            include_fields?: string[] | undefined;
            metafield_namespaces?: string[] | undefined;
            compliance_topics?: ("customers/redact" | "customers/data_request" | "shop/redact")[] | undefined;
        }>, "many">>;
    }, "strip", zod.ZodTypeAny, {
        api_version: string;
        privacy_compliance?: {
            customer_deletion_url?: string | undefined;
            customer_data_request_url?: string | undefined;
            shop_deletion_url?: string | undefined;
        } | undefined;
        subscriptions?: {
            topics: [string, ...string[]];
            uri: string;
            sub_topic?: string | undefined;
            include_fields?: string[] | undefined;
            metafield_namespaces?: string[] | undefined;
            compliance_topics?: ("customers/redact" | "customers/data_request" | "shop/redact")[] | undefined;
        }[] | undefined;
    }, {
        api_version: string;
        privacy_compliance?: {
            customer_deletion_url?: string | undefined;
            customer_data_request_url?: string | undefined;
            shop_deletion_url?: string | undefined;
        } | undefined;
        subscriptions?: {
            topics: [string, ...string[]];
            uri?: unknown;
            sub_topic?: string | undefined;
            include_fields?: string[] | undefined;
            metafield_namespaces?: string[] | undefined;
            compliance_topics?: ("customers/redact" | "customers/data_request" | "shop/redact")[] | undefined;
        }[] | undefined;
    }>, {
        api_version: string;
        privacy_compliance?: {
            customer_deletion_url?: string | undefined;
            customer_data_request_url?: string | undefined;
            shop_deletion_url?: string | undefined;
        } | undefined;
        subscriptions?: {
            topics: [string, ...string[]];
            uri: string;
            sub_topic?: string | undefined;
            include_fields?: string[] | undefined;
            metafield_namespaces?: string[] | undefined;
            compliance_topics?: ("customers/redact" | "customers/data_request" | "shop/redact")[] | undefined;
        }[] | undefined;
    }, {
        api_version: string;
        privacy_compliance?: {
            customer_deletion_url?: string | undefined;
            customer_data_request_url?: string | undefined;
            shop_deletion_url?: string | undefined;
        } | undefined;
        subscriptions?: {
            topics: [string, ...string[]];
            uri?: unknown;
            sub_topic?: string | undefined;
            include_fields?: string[] | undefined;
            metafield_namespaces?: string[] | undefined;
            compliance_topics?: ("customers/redact" | "customers/data_request" | "shop/redact")[] | undefined;
        }[] | undefined;
    }>;
}, "strip", zod.ZodTypeAny, {
    webhooks: {
        api_version: string;
        privacy_compliance?: {
            customer_deletion_url?: string | undefined;
            customer_data_request_url?: string | undefined;
            shop_deletion_url?: string | undefined;
        } | undefined;
        subscriptions?: {
            topics: [string, ...string[]];
            uri: string;
            sub_topic?: string | undefined;
            include_fields?: string[] | undefined;
            metafield_namespaces?: string[] | undefined;
            compliance_topics?: ("customers/redact" | "customers/data_request" | "shop/redact")[] | undefined;
        }[] | undefined;
    };
}, {
    webhooks: {
        api_version: string;
        privacy_compliance?: {
            customer_deletion_url?: string | undefined;
            customer_data_request_url?: string | undefined;
            shop_deletion_url?: string | undefined;
        } | undefined;
        subscriptions?: {
            topics: [string, ...string[]];
            uri?: unknown;
            sub_topic?: string | undefined;
            include_fields?: string[] | undefined;
            metafield_namespaces?: string[] | undefined;
            compliance_topics?: ("customers/redact" | "customers/data_request" | "shop/redact")[] | undefined;
        }[] | undefined;
    };
}>;
export declare const WebhooksSpecIdentifier = "webhooks";
declare const spec: import("../specification.js").ExtensionSpecification<{
    name: string;
    type: string;
    metafields: {
        namespace: string;
        key: string;
    }[];
    handle?: string | undefined;
    description?: string | undefined;
    api_version?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    } | undefined;
    settings?: {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    } | undefined;
}>;
export default spec;
