import { zod } from '@shopify/cli-kit/node/schema';
export declare const FlowActionExtensionSchema: zod.ZodEffects<zod.ZodObject<{
    name: zod.ZodString;
    description: zod.ZodOptional<zod.ZodString>;
    metafields: zod.ZodDefault<zod.ZodOptional<zod.ZodArray<zod.ZodObject<{
        namespace: zod.ZodString;
        key: zod.ZodString;
    }, "strip", zod.ZodTypeAny, {
        namespace: string;
        key: string;
    }, {
        namespace: string;
        key: string;
    }>, "many">>>;
    handle: zod.ZodEffects<zod.ZodEffects<zod.ZodString, string, string>, string, string>;
    api_version: zod.ZodOptional<zod.ZodString>;
    extension_points: zod.ZodOptional<zod.ZodAny>;
    capabilities: zod.ZodOptional<zod.ZodObject<{
        network_access: zod.ZodOptional<zod.ZodBoolean>;
        block_progress: zod.ZodOptional<zod.ZodBoolean>;
        api_access: zod.ZodOptional<zod.ZodBoolean>;
        collect_buyer_consent: zod.ZodOptional<zod.ZodObject<{
            sms_marketing: zod.ZodOptional<zod.ZodBoolean>;
            customer_privacy: zod.ZodOptional<zod.ZodBoolean>;
        }, "strip", zod.ZodTypeAny, {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        }, {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        }>>;
    }, "strip", zod.ZodTypeAny, {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    }, {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    }>>;
    settings: zod.ZodOptional<zod.ZodObject<{
        fields: zod.ZodOptional<zod.ZodArray<zod.ZodObject<{
            key: zod.ZodOptional<zod.ZodString>;
            name: zod.ZodOptional<zod.ZodString>;
            description: zod.ZodOptional<zod.ZodString>;
            required: zod.ZodOptional<zod.ZodBoolean>;
            type: zod.ZodString;
            validations: zod.ZodOptional<zod.ZodArray<zod.ZodAny, "many">>;
        }, "strip", zod.ZodTypeAny, {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }, {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }>, "many">>;
    }, "strip", zod.ZodTypeAny, {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    }, {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    }>>;
    type: zod.ZodLiteral<"flow_action">;
    runtime_url: zod.ZodEffects<zod.ZodString, string, string>;
    validation_url: zod.ZodOptional<zod.ZodEffects<zod.ZodString, string, string>>;
    config_page_url: zod.ZodOptional<zod.ZodEffects<zod.ZodString, string, string>>;
    config_page_preview_url: zod.ZodOptional<zod.ZodEffects<zod.ZodString, string, string>>;
    schema: zod.ZodOptional<zod.ZodString>;
    return_type_ref: zod.ZodOptional<zod.ZodString>;
}, "strip", zod.ZodTypeAny, {
    name: string;
    type: "flow_action";
    metafields: {
        namespace: string;
        key: string;
    }[];
    handle: string;
    runtime_url: string;
    description?: string | undefined;
    api_version?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    } | undefined;
    settings?: {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    } | undefined;
    validation_url?: string | undefined;
    config_page_url?: string | undefined;
    config_page_preview_url?: string | undefined;
    schema?: string | undefined;
    return_type_ref?: string | undefined;
}, {
    name: string;
    type: "flow_action";
    handle: string;
    runtime_url: string;
    description?: string | undefined;
    metafields?: {
        namespace: string;
        key: string;
    }[] | undefined;
    api_version?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    } | undefined;
    settings?: {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    } | undefined;
    validation_url?: string | undefined;
    config_page_url?: string | undefined;
    config_page_preview_url?: string | undefined;
    schema?: string | undefined;
    return_type_ref?: string | undefined;
}>, {
    name: string;
    type: "flow_action";
    metafields: {
        namespace: string;
        key: string;
    }[];
    handle: string;
    runtime_url: string;
    description?: string | undefined;
    api_version?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    } | undefined;
    settings?: {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    } | undefined;
    validation_url?: string | undefined;
    config_page_url?: string | undefined;
    config_page_preview_url?: string | undefined;
    schema?: string | undefined;
    return_type_ref?: string | undefined;
}, {
    name: string;
    type: "flow_action";
    handle: string;
    runtime_url: string;
    description?: string | undefined;
    metafields?: {
        namespace: string;
        key: string;
    }[] | undefined;
    api_version?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    } | undefined;
    settings?: {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    } | undefined;
    validation_url?: string | undefined;
    config_page_url?: string | undefined;
    config_page_preview_url?: string | undefined;
    schema?: string | undefined;
    return_type_ref?: string | undefined;
}>;
/**
 * Extension specification with all properties and methods needed to load a Flow Action.
 */
declare const flowActionSpecification: import("../specification.js").ExtensionSpecification<{
    name: string;
    type: "flow_action";
    metafields: {
        namespace: string;
        key: string;
    }[];
    handle: string;
    runtime_url: string;
    description?: string | undefined;
    api_version?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    } | undefined;
    settings?: {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    } | undefined;
    validation_url?: string | undefined;
    config_page_url?: string | undefined;
    config_page_preview_url?: string | undefined;
    schema?: string | undefined;
    return_type_ref?: string | undefined;
}>;
export default flowActionSpecification;
