import { zod } from '@shopify/cli-kit/node/schema';
export declare const FlowTriggerSettingsSchema: zod.ZodObject<{
    name: zod.ZodOptional<zod.ZodString>;
    description: zod.ZodOptional<zod.ZodString>;
    required: zod.ZodOptional<zod.ZodBoolean>;
    type: zod.ZodString;
    validations: zod.ZodOptional<zod.ZodArray<zod.ZodAny, "many">>;
    key: zod.ZodOptional<zod.ZodString>;
}, "strip", zod.ZodTypeAny, {
    type: string;
    name?: string | undefined;
    description?: string | undefined;
    required?: boolean | undefined;
    validations?: any[] | undefined;
    key?: string | undefined;
}, {
    type: string;
    name?: string | undefined;
    description?: string | undefined;
    required?: boolean | undefined;
    validations?: any[] | undefined;
    key?: string | undefined;
}>;
/**
 * Extension specification with all properties and methods needed to load a Flow Trigger.
 */
declare const flowTriggerSpecification: import("../specification.js").ExtensionSpecification<{
    name: string;
    type: "flow_trigger";
    metafields: {
        namespace: string;
        key: string;
    }[];
    handle: string;
    description?: string | undefined;
    api_version?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    } | undefined;
    schema?: string | undefined;
    settings?: {
        fields?: {
            type: string;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
            key?: string | undefined;
        }[] | undefined;
    } | undefined;
}>;
export default flowTriggerSpecification;
