import { OFFSITE_TARGET, OffsitePaymentsAppExtensionSchema, offsitePaymentsAppExtensionDeployConfig, } from './payments_app_extension_schemas/offsite_payments_app_extension_schema.js';
import { REDEEMABLE_TARGET, redeemablePaymentsAppExtensionDeployConfig, RedeemablePaymentsAppExtensionSchema, } from './payments_app_extension_schemas/redeemable_payments_app_extension_schema.js';
import { CUSTOM_ONSITE_TARGET, customOnsitePaymentsAppExtensionDeployConfig, CustomOnsitePaymentsAppExtensionSchema, } from './payments_app_extension_schemas/custom_onsite_payments_app_extension_schema.js';
import { CUSTOM_CREDIT_CARD_TARGET, customCreditCardPaymentsAppExtensionDeployConfig, CustomCreditCardPaymentsAppExtensionSchema, } from './payments_app_extension_schemas/custom_credit_card_payments_app_extension_schema.js';
import { CREDIT_CARD_TARGET, CreditCardPaymentsAppExtensionSchema, creditCardPaymentsAppExtensionDeployConfig, } from './payments_app_extension_schemas/credit_card_payments_app_extension_schema.js';
import { createExtensionSpecification } from '../specification.js';
import { zod } from '@shopify/cli-kit/node/schema';
const PaymentsAppExtensionSchema = zod.union([
    OffsitePaymentsAppExtensionSchema,
    RedeemablePaymentsAppExtensionSchema,
    CustomOnsitePaymentsAppExtensionSchema,
    CustomCreditCardPaymentsAppExtensionSchema,
    CreditCardPaymentsAppExtensionSchema,
]);
const spec = createExtensionSpecification({
    identifier: 'payments_extension',
    schema: PaymentsAppExtensionSchema,
    appModuleFeatures: (_) => [],
    deployConfig: async (config, _) => {
        const target = config.targeting[0].target;
        switch (target) {
            case OFFSITE_TARGET:
                return offsitePaymentsAppExtensionDeployConfig(config);
            case REDEEMABLE_TARGET:
                return redeemablePaymentsAppExtensionDeployConfig(config);
            case CREDIT_CARD_TARGET:
                return creditCardPaymentsAppExtensionDeployConfig(config);
            case CUSTOM_ONSITE_TARGET:
                return customOnsitePaymentsAppExtensionDeployConfig(config);
            case CUSTOM_CREDIT_CARD_TARGET:
                return customCreditCardPaymentsAppExtensionDeployConfig(config);
            default:
                return {};
        }
    },
});
export default spec;
//# sourceMappingURL=payments_app_extension.js.map