import { zod } from '@shopify/cli-kit/node/schema';
export type CustomOnsitePaymentsAppExtensionConfigType = zod.infer<typeof CustomOnsitePaymentsAppExtensionSchema>;
export declare const CUSTOM_ONSITE_TARGET = "payments.custom-onsite.render";
export declare const CustomOnsitePaymentsAppExtensionSchema: zod.ZodEffects<zod.ZodObject<{
    name: zod.ZodString;
    description: zod.ZodOptional<zod.ZodString>;
    type: zod.ZodString;
    input: zod.ZodOptional<zod.ZodObject<{
        metafield_identifiers: zod.ZodOptional<zod.ZodObject<{
            namespace: zod.ZodString;
            key: zod.ZodString;
        }, "strip", zod.ZodTypeAny, {
            namespace: string;
            key: string;
        }, {
            namespace: string;
            key: string;
        }>>;
    }, "strip", zod.ZodTypeAny, {
        metafield_identifiers?: {
            namespace: string;
            key: string;
        } | undefined;
    }, {
        metafield_identifiers?: {
            namespace: string;
            key: string;
        } | undefined;
    }>>;
    metafields: zod.ZodDefault<zod.ZodOptional<zod.ZodArray<zod.ZodObject<{
        namespace: zod.ZodString;
        key: zod.ZodString;
    }, "strip", zod.ZodTypeAny, {
        namespace: string;
        key: string;
    }, {
        namespace: string;
        key: string;
    }>, "many">>>;
    handle: zod.ZodOptional<zod.ZodEffects<zod.ZodEffects<zod.ZodString, string, string>, string, string>>;
    api_version: zod.ZodString;
    extension_points: zod.ZodOptional<zod.ZodAny>;
    capabilities: zod.ZodOptional<zod.ZodObject<{
        network_access: zod.ZodOptional<zod.ZodBoolean>;
        block_progress: zod.ZodOptional<zod.ZodBoolean>;
        api_access: zod.ZodOptional<zod.ZodBoolean>;
        collect_buyer_consent: zod.ZodOptional<zod.ZodObject<{
            sms_marketing: zod.ZodOptional<zod.ZodBoolean>;
            customer_privacy: zod.ZodOptional<zod.ZodBoolean>;
        }, "strip", zod.ZodTypeAny, {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        }, {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        }>>;
    }, "strip", zod.ZodTypeAny, {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    }, {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    }>>;
    settings: zod.ZodOptional<zod.ZodObject<{
        fields: zod.ZodOptional<zod.ZodArray<zod.ZodObject<{
            key: zod.ZodOptional<zod.ZodString>;
            name: zod.ZodOptional<zod.ZodString>;
            description: zod.ZodOptional<zod.ZodString>;
            required: zod.ZodOptional<zod.ZodBoolean>;
            type: zod.ZodString;
            validations: zod.ZodOptional<zod.ZodArray<zod.ZodAny, "many">>;
        }, "strip", zod.ZodTypeAny, {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }, {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }>, "many">>;
    }, "strip", zod.ZodTypeAny, {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    }, {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    }>>;
    payment_session_url: zod.ZodString;
    refund_session_url: zod.ZodOptional<zod.ZodString>;
    capture_session_url: zod.ZodOptional<zod.ZodString>;
    void_session_url: zod.ZodOptional<zod.ZodString>;
    supported_countries: zod.ZodArray<zod.ZodString, "many">;
    supported_payment_methods: zod.ZodArray<zod.ZodString, "many">;
    test_mode_available: zod.ZodBoolean;
    merchant_label: zod.ZodString;
    buyer_label: zod.ZodOptional<zod.ZodString>;
    buyer_label_translations: zod.ZodOptional<zod.ZodArray<zod.ZodObject<{
        locale: zod.ZodString;
        label: zod.ZodString;
    }, "strip", zod.ZodTypeAny, {
        label: string;
        locale: string;
    }, {
        label: string;
        locale: string;
    }>, "many">>;
    supports_installments: zod.ZodBoolean;
    supports_deferred_payments: zod.ZodBoolean;
    confirmation_callback_url: zod.ZodOptional<zod.ZodString>;
    supports_3ds: zod.ZodBoolean;
    targeting: zod.ZodArray<zod.ZodObject<{
        target: zod.ZodLiteral<"payments.custom-onsite.render">;
    }, "strip", zod.ZodTypeAny, {
        target: "payments.custom-onsite.render";
    }, {
        target: "payments.custom-onsite.render";
    }>, "many">;
    update_payment_session_url: zod.ZodOptional<zod.ZodString>;
    multiple_capture: zod.ZodOptional<zod.ZodBoolean>;
    supports_oversell_protection: zod.ZodOptional<zod.ZodBoolean>;
    modal_payment_method_fields: zod.ZodOptional<zod.ZodArray<zod.ZodObject<{}, "strip", zod.ZodTypeAny, {}, {}>, "many">>;
    checkout_payment_method_fields: zod.ZodOptional<zod.ZodArray<zod.ZodObject<{
        type: zod.ZodUnion<[zod.ZodLiteral<"string">, zod.ZodLiteral<"number">, zod.ZodLiteral<"boolean">]>;
        required: zod.ZodBoolean;
        key: zod.ZodString;
    }, "strip", zod.ZodTypeAny, {
        required: boolean;
        type: "string" | "number" | "boolean";
        key: string;
    }, {
        required: boolean;
        type: "string" | "number" | "boolean";
        key: string;
    }>, "many">>;
}, "strip", zod.ZodTypeAny, {
    name: string;
    type: string;
    metafields: {
        namespace: string;
        key: string;
    }[];
    api_version: string;
    targeting: {
        target: "payments.custom-onsite.render";
    }[];
    payment_session_url: string;
    supported_countries: string[];
    supported_payment_methods: string[];
    test_mode_available: boolean;
    merchant_label: string;
    supports_installments: boolean;
    supports_deferred_payments: boolean;
    supports_3ds: boolean;
    description?: string | undefined;
    input?: {
        metafield_identifiers?: {
            namespace: string;
            key: string;
        } | undefined;
    } | undefined;
    handle?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    } | undefined;
    settings?: {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    } | undefined;
    refund_session_url?: string | undefined;
    capture_session_url?: string | undefined;
    void_session_url?: string | undefined;
    buyer_label?: string | undefined;
    buyer_label_translations?: {
        label: string;
        locale: string;
    }[] | undefined;
    confirmation_callback_url?: string | undefined;
    update_payment_session_url?: string | undefined;
    multiple_capture?: boolean | undefined;
    supports_oversell_protection?: boolean | undefined;
    modal_payment_method_fields?: {}[] | undefined;
    checkout_payment_method_fields?: {
        required: boolean;
        type: "string" | "number" | "boolean";
        key: string;
    }[] | undefined;
}, {
    name: string;
    type: string;
    api_version: string;
    targeting: {
        target: "payments.custom-onsite.render";
    }[];
    payment_session_url: string;
    supported_countries: string[];
    supported_payment_methods: string[];
    test_mode_available: boolean;
    merchant_label: string;
    supports_installments: boolean;
    supports_deferred_payments: boolean;
    supports_3ds: boolean;
    description?: string | undefined;
    input?: {
        metafield_identifiers?: {
            namespace: string;
            key: string;
        } | undefined;
    } | undefined;
    metafields?: {
        namespace: string;
        key: string;
    }[] | undefined;
    handle?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    } | undefined;
    settings?: {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    } | undefined;
    refund_session_url?: string | undefined;
    capture_session_url?: string | undefined;
    void_session_url?: string | undefined;
    buyer_label?: string | undefined;
    buyer_label_translations?: {
        label: string;
        locale: string;
    }[] | undefined;
    confirmation_callback_url?: string | undefined;
    update_payment_session_url?: string | undefined;
    multiple_capture?: boolean | undefined;
    supports_oversell_protection?: boolean | undefined;
    modal_payment_method_fields?: {}[] | undefined;
    checkout_payment_method_fields?: {
        required: boolean;
        type: "string" | "number" | "boolean";
        key: string;
    }[] | undefined;
}>, {
    name: string;
    type: string;
    metafields: {
        namespace: string;
        key: string;
    }[];
    api_version: string;
    targeting: {
        target: "payments.custom-onsite.render";
    }[];
    payment_session_url: string;
    supported_countries: string[];
    supported_payment_methods: string[];
    test_mode_available: boolean;
    merchant_label: string;
    supports_installments: boolean;
    supports_deferred_payments: boolean;
    supports_3ds: boolean;
    description?: string | undefined;
    input?: {
        metafield_identifiers?: {
            namespace: string;
            key: string;
        } | undefined;
    } | undefined;
    handle?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    } | undefined;
    settings?: {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    } | undefined;
    refund_session_url?: string | undefined;
    capture_session_url?: string | undefined;
    void_session_url?: string | undefined;
    buyer_label?: string | undefined;
    buyer_label_translations?: {
        label: string;
        locale: string;
    }[] | undefined;
    confirmation_callback_url?: string | undefined;
    update_payment_session_url?: string | undefined;
    multiple_capture?: boolean | undefined;
    supports_oversell_protection?: boolean | undefined;
    modal_payment_method_fields?: {}[] | undefined;
    checkout_payment_method_fields?: {
        required: boolean;
        type: "string" | "number" | "boolean";
        key: string;
    }[] | undefined;
}, {
    name: string;
    type: string;
    api_version: string;
    targeting: {
        target: "payments.custom-onsite.render";
    }[];
    payment_session_url: string;
    supported_countries: string[];
    supported_payment_methods: string[];
    test_mode_available: boolean;
    merchant_label: string;
    supports_installments: boolean;
    supports_deferred_payments: boolean;
    supports_3ds: boolean;
    description?: string | undefined;
    input?: {
        metafield_identifiers?: {
            namespace: string;
            key: string;
        } | undefined;
    } | undefined;
    metafields?: {
        namespace: string;
        key: string;
    }[] | undefined;
    handle?: string | undefined;
    extension_points?: any;
    capabilities?: {
        network_access?: boolean | undefined;
        block_progress?: boolean | undefined;
        api_access?: boolean | undefined;
        collect_buyer_consent?: {
            sms_marketing?: boolean | undefined;
            customer_privacy?: boolean | undefined;
        } | undefined;
    } | undefined;
    settings?: {
        fields?: {
            type: string;
            key?: string | undefined;
            name?: string | undefined;
            description?: string | undefined;
            required?: boolean | undefined;
            validations?: any[] | undefined;
        }[] | undefined;
    } | undefined;
    refund_session_url?: string | undefined;
    capture_session_url?: string | undefined;
    void_session_url?: string | undefined;
    buyer_label?: string | undefined;
    buyer_label_translations?: {
        label: string;
        locale: string;
    }[] | undefined;
    confirmation_callback_url?: string | undefined;
    update_payment_session_url?: string | undefined;
    multiple_capture?: boolean | undefined;
    supports_oversell_protection?: boolean | undefined;
    modal_payment_method_fields?: {}[] | undefined;
    checkout_payment_method_fields?: {
        required: boolean;
        type: "string" | "number" | "boolean";
        key: string;
    }[] | undefined;
}>;
export declare function customOnsitePaymentsAppExtensionDeployConfig(config: CustomOnsitePaymentsAppExtensionConfigType): Promise<{
    [key: string]: unknown;
} | undefined>;
