import { CurrentAppConfiguration } from '../models/app/app.js';
import { Result } from '@shopify/cli-kit/node/result';
import { zod } from '@shopify/cli-kit/node/schema';
export interface DiffContent {
    baselineContent: string;
    updatedContent: string;
}
export declare function selectConfigName(directory: string, defaultName?: string): Promise<string>;
export declare function selectConfigFile(directory: string): Promise<Result<string, string>>;
export declare function validate(value: string): string | undefined;
export declare function buildDiffConfigContent(localConfig: CurrentAppConfiguration, remoteConfig: unknown, schema?: zod.ZodTypeAny, renderNoChanges?: boolean): {
    baselineContent: string;
    updatedContent: string;
} | undefined;
