import { ConfigExtensionIdentifiersBreakdown, ExtensionIdentifiersBreakdown } from '../services/context/breakdown-extensions.js';
import { InfoTableSection } from '@shopify/cli-kit/node/ui';
export interface DeployOrReleaseConfirmationPromptOptions {
    extensionIdentifiersBreakdown: ExtensionIdentifiersBreakdown;
    configExtensionIdentifiersBreakdown?: ConfigExtensionIdentifiersBreakdown;
    appTitle?: string;
    release: boolean;
    force: boolean;
    showConfig?: boolean;
}
export interface DeployConfirmationPromptOptions {
    appTitle?: string;
    extensionsContentPrompt: {
        extensionsInfoTable?: InfoTableSection;
        hasDeletedExtensions: boolean;
    };
    configContentPrompt?: {
        configInfoTable: InfoTableSection;
    };
    release: boolean;
}
export declare function deployOrReleaseConfirmationPrompt({ force, extensionIdentifiersBreakdown, configExtensionIdentifiersBreakdown, appTitle, release, }: DeployOrReleaseConfirmationPromptOptions): Promise<boolean>;
export declare function buildConfigurationBreakdownMetadata(configExtensionIdentifiersBreakdown?: ConfigExtensionIdentifiersBreakdown): {
    cmd_deploy_config_modules_deleted?: string | undefined;
    cmd_deploy_config_modules_added?: string | undefined;
    cmd_deploy_config_modules_updated?: string | undefined;
    cmd_deploy_config_modules_breakdown?: string | undefined;
    cmd_deploy_include_config_used: boolean;
};
