import { selectOrganizationPrompt, selectAppPrompt } from '../../prompts/dev.js';
import { fetchPartnersSession } from '../context/partner-account-info.js';
import { fetchAppDetailsFromApiKey, fetchOrganizations, fetchOrgAndApps, fetchActiveAppVersion } from '../dev/fetch.js';
import { buildSpecsAppConfiguration } from '../../models/app/app.js';
import { deepMergeObjects } from '@shopify/cli-kit/common/object';
export async function selectApp() {
    const partnersSession = await fetchPartnersSession();
    const orgs = await fetchOrganizations(partnersSession);
    const org = await selectOrganizationPrompt(orgs);
    const { apps } = await fetchOrgAndApps(org.id, partnersSession);
    const selectedAppApiKey = await selectAppPrompt(apps, org.id, partnersSession);
    const fullSelectedApp = await fetchAppDetailsFromApiKey(selectedAppApiKey, partnersSession.token);
    return fullSelectedApp;
}
export async function fetchAppRemoteConfiguration(apiKey, token, specifications) {
    const activeAppVersion = await fetchActiveAppVersion({ token, apiKey });
    const appModuleVersionsConfig = activeAppVersion.app.activeAppVersion?.appModuleVersions.filter((module) => module.specification?.experience === 'configuration') || [];
    const remoteAppConfiguration = remoteAppConfigurationExtensionContent(appModuleVersionsConfig, specifications);
    return buildSpecsAppConfiguration(remoteAppConfiguration);
}
export function remoteAppConfigurationExtensionContent(configRegistrations, specifications) {
    let remoteAppConfig = {};
    const configSpecifications = specifications.filter((spec) => spec.experience === 'configuration');
    configRegistrations.forEach((module) => {
        const configSpec = configSpecifications.find((spec) => spec.identifier === module.specification?.identifier.toLowerCase());
        if (!configSpec)
            return;
        const configString = module.config;
        if (!configString)
            return;
        const config = configString ? JSON.parse(configString) : {};
        remoteAppConfig = deepMergeObjects(remoteAppConfig, configSpec.reverseTransform?.(config) ?? config);
    });
    return { ...remoteAppConfig };
}
//# sourceMappingURL=select-app.js.map