import { EnsureDeploymentIdsPresenceOptions, LocalSource, RemoteSource } from './identifiers.js';
import { AppInterface } from '../../models/app/app.js';
import { IdentifiersExtensions } from '../../models/app/identifiers.js';
import { AppModuleVersion } from '../../api/graphql/app_active_version.js';
export interface ConfigExtensionIdentifiersBreakdown {
    existingFieldNames: string[];
    existingUpdatedFieldNames: string[];
    newFieldNames: string[];
    deletedFieldNames: string[];
}
export interface ExtensionIdentifierBreakdownInfo {
    title: string;
    experience: 'extension' | 'dashboard';
}
export declare function buildExtensionBreakdownInfo(title: string): ExtensionIdentifierBreakdownInfo;
export declare function buildDashboardBreakdownInfo(title: string): ExtensionIdentifierBreakdownInfo;
export interface ExtensionIdentifiersBreakdown {
    onlyRemote: ExtensionIdentifierBreakdownInfo[];
    toCreate: ExtensionIdentifierBreakdownInfo[];
    toUpdate: ExtensionIdentifierBreakdownInfo[];
}
export declare function extensionsIdentifiersDeployBreakdown(options: EnsureDeploymentIdsPresenceOptions): Promise<{
    extensionIdentifiersBreakdown: ExtensionIdentifiersBreakdown;
    extensionsToConfirm: {
        validMatches: IdentifiersExtensions;
        extensionsToCreate: LocalSource[];
        dashboardOnlyExtensions: RemoteSource[];
    };
    remoteExtensionsRegistrations: import("../../api/graphql/all_app_extension_registrations.js").RemoteExtensionRegistrations;
}>;
export declare function extensionsIdentifiersReleaseBreakdown(token: string, apiKey: string, version: string): Promise<{
    extensionIdentifiersBreakdown: {
        onlyRemote: ExtensionIdentifierBreakdownInfo[];
        toCreate: ExtensionIdentifierBreakdownInfo[];
        toUpdate: ExtensionIdentifierBreakdownInfo[];
    };
    versionDetails: {
        id: number;
        uuid: string;
        versionTag: string;
        location: string;
        message: string;
        appModuleVersions: AppModuleVersion[];
    };
}>;
export declare function configExtensionsIdentifiersBreakdown({ token, apiKey, localApp, versionAppModules, release, }: {
    token: string;
    apiKey: string;
    localApp: AppInterface;
    versionAppModules?: AppModuleVersion[];
    release?: boolean;
}): Promise<ConfigExtensionIdentifiersBreakdown | undefined>;
