import { EnsureDeploymentIdsPresenceOptions, LocalSource, RemoteSource } from './identifiers.js';
import { IdentifiersExtensions } from '../../models/app/identifiers.js';
interface AppWithExtensions {
    extensionRegistrations: RemoteSource[];
    dashboardManagedExtensionRegistrations: RemoteSource[];
}
export declare function ensureExtensionsIds(options: EnsureDeploymentIdsPresenceOptions, { extensionRegistrations: initialRemoteExtensions, dashboardManagedExtensionRegistrations: dashboardOnlyExtensions, }: AppWithExtensions): Promise<{
    validMatches: IdentifiersExtensions;
    extensionsToCreate: LocalSource[];
    dashboardOnlyExtensions: RemoteSource[];
}>;
export declare function deployConfirmed(options: EnsureDeploymentIdsPresenceOptions, extensionRegistrations: RemoteSource[], configurationRegistrations: RemoteSource[], { validMatches, extensionsToCreate, }: {
    validMatches: IdentifiersExtensions;
    extensionsToCreate: LocalSource[];
}): Promise<{
    extensions: IdentifiersExtensions;
    extensionIds: {
        [x: string]: string;
    };
    extensionsNonUuidManaged: {
        [key: string]: string;
    };
}>;
export {};
