import { AppInterface } from '../../models/app/app.js';
import { Identifiers } from '../../models/app/identifiers.js';
import { MinimalOrganizationApp } from '../../models/organization.js';
export type PartnersAppForIdentifierMatching = MinimalOrganizationApp;
export interface EnsureDeploymentIdsPresenceOptions {
    app: AppInterface;
    token: string;
    appId: string;
    appName: string;
    envIdentifiers: Partial<Identifiers>;
    force: boolean;
    release: boolean;
    partnersApp?: PartnersAppForIdentifierMatching;
    includeDraftExtensions?: boolean;
}
export interface RemoteSource {
    uuid: string;
    type: string;
    id: string;
    title: string;
    draftVersion?: {
        config: string;
    };
}
export interface LocalSource {
    localIdentifier: string;
    graphQLType: string;
    type: string;
    handle: string;
    contextValue: string;
}
export declare function ensureDeploymentIdsPresence(options: EnsureDeploymentIdsPresenceOptions): Promise<{
    app: string;
    extensions: import("../../models/app/identifiers.js").IdentifiersExtensions;
    extensionIds: {
        [x: string]: string;
    };
    extensionsNonUuidManaged: {
        [key: string]: string;
    };
}>;
