import { deployConfirmed } from './identifiers-extensions.js';
import { configExtensionsIdentifiersBreakdown, extensionsIdentifiersDeployBreakdown } from './breakdown-extensions.js';
import { deployOrReleaseConfirmationPrompt } from '../../prompts/deploy-release.js';
import { AbortSilentError } from '@shopify/cli-kit/node/error';
export async function ensureDeploymentIdsPresence(options) {
    const { extensionIdentifiersBreakdown, extensionsToConfirm, remoteExtensionsRegistrations } = await extensionsIdentifiersDeployBreakdown(options);
    const configExtensionIdentifiersBreakdown = await configExtensionsIdentifiersBreakdown({
        token: options.token,
        apiKey: options.appId,
        localApp: options.app,
        release: options.release,
    });
    const confirmed = await deployOrReleaseConfirmationPrompt({
        extensionIdentifiersBreakdown,
        configExtensionIdentifiersBreakdown,
        appTitle: options.partnersApp?.title,
        release: options.release,
        force: options.force,
    });
    if (!confirmed)
        throw new AbortSilentError();
    const result = await deployConfirmed(options, remoteExtensionsRegistrations.extensionRegistrations, remoteExtensionsRegistrations.configurationRegistrations, extensionsToConfirm);
    return {
        app: options.appId,
        extensions: result.extensions,
        extensionIds: result.extensionIds,
        extensionsNonUuidManaged: result.extensionsNonUuidManaged,
    };
}
//# sourceMappingURL=identifiers.js.map