export interface PartnersSession {
    token: string;
    accountInfo: AccountInfo;
}
export type AccountInfo = UserAccountInfo | ServiceAccountInfo | UnknownAccountInfo;
interface UserAccountInfo {
    type: 'UserAccount';
    email: string;
}
interface ServiceAccountInfo {
    type: 'ServiceAccount';
    orgName: string;
}
interface UnknownAccountInfo {
    type: 'UnknownAccount';
}
export declare function isUserAccount(account: AccountInfo): account is UserAccountInfo;
export declare function isServiceAccount(account: AccountInfo): account is ServiceAccountInfo;
export declare function isUnknownAccount(account: AccountInfo): account is UnknownAccountInfo;
export declare function fetchPartnersSession(): Promise<PartnersSession>;
export {};
