import { geCurrentAccountInfo } from '../../api/graphql/current_account_info.js';
import { outputDebug } from '@shopify/cli-kit/node/output';
import { ensureAuthenticatedPartners } from '@shopify/cli-kit/node/session';
export function isUserAccount(account) {
    return account.type === 'UserAccount';
}
export function isServiceAccount(account) {
    return account.type === 'ServiceAccount';
}
export function isUnknownAccount(account) {
    return account.type === 'UnknownAccount';
}
export async function fetchPartnersSession() {
    const token = await ensureAuthenticatedPartners();
    return {
        token,
        accountInfo: await fetchCurrentAccountInformation(token),
    };
}
async function fetchCurrentAccountInformation(token) {
    try {
        return await geCurrentAccountInfo(token);
        // eslint-disable-next-line no-catch-all/no-catch-all
    }
    catch (error) {
        outputDebug('Error fetching user account info');
        return { type: 'UnknownAccount' };
    }
}
//# sourceMappingURL=partner-account-info.js.map