import { Identifiers, IdentifiersExtensions } from '../../models/app/identifiers.js';
import { AppDeploySchema, AppModuleSettings } from '../../api/graphql/app_deploy.js';
import { ExtensionInstance } from '../../models/extensions/extension-instance.js';
import { AlertCustomSection, TokenItem } from '@shopify/cli-kit/node/ui';
interface DeployThemeExtensionOptions {
    /** The application API key */
    apiKey: string;
    /** Set of local identifiers */
    identifiers: Identifiers;
    /** The token to send authenticated requests to the partners' API  */
    token: string;
}
/**
 * Uploads theme extension(s)
 * @param options - The upload options
 */
export declare function uploadThemeExtensions(themeExtensions: ExtensionInstance[], options: DeployThemeExtensionOptions): Promise<void>;
interface UploadExtensionsBundleOptions {
    /** The application API key */
    apiKey: string;
    /** The path to the bundle file to be uploaded */
    bundlePath?: string;
    /** The token to send authenticated requests to the partners' API  */
    token: string;
    /** App Modules extra data */
    appModules: AppModuleSettings[];
    /** The extensions' numeric identifiers (expressed as a string). */
    extensionIds: IdentifiersExtensions;
    /** Wether or not to release the version */
    release: boolean;
    /** App version message */
    message?: string;
    /** App version identifier */
    version?: string;
    /** The git reference url of the app version */
    commitReference?: string;
}
export interface UploadExtensionValidationError {
    uuid: string;
    errors: {
        message: string;
        field: string[];
    }[];
}
export interface UploadExtensionsBundleOutput {
    validationErrors: UploadExtensionValidationError[];
    versionTag: string;
    message?: string;
    location: string;
    deployError?: string;
}
type ErrorSectionBody = TokenItem;
interface ErrorCustomSection extends AlertCustomSection {
    body: ErrorSectionBody;
}
/**
 * Uploads a bundle.
 * @param options - The upload options
 */
export declare function uploadExtensionsBundle(options: UploadExtensionsBundleOptions): Promise<UploadExtensionsBundleOutput>;
export declare function deploymentErrorsToCustomSections(errors: AppDeploySchema['appDeploy']['userErrors'], extensionIds: IdentifiersExtensions, flags?: {
    version?: string;
}): ErrorCustomSection[];
/**
 * It generates a URL to upload an app bundle.
 * @param apiKey - The application API key
 */
export declare function getExtensionUploadURL(apiKey: string): Promise<string>;
export declare function uploadWasmBlob(extensionIdentifier: string, wasmPath: string, apiKey: string, token: string): Promise<{
    url: string;
    moduleId: string;
}>;
export {};
