import { DeveloperPreviewController } from './dev/ui/components/Dev.js';
import { Web } from '../models/app/app.js';
import { Config } from '@oclif/core';
export interface DevOptions {
    directory: string;
    id?: number;
    configName?: string;
    apiKey?: string;
    storeFqdn?: string;
    reset: boolean;
    update: boolean;
    commandConfig: Config;
    skipDependenciesInstallation: boolean;
    subscriptionProductUrl?: string;
    checkoutCartUrl?: string;
    tunnelUrl?: string;
    noTunnel: boolean;
    theme?: string;
    themeExtensionPort?: number;
    notify?: string;
    graphiqlPort?: number;
    graphiqlKey?: string;
}
export declare function dev(commandOptions: DevOptions): Promise<void>;
export declare function developerPreviewController(apiKey: string, originalToken: string): DeveloperPreviewController;
export declare function logMetadataForDev(options: {
    devOptions: DevOptions;
    tunnelUrl: string;
    shouldUpdateURLs: boolean;
    storeFqdn: string;
}): Promise<void>;
export declare function scopesMessage(scopes: string[]): {
    list: {
        items: string[];
    };
};
export declare function validateCustomPorts(webConfigs: Web[], graphiqlPort: number): Promise<void>;
export declare function setPreviousAppId(directory: string, apiKey: string): void;
