/// <reference types="node" resolution-mode="require"/>
import { ExtensionsPayloadStore } from './payload/store.js';
import { ExtensionDevOptions } from '../extension.js';
import { AppInterface } from '../../../models/app/app.js';
import { ExtensionInstance } from '../../../models/extensions/extension-instance.js';
import { ExtensionBuildOptions } from '../../build/extension.js';
import { AbortSignal } from '@shopify/cli-kit/node/abort';
import { Writable } from 'stream';
export interface WatchEvent {
    path: string;
    type: 'build' | 'localization';
}
export interface FileWatcherOptions {
    devOptions: ExtensionDevOptions;
    payloadStore: ExtensionsPayloadStore;
}
export interface FileWatcher {
    close: () => void;
}
export declare function setupBundlerAndFileWatcher(options: FileWatcherOptions): Promise<{
    close: () => void;
}>;
export interface SetupExtensionWatcherOptions {
    extension: ExtensionInstance;
    app: AppInterface;
    url: string;
    stdout: Writable;
    stderr: Writable;
    signal: AbortSignal;
    onChange: () => Promise<void>;
}
export declare function setupExtensionWatcher({ extension, app, url, stdout, stderr, signal, onChange, }: SetupExtensionWatcherOptions): Promise<void>;
export declare function reloadAndbuildIfNecessary(extension: ExtensionInstance, build: boolean, options: ExtensionBuildOptions): Promise<{
    previousConfig: {
        name: string;
        type: string;
        metafields: {
            namespace: string;
            key: string;
        }[];
        handle?: string | undefined;
        description?: string | undefined;
        api_version?: string | undefined;
        extension_points?: any;
        capabilities?: {
            network_access?: boolean | undefined;
            block_progress?: boolean | undefined;
            api_access?: boolean | undefined;
            collect_buyer_consent?: {
                sms_marketing?: boolean | undefined;
                customer_privacy?: boolean | undefined;
            } | undefined;
        } | undefined;
        settings?: {
            fields?: {
                type: string;
                key?: string | undefined;
                name?: string | undefined;
                description?: string | undefined;
                required?: boolean | undefined;
                validations?: any[] | undefined;
            }[] | undefined;
        } | undefined;
    };
    newConfig: {
        name: string;
        type: string;
        metafields: {
            namespace: string;
            key: string;
        }[];
        handle?: string | undefined;
        description?: string | undefined;
        api_version?: string | undefined;
        extension_points?: any;
        capabilities?: {
            network_access?: boolean | undefined;
            block_progress?: boolean | undefined;
            api_access?: boolean | undefined;
            collect_buyer_consent?: {
                sms_marketing?: boolean | undefined;
                customer_privacy?: boolean | undefined;
            } | undefined;
        } | undefined;
        settings?: {
            fields?: {
                type: string;
                key?: string | undefined;
                name?: string | undefined;
                description?: string | undefined;
                required?: boolean | undefined;
                validations?: any[] | undefined;
            }[] | undefined;
        } | undefined;
    };
}>;
