import { getUIExtensionResourceURL } from '../../../../utilities/extensions/configuration.js';
import { getExtensionPointTargetSurface } from '../utilities.js';
import { createError, sendError as h3SendError } from 'h3';
import { isSpinEnvironment } from '@shopify/cli-kit/node/context/spin';
export function getRedirectUrl(extension, options) {
    const { url: resourceUrl } = getUIExtensionResourceURL(extension.configuration.type, options);
    if (extension.surface === 'checkout' && resourceUrl) {
        const rawUrl = new URL(`https://${options.storeFqdn}/`);
        rawUrl.pathname = resourceUrl;
        rawUrl.searchParams.append('dev', `${options.url}/extensions`);
        return rawUrl.toString();
    }
    else {
        const rawUrl = new URL(`https://${options.storeFqdn}/`);
        rawUrl.pathname = 'admin/extensions-dev';
        rawUrl.searchParams.append('url', getExtensionUrl(extension, options));
        return rawUrl.toString();
    }
}
export function getExtensionPointRedirectUrl(requestedTarget, extension, options) {
    const surface = getExtensionPointTargetSurface(requestedTarget);
    let rawUrl = new URL(`https://${options.storeFqdn}/`);
    switch (surface) {
        case 'checkout':
            // This can never be null because we always generate it
            // whenever there is an extension point targeting Checkout
            rawUrl.pathname = options.checkoutCartUrl;
            rawUrl.searchParams.append('dev', `${options.url}/extensions`);
            break;
        case 'admin':
            rawUrl.pathname = 'admin/extensions-dev';
            rawUrl.searchParams.append('url', getExtensionUrl(extension, options));
            rawUrl.searchParams.append('target', requestedTarget);
            break;
        case 'customer-accounts':
            rawUrl = getCustomerAccountsRedirectUrl(extension, options, requestedTarget);
            break;
        default:
            return undefined;
    }
    return rawUrl.toString();
}
function getCustomerAccountsRedirectUrl(extension, options, requestedTarget = '') {
    const origin = `${options.url}/extensions`;
    const storeId = options.storeId;
    const [_, ...storeDomainParts] = options.storeFqdn.split('.');
    const customerAccountHost = isSpinEnvironment() ? storeDomainParts.join('.') : 'shopify.com';
    const rawUrl = new URL(`https://${customerAccountHost}/${storeId}/account/extensions-development`);
    rawUrl.searchParams.append('origin', origin);
    rawUrl.searchParams.append('extensionId', extension.devUUID);
    rawUrl.searchParams.append('source', 'CUSTOMER_ACCOUNT_EXTENSION');
    if (requestedTarget !== '') {
        rawUrl.searchParams.append('target', requestedTarget);
    }
    return rawUrl;
}
export function getExtensionUrl(extension, options) {
    const extensionUrl = new URL(options.url);
    extensionUrl.pathname = `/extensions/${extension.devUUID}`;
    return extensionUrl.toString();
}
export function sendError(response, error) {
    h3SendError(response.event, createError(error));
}
//# sourceMappingURL=utilities.js.map