import { BaseProcess, DevProcessFunction } from './types.js';
import { ExtensionInstance } from '../../../models/extensions/extension-instance.js';
import { AppInterface } from '../../../models/app/app.js';
import { PartnersAppForIdentifierMatching } from '../../context/identifiers.js';
export interface DraftableExtensionOptions {
    extensions: ExtensionInstance[];
    token: string;
    apiKey: string;
    remoteExtensionIds: {
        [key: string]: string;
    };
    proxyUrl: string;
    localApp: AppInterface;
}
export interface DraftableExtensionProcess extends BaseProcess<DraftableExtensionOptions> {
    type: 'draftable-extension';
}
export declare const pushUpdatesForDraftableExtensions: DevProcessFunction<DraftableExtensionOptions>;
export declare function setupDraftableExtensionsProcess({ localApp, apiKey, token, remoteApp, ...options }: Omit<DraftableExtensionOptions, 'remoteExtensionIds' | 'extensions'> & {
    remoteApp: PartnersAppForIdentifierMatching;
}): Promise<DraftableExtensionProcess | undefined>;
