import { setupGraphiQLServer } from '../graphiql/server.js';
export async function setupGraphiQLServerProcess(options) {
    return {
        type: 'graphiql',
        prefix: `graphiql`,
        options,
        function: launchGraphiQLServer,
    };
}
export const launchGraphiQLServer = async ({ stdout, abortSignal }, options) => {
    const httpServer = setupGraphiQLServer({ ...options, stdout });
    abortSignal.addEventListener('abort', async () => {
        httpServer.close();
    });
};
//# sourceMappingURL=graphiql.js.map