import { BaseProcess, DevProcessFunction } from './types.js';
import { ExtensionInstance } from '../../../models/extensions/extension-instance.js';
import { DotEnvFile } from '@shopify/cli-kit/node/dot-env';
export declare const MANIFEST_VERSION = "3";
export interface PreviewableExtensionOptions {
    apiKey: string;
    storeFqdn: string;
    storeId: string;
    port: number;
    pathPrefix: string;
    cartUrl?: string;
    subscriptionProductUrl?: string;
    proxyUrl: string;
    appName: string;
    appDotEnvFile?: DotEnvFile;
    appDirectory: string;
    appId?: string;
    grantedScopes: string[];
    previewableExtensions: ExtensionInstance[];
}
export interface PreviewableExtensionProcess extends BaseProcess<PreviewableExtensionOptions> {
    type: 'previewable-extension';
}
export declare const launchPreviewableExtensionProcess: DevProcessFunction<PreviewableExtensionOptions>;
export declare function setupPreviewableExtensionsProcess({ allExtensions, storeFqdn, checkoutCartUrl, ...options }: Omit<PreviewableExtensionOptions, 'pathPrefix' | 'previewableExtensions' | 'port' | 'cartUrl'> & {
    allExtensions: ExtensionInstance[];
    checkoutCartUrl?: string;
}): Promise<PreviewableExtensionProcess | undefined>;
