import { devUIExtensions } from '../extension.js';
import { buildCartURLIfNeeded } from '../extension/utilities.js';
export const MANIFEST_VERSION = '3';
export const launchPreviewableExtensionProcess = async ({ stderr, stdout, abortSignal }, { apiKey, storeFqdn, storeId, subscriptionProductUrl, port, cartUrl, proxyUrl, appName, appDotEnvFile, appId, grantedScopes, previewableExtensions, appDirectory, }) => {
    await devUIExtensions({
        appName,
        appDotEnvFile,
        appDirectory,
        id: appId,
        extensions: previewableExtensions,
        stdout,
        stderr,
        signal: abortSignal,
        url: proxyUrl,
        port,
        storeFqdn,
        storeId,
        apiKey,
        grantedScopes,
        checkoutCartUrl: cartUrl,
        subscriptionProductUrl,
        manifestVersion: MANIFEST_VERSION,
    });
};
export async function setupPreviewableExtensionsProcess({ allExtensions, storeFqdn, checkoutCartUrl, ...options }) {
    const previewableExtensions = allExtensions.filter((ext) => ext.isPreviewable);
    if (previewableExtensions.length === 0) {
        return;
    }
    const cartUrl = await buildCartURLIfNeeded(previewableExtensions, storeFqdn, checkoutCartUrl);
    return {
        prefix: 'extensions',
        type: 'previewable-extension',
        function: launchPreviewableExtensionProcess,
        options: {
            pathPrefix: '/extensions',
            port: -1,
            storeFqdn,
            previewableExtensions,
            cartUrl,
            ...options,
        },
    };
}
//# sourceMappingURL=previewable-extension.js.map