import { BaseProcess, DevProcessFunction } from './types.js';
import { PreviewThemeAppExtensionsProcess } from './theme-app-extension.js';
import { PreviewableExtensionProcess } from './previewable-extension.js';
import { DraftableExtensionProcess } from './draftable-extension.js';
import { SendWebhookProcess } from './uninstall-webhook.js';
import { GraphiQLServerProcess } from './graphiql.js';
import { WebProcess } from './web.js';
import { AppInterface } from '../../../models/app/app.js';
import { OrganizationApp } from '../../../models/organization.js';
import { DevOptions } from '../../dev.js';
import { PartnersURLs } from '../urls.js';
export interface ProxyServerProcess extends BaseProcess<{
    port: number;
    rules: {
        [key: string]: string;
    };
}> {
    type: 'proxy-server';
}
type DevProcessDefinition = SendWebhookProcess | PreviewThemeAppExtensionsProcess | WebProcess | ProxyServerProcess | PreviewableExtensionProcess | DraftableExtensionProcess | GraphiQLServerProcess;
export type DevProcesses = DevProcessDefinition[];
interface DevNetworkOptions {
    proxyPort: number;
    proxyUrl: string;
    frontendPort: number;
    backendPort: number;
    currentUrls: PartnersURLs;
}
export interface DevConfig {
    localApp: AppInterface;
    remoteAppUpdated: boolean;
    remoteApp: Omit<OrganizationApp, 'apiSecretKeys'> & {
        apiSecret?: string | undefined;
    };
    token: string;
    storeFqdn: string;
    storeId: string;
    commandOptions: DevOptions;
    network: DevNetworkOptions;
    partnerUrlsUpdated: boolean;
    graphiqlPort: number;
    graphiqlKey?: string;
}
export declare function setupDevProcesses({ localApp, remoteAppUpdated, token, remoteApp, storeFqdn, storeId, commandOptions, network, graphiqlPort, graphiqlKey, }: DevConfig): Promise<{
    processes: DevProcesses;
    previewUrl: string;
    graphiqlUrl: string | undefined;
}>;
export declare const startProxyServer: DevProcessFunction<{
    port: number;
    rules: {
        [key: string]: string;
    };
}>;
export {};
