import { BaseProcess, DevProcessFunction } from './types.js';
import { ExtensionInstance } from '../../../models/extensions/extension-instance.js';
import { AdminSession } from '@shopify/cli-kit/node/session';
export interface PreviewThemeAppExtensionsOptions {
    adminSession: AdminSession;
    themeExtensionServerArgs: string[];
    storefrontToken: string;
    token: string;
}
export interface PreviewThemeAppExtensionsProcess extends BaseProcess<PreviewThemeAppExtensionsOptions> {
    type: 'theme-app-extensions';
}
export declare const runThemeAppExtensionsServer: DevProcessFunction<PreviewThemeAppExtensionsOptions>;
export declare function setupPreviewThemeAppExtensionsProcess({ allExtensions, apiKey, storeFqdn, theme, themeExtensionPort, notify, token, }: Pick<PreviewThemeAppExtensionsOptions, 'token'> & {
    allExtensions: ExtensionInstance[];
    apiKey: string;
    storeFqdn: string;
    theme?: string;
    notify?: string;
    themeExtensionPort?: number;
}): Promise<PreviewThemeAppExtensionsProcess | undefined>;
