import { BaseProcess, DevProcessFunction } from './types.js';
import { Web } from '../../../models/app/app.js';
export interface SendWebhookOptions {
    deliveryPort: number;
    token: string;
    storeFqdn: string;
    apiSecret: string;
    webhooksPath: string;
}
export interface SendWebhookProcess extends BaseProcess<SendWebhookOptions> {
    type: 'send-webhook';
}
export declare const sendWebhook: DevProcessFunction<SendWebhookOptions>;
export declare function setupSendUninstallWebhookProcess({ webs, remoteAppUpdated, backendPort, frontendPort, ...options }: Pick<SendWebhookOptions, 'token' | 'storeFqdn' | 'apiSecret'> & {
    remoteAppUpdated: boolean;
    backendPort: number;
    frontendPort: number;
    webs: Web[];
}): SendWebhookProcess | undefined;
