import { frontAndBackendConfig } from './utils.js';
import { sendUninstallWebhookToAppServer } from '../../webhook/send-app-uninstalled-webhook.js';
export const sendWebhook = async ({ stdout }, options) => {
    await sendUninstallWebhookToAppServer({
        stdout,
        token: options.token,
        address: `http://localhost:${options.deliveryPort}${options.webhooksPath}`,
        sharedSecret: options.apiSecret,
        storeFqdn: options.storeFqdn,
    });
};
export function setupSendUninstallWebhookProcess({ webs, remoteAppUpdated, backendPort, frontendPort, ...options }) {
    const { backendConfig, frontendConfig } = frontAndBackendConfig(webs);
    const webhooksPath = webs.map(({ configuration }) => configuration.webhooks_path).find((path) => path) || '/api/webhooks';
    const sendUninstallWebhook = Boolean(webhooksPath) && remoteAppUpdated && Boolean(frontendConfig || backendConfig);
    if (!sendUninstallWebhook) {
        return;
    }
    return {
        type: 'send-webhook',
        prefix: 'webhooks',
        function: sendWebhook,
        options: {
            deliveryPort: backendConfig ? backendPort : frontendPort,
            webhooksPath,
            ...options,
        },
    };
}
//# sourceMappingURL=uninstall-webhook.js.map