/// <reference types="node" resolution-mode="require"/>
import { BaseProcess } from './types.js';
import { Web } from '../../../models/app/app.js';
import { AbortSignal } from '@shopify/cli-kit/node/abort';
import { Writable } from 'stream';
export interface LaunchWebOptions {
    port: number;
    apiKey: string;
    apiSecret?: string;
    hostname?: string;
    backendPort: number;
    frontendServerPort?: number;
    directory: string;
    devCommand: string;
    scopes?: string;
    shopCustomDomain?: string;
    hmrServerOptions?: {
        port: number;
        httpPaths: string[];
    };
    portFromConfig?: number;
}
export interface WebProcess extends BaseProcess<LaunchWebOptions> {
    type: 'web';
}
export declare function setupWebProcesses({ webs, proxyUrl, frontendPort, backendPort, apiKey, apiSecret, scopes, }: {
    webs: Web[];
    proxyUrl: string;
    frontendPort: number;
    backendPort: number;
    apiKey: string;
    apiSecret: string;
    scopes: string;
}): Promise<WebProcess[]>;
export declare function launchWebProcess({ stdout, stderr, abortSignal }: {
    stdout: Writable;
    stderr: Writable;
    abortSignal: AbortSignal;
}, { port, apiKey, apiSecret, hostname, backendPort, frontendServerPort, directory, devCommand, scopes, shopCustomDomain, hmrServerOptions, }: LaunchWebOptions): Promise<void>;
